
#include <config.h>
#include <nessuslib.h>


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifndef NESSUS_NT
#include <unistd.h>
#include <unistd.h>
#include <netinet/in.h>    
#include <sys/socket.h>
#else
#include <windows.h>
#endif

#define NAME "test-cgi"
#define DESC "Determination of the presence of the 'test-cgi' cgi"
#define COPYRIGHT "no copyright"
#define SUMM "determines the presence of the 'test-cgi' cgi"

PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "CGI abuses");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	if(!host_get_port_state(args, 80))return(0);
	
	if(is_cgi_installed(args, "test-cgi"))
	{
	char * buffer = emalloc(4096);
	char * result;
	int soc = open_sock_tcp(args, 80);
	
	 sprintf(buffer, "GET /cgi-bin/test-cgi?/*\n\n\n");
	 send(soc, buffer, strlen(buffer), 0);
	 bzero(buffer, 4096);
	 recv(soc, buffer, 4096,0);
	 result = emalloc(strlen(buffer) + 100);
	 sprintf(result, "The 'test-cgi' cgi is present\n\
The installed cgis on the remote server are :\n%s\n", buffer);
		efree(&buffer);
		post_info(args, 80, result);
		efree(&result);
		closesocket(soc);
	}
	return(0);
}

