:: Incident Response Collection Report
:: Version 2.1
:: Written by: John McLeod
:: E-mail: mcleodjp@yahoo.com
::
:: The Incident Response Collection Report is a script to call a collection of tools that gathers 
:: and/or analyzes data on a Microsoft Windows system. You can think of this as a snapshot of the 
:: system in the past. Most of the tools are oriented towards data collection rather than analysis. 
:: The idea of IRCR is that anyone could run the tool and send the output to a skilled computer security 
:: professional for further analysis. 
::
:: IRCR was originally written in Perl for a project I was working from 1999 - 2000. At the time there were
:: no Windows response tools that could easily be modified for various tasks. Harlan Carvey wrote a few Perl 
:: scripts that paved the way for IRCR. Shortly after my project, Jesse Kornblum wrote the First Responders
:: Evidence Disk (FRED). Essentially, same concept but in easy-to-use DOS batch file. 
::
:: IRCR v2 is a complete code change from Perl to DOS batch file. Anyone should be able to modify 
:: the batch file to their needs. Therefore, eliminates the need for a coder.
::
:: IRCR v2 was purposely centered on using the IR folder of Helix as a point of reference. Therefore, in
:: order to run IRCR v2 you need the tools and structure of the IR subdirectory on the Helix CD. If you are
:: not familiar with Helix then you are missing out on one of the best CD's ever made. Not only 
:: is HELIX the best thing since sliced bread but Drew (HELIX creator) is a friend of mine.
::
:: Credits: Drew Fahey, Jesse Kornblum, Harlan Carvey, Kevin Mandia, Chris Prosise, Matt Pepe and many others.
:: Tools used: See the README

::--------------------------------------------------------

@echo off
cls

set Path=%~d0\IR\bin\;%~d0\IR\WFT;%~d0\IR\windbg\;%~d0\IR\Foundstone\;%~d0\IR\Cygwin;%~d0\IR\somarsoft\;%~d0\IR\sysinternals\;%~d0\IR\ntsecurity\;%~d0\IR\perl\;%~d0\Static-Binaries\gnu_utils_win32\;%Path%
title IRCR Command Shell

prompt $T$S$P$G$S

For /f "Tokens=*" %%i in ('hostname.exe') do set HOST=%%i

For /f "Tokens=*" %%j in ('ver') do set Version=%%j

rem @echo off
:: Prompt for Name
rem set /p MYNAME=Enter your name: 


@echo off
::============================ Variables ===================================
:: The following are the paths to the apps

:: Windows 2000
SET t-2k=\IR\2k

:: Windows 2003
SET t-2k=\IR\2k3

:: BIN
SET t-bin=\IR\BIN

:: Convar
SET t-con=\IR\convar

:: Cygwin
SET t-cyg=\IR\cygwin

:: Foundstone
SET t-fnd=\IR\foundstone

:: getinfo
SET t-get=\IR\getinfo

:: Hoverdesk
SET t-hov=\IR\hoverdesk

:: nirsoft
SET t-ni=\IR\nirsoft\iehv

:: Windows NT
SET t-nt=\IR\NT

:: ntsecurity
SET t-nts=\IR\ntsecurity

:: Perl
SET t-per=\IR\perl

:: Somarsoft
SET t-som=\IR\somarsoft

:: Sysinternals
SET t-sys=\IR\sysinternals

:: wft
SET t-wft=\IR\wft

:: windbg
SET t-win=\IR\windbg

:: Windows XP 
SET t-xp=\IR\xp



:: Start log file

@echo off
CALL routines.bat EQUALLINE
ECHO                  Incident Response Collection Report 
CALL routines.bat EQUALLINE
ECHO. 
ECHO           Name:  %MYNAME%
ECHO  Computer Name:  %HOST%
ECHO             OS:  %VERSION%
ECHO. 
CALL routines.bat MAKELINE
ECHO START --  Time:  %time%  Date: %date%
CALL routines.bat MAKELINE
ECHO. 


:: Find OS version
ver | grep "Vista">nul
if errorlevel 1 goto maybe2003
::=============================== Vista =======================================================
:: Vista stuff here
SET t-os=\IR\Vista
SET CMDSHELL=cmdvista.exe
ECHO Running XP commands
::
goto end


:maybe2003
ver |grep "2003">nul
if errorlevel 1 goto maybexp
::=============================== 2003 =======================================================
:: 2003 stuff here
SET t-os=\IR\2k3
SET CMDSHELL=cmd2k3.exe
::
goto end


:maybexp
ver |grep "XP">nul
if errorlevel 1 goto maybe2000
::=============================== XP ========================================================
:: XP stuff here
SET t-os=\IR\xp
SET CMDSHELL=cmdxp.exe
::
goto end

:maybe2000
ver |grep "2000">nul
if errorlevel 1 goto maybent
::=============================== 2000 =======================================================
:: 2000 stuff here
SET t-os=\IR\2k
SET CMDSHELL=cmd2k.exe
::
goto end

:maybent
ver |grep "NT">nul
if errorlevel 1 goto notNT
::===================================== NT ====================================================
:: NT stuff here
SET t-os=\IR\nt
SET CMDSHELL=cmdnt.exe
::
goto end

:notNT
echo don't know

:END

::========================== ALL ================================================================:: Find OS version
ver | grep "Vista">nul
if errorlevel 1 goto maybe2003
::=============================== Vista =======================================================
:: Vista stuff here
SET t-os=\IR\Vista
SET CMDSHELL=cmdvista.exe
ECHO Running XP commands
::
goto end


:maybe2003
ver |grep "2003">nul
if errorlevel 1 goto maybexp
::=============================== 2003 =======================================================
:: 2003 stuff here
SET t-os=\IR\2k3
SET CMDSHELL=cmd2k3.exe
::
goto end


:maybexp
ver |grep "XP">nul
if errorlevel 1 goto maybe2000
::=============================== XP ========================================================
:: XP stuff here
SET t-os=\IR\xp
SET CMDSHELL=cmdxp.exe
::
goto end

:maybe2000
ver |grep "2000">nul
if errorlevel 1 goto maybent
::=============================== 2000 =======================================================
:: 2000 stuff here
SET t-os=\IR\2k
SET CMDSHELL=cmd2k.exe
::
goto end

:maybent
ver |grep "NT">nul
if errorlevel 1 goto notNT
::===================================== NT ====================================================
:: NT stuff here
SET t-os=\IR\nt
SET CMDSHELL=cmdnt.exe
::
goto end

:notNT
echo don't know

:END

::========================== ALL ================================================================


::+-----------------------------+
::|				|
::|AT Schedule List		|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  AT  
ECHO AT Schedule List
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\at 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|MS-DOS history list		|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  doskey /history  
ECHO MS-DOS history list
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\doskey /history 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|ipconfig		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  ipconfig /all  
ECHO Displays configuration information
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\ipconfig /all 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Memory		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time% 
ECHO Command:  MEM.exe /d  
ECHO Displays memory usage
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\mem.exe /d 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET ACCOUNTS			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time% 
ECHO Command:  net accounts  
ECHO Displays current settings for password, logon limitations, and domain information
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net accounts 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET FILE			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time% 
ECHO Command:  net file  
ECHO  Lists the open files on a server
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net file 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET GROUP			|
::|-- For Domain Controllers	|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time% 
ECHO Command:  net group  
ECHO Lists groups
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net group 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET LOCALGROUP		|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time% 
ECHO Command:  net localgroup  
ECHO Lists local groups
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net localgroup 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET SESSIONS			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  net sessions  
ECHO  Displays NetBIOS client and server sessions
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net sessions 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET SHARE			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  net share  
ECHO  Lists information about all resources being shared on the computer
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net share 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET START			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  net start  
ECHO Lists running services
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net start 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Netstat		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  netstat -anr  
ECHO Displays current network connections
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\netstat -anr 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET USE			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  net use  
ECHO Lists the computer's connections
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net use 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET USER			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  net user  
ECHO Lists the user accounts for the computer
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net user 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NET VIEW			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  net user  
ECHO Lists the computers in the current domain
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\net view 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|route		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  route print  
ECHO Displays routing information
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\ROUTE print 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|SET			 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  %CMDSHELL% /C set  
ECHO Displays environment variables
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\%CMDSHELL% /C set 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|System Info			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  systeminfo  
ECHO Various information about the machine
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-os%\systeminfo 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Address Resolution Protocol 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  arp -a  
ECHO Displays the IP-to-Physical address
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-wft%\arp -a 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Auditpol		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  auditpol.exe  
ECHO Enables the user to modify the audit policy of the local computer or of any 
ECHO remote computer 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-wft%\auditpol.exe 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Banner			|
::|				|
::+-----------------------------+

CALL routines.bat CR
CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\WinLogon /v LegalNoticeText"  
ECHO Banner Information 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\WinLogon" /v legalnoticetext 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|DIR (Hidden Files)	 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  dir /s /a:h /t:a c: d:  
ECHO List of hidden files.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
dir /s /a:h /t:a c: 
dir /s /a:h /t:a d: 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|List				|
::|				|
::+-----------------------------+

ECHO Miscellaneous file list 
CALL routines.bat CR

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  dir %USERPROFILE%\Start Menu\Programs\Startup  
ECHO List of Startup Programs
CALL routines.bat ENDBOX
ECHO OUTPUT: 
dir %USERPROFILE%\Start Menu\Programs\Startup 
CALL routines.bat CR

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  dir %WINDIR%\Tasks  
ECHO Contains files specifying scheduled tasks, submitted via at.exe or Scheduled 
ECHO Tasks Wizard...job files in this directory with the hidden bit set will not appear in the Scheduled 
ECHO Tasks applet in the Control Panel.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
dir %WINDIR%\Tasks 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Fport		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  fport.exe /p  
ECHO fport reports all open TCP/IP and UDP ports and maps them to the owning application. 
ECHO This is the same information you would see using the 'netstat -an' command, but it also maps those 
ECHO ports to running processes with the PID, process name and path. Fport can be used to quickly identify 
ECHO unknown open ports and their associated applications. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-fnd%\fport.exe /p 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Hunt			 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  hunt.exe \\127.0.0.1  
ECHO Hunt is a quick way to see if a server reveals too much info via NULL sessions. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-fnd%\hunt.exe \\127.0.0.1 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Nbtstat		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  nbtstat -c  
ECHO Displays current connections using NetBIOS over TCP/IP
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-wft%\nbtstat -c 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NTlast (Successful)	 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  ntlast.exe -v -s  
ECHO NTLast is specifically targeted for serious security and IIS administration. Scheduled 
ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
ECHO details is now made easier with NTLast. This tool is able to quickly report on the status of IIS users, 
ECHO as well as filter out web server logons from console logons.  
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-fnd%\ntlast.exe -v -s 
CALL routines.bat CR

:+-----------------------------+
::|				|
::|NTLAST (FAILED)	 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  NTLAST.exe -v -f  
ECHO NTLASTF is specifically targeted for serious security and IIS administration. Scheduled 
ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
ECHO details is now made easier with NTLASTF. This tool is able to quickly report on the status of IIS users, 
ECHO as well as filter out web server logons from console logons.  
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-fnd%\NTLAST.exe -v -f 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NTLAST (Interactive)	 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  NTLAST.exe -v -i  
ECHO NTLASTI is specifically targeted for serious security and IIS administration. Scheduled 
ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
ECHO details is now made easier with NTLASTI. This tool is able to quickly report on the status of IIS users, 
ECHO as well as filter out web server logons from console logons.  
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-fnd%\NTLAST.exe -v -i 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NTLAST (remote)	 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  NTLAST.exe -v -r   
ECHO NTLASTR is specifically targeted for serious security and IIS administration. Scheduled 
ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
ECHO details is now made easier with NTLASTR. This tool is able to quickly report on the status of IIS users, 
ECHO as well as filter out web server logons from console logons.  
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-fnd%\NTLAST.exe -v -r 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|NTLAST (Successful)	 	|
::|				|
::+-----------------------------+


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  NTLAST.exe -v -s  
ECHO NTLASTS is specifically targeted for serious security and IIS administration. Scheduled 
ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
ECHO details is now made easier with NTLASTS. This tool is able to quickly report on the status of IIS users,
ECHO as well as filter out web server logons from console logons.  
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-fnd%\NTLAST.exe -v -s 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|pclip		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  pclip  
ECHO Get the contents of the clipboard
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-wft%\pclip.exe 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Procinterrogate	 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  procinterrogate -list   
ECHO Lists all processes, process ids and their associated dlls.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\procinterrogate -list 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|ps 			 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  PS.exe -ealW  
ECHO Display process status
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-cyg%\PS.exe -ealW 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|PSFILEfile		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  PSFILE.exe  
ECHO PsFile shows a list of files on a system that are opened remotely, and it also allows 
ECHO you to close opened files either by name or by a file identifier. The "net file" command shows you a 
ECHO list of the files that other computers have opened on the system upon which you execute the command, 
ECHO however it truncates long path names and doesn't let you see that information for remote systems. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-sys%\PSFILE.exe 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|PS INFO			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  psinfo   
ECHO PsInfo is a command-line tool that gathers key information about the local or remote 
ECHO Windows NT/2000 system, including the type of installation, kernel build, registered organization and 
ECHO owner, number of processors and their type, amount of physical memory, the install date of the system, 
ECHO and if its a trial version, the expiration date.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-sys%\psinfo 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|pslist 		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  pslist.exe -x  
ECHO PsList is utility that shows you a combination of the information obtainable individually 
ECHO with pmon and pstat. You can view process CPU and memory information, or thread statistics. What makes 
ECHO PsList more powerful than the Resource Kit tools is that you can view process and thread statistics on 
ECHO a remote computer.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-sys%\PSLIST -x 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|psloggedon 		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  psloggedon  
ECHO PsLoggedOn's definition of a locally logged on user is one that has their profile loaded 
ECHO into the Registry, so PsLoggedOn determines who is logged on by scanning the keys under the HKEY_USERS 
ECHO key. For each key that has a name that is a user SID (security Identifier), PsLoggedOn looks up the 
ECHO corresponding user name and displays it. To determine who is logged onto a computer via resource shares, 
ECHO PsLoggedOn uses the NetSessionEnum API. Note that PsLoggedOn will show you as logged on via resource 
ECHO share to remote computers that you query because a logon is required for PsLoggedOn to access the Registry 
ECHO of a remote system.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-sys%\psloggedon 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|psService		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  psservice   
ECHO PsService is a service viewer and controller for Windows NT/2K. Like the SC utility that's 
ECHO included in the Windows NT and Windows 2000 Resource Kits, PsService displays the status, configuration, 
ECHO and dependencies of a service, and allows you to start, stop, pause, resume and restart them. Unlike 
ECHO the SC utility, PsService enables you to logon to a remote system using a different account, for cases 
ECHO when the account from which you run it doesn't have required permissions on the remote system. PsService 
ECHO includes a unique service-search capability, which identifies active instances of a service on your 
ECHO network. You would use the search feature if you wanted to locate systems running DHCP servers, for instance. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-sys%\psservice 
CALL routines.bat CR

REM ::+-----------------------------+
REM ::|				|
REM ::|pulist 		 	|
REM ::|				|
REM ::+-----------------------------+
REM 
REM CALL routines.bat STARTBOX
REM ECHO %time%
REM ECHO Command:  pulist  
REM ECHO Displays processes running on local or remote computers. PuList is similar to TList (a Support 
REM ECHO Tool on the Windows 2000 CD), but also lists the user name associated with each process on a local computer.
REM CALL routines.bat ENDBOX
REM ECHO OUTPUT: 
REM %t-wft%\pulist 
REM CALL routines.bat CR

::+-----------------------------+
::|				|
::|AutoStart Registry Keys	|
::|				|
::+-----------------------------+

ECHO AutoStart Registry Entries
CALL routines.bat CR

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\"   
ECHO Lists programs to be run when system starts. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\"  
ECHO Lists programs to be run when system starts. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Run\"  
ECHO Lists programs to be run when system starts.  On 2K and XP, these entries are 
ECHO ignored when booted to Safe Mode; however, entries preceded by "*" will be processed 
ECHO even when booted to Safe Mode.  On XP, these 'Run' keys are referred to as the 'legacy Run list', 
ECHO as they are provided for backwards compatibility with previous versions of Windows. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Run\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Run\"  
ECHO Lists programs to be run when system starts.  On 2K and XP, these entries are 
ECHO ignored when booted to Safe Mode; however, entries preceded by "*" will be processed even when 
ECHO booted to Safe Mode.  On XP, these 'Run' keys are referred to as the 'legacy Run list', as 
ECHO they are provided for backwards compatibility with previous versions of Windows. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Run\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce\"  
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce\Setup\"  
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\RunOnce\"  
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnceEx\"  
ECHO Lists programs to be run once when the system starts, and deleted. The commands 
ECHO listed here are deleted before the actual commands are run.  If the command is preceded by "!", 
ECHO the command is deleted after the command is run.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce\" 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce\Setup\" 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\RunOnce\" 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnceEx\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\BrowserHelperObjects\"  
ECHO Browser Helper Objects (BHOs) are in-process COM components loaded each time Internet Explorer starts 
ECHO up.  These components run in the same memory context as the browser.  with Active Desktop, Windows Explorer will 
ECHO also support BHOs.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\BrowserHelperObjects\" 
CALL routines.bat CR

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\SharedTaskScheduler\"  
ECHO Entries in this key are automatically loaded by Explorer.exe when Windows starts.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\SharedTaskScheduler\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Classes\exefile\shell\open\command\"  
ECHO The Default setting for these entries is '"%1" %*'.  Some malware will add entries to 
ECHO have other things run.  Also, may need to examine other file types under the Classes key, as well 
ECHO (ie, any file classes that point to an app, with a .exe extension).  These entires map to 
ECHO HKCR\{ext}file\shell\open\command.  Other entries under the HKLM\Software\Classes (and HKCR) key 
ECHO are succeptible to this same sort of subversion.  For example, navigate via RegEdit to the 
ECHO HKCR\Drive\shell\cmd\command key, right-click on the "Default" value, and choose Modify.  In the 
ECHO textfield, add "&& notepad.exe", and click OK.  Open My Computer, select a drive, right-click and 
ECHO choose "Open Command Prompt here..."...both cmd.exe and notepad.exe will run.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Classes\exefile\shell\open\command\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\CommandProcessor" /v AutoRun  
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CommandProcessor" /v AutoRun   
ECHO Commands listed here are executed before all other options listed at the command line; disabled 
ECHO by /d switch; REG_SZ data type.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\CommandProcessor" /v AutoRun  
%t-bin%\reg query "HKCU\Software\Microsoft\CommandProcessor" /v AutoRun  
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\ShellServiceObjectDelayLoad\"  
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\ShellServiceObjectDelayLoad\"  
ECHO Points to the InProcServer for a CLSID; The values found in this key can be mapped to 
ECHO HKLM\Software\Classes\CLSID\{GUID}\InProcServer; Items listed here are loaded by Explorer when Windows 
ECHO starts; Used by malware
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\ShellServiceObjectDelayLoad\" 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\ShellServiceObjectDelayLoad\" 
CALL routines.bat CR

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v load  
ECHO Replaces the use of the "load=" line in Win.ini
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v load 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v run  
ECHO Replaces the use of the "run=" line in Win.ini
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v run 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Policies\Microsoft\Windows\System\Scripts\"  
ECHO %time%
ECHO Command: reg query "HKCU\Software\Policies\Microsoft\Windows\System\Scripts\"  
ECHO Points to scripts for various events (ie, logon, logoff, shutdown, etc.); Usually handled via 
ECHO GPOs, but can also be configured via local security policies
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Policies\Microsoft\Windows\System\Scripts\" 
%t-bin%\reg query "HKCU\Software\Policies\Microsoft\Windows\System\Scripts\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\System" /v Shell  
ECHO Can specify an alternate user shell
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\System" /v Shell 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v AppInit_DLLs  
ECHO DLLs specified within this key are loaded whenever a Windows-based (GUI) application is launched.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v AppInit_DLLs 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v GinaDLL  
ECHO This entry can be subverted to load an alternate GINA, capable of capturing the user's login information 
ECHO in plain text (ie, FakeGINA.DLL from NTSecurity.nu).  This is loaded and used by WinLogon.exe.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v GinaDLL 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v Shell  
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v Shell  
ECHO Indicates executable files launched by Userinit.exe and expected at user shell startup. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v Shell 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v Shell 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v System  
ECHO Indicates programs to be executed in System mode.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v System 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v TaskMan  
ECHO Specifies the Task Manager to be used by Windows.  The default is TaskMan.exe, but the SysInternals.com 
ECHO tool, Process Explorer, can replace this value.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v TaskMan 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v UserInit  
ECHO Lists programs to be automatically run when the user logs in.  Userinit.exe is responsible for shell execution.  
ECHO Nddeagnt.exe is responsible for NetDDE.  Multiple programs may be listed.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v UserInit 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon\Notify\"  
ECHO Specifies programs to be run when certain system events (ie, logon, logoff, startup, shutdown, startscreensaver, 
ECHO stopscreensaver) occur.  The event is generated by Winlogon.exe, at which point the system will look for a DLL 
ECHO within this key to handle the event.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon\Notify\" 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\System\CurrentControlSet\Control\Session Manager" /v BootExecute  
ECHO Specifies the applications, services, and commands executed during startup.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\System\CurrentControlSet\Control\Session Manager" /v BootExecute 
CALL routines.bat CR


::+-----------------------------+
::|				|
::|Various Registry Keys	|
::|				|
::+-----------------------------+
 
ECHO Miscellaneous Registry Entries
CALL routines.bat CR

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v NtfsDisableLastAccessUpdate  
ECHO If set to 1, updating of last access times is disabled.  This can be "very bad' for forensics. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v NtfsDisableLastAccessUpdate 
CALL routines.bat CR 

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKLM\System\CurrentControlSet\Control\Session Manager\KnownDLLs\"  
ECHO Contains a list of DLLs to be loaded at system start
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\System\CurrentControlSet\Control\Session Manager\KnownDLLs\" 
CALL routines.bat CR 

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v defaultdomainname  
ECHO Domain Name
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v defaultdomainname 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v defaultusername  
ECHO User Name
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v defaultusername 
CALL routines.bat CR


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v legalnoticecaption  
ECHO Legal notice caption
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v legalnoticecaption 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|User Activity Registry Keys	|
::|				|
::+-----------------------------+
:: The Registry entries listed here record user activity, and can 
:: be used in conjunction with the key LastWrite time to create a 
:: timeline of user activity.  Many of these keys are referred to as MRU keys.


ECHO User Activity Registry Entries
CALL routines.bat CR

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\Paint\Recent File List"  
ECHO Key Maintains a list of image files accessed with Paint
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\Paint\Recent File List" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\RegEdit"  
ECHO The LastKey value maintains the last key accessed using RegEdit
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\RegEdit" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\RegEdit\Favorites"  
ECHO Maintains a list of favorites added through Favorites menu item in RegEdit
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\RegEdit\Favorites" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\WordPad\Recent File List"  
ECHO List of files accessed/saved in WordPad
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\WordPad\Recent File List" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Search Assistant\ACMru"  
ECHO Maintains a list of items searched for via Start-Search; the subkeys (5001, 5603, 
ECHO 5604, etc.) correspond to the textfields where the user enters search parameters.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Search Assistant\ACMru" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\LastVisitedMRU"  
ECHO Maintains a list of programs accessed, and their locations within the file system.  Sort via the MRUList.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\LastVisitedMRU" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\StreamMRU"  
ECHO Maintains a list of files that are opened 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\StreamMRU" 
CALL routines.bat CR 

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Doc Find Spec MRU"  
ECHO Maintains a list of entries typed into the Start-Run box
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Doc Find Spec MRU" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FindComputerMRU"  
ECHO Maintains a list of entries for computers searched for via Windows Explorer
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FindComputerMRU" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FindComputerMRU"  
ECHO Maintains a list of entries for computers searched for via Windows Explorer
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FindComputerMRU" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Map Network Drive MRU"  
ECHO Maintains a list of drive mapped via the Map Network Drive Wizard.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Map Network Drive MRU" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComputerDescriptions"  
ECHO Values beneath this key are names or IP addresses of machines connected to.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComputerDescriptions" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\MountPoints2"  
ECHO Subkeys that start with "#" are paths to drives that have been mounted; includes 
ECHO the use of the "net use" command.  BaseClass value will usually be "Drive".
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\MountPoints2" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\MediaPlayer\Player\RecentFileList"  
ECHO List of files (movies - .mpg, etc.) accessed via Media Player
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\MediaPlayer\Player\RecentFileList" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\MediaPlayer\Player\RecentURLList"  
ECHO List of files (movies - .mpg, etc.) accessed via Media Player
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\MediaPlayer\Player\RecentURLList" 
CALL routines.bat CR 


CALL routines.bat STARTBOX
ECHO %time%
ECHO Command: reg query "HKCU\Software\Nico Mak Computing\WinZip\filemenu"  
ECHO List of recently used WinZip archives
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Nico Mak Computing\WinZip\filemenu" 
CALL routines.bat CR 

::+-----------------------------+
::|				|
::|TYPED URLs			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  reg query "HKCU\Software\Microsoft\Internet Explorer\TypedURLs"  
ECHO Maintains a list of URLs typed into the IE Address bar
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Internet Explorer\TypedURLs" 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Last files open/saved	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\OpenSaveMRU" /S  
ECHO Maintains a list of files that are opened or saved via Windows Explorer-style dialog boxes
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\OpenSaveMRU" /S 
CALL routines.bat CR


::+-----------------------------+
::|				|
::|Install History		|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall" /S  
ECHO List of files that were installed
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall" /S 
CALL routines.bat CR


::+-----------------------------+
::|				|
::|Run Commands			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RunMRU"  
ECHO Maintains a list of entries typed into the Start-Run box
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RunMRU" 
CALL routines.bat CR

:+-----------------------------+
::|				|
::|Recent Docs			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RecentDocs"  
ECHO List of Recent Docs; Need to convert hex to text
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RecentDocs" 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Recycler			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  ls -alR %HOMEDRIVE%recycler  
ECHO List of files in the recycle bin
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-cyg%\ls -alR %HOMEDRIVE%\recycler 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Prefetch			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  dir %SYSTEMROOT%\Prefetch  
ECHO On XP, handles boot and application launch prefetching.  Prefetch files for 
ECHO application launch contain information regarding path to executeable, etc. Layout.ini file 
ECHO contains a list files used by system defrag utility. On 2K3, only boot prefetching is done, by 
ECHO default.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
dir %SYSTEMROOT%\Prefetch 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Recent			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  dir %USERPROFILE%\Recent  
ECHO List of recently opened files
CALL routines.bat ENDBOX
ECHO OUTPUT: 
dir "%USERPROFILE%\Recent" 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|Servicelist		 	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  servicelist.exe \\127.0.0.1  
ECHO Displays running services on a system 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-wft%\servicelist.exe \\127.0.0.1 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|dumpel (Application Log)	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  dumpel.exe -t -l application  
ECHO Dump Event Log is a command-line tool that dumps an event log for a local or remote system into a 
ECHO  tab-separated text file. This tool can also be used to filter for or filter out certain event types.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-2k%\dumpel.exe -t -l application 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|dumpel (Security Log)	|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  dumpel.exe -t -l security  
ECHO Dump Event Log is a command-line tool that dumps an event log for a local or remote system into a 
ECHO  tab-separated text file. This tool can also be used to filter for or filter out certain event types.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-2k%\dumpel.exe -t -l security 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|dumpel (System Log)		|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  dumpel.exe -t -l system  
ECHO Dump Event Log is a command-line tool that dumps an event log for a local or remote system into a 
ECHO  tab-separated text file. This tool can also be used to filter for or filter out certain event types.
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-2k%\dumpel.exe -t -l system 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|PromiscDetect		|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  promiscdetect.exe  
ECHO PromiscDetect checks if your network adapter(s) is running in promiscuous mode, which 
ECHO may be a sign that you have a sniffer running on your computer. 
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-nts%\promiscdetect.exe 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|IE History			|
::|				|
::+-----------------------------+

REM CALL routines.bat STARTBOX
REM ECHO %time%
REM ECHO Command:  iehv.exe /stext %IEHIS%  
REM ECHO IEHV reads all information from the history file on your computer, and displays the list of all URLs that 
REM ECHO you have visited in the last few days.
REM CALL routines.bat ENDBOX
REM ECHO OUTPUT: 
REM %t-ni%\iehv.exe /stext %IEHIS%
REM CALL routines.bat CR

::+-----------------------------+
::|				|
::|Autoexec.bat			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  cat %SystemDrive%\autoexec.bat  
ECHO Contents of the Autoexec.bat file
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-cyg%\cat %SystemDrive%\autoexec.bat 
CALL routines.bat CR


::+-----------------------------+
::|				|
::|system.ini			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  cat %SystemRoot%\system.ini  
ECHO Contents of the system.ini file
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-cyg%\cat %SystemRoot%\system.ini 
CALL routines.bat CR

::+-----------------------------+
::|				|
::|win.ini			|
::|				|
::+-----------------------------+

CALL routines.bat STARTBOX
ECHO %time%
ECHO Command:  cat %SystemRoot%\win.ini  
ECHO Contents of the win.ini file
CALL routines.bat ENDBOX
ECHO OUTPUT: 
%t-cyg%\cat %SystemRoot%\win.ini 
CALL routines.bat CR

:: End log file
ECHO. 
CALL routines.bat STARTBOX
ECHO END --  Time:  %time%  Date: %date%
CALL routines.bat ENDBOX
ECHO. 
:: 
@echo off
@echo IRCR Netcat is done. 
@echo. 
@echo You should now hash the acquired file using md5sum. 
@echo. 
@echo. 
echo on
exit
