:: Incident Response Collection Report
:: Version 2.1
:: Written by: John McLeod
:: E-mail: mcleodjp@yahoo.com
::
:: The Incident Response Collection Report is a script to call a collection of tools that gathers 
:: and/or analyzes data on a Microsoft Windows system. You can think of this as a snapshot of the 
:: system in the past. Most of the tools are oriented towards data collection rather than analysis. 
:: The idea of IRCR is that anyone could run the tool and send the output to a skilled computer security 
:: professional for further analysis. 
::
:: IRCR was originally written in Perl for a project I was working from 1999 - 2000. At the time there were
:: no Windows response tools that could easily be modified for various tasks. Harlan Carvey wrote a few Perl 
:: scripts that paved the way for IRCR. Shortly after my project, Jesse Kornblum wrote the First Responders
:: Evidence Disk (FRED). Essentially, same concept but in easy-to-use DOS batch file. 
::
:: IRCR v2 is a complete code change from Perl to DOS batch file. Anyone should be able to modify 
:: the batch file to their needs. Therefore, eliminates the need for a coder.
::
:: IRCR v2 was purposely centered on using the IR folder of Helix as a point of reference. Therefore, in
:: order to run IRCR v2 you need the tools and structure of the IR subdirectory on the Helix CD. If you are
:: not familiar with Helix then you are missing out on one of the best CD's ever made. Not only 
:: is HELIX the best thing since sliced bread but Drew (HELIX creator) is a friend of mine.
::
:: Credits: Drew Fahey, Jesse Kornblum, Harlan Carvey, Kevin Mandia, Chris Prosise, Matt Pepe and many others.
:: Tools used: See the README
::
:: Change:
:: Fixed OS pointer
:: Fixed the output path
:: Fixed version and output statements in log file
:: Fixed hostname
:: 
::
::--------------------------------------------------------

@echo off
cls

set Path=%~d0\IR\bin\;%~d0\IR\IRCR;%~d0\IR\windbg\;%~d0\IR\Foundstone\;%~d0\IR\Cygwin;%~d0\IR\somarsoft\;%~d0\IR\sysinternals\;%~d0\IR\ntsecurity\;%~d0\IR\perl\;%~d0\Static-Binaries\gnu_utils_win32\;%Path%
title IRCR Command Shell
echo Ctrl-D for Directory or Ctrl-F for filename completion
echo The Shell Path has been modified to find trusted cdrom binaries first
echo Do not navigate away from the CD drive letter.
echo =====================================================================
prompt $T$S$P$G$S

:: Prompt for output
set /p MYFOLDER=Enter the path where you want all your files (i.e. f:\myoutput): 
mkdir %MYFOLDER% 

For /f "Tokens=*" %%i in ('hostname.exe') do set HOST=%%i

SET MYPATH=%MYFOLDER%\%HOST%

For /f "Tokens=*" %%j in ('ver') do set Version=%%j

@ECHO OFF
:: Make directories
   
mkdir %MYPATH%\files

:: Prompt for Name
set /p MYNAME=Enter your name: 

::============================ Variables ===================================
:: audit log
SET LOG=%MYPATH%\files\log.txt

:: The following are the paths to the apps
:: Windows 2000
SET t-2k=\IR\2k

:: Windows 2003
SET t-2k3=\IR\2k3

:: BIN
SET t-bin=\IR\BIN

:: Convar
SET t-con=\IR\convar

:: Cygwin
SET t-cyg=\IR\cygwin

:: Foundstone
SET t-fnd=\IR\foundstone

:: getinfo
SET t-get=\IR\getinfo

:: Hoverdesk
SET t-hov=\IR\hoverdesk

:: nirsoft
SET t-ni=\IR\nirsoft\iehv

:: Windows NT
SET t-nt=\IR\NT

:: ntsecurity
SET t-nts=\IR\ntsecurity

:: Perl
SET t-per=\IR\perl

:: Somarsoft
SET t-som=\IR\somarsoft

:: Sysinternals
SET t-sys=\IR\sysinternals

:: wft
SET t-wft=\IR\wft

:: windbg
SET t-win=\IR\windbg

:: Windows XP 
SET t-xp=\IR\xp



:: Set counter to zero
SET COUNT=0

:: Start log file
ECHO IRCR is running...
>> %LOG% ECHO                  Incident Response Collection Report 
>> %LOG% ECHO. 
>> %LOG% ECHO           Type:  Audit Log
>> %LOG% ECHO    Destination:  %LOG%
>> %LOG% ECHO           Name:  %MYNAME%
>> %LOG% ECHO  Computer Name:  %HOST%
>> %LOG% ECHO             OS:  %VERSION%
>> %LOG% ECHO. 
>> %LOG% CALL routines.bat MAKELINE
>> %LOG% ECHO START --  Time:  %time%  Date: %date%
>> %LOG% CALL routines.bat MAKELINE
ECHO Time:  %time%  Date: %date%
>> %LOG% ECHO. 


:: Find OS version
ver | grep "Vista">nul
if errorlevel 1 goto maybe2003
::=============================== Vista =======================================================
:: Vista stuff here
SET t-os=\IR\Vista
SET CMDSHELL=cmdvista.exe
ECHO Running XP commands
::
goto end


:maybe2003
ver |grep "2003">nul
if errorlevel 1 goto maybexp
::=============================== 2003 =======================================================
:: 2003 stuff here
SET t-os=\IR\2k3
SET CMDSHELL=cmd2k3.exe
::
goto end


:maybexp
ver |grep "XP">nul
if errorlevel 1 goto maybe2000
::=============================== XP ========================================================
:: XP stuff here
SET t-os=\IR\xp
SET CMDSHELL=cmdxp.exe
::
goto end

:maybe2000
ver |grep "2000">nul
if errorlevel 1 goto maybent
::=============================== 2000 =======================================================
:: 2000 stuff here
SET t-os=\IR\2k
SET CMDSHELL=cmd2k.exe
::
goto end

:maybent
ver |grep "NT">nul
if errorlevel 1 goto notNT
::===================================== NT ====================================================
:: NT stuff here
SET t-os=\IR\nt
SET CMDSHELL=cmdnt.exe
::
goto end

:notNT
echo don't know

:END

::========================== ALL ================================================================

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\at
::+-----------------------------+
::|				|
::|AT Schedule List		|
::|				|
::+-----------------------------+

SET ATINFO=%MYPATH%\files\ATINFO.txt

>> %ATINFO% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  AT | tee -a %LOG% >> %ATINFO%
>> %ATINFO% CALL routines.bat EQUALLINE
>> %ATINFO% ECHO AT Schedule List
>> %ATINFO% CALL routines.bat MAKELINE
>> %ATINFO% ECHO OUTPUT: 
%t-os%\at >> %ATINFO%
>> %ATINFO% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %ATINFO% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\doskey /history
::+-----------------------------+
::|				|
::|MS-DOS history list		|
::|				|
::+-----------------------------+

SET DOSKEYH=%MYPATH%\files\DOSKEYH.txt

>> %DOSKEYH% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  doskey /history | tee -a %LOG% >> %DOSKEYH% 
>> %DOSKEYH% CALL routines.bat EQUALLINE
>> %DOSKEYH% ECHO MS-DOS history list
>> %DOSKEYH% CALL routines.bat MAKELINE
>> %DOSKEYH% ECHO OUTPUT: 
%t-os%\doskey /history >> %DOSKEYH%
>> %DOSKEYH% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %DOSKEYH%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\ipconfig /all
::+-----------------------------+
::|				|
::|ipconfig		 	|
::|				|
::+-----------------------------+

SET IPCONFIG=%MYPATH%\files\IPCONFIG.txt

>> %IPCONFIG% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  ipconfig /all | tee -a %LOG% >> %IPCONFIG% 
>> %IPCONFIG% CALL routines.bat EQUALLINE
>> %IPCONFIG% ECHO Displays configuration information
>> %IPCONFIG% CALL routines.bat MAKELINE
>> %IPCONFIG% ECHO OUTPUT: 
%t-os%\ipconfig /all >> %IPCONFIG%
>> %IPCONFIG% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %IPCONFIG% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\mem.exe /d
::+-----------------------------+
::|				|
::|Memory		 	|
::|				|
::+-----------------------------+

SET MEM=%MYPATH%\files\MEM.txt

>> %MEM% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time% 
ECHO Command:  MEM.exe /d | tee -a %LOG% >> %MEM% 
>> %MEM% CALL routines.bat EQUALLINE
>> %MEM% ECHO Displays memory usage
>> %MEM% CALL routines.bat MAKELINE
>> %MEM% ECHO OUTPUT: 
%t-os%\mem.exe /d >> %MEM%
>> %MEM% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %MEM% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net accounts
::+-----------------------------+
::|				|
::|NET ACCOUNTS			|
::|				|
::+-----------------------------+

SET NETACCT=%MYPATH%\files\NETACCT.txt

>> %NETACCT% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time% 
ECHO Command:  net accounts | tee -a %LOG% >> %NETACCT% 
>> %NETACCT% CALL routines.bat EQUALLINE
>> %NETACCT% ECHO Displays current settings for password, logon limitations, and domain information
>> %NETACCT% CALL routines.bat MAKELINE
>> %NETACCT% ECHO OUTPUT: 
%t-os%\net accounts >> %NETACCT%
>> %NETACCT% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETACCT% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net file
::+-----------------------------+
::|				|
::|NET FILE			|
::|				|
::+-----------------------------+

SET NETFILE=%MYPATH%\files\NETFILE.txt

>> %NETFILE% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time% 
ECHO Command:  net file | tee -a %LOG% >> %NETFILE% 
>> %NETFILE% CALL routines.bat EQUALLINE
>> %NETFILE% ECHO  Lists the open files on a server
>> %NETFILE% CALL routines.bat MAKELINE
>> %NETFILE% ECHO OUTPUT: 
%t-os%\net file >> %NETFILE%
>> %NETFILE% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETFILE% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net group
::+-----------------------------+
::|				|
::|NET GROUP			|
::|-- For Domain Controllers	|
::+-----------------------------+

SET NETGROUP=%MYPATH%\files\NETGROUP.txt

>> %NETGROUP% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time% 
ECHO Command:  net group | tee -a %LOG% >> %NETGROUP% 
>> %NETGROUP% CALL routines.bat EQUALLINE
>> %NETGROUP% ECHO Lists groups
>> %NETGROUP% CALL routines.bat MAKELINE
>> %NETGROUP% ECHO OUTPUT: 
%t-os%\net group >> %NETGROUP%
>> %NETGROUP% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETGROUP% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net localgroup
::+-----------------------------+
::|				|
::|NET LOCALGROUP		|
::|				|
::+-----------------------------+

SET NETLGRP=%MYPATH%\files\NETLGRP.txt

>> %NETLGRP% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time% 
ECHO Command:  net localgroup | tee -a %LOG% >> %NETLGRP% 
>> %NETLGRP% CALL routines.bat EQUALLINE
>> %NETLGRP% ECHO Lists local groups
>> %NETLGRP% CALL routines.bat MAKELINE
>> %NETLGRP% ECHO OUTPUT: 
%t-os%\net localgroup >> %NETLGRP%
>> %NETLGRP% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETLGRP%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net sessions 
::+-----------------------------+
::|				|
::|NET SESSIONS			|
::|				|
::+-----------------------------+

SET NETSESS=%MYPATH%\files\NETSESS.txt

>> %NETSESS% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  net sessions | tee -a %LOG% >> %NETSESS% 
>> %NETSESS% CALL routines.bat EQUALLINE
>> %NETSESS% ECHO  Displays NetBIOS client and server sessions
>> %NETSESS% CALL routines.bat MAKELINE
>> %NETSESS% ECHO OUTPUT: 
%t-os%\net sessions >> %NETSESS%
>> %NETSESS% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETSESS%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net share
::+-----------------------------+
::|				|
::|NET SHARE			|
::|				|
::+-----------------------------+

SET NETSHARE=%MYPATH%\files\NETSHARE.txt

>> %NETSHARE% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  net share | tee -a %LOG% >> %NETSHARE% 
>> %NETSHARE% CALL routines.bat EQUALLINE
>> %NETSHARE% ECHO  Lists information about all resources being shared on the computer
>> %NETSHARE% CALL routines.bat MAKELINE
>> %NETSHARE% ECHO OUTPUT: 
%t-os%\net share >> %NETSHARE%
>> %NETSHARE% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETSHARE%   
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net start
::+-----------------------------+
::|				|
::|NET START			|
::|				|
::+-----------------------------+

SET NETSTART=%MYPATH%\files\NETSTART.txt

>> %NETSTART% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  net start | tee -a %LOG% >> %NETSTART% 
>> %NETSTART% CALL routines.bat EQUALLINE
>> %NETSTART% ECHO Lists running services
>> %NETSTART% CALL routines.bat MAKELINE
>> %NETSTART% ECHO OUTPUT: 
%t-os%\net start >> %NETSTART%
>> %NETSTART% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETSTART%   
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\netstat -anr
::+-----------------------------+
::|				|
::|Netstat		 	|
::|				|
::+-----------------------------+

SET NETSTAT=%MYPATH%\files\NETSTAT.txt

>> %NETSTAT% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  netstat -anr | tee -a %LOG% >> %NETSTAT% 
>> %NETSTAT% CALL routines.bat EQUALLINE
>> %NETSTAT% ECHO Displays current network connections
>> %NETSTAT% CALL routines.bat MAKELINE
>> %NETSTAT% ECHO OUTPUT: 
%t-os%\netstat -anr >> %NETSTAT%
>> %NETSTAT% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETSTAT%   
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net use
::+-----------------------------+
::|				|
::|NET USE			|
::|				|
::+-----------------------------+

SET NETUSE=%MYPATH%\files\NETUSE.txt

>> %NETUSE% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  net use | tee -a %LOG% >> %NETUSE% 
>> %NETUSE% CALL routines.bat EQUALLINE
>> %NETUSE% ECHO Lists the computer's connections
>> %NETUSE% CALL routines.bat MAKELINE
>> %NETUSE% ECHO OUTPUT: 
%t-os%\net use >> %NETUSE%
>> %NETUSE% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETUSE%    
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net user
::+-----------------------------+
::|				|
::|NET USER			|
::|				|
::+-----------------------------+

SET NETUSER=%MYPATH%\files\NETUSER.txt

>> %NETUSER% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  net user | tee -a %LOG% >> %NETUSER% 
>> %NETUSER% CALL routines.bat EQUALLINE
>> %NETUSER% ECHO Lists the user accounts for the computer
>> %NETUSER% CALL routines.bat MAKELINE
>> %NETUSER% ECHO OUTPUT: 
%t-os%\net user >> %NETUSER%
>> %NETUSER% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETUSER%    
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\net view
::+-----------------------------+
::|				|
::|NET VIEW			|
::|				|
::+-----------------------------+

SET NETVIEW=%MYPATH%\files\NETVIEW.txt

>> %NETVIEW% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  net user | tee -a %LOG% >> %NETVIEW% 
>> %NETVIEW% CALL routines.bat EQUALLINE
>> %NETVIEW% ECHO Lists the computers in the current domain
>> %NETVIEW% CALL routines.bat MAKELINE
>> %NETVIEW% ECHO OUTPUT: 
%t-os%\net view >> %NETVIEW%
>> %NETVIEW% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NETVIEW%    
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\ROUTE print 
::+-----------------------------+
::|				|
::|route		 	|
::|				|
::+-----------------------------+

SET ROUTE=%MYPATH%\files\ROUTE.txt

>> %ROUTE% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  route print | tee -a %LOG% >> %ROUTE% 
>> %ROUTE% CALL routines.bat EQUALLINE
>> %ROUTE% ECHO Displays routing information
>> %ROUTE% CALL routines.bat MAKELINE
>> %ROUTE% ECHO OUTPUT: 
%t-os%\ROUTE print >> %ROUTE%
>> %ROUTE% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %ROUTE%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\%CMDSHELL% /C set
::+-----------------------------+
::|				|
::|SET			 	|
::|				|
::+-----------------------------+

SET SETENV=%MYPATH%\files\SETENV.txt

>> %SETENV% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  %CMDSHELL% /C set | tee -a %LOG% >> %SETENV% 
>> %SETENV% CALL routines.bat EQUALLINE
>> %SETENV% ECHO Displays environment variables
>> %SETENV% CALL routines.bat MAKELINE
>> %SETENV% ECHO OUTPUT: 
%t-os%\%CMDSHELL% /C set >> %SETENV%
>> %SETENV% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %SETENV% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\systeminfo
::+-----------------------------+
::|				|
::|System Info			|
::|				|
::+-----------------------------+

SET SYSINFO=%MYPATH%\files\SYSINFO.txt

>> %SYSINFO% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  systeminfo | tee -a %LOG% >> %SYSINFO% 
>> %SYSINFO% CALL routines.bat EQUALLINE
>> %SYSINFO% ECHO Various information about the machine
>> %SYSINFO% CALL routines.bat MAKELINE
>> %SYSINFO% ECHO OUTPUT: 
%t-os%\systeminfo >> %SYSINFO%
>> %SYSINFO% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %SYSINFO%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\arp -a
::+-----------------------------+
::|				|
::|Address Resolution Protocol 	|
::|				|
::+-----------------------------+

SET ARP=%MYPATH%\files\ARP.txt

>> %ARP% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  arp -a | tee -a %LOG% >> %ARP% 
>> %ARP% CALL routines.bat EQUALLINE
>> %ARP% ECHO Displays the IP-to-Physical address
>> %ARP% CALL routines.bat MAKELINE
>> %ARP% ECHO OUTPUT: 
%t-os%\arp -a >> %ARP%
>> %ARP% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %ARP%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-2k%\auditpol.exe
::+-----------------------------+
::|				|
::|Auditpol		 	|
::|				|
::+-----------------------------+

SET AUDITPOL=%MYPATH%\files\AUDITPOL.txt

>> %AUDITPOL% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  auditpol.exe | tee -a %LOG% >> %AUDITPOL% 
>> %AUDITPOL% CALL routines.bat EQUALLINE
>> %AUDITPOL% ECHO Enables the user to modify the audit policy of the local computer or of any 
>> %AUDITPOL% ECHO remote computer 
>> %AUDITPOL% CALL routines.bat MAKELINE
>> %AUDITPOL% ECHO OUTPUT: 
%t-2k%\auditpol.exe >> %AUDITPOL%
>> %AUDITPOL% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %AUDITPOL%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\WinLogon" /v legalnoticetext
::+-----------------------------+
::|				|
::|Banner			|
::|				|
::+-----------------------------+

SET REGB=%MYPATH%\files\regban.txt

>> %REGB% CALL routines.bat CR
>> %REGB% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\WinLogon /v LegalNoticeText" | tee -a %LOG% >> %REGB% 
>> %REGB% CALL routines.bat EQUALLINE
>> %REGB% ECHO Banner Information 
>> %REGB% CALL routines.bat MAKELINE
>> %REGB% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\WinLogon" /v legalnoticetext >> %REGB%
>> %REGB% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %REGB%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running dir /s /a:h /t:a c: d:
::+-----------------------------+
::|				|
::|DIR (Hidden Files)	 	|
::|				|
::+-----------------------------+
SET DIRHIDE=%MYPATH%\files\DIRHIDE.txt

>> %DIRHIDE% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  dir /s /a:h /t:a c: d: | tee -a %LOG% >> %DIRHIDE% 
>> %DIRHIDE% CALL routines.bat EQUALLINE
>> %DIRHIDE% ECHO List of hidden files.
>> %DIRHIDE% CALL routines.bat MAKELINE
>> %DIRHIDE% ECHO OUTPUT: 
dir /s /a:h /t:a c: >> %DIRHIDE%
rem dir /s /a:h /t:a d: >> %DIRHIDE%
>> %DIRHIDE% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %DIRHIDE%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running dir %USERPROFILE%\Start Menu\Programs\Startup
::+-----------------------------+
::|				|
::|List				|
::|				|
::+-----------------------------+

SET DIRLST=%MYPATH%\files\dirlst.txt


>> %DIRLST% ECHO Miscellaneous file list 
>> %DIRLST% CALL routines.bat CR

>> %DIRLST% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  dir %USERPROFILE%\Start Menu\Programs\Startup | tee -a %LOG% >> %DIRLST% 
>> %DIRLST% CALL routines.bat EQUALLINE
>> %DIRLST% ECHO List of Startup Programs
>> %DIRLST% CALL routines.bat MAKELINE
>> %DIRLST% ECHO OUTPUT: 
dir %USERPROFILE%\Start Menu\Programs\Startup >> %DIRLST%
>> %DIRLST% CALL routines.bat CR

>> %DIRLST% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  dir %WINDIR%\Tasks | tee -a %LOG% >> %DIRLST% 
>> %DIRLST% CALL routines.bat EQUALLINE
>> %DIRLST% ECHO Contains files specifying scheduled tasks, submitted via at.exe or Scheduled 
>> %DIRLST% ECHO Tasks Wizard...job files in this directory with the hidden bit set will not appear in the Scheduled 
>> %DIRLST% ECHO Tasks applet in the Control Panel.
>> %DIRLST% CALL routines.bat MAKELINE
>> %DIRLST% ECHO OUTPUT: 
dir %WINDIR%\Tasks >> %DIRLST%
>> %DIRLST% CALL routines.bat CR

>> %LOG% ECHO.
>> %LOG% md5deep %DIRLST%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-fnd%\fport.exe /p 
::+-----------------------------+
::|				|
::|Fport		 	|
::|				|
::+-----------------------------+

SET FPORT=%MYPATH%\files\FPORT.txt

>> %FPORT% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  fport.exe /p | tee -a %LOG% >> %FPORT% 
>> %FPORT% CALL routines.bat EQUALLINE
>> %FPORT% ECHO fport reports all open TCP/IP and UDP ports and maps them to the owning application. 
>> %FPORT% ECHO This is the same information you would see using the 'netstat -an' command, but it also maps those 
>> %FPORT% ECHO ports to running processes with the PID, process name and path. Fport can be used to quickly identify 
>> %FPORT% ECHO unknown open ports and their associated applications. 
>> %FPORT% CALL routines.bat MAKELINE
>> %FPORT% ECHO OUTPUT: 
%t-fnd%\fport.exe /p >> %FPORT%
>> %FPORT% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %FPORT%  
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-fnd%\hunt.exe \\127.0.0.1
::+-----------------------------+
::|				|
::|Hunt			 	|
::|				|
::+-----------------------------+

SET HUNT=%MYPATH%\files\HUNT.txt

>> %HUNT% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  hunt.exe \\127.0.0.1 | tee -a %LOG% >> %HUNT% 
>> %HUNT% CALL routines.bat EQUALLINE
>> %HUNT% ECHO Hunt is a quick way to see if a server reveals too much info via NULL sessions. 
>> %HUNT% CALL routines.bat MAKELINE
>> %HUNT% ECHO OUTPUT: 
%t-fnd%\hunt.exe \\127.0.0.1 >> %HUNT%
>> %HUNT% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %HUNT% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-os%\nbtstat -c 
::+-----------------------------+
::|				|
::|Nbtstat		 	|
::|				|
::+-----------------------------+

SET NBTSTAT=%MYPATH%\files\NBTSTAT.txt

>> %NBTSTAT% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  nbtstat -c | tee -a %LOG% >> %NBTSTAT% 
>> %NBTSTAT% CALL routines.bat EQUALLINE
>> %NBTSTAT% ECHO Displays current connections using NetBIOS over TCP/IP
>> %NBTSTAT% CALL routines.bat MAKELINE
>> %NBTSTAT% ECHO OUTPUT: 
%t-os%\nbtstat -c >> %NBTSTAT%
>> %NBTSTAT% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NBTSTAT% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-fnd%\ntlast.exe -v -s 
::+-----------------------------+
::|				|
::|NTlast (Successful)	 	|
::|				|
::+-----------------------------+

SET NTLAST=%MYPATH%\files\NTLAST.txt

>> %NTLAST% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  ntlast.exe -v -s | tee -a %LOG% >> %NTLAST% 
>> %NTLAST% CALL routines.bat EQUALLINE
>> %NTLAST% ECHO NTLast is specifically targeted for serious security and IIS administration. Scheduled 
>> %NTLAST% ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
>> %NTLAST% ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
>> %NTLAST% ECHO details is now made easier with NTLast. This tool is able to quickly report on the status of IIS users, 
>> %NTLAST% ECHO as well as filter out web server logons from console logons.  
>> %NTLAST% CALL routines.bat MAKELINE
>> %NTLAST% ECHO OUTPUT: 
%t-fnd%\ntlast.exe -v -s >> %NTLAST%
>> %NTLAST% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NTLAST% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-fnd%\NTLAST.exe -v -f
::+-----------------------------+
::|				|
::|NTLAST (FAILED)	 	|
::|				|
::+-----------------------------+

SET NTLASTF=%MYPATH%\files\NTLASTF.txt

>> %NTLASTF% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  NTLAST.exe -v -f | tee -a %LOG% >> %NTLASTF% 
>> %NTLASTF% CALL routines.bat EQUALLINE
>> %NTLASTF% ECHO NTLASTF is specifically targeted for serious security and IIS administration. Scheduled 
>> %NTLASTF% ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
>> %NTLASTF% ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
>> %NTLASTF% ECHO details is now made easier with NTLASTF. This tool is able to quickly report on the status of IIS users, 
>> %NTLASTF% ECHO as well as filter out web server logons from console logons.  
>> %NTLASTF% CALL routines.bat MAKELINE
>> %NTLASTF% ECHO OUTPUT: 
%t-fnd%\NTLAST.exe -v -f >> %NTLASTF%
>> %NTLASTF% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NTLASTF%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-fnd%\NTLAST.exe -v -i
::+-----------------------------+
::|				|
::|NTLAST (Interactive)	 	|
::|				|
::+-----------------------------+

SET NTLASTI=%MYPATH%\files\NTLASTI.txt

>> %NTLASTI% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  NTLAST.exe -v -i | tee -a %LOG% >> %NTLASTI% 
>> %NTLASTI% CALL routines.bat EQUALLINE
>> %NTLASTI% ECHO NTLASTI is specifically targeted for serious security and IIS administration. Scheduled 
>> %NTLASTI% ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
>> %NTLASTI% ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
>> %NTLASTI% ECHO details is now made easier with NTLASTI. This tool is able to quickly report on the status of IIS users, 
>> %NTLASTI% ECHO as well as filter out web server logons from console logons.  
>> %NTLASTI% CALL routines.bat MAKELINE
>> %NTLASTI% ECHO OUTPUT: 
%t-fnd%\NTLAST.exe -v -i >> %NTLASTI%
>> %NTLASTI% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NTLASTI%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-fnd%\NTLAST.exe -v -r 
::+-----------------------------+
::|				|
::|NTLAST (remote)	 	|
::|				|
::+-----------------------------+

SET NTLASTR=%MYPATH%\files\NTLASTR.txt

>> %NTLASTR% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  NTLAST.exe -v -r | tee -a %LOG% >> %NTLASTR% 
>> %NTLASTR% CALL routines.bat EQUALLINE
>> %NTLASTR% ECHO NTLASTR is specifically targeted for serious security and IIS administration. Scheduled 
>> %NTLASTR% ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
>> %NTLASTR% ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
>> %NTLASTR% ECHO details is now made easier with NTLASTR. This tool is able to quickly report on the status of IIS users, 
>> %NTLASTR% ECHO as well as filter out web server logons from console logons.  
>> %NTLASTR% CALL routines.bat MAKELINE
>> %NTLASTR% ECHO OUTPUT: 
%t-fnd%\NTLAST.exe -v -r >> %NTLASTR%
>> %NTLASTR% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NTLASTR%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-fnd%\NTLAST.exe -v -s 
::+-----------------------------+
::|				|
::|NTLAST (Successful)	 	|
::|				|
::+-----------------------------+

SET NTLASTS=%MYPATH%\files\NTLASTS.txt

>> %NTLASTS% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  NTLAST.exe -v -s | tee -a %LOG% >> %NTLASTS% 
>> %NTLASTS% CALL routines.bat EQUALLINE
>> %NTLASTS% ECHO NTLASTS is specifically targeted for serious security and IIS administration. Scheduled 
>> %NTLASTS% ECHO review of your NT event logs is critical for your network. A server breach can be uncovered by regular 
>> %NTLASTS% ECHO system auditing. Identifying and tracking who has gained access to your system, then documenting the 
>> %NTLASTS% ECHO details is now made easier with NTLASTS. This tool is able to quickly report on the status of IIS users,
>> %NTLASTS% ECHO as well as filter out web server logons from console logons.  
>> %NTLASTS% CALL routines.bat MAKELINE
>> %NTLASTS% ECHO OUTPUT: 
%t-fnd%\NTLAST.exe -v -s >> %NTLASTS%
>> %NTLASTS% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %NTLASTS%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\pclip.exe
::+-----------------------------+
::|				|
::|pclip		 	|
::|				|
::+-----------------------------+

SET PCLIP=%MYPATH%\files\PCLIP.txt

>> %PCLIP% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  pclip | tee -a %LOG% >> %PCLIP% 
>> %PCLIP% CALL routines.bat EQUALLINE
>> %PCLIP% ECHO Get the contents of the clipboard
>> %PCLIP% CALL routines.bat MAKELINE
>> %PCLIP% ECHO OUTPUT: 
%t-bin%\pclip.exe >> %PCLIP%
>> %PCLIP% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PCLIP%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\procinterrogate -list
::+-----------------------------+
::|				|
::|Procinterrogate	 	|
::|				|
::+-----------------------------+
REM winfingerprint.sourceforge.net
SET PROCINT=%MYPATH%\files\PROCINT.txt

>> %PROCINT% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  procinterrogate -list | tee -a %LOG% >> %PROCINT%  
>> %PROCINT% CALL routines.bat EQUALLINE
>> %PROCINT% ECHO Lists all processes, process ids and their associated dlls.
>> %PROCINT% CALL routines.bat MAKELINE
>> %PROCINT% ECHO OUTPUT: 
%t-bin%\procinterrogate -list >> %PROCINT%
>> %PROCINT% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PROCINT%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-cyg%\PS.exe -ealW 
::+-----------------------------+
::|				|
::|ps 			 	|
::|				|
::+-----------------------------+

SET PS=%MYPATH%\files\PS.txt

>> %PS% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  PS.exe -ealW | tee -a %LOG% >> %PS% 
>> %PS% CALL routines.bat EQUALLINE
>> %PS% ECHO Display process status
>> %PS% CALL routines.bat MAKELINE
>> %PS% ECHO OUTPUT: 
%t-cyg%\PS.exe -ealW >> %PS%
>> %PS% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PS%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-sys%\PSFILE.exe
::+-----------------------------+
::|				|
::|PSFILEfile		 	|
::|				|
::+-----------------------------+

SET PSFILE=%MYPATH%\files\PSFILE.txt

>> %PSFILE% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  PSFILE.exe | tee -a %LOG% >> %PSFILE% 
>> %PSFILE% CALL routines.bat EQUALLINE
>> %PSFILE% ECHO PsFile shows a list of files on a system that are opened remotely, and it also allows 
>> %PSFILE% ECHO you to close opened files either by name or by a file identifier. The "net file" command shows you a 
>> %PSFILE% ECHO list of the files that other computers have opened on the system upon which you execute the command, 
>> %PSFILE% ECHO however it truncates long path names and doesn't let you see that information for remote systems. 
>> %PSFILE% CALL routines.bat MAKELINE
>> %PSFILE% ECHO OUTPUT: 
%t-sys%\PSFILE.exe >> %PSFILE%
>> %PSFILE% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PSFILE%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-sys%\psinfo
::+-----------------------------+
::|				|
::|PS INFO			|
::|				|
::+-----------------------------+

SET PSINFO=%MYPATH%\files\PSINFO.txt

>> %PSINFO% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  psinfo | tee -a %LOG%  >> %PSINFO% 
>> %PSINFO% CALL routines.bat EQUALLINE
>> %PSINFO% ECHO PsInfo is a command-line tool that gathers key information about the local or remote 
>> %PSINFO% ECHO Windows NT/2000 system, including the type of installation, kernel build, registered organization and 
>> %PSINFO% ECHO owner, number of processors and their type, amount of physical memory, the install date of the system, 
>> %PSINFO% ECHO and if its a trial version, the expiration date.
>> %PSINFO% CALL routines.bat MAKELINE
>> %PSINFO% ECHO OUTPUT: 
%t-sys%\psinfo >> %PSINFO%
>> %PSINFO% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PSINFO%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-sys%\PSLIST -x 
::+-----------------------------+
::|				|
::|pslist 		 	|
::|				|
::+-----------------------------+

SET PSLIST=%MYPATH%\files\PSLIST.txt

>> %PSLIST% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  pslist.exe -x | tee -a %LOG% >> %PSLIST% 
>> %PSLIST% CALL routines.bat EQUALLINE
>> %PSLIST% ECHO PsList is utility that shows you a combination of the information obtainable individually 
>> %PSLIST% ECHO with pmon and pstat. You can view process CPU and memory information, or thread statistics. What makes 
>> %PSLIST% ECHO PsList more powerful than the Resource Kit tools is that you can view process and thread statistics on 
>> %PSLIST% ECHO a remote computer.
>> %PSLIST% CALL routines.bat MAKELINE
>> %PSLIST% ECHO OUTPUT: 
%t-sys%\PSLIST -x >> %PSLIST%
>> %PSLIST% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PSLIST%
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-sys%\psloggedon 
::+-----------------------------+
::|				|
::|psloggedon 		 	|
::|				|
::+-----------------------------+

SET PSLOGON=%MYPATH%\files\PSLOGON.txt

>> %PSLOGON% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  psloggedon | tee -a %LOG% >> %PSLOGON% 
>> %PSLOGON% CALL routines.bat EQUALLINE
>> %PSLOGON% ECHO PsLoggedOn's definition of a locally logged on user is one that has their profile loaded 
>> %PSLOGON% ECHO into the Registry, so PsLoggedOn determines who is logged on by scanning the keys under the HKEY_USERS 
>> %PSLOGON% ECHO key. For each key that has a name that is a user SID (security Identifier), PsLoggedOn looks up the 
>> %PSLOGON% ECHO corresponding user name and displays it. To determine who is logged onto a computer via resource shares, 
>> %PSLOGON% ECHO PsLoggedOn uses the NetSessionEnum API. Note that PsLoggedOn will show you as logged on via resource 
>> %PSLOGON% ECHO share to remote computers that you query because a logon is required for PsLoggedOn to access the Registry 
>> %PSLOGON% ECHO of a remote system.
>> %PSLOGON% CALL routines.bat MAKELINE
>> %PSLOGON% ECHO OUTPUT: 
%t-sys%\psloggedon >> %PSLOGON%
>> %PSLOGON% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PSLOGON%
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-sys%\psservice
::+-----------------------------+
::|				|
::|psService		 	|
::|				|
::+-----------------------------+

SET PSSRVC=%MYPATH%\files\PSSRVC.txt

>> %PSSRVC% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  psservice | tee -a %LOG% >> %PSSRVC%  
>> %PSSRVC% CALL routines.bat EQUALLINE
>> %PSSRVC% ECHO PsService is a service viewer and controller for Windows NT/2K. Like the SC utility that's 
>> %PSSRVC% ECHO included in the Windows NT and Windows 2000 Resource Kits, PsService displays the status, configuration, 
>> %PSSRVC% ECHO and dependencies of a service, and allows you to start, stop, pause, resume and restart them. Unlike 
>> %PSSRVC% ECHO the SC utility, PsService enables you to logon to a remote system using a different account, for cases 
>> %PSSRVC% ECHO when the account from which you run it doesn't have required permissions on the remote system. PsService 
>> %PSSRVC% ECHO includes a unique service-search capability, which identifies active instances of a service on your 
>> %PSSRVC% ECHO network. You would use the search feature if you wanted to locate systems running DHCP servers, for instance. 
>> %PSSRVC% CALL routines.bat MAKELINE
>> %PSSRVC% ECHO OUTPUT: 
%t-sys%\psservice >> %PSSRVC%
>> %PSSRVC% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PSSRVC%
>> %LOG% ECHO.


REM SET /A COUNT=COUNT+1
REM ECHO %COUNT% Running %t-2k%\pulist
REM ::+-----------------------------+
REM ::|				|
REM ::|pulist 		 	|
REM ::|				|
REM ::+-----------------------------+
REM
REM SET PULIST=%MYPATH%\files\PULIST.txt
REM 
REM >> %PULIST% CALL routines.bat EQUALLINE
REM >> %LOG% ECHO %time%
REM ECHO Command:  pulist | tee -a %LOG% >> %PULIST% 
REM >> %PULIST% CALL routines.bat EQUALLINE
REM >> %PULIST% ECHO Displays processes running on local or remote computers. PuList is similar to TList (a Support 
REM >> %PULIST% ECHO Tool on the Windows 2000 CD), but also lists the user name associated with each process on a local computer.
REM >> %PULIST% CALL routines.bat MAKELINE
REM >> %PULIST% ECHO OUTPUT: 
REM %t-2k%\pulist >> %PULIST%
REM >> %PULIST% CALL routines.bat CR
REM >> %LOG% ECHO.
REM >> %LOG% md5deep %PULIST% 
REM >> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\"
::+-----------------------------+
::|				|
::|AutoStart Registry Keys	|
::|				|
::+-----------------------------+

SET REGA=%MYPATH%\files\regautos.txt


>> %REGA% ECHO AutoStart Registry Entries
>> %REGA% CALL routines.bat CR

>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\" | tee -a %LOG% >> %REGA%  
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Lists programs to be run when system starts. 
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Lists programs to be run when system starts. 
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Run\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Lists programs to be run when system starts.  On 2K and XP, these entries are 
>> %REGA% ECHO ignored when booted to Safe Mode; however, entries preceded by "*" will be processed 
>> %REGA% ECHO even when booted to Safe Mode.  On XP, these 'Run' keys are referred to as the 'legacy Run list', 
>> %REGA% ECHO as they are provided for backwards compatibility with previous versions of Windows. 
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Run\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Run\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Lists programs to be run when system starts.  On 2K and XP, these entries are 
>> %REGA% ECHO ignored when booted to Safe Mode; however, entries preceded by "*" will be processed even when 
>> %REGA% ECHO booted to Safe Mode.  On XP, these 'Run' keys are referred to as the 'legacy Run list', as 
>> %REGA% ECHO they are provided for backwards compatibility with previous versions of Windows. 
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Run\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce\" | tee -a %LOG% >> %REGA%
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce\Setup\" | tee -a %LOG% >> %REGA%
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\RunOnce\" | tee -a %LOG% >> %REGA%
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnceEx\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Lists programs to be run once when the system starts, and deleted. The commands 
>> %REGA% ECHO listed here are deleted before the actual commands are run.  If the command is preceded by "!", 
>> %REGA% ECHO the command is deleted after the command is run.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce\" >> %REGA%
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce\Setup\" >> %REGA%
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\RunOnce\" >> %REGA%
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnceEx\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\BrowserHelperObjects\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Browser Helper Objects (BHOs) are in-process COM components loaded each time Internet Explorer starts 
>> %REGA% ECHO up.  These components run in the same memory context as the browser.  with Active Desktop, Windows Explorer will 
>> %REGA% ECHO also support BHOs.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\BrowserHelperObjects\" >> %REGA%
>> %REGA% CALL routines.bat CR

>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\SharedTaskScheduler\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Entries in this key are automatically loaded by Explorer.exe when Windows starts.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\SharedTaskScheduler\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Classes\exefile\shell\open\command\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO The Default setting for these entries is '"%1" %*'.  Some malware will add entries to 
>> %REGA% ECHO have other things run.  Also, may need to examine other file types under the Classes key, as well 
>> %REGA% ECHO (ie, any file classes that point to an app, with a .exe extension).  These entires map to 
>> %REGA% ECHO HKCR\{ext}file\shell\open\command.  Other entries under the HKLM\Software\Classes (and HKCR) key 
>> %REGA% ECHO are succeptible to this same sort of subversion.  For example, navigate via RegEdit to the 
>> %REGA% ECHO HKCR\Drive\shell\cmd\command key, right-click on the "Default" value, and choose Modify.  In the 
>> %REGA% ECHO textfield, add "&& notepad.exe", and click OK.  Open My Computer, select a drive, right-click and 
>> %REGA% ECHO choose "Open Command Prompt here..."...both cmd.exe and notepad.exe will run.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Classes\exefile\shell\open\command\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\CommandProcessor" /v AutoRun | tee -a %LOG% >> %REGA%
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CommandProcessor" /v AutoRun  | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Commands listed here are executed before all other options listed at the command line; disabled 
>> %REGA% ECHO by /d switch; REG_SZ data type.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\CommandProcessor" /v AutoRun  >> %REGA%
%t-bin%\reg query "HKCU\Software\Microsoft\CommandProcessor" /v AutoRun  >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\ShellServiceObjectDelayLoad\" | tee -a %LOG% >> %REGA%
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\ShellServiceObjectDelayLoad\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Points to the InProcServer for a CLSID; The values found in this key can be mapped to 
>> %REGA% ECHO HKLM\Software\Classes\CLSID\{GUID}\InProcServer; Items listed here are loaded by Explorer when Windows 
>> %REGA% ECHO starts; Used by malware
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\ShellServiceObjectDelayLoad\" >> %REGA%
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\ShellServiceObjectDelayLoad\" >> %REGA%
>> %REGA% CALL routines.bat CR

>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v load | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Replaces the use of the "load=" line in Win.ini
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v load >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v run | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Replaces the use of the "run=" line in Win.ini
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v run >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Policies\Microsoft\Windows\System\Scripts\" | tee -a %LOG% >> %REGA%
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Policies\Microsoft\Windows\System\Scripts\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Points to scripts for various events (ie, logon, logoff, shutdown, etc.); Usually handled via 
>> %REGA% ECHO GPOs, but can also be configured via local security policies
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Policies\Microsoft\Windows\System\Scripts\" >> %REGA%
%t-bin%\reg query "HKCU\Software\Policies\Microsoft\Windows\System\Scripts\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\System" /v Shell | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Can specify an alternate user shell
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\System" /v Shell >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v AppInit_DLLs | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO DLLs specified within this key are loaded whenever a Windows-based (GUI) application is launched.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Windows" /v AppInit_DLLs >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v GinaDLL | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO This entry can be subverted to load an alternate GINA, capable of capturing the user's login information 
>> %REGA% ECHO in plain text (ie, FakeGINA.DLL from NTSecurity.nu).  This is loaded and used by WinLogon.exe.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v GinaDLL >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v Shell | tee -a %LOG% >> %REGA%
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v Shell | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Indicates executable files launched by Userinit.exe and expected at user shell startup. 
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v Shell >> %REGA%
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v Shell >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v System | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Indicates programs to be executed in System mode.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v System >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v TaskMan | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Specifies the Task Manager to be used by Windows.  The default is TaskMan.exe, but the SysInternals.com 
>> %REGA% ECHO tool, Process Explorer, can replace this value.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v TaskMan >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v UserInit | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Lists programs to be automatically run when the user logs in.  Userinit.exe is responsible for shell execution.  
>> %REGA% ECHO Nddeagnt.exe is responsible for NetDDE.  Multiple programs may be listed.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v UserInit >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon\Notify\" | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Specifies programs to be run when certain system events (ie, logon, logoff, startup, shutdown, startscreensaver, 
>> %REGA% ECHO stopscreensaver) occur.  The event is generated by Winlogon.exe, at which point the system will look for a DLL 
>> %REGA% ECHO within this key to handle the event.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\Winlogon\Notify\" >> %REGA%
>> %REGA% CALL routines.bat CR


>> %REGA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\System\CurrentControlSet\Control\Session Manager" /v BootExecute | tee -a %LOG% >> %REGA%
>> %REGA% CALL routines.bat EQUALLINE
>> %REGA% ECHO Specifies the applications, services, and commands executed during startup.
>> %REGA% CALL routines.bat MAKELINE
>> %REGA% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\System\CurrentControlSet\Control\Session Manager" /v BootExecute >> %REGA%
>> %REGA% CALL routines.bat CR

>> %LOG% ECHO.
>> %LOG% md5deep %REGA% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v NtfsDisableLastAccessUpdate

::+-----------------------------+
::|				|
::|Various Registry Keys	|
::|				|
::+-----------------------------+
 
SET REGM=%MYPATH%\files\regmisc.txt


>> %REGM% ECHO Miscellaneous Registry Entries
>> %REGM% CALL routines.bat CR

>> %REGM% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v NtfsDisableLastAccessUpdate | tee -a %LOG% >> %REGM%
>> %REGM% CALL routines.bat EQUALLINE
>> %REGM% ECHO If set to 1, updating of last access times is disabled.  This can be "very bad' for forensics. 
>> %REGM% CALL routines.bat MAKELINE
>> %REGM% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v NtfsDisableLastAccessUpdate >> %REGM%
>> %REGM% CALL routines.bat CR 

>> %REGM% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKLM\System\CurrentControlSet\Control\Session Manager\KnownDLLs\" | tee -a %LOG% >> %REGM%
>> %REGM% CALL routines.bat EQUALLINE
>> %REGM% ECHO Contains a list of DLLs to be loaded at system start
>> %REGM% CALL routines.bat MAKELINE
>> %REGM% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\System\CurrentControlSet\Control\Session Manager\KnownDLLs\" >> %REGM%
>> %REGM% CALL routines.bat CR 

>> %REGM% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v defaultdomainname | tee -a %LOG% >> %REGM%
>> %REGM% CALL routines.bat EQUALLINE
>> %REGM% ECHO Domain Name
>> %REGM% CALL routines.bat MAKELINE
>> %REGM% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v defaultdomainname >> %REGM%
>> %REGM% CALL routines.bat CR


>> %REGM% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v defaultusername | tee -a %LOG% >> %REGM%
>> %REGM% CALL routines.bat EQUALLINE
>> %REGM% ECHO User Name
>> %REGM% CALL routines.bat MAKELINE
>> %REGM% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v defaultusername >> %REGM%
>> %REGM% CALL routines.bat CR


>> %REGM% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v legalnoticecaption | tee -a %LOG% >> %REGM%
>> %REGM% CALL routines.bat EQUALLINE
>> %REGM% ECHO Legal notice caption
>> %REGM% CALL routines.bat MAKELINE
>> %REGM% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows NT\CurrentVersion\Winlogon" /v legalnoticecaption >> %REGM%
>> %REGM% CALL routines.bat CR

>> %LOG% ECHO.
>> %LOG% md5deep %REGM% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\Paint\Recent File List"
::+-----------------------------+
::|				|
::|User Activity Registry Keys	|
::|				|
::+-----------------------------+
:: The Registry entries listed here record user activity, and can 
:: be used in conjunction with the key LastWrite time to create a 
:: timeline of user activity.  Many of these keys are referred to as MRU keys.

 
SET REGUA=%MYPATH%\files\regUA.txt


>> %REGUA% ECHO User Activity Registry Entries
>> %REGUA% CALL routines.bat CR

>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\Paint\Recent File List" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Key Maintains a list of image files accessed with Paint
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\Paint\Recent File List" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\RegEdit" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO The LastKey value maintains the last key accessed using RegEdit
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\RegEdit" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\RegEdit\Favorites" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Maintains a list of favorites added through Favorites menu item in RegEdit
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\RegEdit\Favorites" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\WordPad\Recent File List" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO List of files accessed/saved in WordPad
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\CurrentVersion\Applets\WordPad\Recent File List" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Search Assistant\ACMru" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Maintains a list of items searched for via Start-Search; the subkeys (5001, 5603, 
>> %REGUA% ECHO 5604, etc.) correspond to the textfields where the user enters search parameters.
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Search Assistant\ACMru" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\LastVisitedMRU" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Maintains a list of programs accessed, and their locations within the file system.  Sort via the MRUList.
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\LastVisitedMRU" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\StreamMRU" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Maintains a list of files that are opened 
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\StreamMRU" >> %REGUA%
>> %REGUA% CALL routines.bat CR 

>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Doc Find Spec MRU" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Maintains a list of entries typed into the Start-Run box
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Doc Find Spec MRU" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FindComputerMRU" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Maintains a list of entries for computers searched for via Windows Explorer
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FindComputerMRU" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FindComputerMRU" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Maintains a list of entries for computers searched for via Windows Explorer
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FindComputerMRU" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Map Network Drive MRU" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Maintains a list of drive mapped via the Map Network Drive Wizard.
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Map Network Drive MRU" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComputerDescriptions" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Values beneath this key are names or IP addresses of machines connected to.
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComputerDescriptions" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\MountPoints2" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO Subkeys that start with "#" are paths to drives that have been mounted; includes 
>> %REGUA% ECHO the use of the "net use" command.  BaseClass value will usually be "Drive".
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\MountPoints2" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\MediaPlayer\Player\RecentFileList" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO List of files (movies - .mpg, etc.) accessed via Media Player
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\MediaPlayer\Player\RecentFileList" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Microsoft\MediaPlayer\Player\RecentURLList" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO List of files (movies - .mpg, etc.) accessed via Media Player
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\MediaPlayer\Player\RecentURLList" >> %REGUA%
>> %REGUA% CALL routines.bat CR 


>> %REGUA% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command: reg query "HKCU\Software\Nico Mak Computing\WinZip\filemenu" | tee -a %LOG% >> %REGUA%
>> %REGUA% CALL routines.bat EQUALLINE
>> %REGUA% ECHO List of recently used WinZip archives
>> %REGUA% CALL routines.bat MAKELINE
>> %REGUA% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Nico Mak Computing\WinZip\filemenu" >> %REGUA%
>> %REGUA% CALL routines.bat CR 

>> %LOG% ECHO.
>> %LOG% md5deep %REGUA% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKCU\Software\Microsoft\Internet Explorer\TypedURLs"
::+-----------------------------+
::|				|
::|TYPED URLs			|
::|				|
::+-----------------------------+

SET TYPEDURLS=%MYPATH%\files\TYPEDURLS.txt

>> %TYPEDURLS% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  reg query "HKCU\Software\Microsoft\Internet Explorer\TypedURLs" | tee -a %LOG% >> %TYPEDURLS%
>> %TYPEDURLS% CALL routines.bat EQUALLINE
>> %TYPEDURLS% ECHO Maintains a list of URLs typed into the IE Address bar
>> %TYPEDURLS% CALL routines.bat MAKELINE
>> %TYPEDURLS% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Internet Explorer\TypedURLs" >> %TYPEDURLS%
>> %TYPEDURLS% CALL routines.bat CR
>> %LOG% md5deep %TYPEDURLS% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\OpenSaveMRU" /S 
::+-----------------------------+
::|				|
::|Last files open/saved	|
::|				|
::+-----------------------------+

SET LASTSAVED=%MYPATH%\files\LASTSAVED.txt

>> %LASTSAVED% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\OpenSaveMRU" /S | tee -a %LOG% >> %LASTSAVED%
>> %LASTSAVED% CALL routines.bat EQUALLINE
>> %LASTSAVED% ECHO Maintains a list of files that are opened or saved via Windows Explorer-style dialog boxes
>> %LASTSAVED% CALL routines.bat MAKELINE
>> %LASTSAVED% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\ComDlg32\OpenSaveMRU" /S >> %LASTSAVED%
>> %LASTSAVED% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %LASTSAVED% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall" /S
::+-----------------------------+
::|				|
::|Install History		|
::|				|
::+-----------------------------+

SET INSTALLH=%MYPATH%\files\INSTALLH.txt

>> %INSTALLH% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall" /S | tee -a %LOG% >> %INSTALLH%
>> %INSTALLH% CALL routines.bat EQUALLINE
>> %INSTALLH% ECHO List of files that were installed
>> %INSTALLH% CALL routines.bat MAKELINE
>> %INSTALLH% ECHO OUTPUT: 
%t-bin%\reg query "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall" /S >> %INSTALLH%
>> %INSTALLH% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %INSTALLH% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RunMRU"
::+-----------------------------+
::|				|
::|Run Commands			|
::|				|
::+-----------------------------+

SET RUNCOM=%MYPATH%\files\RUNCOM.txt

>> %RUNCOM% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RunMRU" | tee -a %LOG% >> %RUNCOM%
>> %RUNCOM% CALL routines.bat EQUALLINE
>> %RUNCOM% ECHO Maintains a list of entries typed into the Start-Run box
>> %RUNCOM% CALL routines.bat MAKELINE
>> %RUNCOM% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RunMRU" >> %RUNCOM%
>> %RUNCOM% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %RUNCOM% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RecentDocs"
::+-----------------------------+
::|				|
::|Recent Docs			|
::|				|
::+-----------------------------+

SET RECDOCS=%MYPATH%\files\RECDOCS.txt

>> %RECDOCS% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RecentDocs" | tee -a %LOG% >> %RECDOCS%
>> %RECDOCS% CALL routines.bat EQUALLINE
>> %RECDOCS% ECHO List of Recent Docs; Need to convert hex to text
>> %RECDOCS% CALL routines.bat MAKELINE
>> %RECDOCS% ECHO OUTPUT: 
%t-bin%\reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\RecentDocs" >> %RECDOCS%
>> %RECDOCS% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %RECDOCS% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-cyg%\ls -alR %HOMEDRIVE%\recycler
::+-----------------------------+
::|				|
::|Recycler			|
::|				|
::+-----------------------------+

SET recycler=%MYPATH%\files\recycler.txt

>> %recycler% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  ls -alR %HOMEDRIVE%\recycler | tee -a %LOG% >> %recycler%
>> %recycler% CALL routines.bat EQUALLINE
>> %recycler% ECHO List of files in the recycle bin
>> %recycler% CALL routines.bat MAKELINE
>> %recycler% ECHO OUTPUT: 
%t-cyg%\ls -alR %HOMEDRIVE%\recycler >> %recycler%
>> %recycler% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %recycler% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running dir %SYSTEMROOT%\Prefetch
::+-----------------------------+
::|				|
::|Prefetch			|
::|				|
::+-----------------------------+

SET prefetch=%MYPATH%\files\prefetch.txt

>> %prefetch% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  dir %SYSTEMROOT%\Prefetch | tee -a %LOG% >> %prefetch%
>> %prefetch% CALL routines.bat EQUALLINE
>> %prefetch% ECHO On XP, handles boot and application launch prefetching.  Prefetch files for 
>> %DIRLST% ECHO application launch contain information regarding path to executeable, etc. Layout.ini file 
>> %DIRLST% ECHO contains a list files used by system defrag utility. On 2K3, only boot prefetching is done, by 
>> %DIRLST% ECHO default.
>> %prefetch% CALL routines.bat MAKELINE
>> %prefetch% ECHO OUTPUT: 
dir %SYSTEMROOT%\Prefetch >> %prefetch%
>> %prefetch% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %prefetch% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running dir %USERPROFILE%\Recent
::+-----------------------------+
::|				|
::|Recent			|
::|				|
::+-----------------------------+

SET recent=%MYPATH%\files\recent.txt

>> %recent% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  dir %USERPROFILE%\Recent | tee -a %LOG% >> %recent%
>> %recent% CALL routines.bat EQUALLINE
>> %recent% ECHO List of recently opened files
>> %recent% CALL routines.bat MAKELINE
>> %recent% ECHO OUTPUT: 
dir "%USERPROFILE%\Recent" >> %recent%
>> %recent% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %recent% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-bin%\servicelist.exe \\127.0.0.1
::+-----------------------------+
::|				|
::|Servicelist		 	|
::|				|
::+-----------------------------+

SET SRVCLIST=%MYPATH%\files\SRVCLIST.txt

>> %SRVCLIST% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  servicelist.exe \\127.0.0.1 | tee -a %LOG% >> %SRVCLIST% 
>> %SRVCLIST% CALL routines.bat EQUALLINE
>> %SRVCLIST% ECHO Displays running services on a system 
>> %SRVCLIST% CALL routines.bat MAKELINE
>> %SRVCLIST% ECHO OUTPUT: 
%t-bin%\servicelist.exe \\127.0.0.1 >> %SRVCLIST%
>> %SRVCLIST% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %SRVCLIST% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-2k%\dumpel.exe -t -l application 
::+-----------------------------+
::|				|
::|dumpel (Application Log)	|
::|				|
::+-----------------------------+

SET APPLOG=%MYPATH%\files\APPLOG.txt

>> %APPLOG% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  dumpel.exe -t -l application | tee -a %LOG% >> %APPLOG%
>> %APPLOG% CALL routines.bat EQUALLINE
>> %APPLOG% ECHO Dump Event Log is a command-line tool that dumps an event log for a local or remote system into a 
>> %APPLOG% ECHO  tab-separated text file. This tool can also be used to filter for or filter out certain event types.
>> %APPLOG% CALL routines.bat MAKELINE
>> %APPLOG% ECHO OUTPUT: 
%t-2k%\dumpel.exe -t -l application >> %APPLOG%
>> %APPLOG% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %APPLOG% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-2k%\dumpel.exe -t -l security
::+-----------------------------+
::|				|
::|dumpel (Security Log)	|
::|				|
::+-----------------------------+

SET SECLOG=%MYPATH%\files\SECLOG.txt

>> %SECLOG% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  dumpel.exe -t -l security | tee -a %LOG% >> %SECLOG%
>> %SECLOG% CALL routines.bat EQUALLINE
>> %SECLOG% ECHO Dump Event Log is a command-line tool that dumps an event log for a local or remote system into a 
>> %SECLOG% ECHO  tab-separated text file. This tool can also be used to filter for or filter out certain event types.
>> %SECLOG% CALL routines.bat MAKELINE
>> %SECLOG% ECHO OUTPUT: 
%t-2k%\dumpel.exe -t -l security >> %SECLOG%
>> %SECLOG% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %SECLOG% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-2k%\dumpel.exe -t -l system 
::+-----------------------------+
::|				|
::|dumpel (System Log)		|
::|				|
::+-----------------------------+

SET SYSLOG=%MYPATH%\files\SYSLOG.txt

>> %SYSLOG% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  dumpel.exe -t -l system | tee -a %LOG% >> %SYSLOG%
>> %SYSLOG% CALL routines.bat EQUALLINE
>> %SYSLOG% ECHO Dump Event Log is a command-line tool that dumps an event log for a local or remote system into a 
>> %SYSLOG% ECHO  tab-separated text file. This tool can also be used to filter for or filter out certain event types.
>> %SYSLOG% CALL routines.bat MAKELINE
>> %SYSLOG% ECHO OUTPUT: 
%t-2k%\dumpel.exe -t -l system >> %SYSLOG%
>> %SYSLOG% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %SYSLOG% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-nts%\promiscdetect.exe
::+-----------------------------+
::|				|
::|PromiscDetect		|
::|				|
::+-----------------------------+

SET PROMISC=%MYPATH%\files\Promisc.txt

>> %PROMISC% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  promiscdetect.exe | tee -a %LOG% >> %PROMISC%
>> %PROMISC% CALL routines.bat EQUALLINE
>> %PROMISC% ECHO PromiscDetect checks if your network adapter(s) is running in promiscuous mode, which 
>> %PROMISC% ECHO may be a sign that you have a sniffer running on your computer. 
>> %PROMISC% CALL routines.bat MAKELINE
>> %PROMISC% ECHO OUTPUT: 
%t-nts%\promiscdetect.exe >> %PROMISC%
>> %PROMISC% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %PROMISC% 
>> %LOG% ECHO.


SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-ni%\iehv.exe /stext
::+-----------------------------+
::|				|
::|IE History			|
::|				|
::+-----------------------------+

SET IEHIS=%MYPATH%\files\IEHIS.txt

>> %IEHIS% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  iehv.exe /stext %IEHIS% | tee -a %LOG% >> %IEHIS%
>> %IEHIS% CALL routines.bat EQUALLINE
>> %IEHIS% ECHO IEHV reads all information from the history file on your computer, and displays the list of all URLs that 
>> %IEHIS% ECHO you have visited in the last few days.
>> %IEHIS% CALL routines.bat MAKELINE
>> %IEHIS% ECHO OUTPUT: 
%t-ni%\iehv.exe /stext %IEHIS%
>> %IEHIS% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %IEHIS% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-cyg%\cat %SystemDrive%\autoexec.bat 
::+-----------------------------+
::|				|
::|Autoexec.bat			|
::|				|
::+-----------------------------+

SET autoexec=%MYPATH%\files\autoexec.txt

>> %autoexec% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  cat %SystemDrive%\autoexec.bat | tee -a %LOG% >> %autoexec%
>> %autoexec% CALL routines.bat EQUALLINE
>> %autoexec% ECHO Contents of the Autoexec.bat file
>> %autoexec% CALL routines.bat MAKELINE
>> %autoexec% ECHO OUTPUT: 
%t-cyg%\cat %SystemDrive%\autoexec.bat >> %autoexec%
>> %autoexec% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %autoexec% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-cyg%\cat %SystemRoot%\system.ini 
::+-----------------------------+
::|				|
::|system.ini			|
::|				|
::+-----------------------------+

SET system=%MYPATH%\files\system.txt

>> %system% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  cat %SystemRoot%\system.ini | tee -a %LOG% >> %system%
>> %system% CALL routines.bat EQUALLINE
>> %system% ECHO Contents of the system.ini file
>> %system% CALL routines.bat MAKELINE
>> %system% ECHO OUTPUT: 
%t-cyg%\cat %SystemRoot%\system.ini >> %system%
>> %system% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %system% 
>> %LOG% ECHO.

SET /A COUNT=COUNT+1
ECHO %COUNT% Running %t-cyg%\cat %SystemRoot%\win.ini
::+-----------------------------+
::|				|
::|win.ini			|
::|				|
::+-----------------------------+

SET winini=%MYPATH%\files\winini.txt

>> %winini% CALL routines.bat EQUALLINE
>> %LOG% ECHO %time%
ECHO Command:  cat %SystemRoot%\win.ini | tee -a %LOG% >> %winini%
>> %winini% CALL routines.bat EQUALLINE
>> %winini% ECHO Contents of the win.ini file
>> %winini% CALL routines.bat MAKELINE
>> %winini% ECHO OUTPUT: 
%t-cyg%\cat %SystemRoot%\win.ini >> %winini%
>> %winini% CALL routines.bat CR
>> %LOG% ECHO.
>> %LOG% md5deep %winini% 
>> %LOG% ECHO.




:: End log file
>> %LOG% ECHO. 
>> %LOG% CALL routines.bat MAKELINE
>> %LOG% ECHO END --  Time:  %time%  Date: %date%
>> %LOG% CALL routines.bat MAKELINE
ECHO Time:  %time%  Date: %date%
>> %LOG% ECHO. 
:: 
@echo off
:: Hash all files
md5deep %MYPATH%\files\*.txt >> %MYPATH%\files\Allfilehashlst.txt

:: Copy htm front end to output directory
cd %MYPATH%
%t-bin%\tar -xvf \IR\IRCR\IRCRrptfiles.tar

ECHO.
ECHO.
ECHO IRCR is done.
ECHO.
ECHO Type exit if you are done.
echo on
