unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ScktComp, StdCtrls, Spin, ExtCtrls, Buttons, ComCtrls, Menus;

type
  TFormMain = class(TForm)
    ServerSocket1: TServerSocket;
    Panel1: TPanel;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Panel2: TPanel;
    Memo1: TMemo;
    BitBtn1: TBitBtn;
    StatusBar1: TStatusBar;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SaveDialog1: TSaveDialog;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    SpinEdit1: TSpinEdit;
    procedure ServerSocket1ClientRead(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServerSocket1ClientConnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure BitBtn1Click(Sender: TObject);
    procedure AppException(Sender: TObject; E: Exception)  ;
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure LSpinEdit1Change(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ServerSocket1ClientDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServerSocket1ThreadEnd(Sender: TObject;
      Thread: TServerClientThread);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

procedure TFormMain.AppException(Sender: TObject; E: Exception );
begin
//
end;

procedure TFormMain.ServerSocket1ClientRead(Sender: TObject;
  Socket: TCustomWinSocket);
var
	S,Z:String;
        i:integer;
begin
	S := Socket.ReceiveText;
	Memo1.Lines.Add( Socket.RemoteAddress +' DATA: '+ S );

        if CheckBox1.Checked then begin
	        Z := '';
		for i:=1 to length(S) do begin
        		Z := Z + inttohex(ord(S[i]),2)+ ' ';
		end;
		Memo1.Lines.Add( '> '+Socket.RemoteAddress +' HEX: '+Z );
        end;

        if CheckBox2.Checked then begin
	        Z := '';
		for i:=1 to length(S) do begin
        		Z := Z + inttostr(ord(S[i]))+ ' ';
		end;
		Memo1.Lines.Add( '> '+Socket.RemoteAddress +' DEC: '+Z );
        end;
end;

procedure TFormMain.ServerSocket1ClientConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
        Memo1.Lines.Add( Socket.RemoteAddress+' connected.' );
end;

procedure TFormMain.BitBtn1Click(Sender: TObject);
begin
        if not ServerSocket1.Active then begin
        	ServerSocket1.Port := SpinEdit1.Value;
        	ServerSocket1.Open;
                BitBtn1.Caption := 'STOP';
		Caption := Application.Title + ' ['+inttostr(SpinEdit1.Value)+']';
        end else begin
        	ServerSocket1.Close;
                BitBtn1.Caption := 'START';
		Caption := Application.Title + ' [inactive]';
        end;
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
	Caption := Application.Title + ' [inactive]';
        Application.OnException := AppException;
end;

procedure TFormMain.ComboBox1Change(Sender: TObject);
begin
        case ComboBox1.ItemIndex of
          0: SpinEdit1.Value := 7;
          1: SpinEdit1.Value := 17;
          2: SpinEdit1.Value := 21;
          3: SpinEdit1.Value := 23;
          4: SpinEdit1.Value := 25;
          5: SpinEdit1.Value := 70;
          6: SpinEdit1.Value := 79;
          7: SpinEdit1.Value := 80;
          8: SpinEdit1.Value := 110;
          9: SpinEdit1.Value := 113;
          10: SpinEdit1.Value := 139;
        end;
end;


procedure TFormMain.FormResize(Sender: TObject);
begin
	if Height<320 then Height := 320;
	if Width<450 then Width := 450;
end;

procedure TFormMain.SpeedButton1Click(Sender: TObject);
begin
        Memo1.Text := '';
end;

procedure TFormMain.LSpinEdit1Change(Sender: TObject);
begin
        case SpinEdit1.Value of
          7: ComboBox1.ItemIndex := 0;
          17: ComboBox1.ItemIndex := 1;
          21: ComboBox1.ItemIndex := 2;
          23: ComboBox1.ItemIndex := 3;
          25: ComboBox1.ItemIndex := 4;
          70: ComboBox1.ItemIndex := 5;
          79: ComboBox1.ItemIndex := 6;
          80: ComboBox1.ItemIndex := 7;
          110: ComboBox1.ItemIndex := 8;
          113: ComboBox1.ItemIndex := 9;
          139: ComboBox1.ItemIndex := 10;
          else ComboBox1.ItemIndex := 11;
        end;
end;

procedure TFormMain.FormActivate(Sender: TObject);
begin
        LSpinEdit1Change( Sender );
end;

procedure TFormMain.ServerSocket1ClientDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
        Memo1.Lines.Add( Socket.RemoteAddress+' disconnected.' );
end;

procedure TFormMain.ServerSocket1ThreadEnd(Sender: TObject;
  Thread: TServerClientThread);
begin
        Memo1.Lines.Add( ServerSocket1.Socket.RemoteAddress+' disconnected.' );
end;

procedure TFormMain.SpeedButton2Click(Sender: TObject);
begin
	if SaveDialog1.Execute then begin
		Memo1.Lines.SaveToFile( SaveDialog1.FileName );
        end;
end;


end.
