// Command line text filter and search tool for WIN32.
// This is needed for searching addresses from "web server statistics" logs.

#pragma hdrstop
#include <condefs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

//---------------------------------------------------------------------------
#pragma argsused

int  main(int argc,char *argv[])
{    FILE *fp;
     char *sp;
     char buf[10002];
     char tmp[10002];
     char fn[1024];
     int  i,j,k,dot,start,stop;
     bool ok,alpha,reverse=false;

     if(argc<2) goto zz;

     strncpy(buf,argv[1],1023);

     if(buf[0]=='-')
     { if(buf[2]!=0x00) goto zz;
       if(tolower(buf[1])=='f' ) goto ff;
       if(tolower(buf[1])=='r' )
       { reverse=true; goto ff; };
       goto zz;                          };

     // Seek lines with given strings.

     if(argc<3) goto zz;

     strcpy(fn,argv[1]);

     fp=fopen(fn,"r");

     if(fp==NULL)
     { printf("\ncannot open file %s\n",fn); exit(0); }
     else
       printf("\n");

 rr: sp=fgets(buf,sizeof(buf),fp);

     if(sp==NULL) goto xx;

     for(i=2;i<argc;i++) if(strstr(buf,argv[i])==NULL) goto rr;

     printf("%s",buf);

     goto rr;

 xx: exit(0);

     // Pick addresses from input file.

 ff: if(argc<3) goto zz;

     strcpy(fn,argv[2]);

     fp=fopen(fn,"r");

     if(fp==NULL)
     { printf("\ncannot open file %s\n",fn); exit(0); }
     else
       printf("\n");

 aa: sp=fgets(buf,sizeof(buf),fp);

     if(sp==NULL) goto xx;

     k=strlen(buf);

     i=0;
     start=-1;

 bb: if(i>=k) goto aa;

     // Locate start point.

     if(start==-1)
     { if(buf[i]==' ') { i++; goto bb; };
       if(buf[i]>' ' ) { start=i; dot=-1; ok=true; alpha=false; }; };

     if(start>=0)
     {
       // Locate end point.

       if(buf[i]<=' ') { stop=i; goto dd; };

       // Check legal characters.

       if(buf[i]=='.') { dot=i++; goto bb; };
       if(buf[i]=='-') goto tt;
       if(isalpha(buf[i])) { alpha=true; goto tt; };
       if(isdigit(buf[i])) goto tt;
       ok=false;
     };

 tt: i++; goto bb;

     // Seek again

 cc: start=stop=dot=-1;
     goto bb;

     // Check string.

 dd: if(ok==false || alpha==false) goto cc;
     if(dot==-1 || stop==-1) goto cc;
     if(stop-dot<2 ) goto cc;
     if(dot-start<2) goto cc;

     memset(tmp,0,sizeof(tmp));
     memcpy(tmp,&buf[start],stop-start);

     if(tmp[0]=='.' || tmp[1]=='.') goto cc;
     k=strlen(tmp);
     if(tmp[k-1]=='.' || tmp[k-2]=='.') goto cc;

     if(reverse==false) goto qq;

     // Revert address.

     strcpy(buf,tmp);
     memset(tmp,0,sizeof(tmp));
     i=k-1;
     j=0;

 hh: while(1)
     { if(buf[i]=='.') break;
       if(i==0) break;
       i--;                  };

     if(i>0)
     { strcpy(&tmp[j],&buf[i+1]);
       strcat(tmp,".");
       j=strlen(tmp);
       buf[i]=0x00;
       i=strlen(buf)-1; goto hh; }
     else
       strcpy(&tmp[j],&buf[i]);

     // Domain filter (alpha only).

 qq: k=strlen(tmp);
     i=k-1; j=0;
     while(1)
     { if(tmp[i]=='.') break;
       j++;
       if(j>3 || !isalpha(tmp[i])) goto cc;
       if(i==0) break;
       i--;                                };

     // .com .mil .gov .edu .org .net .int

     if(j==3)
     { strcpy(buf,&tmp[k-j]);
       strlwr(buf);
       if(strcmp(buf,"com")==0) goto mm;
       if(strcmp(buf,"mil")==0) goto mm;
       if(strcmp(buf,"gov")==0) goto mm;
       if(strcmp(buf,"edu")==0) goto mm;
       if(strcmp(buf,"org")==0) goto mm;
       if(strcmp(buf,"net")==0) goto mm;
       if(strcmp(buf,"int")==0) goto mm;
       goto cc;                          };

 mm: printf("%s \n",tmp);

     goto aa;

 zz: printf("\nSeek lines: LogTool logfile string1 [\"string2 \" ... string9] (find all strings)\n");
     printf("\nFiltering:  LogTool -f logfile (addresses in order: server.company.com).\n");
     printf("\nFiltering:  LogTool -r logfile (addresses in order: com.company.server).\n");
     exit(0);
}

