#include <stdio.h>

#define TRUE  1
#define FALSE 0

static void convert_half_byte_to_base_2(int,int *);
static int  convert_hex_to_half_byte(char,int *);
static int  convert_to_base_2(char *,int *);
static void day_number_to_date(int,int *,int *,int *);
static void divide(int *,int *,int *,int *);
static int  greater_than(int *,int *);
       int  main(int,char **);
static void multiply(int,int *,int *);
static void subtract(int *,int *,int *);

int main(
  int  argc,
  char **argv)
    {
      static   int fatal_error;
      static   int base_32768;
      register int base_32768_bit_num;
      static   int clock_seq;
      static   int day;
      static   int days;
      static   int days_base_32768 [2];
      static   int dividend [4];
      static   int GUID_base_2 [128];
      static   int GUID_bit_num;
      static   int hour;
      static   int millisecond;
      static   int minute;
      static   int month;
      static   int remainder [3];
      static   int second;
      static   int tem_int;
      static   int tenth_microsecs_in_day_base_32768 [3] = {16384, 21715, 804};
      static   int timestamp_base_2 [60];    /* least significant bit first */
      static   int timestamp_base_32768 [4]; /* least significant bit first */
      register int timestamp_bit_num;
      static   int version;
      static   int year;

      fatal_error=FALSE;
      if ((argc == 2)
      &&  (convert_to_base_2(*(argv+1),&GUID_base_2[0])))
        {
          version=0;
          for (GUID_bit_num=48; GUID_bit_num < 52; ++GUID_bit_num)
            {
              version+=version;
              version+=GUID_base_2[GUID_bit_num];
            }
          switch (version)
            {
              case 1:
                if ((GUID_base_2[64] == 1)
                &&  (GUID_base_2[65] == 0))
                  {
                    timestamp_bit_num=0;
                    for (GUID_bit_num=32; GUID_bit_num--;)
                      timestamp_base_2[timestamp_bit_num++]
                       =GUID_base_2[GUID_bit_num];
                    for (GUID_bit_num=47; GUID_bit_num > 31; --GUID_bit_num)
                      timestamp_base_2[timestamp_bit_num++]
                       =GUID_base_2[GUID_bit_num];
                    for (GUID_bit_num=63; GUID_bit_num > 51; --GUID_bit_num)
                      timestamp_base_2[timestamp_bit_num++]
                       =GUID_base_2[GUID_bit_num];
                    timestamp_bit_num=15;
                    base_32768=0;              
                    for (base_32768_bit_num=15; base_32768_bit_num--;)
                      {
                        base_32768+=base_32768;
                        base_32768+=timestamp_base_2[--timestamp_bit_num];
                      }
                    timestamp_base_32768[0]=base_32768;
                    timestamp_bit_num=30;
                    base_32768=0;              
                    for (base_32768_bit_num=15; base_32768_bit_num--;)
                      {
                        base_32768+=base_32768;
                        base_32768+=timestamp_base_2[--timestamp_bit_num];
                      }
                    timestamp_base_32768[1]=base_32768;
                    timestamp_bit_num=45;
                    base_32768=0;              
                    for (base_32768_bit_num=15; base_32768_bit_num--;)
                      {
                        base_32768+=base_32768;
                        base_32768+=timestamp_base_2[--timestamp_bit_num];
                      }
                    timestamp_base_32768[2]=base_32768;
                    timestamp_bit_num=60;
                    base_32768=0;              
                    for (base_32768_bit_num=15; base_32768_bit_num--;)
                      {
                        base_32768+=base_32768;
                        base_32768+=timestamp_base_2[--timestamp_bit_num];
                      }
                    timestamp_base_32768[3]=base_32768;
                    dividend[3]=0;
                    dividend[2]=timestamp_base_32768[3];
                    dividend[1]=timestamp_base_32768[2];
                    dividend[0]=timestamp_base_32768[1];
                    divide(&dividend[0],&tenth_microsecs_in_day_base_32768[0],
                     &days_base_32768[1],&remainder[0]);
                    dividend[3]=remainder[2];
                    dividend[2]=remainder[1];
                    dividend[1]=remainder[0];
                    dividend[0]=timestamp_base_32768[0];
                    divide(&dividend[0],&tenth_microsecs_in_day_base_32768[0],
                     &days_base_32768[0],&remainder[0]);
                    days=32768*days_base_32768[1]+days_base_32768[0];
                    days=days-62170;
                    day_number_to_date(days,&year,&month,&day);
                    tem_int=32768*remainder[2]+remainder[1];
                    millisecond=tem_int/10000;
                    tem_int-=10000*millisecond;
                    tem_int=32768*tem_int+remainder[0];
                    millisecond=32768*millisecond+tem_int/10000;
                    hour=millisecond/3600000;
                    millisecond-=3600000*hour;
                    minute=millisecond/60000;
                    millisecond-=60000*minute;
                    second=millisecond/1000;
                    millisecond-=1000*second;
                    printf("     Timestamp:  "
                     "%2.2d/%2.2d/%4.4d %2.2d:%2.2d:%2.2d.%3.3d UTC\n",
                     month,day,year,hour,minute,second,millisecond);
                    clock_seq=0;
                    for (GUID_bit_num=66; GUID_bit_num < 80; ++GUID_bit_num)
                      {
                        clock_seq+=clock_seq;
                        clock_seq+=GUID_base_2[GUID_bit_num];
                      }
                    printf("Clock sequence:  %d\n",clock_seq);
                    printf("       Node ID:  %s\n",*(argv+1)+24);
                  }
                else
                  {
                    fatal_error=TRUE;
                    fprintf(stderr,"The variant in this GUID doesn\'t conform "
                     "to the Leach standard.\n");
                  }
                break;
              case 2:
                fatal_error=TRUE;
                fprintf(stderr,
                 "This is a DCE security GUID, not a Leach GUID.\n");
                break;
              default:
                fatal_error=TRUE;
                fprintf(stderr,"This GUID is nonstandard version %d.\n",
                 version);
                break;
            }
        }
      else
        {
          fatal_error=TRUE;
          fprintf(stderr,
           "\ndecoguid decodes a GUID conforming to the Internet Draft\n"
           "    <draft-leach-uuids-guids-00.txt>.\n\n"
           "  Usage:  decoguid <GUID>\n\n"
           "Example:  decoguid f81d4fae-7dec-11d0-a765-00a0c91e6bf6\n");
        }
      return fatal_error;
    }

static int convert_hex_to_half_byte(
  char hex,
  int  *half_byte)
    {
      register int success;

      success=TRUE;
      if ((hex >= '0') && (hex <= '9'))
        *half_byte=hex-'0';
      else
        if ((hex >= 'a') && (hex <= 'f'))
          *half_byte=hex-'a'+10;
        else
          if ((hex >= 'A') && (hex <= 'F'))
            *half_byte=hex-'A'+10;
          else
            {
              *half_byte=0;
              success=FALSE;
            }
      return success;
    }

static void convert_half_byte_to_base_2(
  int half_byte,
  int *base_2)
    {
      if (half_byte & 8)
        *base_2=1;
      else
        *base_2=0;
      ++base_2;
      if (half_byte & 4)
        *base_2=1;
      else
        *base_2=0;
      ++base_2;
      if (half_byte & 2)
        *base_2=1;
      else
        *base_2=0;
      ++base_2;
      if (half_byte & 1)
        *base_2=1;
      else
        *base_2=0;
      ++base_2;
      return;
    }
  
static int convert_to_base_2(
  char *GUID,
  int  *base_2)
    {
      static   int half_byte;
      register int half_byte_count;
      register int success;

      success=TRUE;
      for (half_byte_count=8; (success && (half_byte_count--));)
        if (success=convert_hex_to_half_byte(*GUID++,&half_byte))   
          {
            convert_half_byte_to_base_2(half_byte,base_2);          
            base_2+=4;
          }
      if (success)
        {
          if (*GUID++ != '-')
            success=FALSE;
        }
      if (success)
        for (half_byte_count=4; (success && (half_byte_count--));)
          if (success=convert_hex_to_half_byte(*GUID++,&half_byte))   
            {
              convert_half_byte_to_base_2(half_byte,base_2);          
              base_2+=4;
            }
      if (success)
        {
          if (*GUID++ != '-')
            success=FALSE;
        }
      if (success)
        for (half_byte_count=4; (success && (half_byte_count--));)
          if (success=convert_hex_to_half_byte(*GUID++,&half_byte))   
            {
              convert_half_byte_to_base_2(half_byte,base_2);          
              base_2+=4;
            }
      if (success)
        {
          if (*GUID++ != '-')
            success=FALSE;
        }
      if (success)
        for (half_byte_count=4; (success && (half_byte_count--));)
          if (success=convert_hex_to_half_byte(*GUID++,&half_byte))   
            {
              convert_half_byte_to_base_2(half_byte,base_2);          
              base_2+=4;
            }
      if (success)
        {
          if (*GUID++ != '-')
            success=FALSE;
        }
      if (success)
        for (half_byte_count=12; (success && (half_byte_count--));)
          if (success=convert_hex_to_half_byte(*GUID++,&half_byte))   
            {
              convert_half_byte_to_base_2(half_byte,base_2);          
              base_2+=4;
            }
      return success;
    }
  
static void divide(
  int *dividend,
  int *divisor,
  int *quotient,
  int *remainder)
    {
      static   int product [4];
      register int tem_int;
      register int trial_quotient;
 
      tem_int=dividend[3];
      trial_quotient=32768*tem_int;
      tem_int=dividend[2];
      trial_quotient+=tem_int;
      tem_int=divisor[2];
      trial_quotient/=tem_int;
      if (trial_quotient >= 32768)
        trial_quotient=32767;
      multiply(trial_quotient,divisor,&product[0]);
      while (greater_than(&product[0],dividend))
        {
          --trial_quotient;
          multiply(trial_quotient,divisor,&product[0]);
        }
      subtract(dividend,&product[0],remainder);
      *quotient=trial_quotient;
      return;
    }

static void multiply(
  int multiplier,
  int *multiplicand,
  int *product)
    {
      static   int carry;
      register int digit_num;
      register int tem_int;
 
      carry=0;
      for (digit_num=0; digit_num < 3; ++digit_num)
        {
          tem_int=multiplicand[digit_num];
          tem_int=multiplier*tem_int+carry;
          carry=tem_int/32768;
          product[digit_num]=tem_int-32768*carry;
        }
      product[3]=carry;
      return;
    }

static int greater_than(
  int *arg1,
  int *arg2)
    {
      static   int digit_num;
      static   int finished;
      static   int result;
      register int tem_int_1;
      register int tem_int_2;
 
      digit_num=3;
      finished=FALSE;
      result=FALSE;
      while ((digit_num >= 0) & (! finished))
        {
          tem_int_1=arg1[digit_num];
          tem_int_2=arg2[digit_num];
          if (tem_int_1 > tem_int_2)
            {
              result=TRUE;
              finished=TRUE;
            }
          else
            if (tem_int_1 < tem_int_2)
              finished=TRUE;
            else
              --digit_num;
        }
      return result;
    }

static void subtract(
  int *minuend,
  int *subtrahend,
  int *remainder)
    {
      register int digit_num;
      register int tem_int;
 
      for (digit_num=0; digit_num < 3; ++digit_num)
        {
          tem_int=minuend[digit_num];
          if (subtrahend[digit_num] > tem_int)
            {
              tem_int=tem_int+32768;
              minuend[digit_num+1]=minuend[digit_num+1]-1;
            }
          tem_int=tem_int-subtrahend[digit_num];
          remainder[digit_num]=tem_int;
        }
      return;
    }

static void day_number_to_date(
  int day_number,
  int *year,
  int *month,
  int *day)
    {
      static   int target_day;
      register int target_month;
      static   int target_year;
      register int tem_int;
 
      tem_int=day_number+640212;
      target_year=(4*tem_int-1)/146097;
      tem_int=4*tem_int-1-146097*target_year;
      target_day=tem_int/4;
      tem_int=(4*target_day+3)/1461;
      target_day=4*target_day+3-1461*tem_int;
      target_day=(target_day+4)/4;
      target_month=(5*target_day-3)/153;
      target_day=5*target_day-3-153*target_month;
      target_day=(target_day+5)/5;
      target_year=100*target_year+tem_int;
      if (target_month < 10)
          target_month+=3;
      else
        {
          target_month-=9;
          ++target_year;
        }
      *year=target_year;
      *month=target_month;
      *day=target_day;
      return;
    }

