#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <windows.h>

typedef struct FileNameNode
                 {
                   char                *strFileName;
                   struct FileNameNode *pLesser;
                   struct FileNameNode *pGreater;
                 } *FileNameNodePtr;

typedef struct AdapterNode
                 {
                   char               strAdapterID [13];
                   FileNameNodePtr    pFileHead;
                   struct AdapterNode *pLesser;
                   struct AdapterNode *pGreater;
                 } *AdapterNodePtr;

typedef struct DirNode
                 {
                   char           strFileName [MAX_PATH];
                   DWORD          dwAttributes;
                   struct DirNode *pNext;
                 } *DirNodePtr;

typedef struct DirectoryNode
                 {
                   char                 *strFileName;
                   struct DirectoryNode *pNext;
                 } *DirectoryNodePtr;

static void AddAdapterAndFileName(AdapterNodePtr *,char *,char *);
static void AddFileName(FileNameNodePtr *,char *);
static void AddSignature(AdapterNodePtr *,int *,int,char *);
static void AddSignatures(AdapterNodePtr *,char *);
static void BuildDirectory(char *,DirectoryNodePtr *);
static void GetDir(char *,DirNodePtr *);
       int  main(int,char **);
static void ReportAdapters(AdapterNodePtr *);
static void ReportFileNames(char *,FileNameNodePtr *);

int bFatalError;

int main(
  int  argc,
  char **argv)
    {
      static int              nArg;
      static AdapterNodePtr   pAdapterHead;
      static DirectoryNodePtr pDirectory;
      static DirectoryNodePtr pDirectoryHead;

      bFatalError=FALSE;
      if (argc >= 2)
        {
          pAdapterHead=NULL;
          for (nArg=1; ((! bFatalError) && (nArg < argc)); ++nArg)
            {
              pDirectoryHead=NULL;
              BuildDirectory(*(argv+nArg),&pDirectoryHead);
              while (pDirectoryHead != NULL)
                {
                  if (! bFatalError)
                    AddSignatures(&pAdapterHead,pDirectoryHead->strFileName);
                  pDirectory=pDirectoryHead;
                  pDirectoryHead=pDirectoryHead->pNext;
                  free((char *) pDirectory);
                }
            }
          ReportAdapters(&pAdapterHead);
        }
      else
        {
          fprintf(stderr,
           "\nethadapt lists the Ethernet adapters associated with the files "
           "in given\n     directories and their subdirectories.\n\n"
           "   Usage:  ethadapt <starting-directory> [<starting-directory>]\n\n"
           "Examples:  ethadapt C: E:\n"
           "           ethadapt .\n"
           "           ethadapt \"C:\\My Documents\"\n\n");
          bFatalError=TRUE;
        }
      return bFatalError;
    }

static void BuildDirectory(
  char             *strPathName,
  DirectoryNodePtr *pDirectoryHead)
    {
      char             *pChar;
      DirNodePtr       pDir;
      DirNodePtr       pDirHead;
      DirectoryNodePtr pNewDirectory;
      char             strDirName[1024];
      char             strNewPathName[1024];

      strcpy(strDirName,strPathName);
      strcat(strDirName,"\\*.*");
      pDirHead=NULL;
      GetDir(strDirName,&pDirHead);
      if (! bFatalError)
        {
          while (pDirHead != NULL)
            {
              if (pDirHead->strFileName[0] != '.')
                {
                  strcpy(strNewPathName,strPathName);
                  strcat(strNewPathName,"\\");
                  strcat(strNewPathName,pDirHead->strFileName);
                  if ((pDirHead->dwAttributes) & FILE_ATTRIBUTE_DIRECTORY)
                    BuildDirectory(strNewPathName,pDirectoryHead);
                  else
                    {
                      pChar=pDirHead->strFileName;
                      if (*pDirectoryHead == NULL)
                        {
                          if ((*pDirectoryHead
                           =(struct DirectoryNode *)
                           malloc((unsigned) sizeof(struct DirectoryNode)))
                           == NULL)
                            {
                              bFatalError=TRUE;
                              fprintf(stderr,"Fatal error:  out of memory.\n");
                            }
                          else
                            {
                              (*pDirectoryHead)->pNext=NULL;
                              if (((*pDirectoryHead)->strFileName
                               =malloc((unsigned) (1+strlen(strNewPathName))))
                               == NULL)
                                {
                                  bFatalError=TRUE;
                                  fprintf(stderr,
                                   "Fatal error:  out of memory.\n");
                                }
                              else
                                strcpy((*pDirectoryHead)->strFileName,
                                 strNewPathName);
                            }
                        }
                      else
                        {
                          if ((pNewDirectory=(struct DirectoryNode *)
                           malloc((unsigned) sizeof(struct DirectoryNode)))
                           == NULL)
                            {
                              bFatalError=TRUE;
                              fprintf(stderr,"Fatal error:  out of memory.\n");
                            }
                          else
                            {
                              pNewDirectory->pNext=(*pDirectoryHead);
                              (*pDirectoryHead)=pNewDirectory;
                              if ((pNewDirectory->strFileName
                               =malloc((unsigned) (1+strlen(strNewPathName))))
                               == NULL)
                                {
                                  bFatalError=TRUE;
                                  fprintf(stderr,
                                   "Fatal error:  out of memory.\n");
                                }
                              else
                                strcpy(pNewDirectory->strFileName,
                                 strNewPathName);
                            }
                        }
                    }
                }
              pDir=pDirHead;
              pDirHead=pDirHead->pNext;
              free((char *) pDir);
            }
        }
    }

static void GetDir(
  char far   *strDirName,
  DirNodePtr *pDirHead)
    {
      static DirNodePtr      pNewDir;
      static HANDLE          hDir;
      static WIN32_FIND_DATA fdDirResult;

      if ((hDir=FindFirstFile(strDirName,&fdDirResult)) 
       != INVALID_HANDLE_VALUE)
        {
          do
            {
              if (*pDirHead == NULL)
                {
                  if ((*pDirHead
                   =(struct DirNode *)
                   malloc((unsigned) sizeof(struct DirNode))) == NULL)
                    {
                      bFatalError=TRUE;
                      fprintf(stderr,"Fatal error:  out of memory.\n");
                    }
                  else
                    {
                      (*pDirHead)->pNext=NULL;
                      strcpy((*pDirHead)->strFileName,fdDirResult.cFileName);
                      (*pDirHead)->dwAttributes=fdDirResult.dwFileAttributes;
                    }
                }
              else
                {
                  if ((pNewDir=(struct DirNode *)
                   malloc((unsigned) sizeof(struct DirNode))) == NULL)
                    {
                      bFatalError=TRUE;
                      fprintf(stderr,"Fatal error:  out of memory.\n");
                    }
                  else
                    {
                      strcpy(pNewDir->strFileName,fdDirResult.cFileName);
                      pNewDir->dwAttributes=fdDirResult.dwFileAttributes;
                      pNewDir->pNext=(*pDirHead);
                      (*pDirHead)=pNewDir;
                    }
                }
            }
          while (FindNextFile(hDir,&fdDirResult));
          FindClose(hDir);
        }
      return;
    }

static void AddFileName(
  FileNameNodePtr *pFileNameHead,
  char            *strFileName)
    {
      static int              bFinished;
      static int              nRelation;
      static FileNameNodePtr  pExternal;
      static FileNameNodePtr  pInternal;

      if (*pFileNameHead == NULL)
        if ((*pFileNameHead
         =(FileNameNodePtr) malloc(sizeof(struct FileNameNode))) == NULL)
          {
            bFatalError=TRUE;
            fprintf(stderr,"Fatal error:  out of memory.\n");
          }
        else
          if (((*pFileNameHead)->strFileName
           =(char *) malloc(1+strlen(strFileName))) == NULL)
            {
              bFatalError=TRUE;
              fprintf(stderr,"Fatal error:  out of memory.\n");
              free((void *) *pFileNameHead);
              *pFileNameHead=NULL;
            }
          else
            {
              strcpy((*pFileNameHead)->strFileName,strFileName);
              (*pFileNameHead)->pLesser=NULL;
              (*pFileNameHead)->pGreater=NULL;
            }
      else
        {
          bFinished=FALSE;
          pInternal=*pFileNameHead;
          while ((! bFatalError) && (! bFinished))
            {
              nRelation=stricmp(strFileName,pInternal->strFileName);
              if (nRelation < 0)
                if (pInternal->pLesser == NULL)
                  {
                    if ((pExternal=(FileNameNodePtr)
                     malloc(sizeof(struct FileNameNode))) == NULL)
                      {
                        bFatalError=TRUE;
                        fprintf(stderr,"Fatal error:  out of memory.\n");
                      }
                    else
                      if ((pExternal->strFileName
                       =(char *) malloc(1+strlen(strFileName))) == NULL)
                        {
                          bFatalError=TRUE;
                          fprintf(stderr,"Fatal error:  out of memory.\n");
                          free((void *) pExternal);
                          pExternal=NULL;
                        }
                      else
                        {
                          strcpy(pExternal->strFileName,strFileName);
                          pExternal->pLesser=NULL;
                          pExternal->pGreater=NULL;
                          pInternal->pLesser=pExternal;
                        }
                    bFinished=TRUE;
                  }
                else
                  pInternal=pInternal->pLesser;
              else
                if (nRelation > 0)
                  if (pInternal->pGreater == NULL)
                    {
                      if ((pExternal=(FileNameNodePtr)
                       malloc(sizeof(struct FileNameNode))) == NULL)
                        {
                          bFatalError=TRUE;
                          fprintf(stderr,"Fatal error:  out of memory.\n");
                        }
                      else
                        if ((pExternal->strFileName
                         =(char *) malloc(1+strlen(strFileName))) == NULL)
                          {
                            bFatalError=TRUE;
                            fprintf(stderr,"Fatal error:  out of memory.\n");
                            free((void *) pExternal);
                            pExternal=NULL;
                          }
                        else
                          {
                            strcpy(pExternal->strFileName,strFileName);
                            pExternal->pLesser=NULL;
                            pExternal->pGreater=NULL;
                            pInternal->pGreater=pExternal;
                          }
                      bFinished=TRUE;
                    }
                  else
                    pInternal=pInternal->pGreater;
                else
                  bFinished=TRUE;
            }
        }
      return;
    }

static void AddAdapterAndFileName(
  AdapterNodePtr *pAdapterHead,
  char           *strAdapterID,
  char           *strFileName)
    {
      static int             bFinished;
      static int             nRelation;
      static AdapterNodePtr  pExternal;
      static AdapterNodePtr  pInternal;

      if (*pAdapterHead == NULL)
        if ((*pAdapterHead
         =(AdapterNodePtr) malloc(sizeof(struct AdapterNode))) == NULL)
          {
            bFatalError=TRUE;
            fprintf(stderr,"Fatal error:  out of memory.\n");
          }
        else
          {
            strcpy((*pAdapterHead)->strAdapterID,strAdapterID);
            (*pAdapterHead)->pFileHead=NULL;
            (*pAdapterHead)->pLesser=NULL;
            (*pAdapterHead)->pGreater=NULL;
            AddFileName(&((*pAdapterHead)->pFileHead),strFileName);
          }
      else
        {
          bFinished=FALSE;
          pInternal=*pAdapterHead;
          while ((! bFatalError) && (! bFinished))
            {
              nRelation=stricmp(strAdapterID,pInternal->strAdapterID);
              if (nRelation < 0)
                if (pInternal->pLesser == NULL)
                  {
                    if ((pExternal=(AdapterNodePtr)
                     malloc(sizeof(struct AdapterNode))) == NULL)
                      {
                        bFatalError=TRUE;
                        fprintf(stderr,"Fatal error:  out of memory.\n");
                      }
                    else
                      {
                        strcpy(pExternal->strAdapterID,strAdapterID);
                        pExternal->pFileHead=NULL;
                        pExternal->pLesser=NULL;
                        pExternal->pGreater=NULL;
                        AddFileName(&(pExternal->pFileHead),strFileName);
                        pInternal->pLesser=pExternal;
                      }
                    bFinished=TRUE;
                  }
                else
                  pInternal=pInternal->pLesser;
              else
                if (nRelation > 0)
                  if (pInternal->pGreater == NULL)
                    {
                      if ((pExternal=(AdapterNodePtr)
                       malloc(sizeof(struct AdapterNode))) == NULL)
                        {
                          bFatalError=TRUE;
                          fprintf(stderr,"Fatal error:  out of memory.\n");
                        }
                      else
                        {
                          strcpy(pExternal->strAdapterID,strAdapterID);
                          pExternal->pFileHead=NULL;
                          pExternal->pLesser=NULL;
                          pExternal->pGreater=NULL;
                          AddFileName(&(pExternal->pFileHead),strFileName);
                          pInternal->pGreater=pExternal;
                        }
                      bFinished=TRUE;
                    }
                  else
                    pInternal=pInternal->pGreater;
                else
                  {
                    AddFileName(&(pInternal->pFileHead),strFileName);
                    bFinished=TRUE;
                  }
            }
        }
      return;
    }

static void AddSignature(
  AdapterNodePtr  *pAdapterHead,
  int             *pCircularBufferHead,
  int             nStartingByteNum,
  char            *strFileName)
    {
      register int  bOdd;
      static   int  bSignature;
      register int  nByteNum;
      register int  nCharNum;
      static   int  nOffset;
      static   int  *pByte;
      static   char *pSignature;
      static   char strSignature [37];

      bSignature=TRUE;
      nOffset=nStartingByteNum;
      pByte=pCircularBufferHead+nOffset;
      for (nByteNum=36; ((bSignature) && (nByteNum--));)
        {
          if ((nByteNum == 27)
          ||  (nByteNum == 22)
          ||  (nByteNum == 17)
          ||  (nByteNum == 12))
            bSignature=(*pByte == (int) '-');
          else
            bSignature=(((*pByte >= (int) '0') && (*pByte <= (int) '9'))
             ||  ((*pByte >= (int) 'A') && (*pByte <= (int) 'F'))
             ||  ((*pByte >= (int) 'a') && (*pByte <= (int) 'f')));
          if (++nOffset < 72)
            ++pByte;
          else
            {
              nOffset=0;
              pByte=pCircularBufferHead;
            }
        }
      if (bSignature)
        {
          nOffset=nStartingByteNum;
          pByte=pCircularBufferHead+nOffset;
          pSignature=&strSignature[0];
          for (nCharNum=36; nCharNum--;)
            {
              *pSignature++=(char) *pByte;
              if (++nOffset < 72)
                ++pByte;
              else
                {
                  nOffset=0;
                  pByte=pCircularBufferHead;
                }
            }
          *pSignature='\0';
          AddAdapterAndFileName(pAdapterHead,&strSignature[24],strFileName);
        }
      else
        {
          bSignature=TRUE;
          bOdd=TRUE;
          nOffset=nStartingByteNum;
          pByte=pCircularBufferHead+nOffset;
          for (nByteNum=72; ((bSignature) && (nByteNum--));)
            {
              if (bOdd)
                if ((nByteNum == 55)
                ||  (nByteNum == 45)
                ||  (nByteNum == 35)
                ||  (nByteNum == 25))
                  bSignature=(*pByte == (int) '-');
                else
                  bSignature=(((*pByte >= (int) '0') && (*pByte <= (int) '9'))
                   ||  ((*pByte >= (int) 'A') && (*pByte <= (int) 'F'))
                   ||  ((*pByte >= (int) 'a') && (*pByte <= (int) 'f')));
              else
                bSignature=(*pByte == 0);
              if (++nOffset < 72)
                ++pByte;
              else
                {
                  nOffset=0;
                  pByte=pCircularBufferHead;
                }
              bOdd=! bOdd;
            }
          if (bSignature)
            {
              nOffset=nStartingByteNum;
              pByte=pCircularBufferHead+nOffset;
              pSignature=&strSignature[0];
              for (nCharNum=36; nCharNum--;)
                {
                  *pSignature++=(char) *pByte;
                  if (++nOffset < 72)
                    ++pByte;
                  else
                    {
                      nOffset=0;
                      pByte=pCircularBufferHead;
                    }
                  if (++nOffset < 72)
                    ++pByte;
                  else
                    {
                      nOffset=0;
                      pByte=pCircularBufferHead;
                    }
                }
              *pSignature='\0';
              AddAdapterAndFileName(pAdapterHead,&strSignature[24],strFileName);
            }
        }
      return;
    }

static void AddSignatures(
 AdapterNodePtr *pAdapterHead,
 char           *strFileName)
  {
             FILE            *i;
    register int             nByteNum;
    register int             nCharNum;
    static   int             nCurrentChar;
    static   int             nLast72Bytes [72];

    if ((i=fopen(strFileName,"rb")) != NULL)
      {
        nByteNum=0;
        while (((nLast72Bytes[nByteNum]=fgetc(i)) != EOF)
        &&     (++nByteNum < 72));
        if (nByteNum >= 72)
          {
            nByteNum=0;
            do
              {
                AddSignature(pAdapterHead,&nLast72Bytes[0],nByteNum,
                 strFileName);
                nCurrentChar=fgetc(i);
                if (nCurrentChar != EOF)
                  {
                    nLast72Bytes[nByteNum]=nCurrentChar;
                    if (++nByteNum >= 72)
                      nByteNum=0;
                  }
              }
            while ((! bFatalError) && (nCurrentChar != EOF));
          }
        else
          {
            while (nByteNum < 72)
              nLast72Bytes[nByteNum++]=0;
            nByteNum=0;
            AddSignature(pAdapterHead,&nLast72Bytes[0],nByteNum,strFileName);
          }
        fclose(i);
        for (nCharNum=36; ((! bFatalError) && (nCharNum--));)
          {
            nLast72Bytes[nByteNum]=0;
            if (++nByteNum >= 72)
              nByteNum=0;
            AddSignature(pAdapterHead,&nLast72Bytes[0],nByteNum,strFileName);
          }
      }
    return;
  }

static void ReportFileNames(
  char            *strAdapterID,
  FileNameNodePtr *pFileNameHead)
    {
      if (*pFileNameHead != NULL)
        {
          ReportFileNames(strAdapterID,&((*pFileNameHead)->pLesser));
          if (! bFatalError)
            {
              printf("%s %s\n",strAdapterID,(*pFileNameHead)->strFileName);
              strcpy(strAdapterID,"            ");
            }
          ReportFileNames(strAdapterID,&((*pFileNameHead)->pGreater));
          free((void *) ((*pFileNameHead)->strFileName));
          free((void *) *pFileNameHead);
        }
      return;
    }

static void ReportAdapters(
  AdapterNodePtr *pAdapterHead)
     {
       if (*pAdapterHead != NULL)
         {
           ReportAdapters(&((*pAdapterHead)->pLesser));
           ReportFileNames((*pAdapterHead)->strAdapterID,
            &((*pAdapterHead)->pFileHead));
           ReportAdapters(&((*pAdapterHead)->pGreater));
           free((void *) *pAdapterHead);
           *pAdapterHead=NULL;
         }
       return;
     }

