/* ifstat.cpp built by cys / snake_clanman@hotmail.com */

#include <stdio.h>
#include <windows.h>
#include <Iprtrmib.h>
#include <Iphlpapi.h>
#pragma comment(lib,"Iphlpapi.lib")

void ListInterfaces(DWORD interfaces);

int main(int argc, char **argv)
{
 MIB_IFROW stats;
 DWORD oldrecv = 0, oldsent = 0, interfaces = 0;
 GetNumberOfInterfaces(&interfaces);
 if(argc<2)
 {
	 printf("\nUsage: %s <interface number>\n",argv[0]);
	 if(interfaces>0)
		 ListInterfaces(interfaces);
	 else
		 printf("No interfaces found\n");
	 exit(-1);
 }
 stats.dwIndex = atoi(argv[1]);
 printf("Windows Bandwidth Monitor by cys\n\n# Nic : KB/s In : KB/s Out #\n");
 while(1) 
 {
	 GetIfEntry(&stats);
	 printf("#  %d  :   %u    :     %u    #\t\t\r",atoi(argv[1]),(stats.dwInOctets/1024)-oldrecv,(stats.dwOutOctets/1024)-oldsent);
	 oldrecv = stats.dwInOctets/1024;
	 oldsent = stats.dwOutOctets/1024;
	 Sleep(1000);
 }
}
char *getinterfacetype(DWORD bleh)
{
	if(bleh==MIB_IF_TYPE_OTHER)
		return "OTHER";
	else if(bleh==MIB_IF_TYPE_ETHERNET)
		return "ETHERNET";
	else if(bleh==MIB_IF_TYPE_TOKENRING)
		return "TOKENRING";
	else if(bleh==MIB_IF_TYPE_FDDI)
		return "FDDI";
	else if(bleh==MIB_IF_TYPE_PPP)
		return "PPP";
	else if(bleh==MIB_IF_TYPE_LOOPBACK)
		return "LOOPBACK";
	else if(bleh==MIB_IF_TYPE_SLIP)
		return "SLIP";
	else
		return "UNKNOWN";
}
void ListInterfaces(DWORD interfaces)
{
 DWORD x;
 printf("\n# Interface : Speed : Type #\n");
 for(x=1;x<interfaces+1;x++)
 {
	 MIB_IFROW nic;
	 nic.dwIndex = x;
	 GetIfEntry(&nic);
	 printf("# %d : %s : %u KB/s : %s #\n\n",x,nic.bDescr,nic.dwSpeed/1024,getinterfacetype(nic.dwSpeed));
 }
}








	