; Title:    Aimhol - A companion to AOL 'Find a Buddy Wizard'.
; Purpose:  Automatically retrieves AOL Instant Messenger screen names from the OSCAR/BOS servers!
; Author:   Vengy! (-_-)
; Date:     2003 and beyond ...
; Tested:   Win2K/XP ...
; Compiled: MASM32
; Bugs:     cyber_flash@hotmail.com


; AIM Login Process:
; ------------------
; OSCAR (Open System for Communication in Realtime) is a proprietary protocol
; developed by America On-Line (AOL). OSCAR defines a system of exchanging instant messages.
; The protocol is used by all versions of AOL's Instant Messenger (AIM) client and the latest 
; versions of ICQ (ICQ2000 and later). An OSCAR login is composed of a TCP packet that includes
; the login name (screen name), password, and client version string.
;
; Upon successful login, a cookie is issued that grants users access to the various BOS servers
; for the life of the session. The AIM network is comprised of two kinds of servers:
; Open System for Communications in Real-time (OSCAR), which handles user authorizations;
; and Basic OSCAR Service (BOS), which provides the search tools for users to find each other.


; How Aimhol works:
; -----------------
; It randomly picks a "Last Name" from a list of 2150 most common surnames (see surnames.inc)
; as compiled by 'http://www.census.gov/genealogy/names/dist.all.last' or builds a new random
; surname based upon the ODDS parameter, then sends it to the BOS server as a 'Find Buddy' request.
; It uses port 443 to connect. AIM default is 5190 but HTTPS (443) slips thru most firewalls.
; All responses are logged in ***BUDDY.TXT*** using the TLV (Type)(Length)(Value) format as follows:
;
; (00,09)(00,NN)(Screen Name)
; (00,08)(00,NN)(City)
; (00,07)(00,NN)(State)
; (00,06)(00,NN)(Country)
; (00,02)(00,NN)(Last Name)
; (00,01)(00,NN)(First Name)
;
; Additional data such as, hobbies, nick names, etc.,... are logged too!
; Also, Screen Names are extracted from buddy.txt and saved in ***SN.TXT***.


; Derivation: 
; -----------
; Aimhol - not quite a Warhol. ;)


; Theory:
; -------
; Generating random surnames such as DFDGIOP, Q320EWQE, FD1F,... (using the 'rand' function) 
; Will create more chaotic search results which has the effect of covering a wider range of screen names.
; Other suggestions to: cyber_flash@hotmail.com


; Assemble:
; ---------
; Launch MASM32 and place these 3 files into the \MASM32\INCLUDE folder:
;
; surnames.inc
; misc_stuff.inc
; rand.inc
;
; Run the 'Console Assemble & Link' menu option.


; Examples:
; ---------
; MAXRETRIES=2,MAXSUBMITS=3 means that three surnames, say SMITH, JOHNSON and DOE
; will each be submitted twice for a total of 6 search requests to the BOS Search server.
; In my testing, retries seems to retrieve new data each time, but after 10 attempts or so,
; you'll get diminishing returns since alot are duplicates of previous searches!
;
; This simple 2x3 example found 600 unique AIM screen names quickly!
; Searching with 2x15 yielded 2922 screen names. :)


; Thanks To:
; ----------
; > Home of the UnOfficial AIM/OSCAR Protocol Specification.
;   You will find the documents explaining the AIM/OSCAR protocol and related issues.
;   Please visit: http://aimdoc.sourceforge.net/OSCARdoc/
;
; > Ethereal is a free network protocol analyzer for Unix and Windows.
;   It allows you to examine data from a live network or from a capture file on disk.
;   Please visit: http://www.ethereal.com/
;
; > Makoto Matsumoto and Takuji Nishimura psuedo random number generating algorithm!
;   Copyright 1997, matumoto@math.keio.ac.jp
;   Please visit: http://www.math.keio.ac.jp/matumoto/emt.html
;
; > The MD5 algorithm (Message Digest 5) is a cryptographic message digest algorithm.
;   It takes as input a message of arbitrary length and produces as output a 128-bit "fingerprint". 
;   Please visit: http://win32assembly.online.fr/



; =======================================  Let The Games Begin! ======================================= 
.486p
.MODEL flat, stdcall
option casemap:none 


include	\masm32\include\windows.inc
include	\masm32\include\user32.inc
include	\masm32\include\kernel32.inc
include	\masm32\include\gdi32.inc
include	\masm32\include\ws2_32.inc
include	\masm32\include\masm32.inc


include	\masm32\include\misc_stuff.inc
include	\masm32\include\rand.inc
include	\masm32\include\surnames.inc


includelib  \masm32\lib\gdi32.lib
includelib  \masm32\lib\kernel32.lib
includelib  \masm32\lib\user32.lib
includelib  \masm32\lib\ws2_32.lib
includelib  \masm32\lib\masm32.lib

  
  PORT                equ 443                        ; AIM default is 5190. HTTPS (443) slips thru most firewalls.
  PORT_SIZE           equ 3                          ; Length in bytes of the port number.

  SLEEP               equ 5                          ; Sleep 5 seconds between 'Find Buddy' requests.
  
  MAXSIZE             equ 256                        ; Key Buffer
  BUFSIZE             equ 1000                       ; Generic Buffer
  NAMSIZE             equ 15*1024                    ; 15KB buffer per name request.

; Note:
; -----
; Following the first two bytes [command_start,channel_id] is a word representing the sequence number. 
; Why AOL needed a sequence number on a protocol that uses TCP/IP is unknown. 
; However, you must always provide an ever-increasing sequence number or your client will be 
; abruptly disconnected. Sequence numbers can begin with any number and must always increase by one. 
; The sequence numbers used by the client are completely separate from the sequence numbers sent to you by AOL.
; This program starts at seq# 0,1,2,...,65535!


CONN_ACK            STRUC
  command_start     db 0
  channel_id        db 0
  sequence_number   db 00h,00h                          
  data_length       dw 0
  data              db 4 dup(0)
CONN_ACK            ENDS


SIGNON_USER         STRUC
  command_start     db 2ah
  channel_id        db 02h
  sequence_number   db 00h,00h                        
  data_length       db 00h
                    db 00h
  fnac_family_id    dw 1700h
  fnac_subtype_id   dw 0600h
  fnac_flags        dw 0000h
  fnac_id           dd 00000000h
  info_type         dw 0100h
  screen_name_len   db 00h
                    db 00h
  ; Screen name goes here. Sent from with the main program.               
SIGNON_USER         ENDS



SIGNON_USER_REPLY   STRUC
  command_start     db 0
  channel_id        db 0
  sequence_number   dw 0
  data_length       dw 0
  fnac_family_id    dw 0
  fnac_subtype_id   dw 0
  fnac_flags        dw 0
  fnac_id           dd 0
  signon_challenge  db 0
                    db 0
  signon_key        db BUFSIZE dup(0)
SIGNON_USER_REPLY   ENDS


AUTHORIZE_REQUEST_HDR   STRUC
  command_start     db 2ah
  channel_id        db 02h                           
  sequence_number   db 00h,00h                     
  data_length       db 00h
                    db 00h                  
  fnac_family_id    dw 1700h
  fnac_subtype_id   dw 0200h
  fnac_flags        dw 0000h
  fnac_id           dd 00000000h
  info_type         dw 0100h
  screen_name_len   db 00h
                    db 00h
  ; Screen name goes here. Sent from with the main program.
AUTHORIZE_REQUEST_HDR ENDS
       

AUTHORIZE_REQUEST_END   STRUC
  md5_maybe         dw 2500h
  fingerprint_len   dw 1000h
  md5_fingerprint   dd ?                          
                    dd ?
                    dd ?
                    dd ?
  ClientProfile     db 000h,003h
  CPLength          db 000h,02Dh
  Version           db 041h,04Fh,04Ch,020h                                                      ; AOL
                    db 049h,06Eh,073h,074h,061h,06Eh,074h,020h                                  ; Instant
                    db 04Dh,065h,073h,073h,065h,06Eh,067h,065h,072h,02Ch,020h                   ; Messenger,
                    db 076h,065h,072h,073h,069h,06Fh,06Eh,020h                                  ; Version
                    db 035h,02Eh,031h,02Eh,033h,030h,033h,036h,02Fh,057h,049h,04Eh,033h,032h    ; 5.1.3036/WIN32
unknown             db 000h,016h
uLength             db 000h,002h,001h,009h
ClientVersionMajor  db 000h,017h
CVMLength           db 000h,002h
Major               db 000h,005h
ClientVersionMinor  db 000h,018h
CVMiLength          db 000h,002h
Minor               db 000h,001h
unknown1            db 000h,019h
u1Length            db 000h,002h
                    db 000h,000h
ClientVersionBuild  db 000h,01Ah
CVBLength           db 000h,002h
Build               db 00Bh,0DCh
unknown2            db 000h,014h
u2Length            db 000h,004h
u2Data              db 000h,000h
                    db 000h,0D2h
LanguageCode        db 000h,00Fh
LCLength            db 000h,002h
en                  db 065h,06Eh
CountryCode         db 000h,00Eh
CCLength            db 000h,002h
us                  db 075h,073h
AUTHORIZE_REQUEST_END  ENDS


SIGNON_BOS          STRUC
  command_start     db 2ah
  channel_id        db 01h
  sequence_number   db 00h,00h                       
  data_length       db 00h
                    db 00h
  data              db 00h,00h,00h,01h
  cookie_TLV        db 00h,06h
  cookie_len        db 00h
                    db 00h
  cookie_key        db MAXSIZE dup(0)
SIGNON_BOS          ENDS


SERVER_BOS_READY    STRUC
  command_start     db 0
  channel_id        db 0
  sequence_number   dw 0
  data_length       dw 0
  fnac_family_id    dw 0
  fnac_subtype_id   dw 0
  fnac_flags        dw 0
  fnac_id           dd 0
  data              db BUFSIZE dup(0)
SERVER_BOS_READY    ENDS


CLIENT_SNAC_REQUEST STRUC
  command_start     db 2ah
  channel_id        db 02h
  sequence_number   db 00h,00h                      
  data_length       dw 1200h
  fnac_family_id    dw 0100h
  fnac_subtype_id   dw 1700h
  fnac_flags        dw 0000h
  fnac_id           db 00h,00h,00h,17h
  data              db 00h,01h,00h,03h,00h,0fh,00h,01h
CLIENT_SNAC_REQUEST ENDS


SERVER_SNAC_RESPONSE STRUC
  command_start     db 0
  channel_id        db 0
  sequence_number   dw 0
  data_length       dw 0
  fnac_family_id    dw 0
  fnac_subtype_id   dw 0
  fnac_flags        dw 0
  fnac_id           dd 0
  data              db BUFSIZE dup(0)  
SERVER_SNAC_RESPONSE ENDS


CLIENT_RATE_REQUEST STRUC
  command_start     db 2ah
  channel_id        db 02h
  sequence_number   db 00h,00h                      
  data_length       dw 0a00h
  fnac_family_id    dw 0100h
  fnac_subtype_id   dw 0600h
  fnac_flags        dw 0000h
  fnac_id           db 00h,00h,00h,06h
CLIENT_RATE_REQUEST ENDS


SERVER_RATE_RESPONSE STRUC
  command_start     db 0
  channel_id        db 0
  sequence_number   dw 0
  data_length       dw 0 
  fnac_family_id    dw 0
  fnac_subtype_id   dw 0
  fnac_flags        dw 0
  fnac_id           dd 0
  data              db BUFSIZE dup(0)
SERVER_RATE_RESPONSE ENDS


CLIENT_RATE_ACK     STRUC
  command_start     db 2ah
  channel_id        db 02h
  sequence_number   db 00h,00h                     
  data_length       dw 1400h
  fnac_family_id    dw 0100h
  fnac_subtype_id   dw 0800h
  fnac_flags        dw 0000h
  fnac_id           db 00h,00h,00h,08h
  data              db 00h,01h,00h,02h,00h,03h,00h,04h,00h,05h
CLIENT_RATE_ACK     ENDS


CLIENT_READY        STRUC
  command_start     db 2ah
  channel_id        db 02h
  sequence_number   db 00h,00h                       
  data_length       dw 1a00h
  fnac_family_id    dw 0100h
  fnac_subtype_id   dw 0200h
  fnac_flags        dw 0000h
  fnac_id           db 00h,00h,00h,02h
  data              db 00h,01h,00h,03h,00h,10h,06h,29h,00h,0fh,00h,01h,00h,10h,06h,29h
CLIENT_READY        ENDS


CLIENT_SERVICE_REQUEST STRUC
  command_start     db 2ah
  channel_id        db 02h
  sequence_number   db 00h,00h                      
  data_length       dw 0c00h
  fnac_family_id    dw 0100h
  fnac_subtype_id   dw 0400h
  fnac_flags        dw 0000h
  fnac_id           db 00h,03h,00h,04h
  data              db 00h,0fh
CLIENT_SERVICE_REQUEST ENDS


SIGNON_BOS_REDIRECT STRUC
  command_start     db 2ah
  channel_id        db 01h
  sequence_number   db 00h,00h                    
  data_length       db 01h
                    db 08h
  data              db 00h,00h,00h,01h
  cookie_TLV        db 00h,06h
  cookie_len        db 01h
                    db 00h
  cookie_key        db MAXSIZE dup(0)
SIGNON_BOS_REDIRECT ENDS


FIND_BUDDY          STRUC
  command_start     db 2ah         ; --- BY SURNAME  
  channel_id        db 02h
  sequence_number   db 00h,00h                     
  data_length       dw 2f00h 
  fnac_family_id    dw 0f00h
  fnac_subtype_id   dw 0200h
  fnac_flags        dw 0000h
  fnac_id           db 00h
  lookup_attempts   db 01h
                    db 00h,02h
  data              db 00h,1ch,00h,08h,75h,73h,2dh,61h,73h,63h,69h,69h,00h,0ah,00h,02h,00h,00h,00h,02h        
  surname_length    db 00h,0fh
  surname           db 15 dup(0)

  ;command_start     db 2ah        ; --- BY EMAIL (example: bort@aol.com)
  ;channel_id        db 02h
  ;sequence_number   db 00h,00h                       
  ;data_length       dw 1600h
  ;fnac_family_id    dw 0a00h
  ;fnac_subtype_id   dw 0200h
  ;fnac_flags        dw 0000h
  ;fnac_id           db 00h,00h,00h,15h
  ;surname           db 62h,6fh,72h,74h,40h,61h,6fh,6ch,2eh,63h,6fh,6dh 

  ;command_start     db 2ah        ; -- BY INTEREST (example: music/classical)
  ;channel_id        db 02h
  ;sequence_number   db 00h,00h                     
  ;data_length       dw 2900h
  ;fnac_family_id    dw 0f00h
  ;fnac_subtype_id   dw 0200h
  ;fnac_flags        dw 0000h
  ;fnac_id           db 00h,07h,00h,02h
  ;surname           db 00h,1ch,00h,08h,75h,73h,2dh,61h,73h,63h
  ;                  db 69h,69h,00h,0ah,00h,02h,00h,01h,00h,0bh
  ;                  db 00h,09h,43h,6ch,61h,73h,73h,69h,63h,61h,6ch
FIND_BUDDY           ENDS


AIM_LOGOUT          STRUC
  command_start     db 2ah
  channel_id        db 04h
  sequence_number   db 00h,00h                   
  data              db 00h,00h
AIM_LOGOUT          ENDS


.DATA

        banner                      db 13,10
                                    db " _______   __              __              __  ",13,10
                                    db "|   _   | |__| .--------. |  |--. .-----. |  | ",13,10
                                    db "|.  1   | |  | |        | |     | |  _  | |  | ",13,10
                                    db "|.  _   | |__| |__|__|__| |__|__| |_____| |__| ",13,10
                                    db "|:  |   |                                      ",13,10
                                    db "|::.|:. | AIM: Find A Random Buddy Wizard! ... ",13,10
                                    db "'--- ---'                                      ",13,10
                                    db "==============================================",13,10
                                    db 13,10,0

        Username                    db 'Username: '
        SCREEN_NAME                 db MAXSIZE dup(0)   ; Your AIM screen name. 
        SCREEN_NAME_SIZE            dw 0                ; Length in bytes of 'yourscreenname'.
                                    dw 0

        Password                    db 'Password: '
        PASSWORD                    db MAXSIZE dup(0)   ; Your AIM password.
        PASSWORD_SIZE               dw 0                ; Length in bytes of 'yourpassword'. 
                                    dw 0 

        MaxSubmits                  db 13,10,'Number of surnames to submit (1-65535): '    
        MaxSubmitsStr               db 7 dup(0)
        MAXSUBMITS                  dw 0                ; Max. number of submitted surnames. [1-65535]
        MaxSubmitsRead              dw 0
                                    dw 0

        MaxRetries                  db 'Number of resubmits per surname (1-10): '    
        MaxRetriesStr               db 4 dup(0)
        MAXRETRIES                  db 0                ; Retry surnames to obtain new data. [1-10]
        MaxRetriesRead              dw 0
                                    dw 0    

        MaxOdds                     db 'Odds of submitting random names (1-50): '    
        MaxOddsStr                  db 4 dup(0)
        ODDS                        db 0                ; Odds of submitting a new random surname. [1-50]
        MaxOddsRead                 dw 0
                                    dw 0                                            

        type_err                    db 0
        user_err                    db 'Invalid Username. Must be 3-16 characters.',0 
        pass_err                    db 'Invalid Password. Must be 4-16 characters.',0
        maxs_err                    db 'Invalid Number. Outside range 1-65535.',0
        maxr_err                    db 'Invalid Number. Outside range 1-10.',0   
        odds_err                    db 'Invalid Number. Outside range 1-10.',0             

        hInput                      dd 0
        hOutPut                     dd 0
        bWritten                    dd 0   

        md5_buff                    db BUFSIZE dup(0)     
        aol_str                     db 'AOL Instant Messenger (SM)'

        write_msg                   db 13,10,'Writing raw buddy data to BUDDY.TXT' ,0
        buddy_filename              db 'buddy.txt',0
        write1_msg                  db 13,10,'Writing screen names to SN.TXT' ,0
        sn_filename                 db 'sn.txt',0    
                
        fhandle_txt                 dd ?
        bytes_write                 dd ?     

        pMem                        dd 0     
        err_num                     db 0 
        ten                         dw 10
        
        pad                         db 5 dup('.')
        num                         db 5 dup(0)
        space                       db ' '
        buddy_name                  db 16 dup(0)
        
        rand_name                   db 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'
        pad_rand                    db 15 dup(' ')
        
        szConsoleTitle              db 'AIMHOL - AOL Screen Name Search Tool',0

        szAUTTitle                  db 'Connecting to Login OSCAR Server:  '   
        szOSCARName                 db 'login.oscar.aol.com',0 
        
        szBOSTitle                  db 'Connecting to Basic OSCAR Server:  '
        szBOS_Server_IP             db 16 dup(0)
        
        szBOSrTitle                 db 'Connecting to Search OSCAR Server: '
        szBOS_Redirect_Server_IP    db 16 dup(0)
        
        err_buff                    db 'Invalid Login! Please try again or visit:',13,10
        error_response              db MAXSIZE dup(0)
        
        szCONfail                   db 'Connect failed!',0 
        szMEMfail                   db 'Sorry, unable to allocate memory!',0         
        
        szStartSearch               db 13,10,'Count Surname'
        szHdr                       db 13,10,'----- ----------------',0
        szDone                      db 13,10,'Done! Press enter to quit . . .',0
          
        authorization_request_hdr   AUTHORIZE_REQUEST_HDR <> 
        authorization_request_end   AUTHORIZE_REQUEST_END <>
                        
        connection_ack              CONN_ACK <>
        
        signon_username             SIGNON_USER <>
        signon_username_reply       SIGNON_USER_REPLY <> 
        
        signon_bos_server           SIGNON_BOS <>
        server_bos_ready            SERVER_BOS_READY <>
        
        client_snac_request         CLIENT_SNAC_REQUEST <>
        server_snac_response        SERVER_SNAC_RESPONSE <>
        
        client_rate_request         CLIENT_RATE_REQUEST <>
        server_rate_response        SERVER_RATE_RESPONSE <>
        
        client_rate_ack             CLIENT_RATE_ACK <>
        
        find_buddy                  FIND_BUDDY <>
        
        aim_logout                  AIM_LOGOUT <>
        
        client_ready                CLIENT_READY <>
        
        client_service_request      CLIENT_SERVICE_REQUEST <>
        signon_bos_redirect         SIGNON_BOS_REDIRECT <>

       
.CODE
Main:      
        ; --- Title of my tool.
        invoke    SetConsoleTitle, addr szConsoleTitle 

        ; --- Banner in green, everything else in white color!
        invoke   GetStdHandle, STD_OUTPUT_HANDLE
        push     eax
        invoke   SetConsoleTextAttribute, eax,FOREGROUND_GREEN        
        invoke   PrintText, addr banner
        pop      eax
        invoke   SetConsoleTextAttribute, eax,FOREGROUND_RED OR FOREGROUND_GREEN OR FOREGROUND_BLUE

        ; --- Get Login Username and Password
        call      Get_Login_Data
        cmp       byte ptr [type_err],0 ; 0=no errors
        jnz       bad_input        

        ; --- Initialize Winsock.
        invoke    WSAStartup, 0101h, addr WSAData 
              
        ; --- Connect to the AIM Login Authorizer server: login.oscar.aol.com
        invoke    PrintText, addr  szAUTTitle        
        invoke    ConnectToHost, addr hSock, addr szOSCARName, PORT, SOCK_STREAM
        cmp       eax,-1
        je        connect_failed

        ; --- Set socket timeout to 60 seconds.
        invoke    TimeOut, hSock, 60*1000        

        ; --- Receive Connection Acknowledge.
        invoke    Recv_Data, hSock,addr connection_ack, SIZEOF connection_ack 

        ; --- Send Connection Acknowledge.
        invoke    SequenceNumber, addr connection_ack.sequence_number
        invoke    Send_Data, hSock, addr connection_ack, SIZEOF connection_ack 
        
        ; --- Setup Sign-on request.        
        xor       ecx,ecx
        mov       cx,[SCREEN_NAME_SIZE]
        mov       byte ptr [signon_username.screen_name_len+1],cl        
        add       cx,SIZEOF SIGNON_USER-6
        mov       byte ptr [signon_username.data_length+1],cl 

        ; --- Send Sign-on request.
        invoke    SequenceNumber, addr signon_username.sequence_number
        invoke    Send_Data, hSock, addr signon_username, SIZEOF signon_username
        xor       ecx,ecx
        mov       cx,[SCREEN_NAME_SIZE]
        invoke    Send_Data, hSock, addr SCREEN_NAME, ecx       

        ; --- Receive Sign-on response. 
        invoke    Recv_Data, hSock, addr signon_username_reply, SIZEOF signon_username_reply     

        ; --- Check for errors! 
        mov       eax,offset signon_username_reply 
        add       ax,20                     ; Jump over static command_start data
        add       ax,[SCREEN_NAME_SIZE]     ; Jump over Screen Name to start of TLV.
        inc       eax                                           
        cmp       byte ptr [eax],04h        ; 04=Error, 05=IP address.
        je        err_msg

        ; --- Create MD5 message string: [KEY<join>PASSWORD<join>AOL Instant Messenger (SM)]
        mov       esi,offset signon_username_reply.signon_key
        mov       edi,offset md5_buff
        xor       ecx,ecx
        xor       ebx,ebx
        mov       cl, byte ptr [signon_username_reply.signon_challenge+1]
        add       ebx,ecx
        rep       movsb
        mov       esi,offset PASSWORD
        mov       cx,[PASSWORD_SIZE]
        add       ebx,ecx
        rep       movsb
        mov       esi,offset aol_str
        mov       ecx,SIZEOF aol_str
        add       ebx,ecx
        rep       movsb

        ; --- Hash the string using the MD5 algorithm. Cool! (ebx=message length)
        invoke	  MD5hash,addr md5_buff,ebx,addr stMD5Result

        ; --- Save fingerprint/hash result.
        mov       esi,offset stMD5Result
        mov       edi,offset authorization_request_end.md5_fingerprint
        mov       ecx,4
        rep       movsd

        ; --- Setup Authorization Request!
        xor       ecx,ecx
        mov       cx,[SCREEN_NAME_SIZE]
        mov       byte ptr [authorization_request_hdr.screen_name_len+1],cl
        add       cx,(SIZEOF AUTHORIZE_REQUEST_HDR-6)+(SIZEOF AUTHORIZE_REQUEST_END)
        mov       byte ptr [authorization_request_hdr.data_length+1],cl

        ; --- Send Authorization Request!
        invoke    SequenceNumber, addr authorization_request_hdr.sequence_number
        invoke    Send_Data, hSock, addr authorization_request_hdr, SIZEOF authorization_request_hdr
        xor       ecx,ecx
        mov       cx,[SCREEN_NAME_SIZE]
        invoke    Send_Data, hSock, addr SCREEN_NAME, ecx        
        invoke    Send_Data, hSock, addr authorization_request_end, SIZEOF authorization_request_end

        ; --- Allocate recv buffer.
        invoke    GlobalAlloc,GMEM_FIXED OR GMEM_ZEROINIT,BUFSIZE
        
        test      eax,eax		
        jz        memory_bad

        mov       pMem,eax                  ; Pointer to memory buffer

        ; --- Receive Authorization response and cookie! :)
        invoke    Recv_Data, hSock, pMem, BUFSIZE                            

        ; --- Check for errors!         
        mov       eax,pMem
        add       ax,20
        add       ax,[SCREEN_NAME_SIZE]     ; Jump over static command_start data + Screen Name to start of TLV.
        inc       eax
        cmp       byte ptr [eax],04h        ; 04=Error, 05=IP address.
        je        err_msg

        ; --- Get BOS Server IP and Cookie.                
        inc       eax
        inc       eax            
        xor       ecx,ecx
        mov       cl,byte ptr [eax]         ; Length of BOS Server IP:Port (00,NN)
        sub       cl,1+PORT_SIZE            ; Subtract the ":Port" part                    
        inc       eax
        mov       esi,eax                   ; Now at start of IP address.
        mov       edi,offset szBOS_Server_IP
        rep       movsb                     ; Store it!
        add       esi,1+PORT_SIZE+2         ; Jump over ":Port,00,06" (Start TLV Authorization)
        xor       ecx,ecx        
        mov       ch,byte ptr [esi]         ; Store Authorization Length (NN,NN)
        mov       cl,byte ptr [esi+1]
        mov       byte ptr [signon_bos_server.cookie_len],ch
        mov       byte ptr [signon_bos_server.cookie_len+1],cl
        push      ecx
        add       cl,8                      ; Compute data_length (8 = data+cookie_TLV+cookie_len)
        mov       byte ptr [signon_bos_server.data_length],ch
        mov       byte ptr [signon_bos_server.data_length+1],cl
        pop       ecx
        inc       esi      
        inc       esi                       ; Start of Authorization Cookie!
        mov       edi,offset signon_bos_server.cookie_key
        rep       movsb                     ; Store session Cookie! 
        jmp       bos_ok        

err_msg:
        xor       ecx,ecx
        mov       cl,byte ptr [eax+2]       ; Length of error message.
        add       eax,3                     ; Start of error message.
        xchg      eax,esi
        mov       edi,offset err_buff+(SIZEOF err_buff)
        rep       movsb                     ; Store Error.
        
        inc       byte ptr [err_num]        ; Set error flag.

bos_ok:
        ; --- Free allocated memory
        invoke    GlobalFree, pMem

        ; --- Logout. Close connection.
        invoke    SequenceNumber, addr aim_logout.sequence_number
        invoke    Send_Data, hSock, addr aim_logout, SIZEOF aim_logout

        ; --- Close socket to Authorizer Server: login.oscar.aol.com
        invoke    closesocket, hSock

        ; --- Maybe exit program?
        cmp       byte ptr [err_num],0      ; 0=no error, 1=error.
        je        connect_to_bos

        ; --- Dislay error message.
        invoke    PrintText, addr err_buff           
        jmp       exit
        

        ; ================================= Connect to BOS Server ================================= 
        ; --- Connect to the BOS server.
connect_to_bos:
        invoke    PrintText, addr  szBOSTitle 
        invoke    ConnectToHost, addr hSock, addr szBOS_Server_IP, PORT, SOCK_STREAM
        cmp       eax,-1
        je        connect_failed

        ; --- Set socket timeout to 60 seconds.
        invoke    TimeOut, hSock, 60*1000   

        ; --- Receive Connection Acknowledge
        invoke    Recv_Data, hSock, addr connection_ack, SIZEOF connection_ack

        ; --- Send BOS Sign-on request.
        invoke    SequenceNumber, addr signon_bos_server.sequence_number
        invoke    Send_Data, hSock, addr signon_bos_server, SIZEOF signon_bos_server

        ; --- Receive BOS server ready response. Server is now ready for normal functions.
        invoke    Recv_Data, hSock, addr server_bos_ready, SIZEOF server_bos_ready		 

        ; --- Send Client Snac request.
        invoke    SequenceNumber, addr client_snac_request.sequence_number 
        invoke    Send_Data, hSock, addr client_snac_request, SIZEOF client_snac_request
       
        ; --- Receive Server Snac response.
        invoke    Recv_Data, hSock, addr server_snac_response, SIZEOF server_snac_response

        ; --- Send Client Rate Information request.
        invoke    SequenceNumber, addr client_rate_request.sequence_number              
        invoke    Send_Data, hSock, addr client_rate_request, SIZEOF client_rate_request

        ; --- Receive Server Rate Information response.
        invoke    Recv_Data, hSock, addr server_rate_response, SIZEOF server_rate_response 

        ; --- Send Client Rate ACK.
        invoke    SequenceNumber, addr client_rate_ack.sequence_number              
        invoke    Send_Data, hSock, addr client_rate_ack, SIZEOF client_rate_ack

        ; --- Send Client Ready.
        invoke    SequenceNumber, addr client_ready.sequence_number              
        invoke    Send_Data, hSock, addr client_ready, SIZEOF client_ready

        ; --- Send Request for new service! (server will redirect client)
        invoke    SequenceNumber, addr client_service_request.sequence_number             
        invoke    Send_Data, hSock, addr client_service_request, SIZEOF client_service_request

        ; --- Receive Authorization response and NEW cookie! :)
        invoke    GlobalAlloc,GMEM_FIXED OR GMEM_ZEROINIT,BUFSIZE
        
        test      eax,eax		
        jz        memory_bad
      
        mov       pMem,eax
        invoke    Recv_Data, hSock, pMem, BUFSIZE

        ; --- Get BOS Redirect Server IP and session Cookie.
        mov       esi,pMem
        add       esi,25                            ; Jump over static command_start data stuff.
        xor       ecx,ecx
        mov       cl,byte ptr [esi]                 ; Length of Redirect BOS Server IP.
        inc       esi                               ; Now at start of IP address.                        
        mov       edi,offset szBOS_Redirect_Server_IP
        rep       movsb                             ; Store Cookie! 
        mov       ch,byte ptr [esi+2]               ; Store Authorization Cookie Length (NN,NN)
        mov       cl,byte ptr [esi+3]
        mov       byte ptr [signon_bos_redirect.cookie_len],ch
        mov       byte ptr [signon_bos_redirect.cookie_len+1],cl
        add       esi,4                             ; Start of Authorization Cookie.
        mov       edi,offset signon_bos_redirect.cookie_key
        rep       movsb                             ; Store BOS session cookie! 

        ; --- Free allocated memory.
        invoke    GlobalFree, pMem

        ; --- Logout. Close connection.
        invoke    SequenceNumber, addr aim_logout.sequence_number                                
        invoke    Send_Data, hSock, addr aim_logout, SIZEOF aim_logout

        ; --- Close socket to BOS Server.
        invoke    closesocket, hSock

       
        ; ================================= Connect to BOS Server (Redirect) =================================
        ; --- Connect to the Redirect BOS server.
        invoke    PrintText, addr  szBOSrTitle 
        invoke    ConnectToHost, addr hSock, addr szBOS_Redirect_Server_IP, PORT, SOCK_STREAM
        cmp       eax,-1
        je        connect_failed

        ; --- Set socket timeout to 60 seconds.
        invoke    TimeOut, hSock, 60*1000        

        ; --- Receive Connection Acknowledge.
        invoke    Recv_Data, hSock, addr connection_ack, SIZEOF connection_ack

        ; --- Send Sign-on request.
        invoke    SequenceNumber, addr signon_bos_redirect.sequence_number
        invoke    Send_Data, hSock, addr signon_bos_redirect, SIZEOF signon_bos_redirect

        ; --- Receive Redirect BOS server ready response. Server is now ready for normal functions.
        invoke    Recv_Data, hSock, addr server_bos_ready, SIZEOF server_bos_ready
  
        ; --- Send Client Snac request.
        invoke    SequenceNumber, addr client_snac_request.sequence_number
        invoke    Send_Data, hSock, addr client_snac_request, SIZEOF client_snac_request
       
        ; --- Receive Server Snac response.
        invoke    Recv_Data, hSock, addr server_snac_response, SIZEOF server_snac_response

        ; --- Send Client Rate Information request.
        invoke    SequenceNumber, addr client_rate_request.sequence_number
        invoke    Send_Data, hSock, addr client_rate_request, SIZEOF client_rate_request

        ; --- Receive Server Rate Information response.
        invoke    Recv_Data, hSock, addr server_rate_response, SIZEOF server_rate_response	 

        ; --- Send Client Rate ACK.
        invoke    SequenceNumber, addr client_rate_ack.sequence_number
        invoke    Send_Data, hSock, addr client_rate_ack, SIZEOF client_rate_ack

        ; --- Send Client Ready.
        invoke    SequenceNumber, addr client_ready.sequence_number
        invoke    Send_Data, hSock, addr client_ready, SIZEOF client_ready


        ; ================================= Start Buddy Search =================================
        ; --- Display start search message!
        invoke    PrintText, addr szStartSearch

        ; --- Allocate memory buffer for surnames.
        xor       eax,eax
        xor       edx,edx
        mov       dl,[MAXRETRIES]
        mov       ax,[MAXSUBMITS]
        mul       edx
        mov       ecx,NAMSIZE
        mul       ecx
        push      eax
        
        invoke    GlobalAlloc,GMEM_FIXED OR GMEM_ZEROINIT,eax
        
        test      eax,eax		
        jz        memory_bad

        mov       pMem,eax

        ; --- Track memory buffer pointer using ESI.
        xchg      esi,eax

        ; --- Track memory buffer size left using ECX.
        pop       ecx

surname_search:

        ; --- Decrease submit total.
        dec       word ptr [MAXSUBMITS]

        ; --- Select a random Last Name buddy.
        push      esi
        push      ecx
        
        ; --- Pick from surnames.inc or build a new random surname. [1 in ODDS]
        invoke    GetTickCount        
        invoke    Randomize,eax
        xor       eax,eax
        mov       al,byte ptr [ODDS]
        invoke    Rand,eax
        cmp       eax,0                 ; eax = [0...(ODDS-1)]
        jne       surnames_inc

        ; --- Calculate random buddy length.
        invoke    GetTickCount        
        invoke    Randomize,eax
        invoke    Rand,15               ; Length eax = [0...14]
        inc       eax                   ; Ensure at least a one character name. ;)
        xchg      eax,ecx               ; Store length. (ecx) 
        
        ; --- Pad buffer with 15 spaces.
        push      ecx
        lea       esi,offset pad_rand
        mov       edi,offset find_buddy.surname
        mov       ecx,15
        rep       movsb
        
        ; --- Build a new name but start it always with a character!
        invoke    Sleep,100             ; Introduce some randomness.
        invoke    GetTickCount        
        invoke    Randomize,eax
        invoke    Rand,26               ; eax = [0...25] (A-Z)
        lea       esi,[eax+offset rand_name]
        mov       edi,offset find_buddy.surname
        pop       ecx
        dec       ecx
        movsb

build_it:
        push      ecx
        push      edi
        invoke    Sleep,100             ; Introduce some randomness.
        invoke    GetTickCount        
        invoke    Randomize,eax
        invoke    Rand,36               ; eax = [0...35] (A-Z-0-9)
        lea       esi,[eax+offset rand_name]
        pop       edi
        movsb                           ; Move the single character.
        pop       ecx
        dec       ecx
        jnz       build_it

        jmp       disp_name
        
surnames_inc:
        ; --- Select a buddy from a list of 2150 most common surnames!
        invoke    GetTickCount        
        invoke    Randomize,eax
        invoke    Rand,2150             
        mov       ecx,15
        mul       ecx                          
        lea       esi,[eax+offset surname]
        mov       edi,offset find_buddy.surname
        mov       ecx,15
        rep       movsb

disp_name:
        ; --- Pad and convert total submit number to a string.
        lea       esi,offset pad
        mov       edi,offset num
        mov       ecx,5
        rep       movsb
        
        xor       eax,eax
        mov       ax,word ptr [MAXSUBMITS]
        xor       ecx,ecx
        mov       edi,offset num
next_div:
        xor       edx,edx
        div       ten
        push      edx
        inc       ecx
        test      eax,eax
        jnz       next_div
out_sym:
        pop       edx
        add       dl,'0'
        mov       byte ptr [edi],dl
        inc       edi
        dec       ecx
        jnz       out_sym

        ; ---  Setup Last Name buddy!
        lea       esi,offset find_buddy.surname
        mov       edi,offset buddy_name
        mov       ecx,15
        rep       movsb

        ; --- Display current search number and name!
        invoke    PrintText, addr num 
        
        pop       ecx
        pop       esi

        ; --- Initialize start search number.
        mov       byte ptr [find_buddy.lookup_attempts],0

surname_retry:

        ; --- Increment search number. AOL uses 01,02,03,... in their search calculations.
        inc       byte ptr [find_buddy.lookup_attempts]

        ; --- Check for sequence word overflow!
        cmp       word ptr [seq_num],65535
        je        seq_max_exceeded

        ; --- Send FIND BUDDY request.
        invoke    SequenceNumber, addr find_buddy.sequence_number
        invoke    Send_Data, hSock, addr find_buddy, SIZEOF find_buddy

        ; --- SLEEP seconds. Give the server time to send results. Sleep function changes ECX!!!
        pushad
        invoke    Sleep,SLEEP*1000 
        popad

        ; --- Receive Screen Name Data! :) Returns: ESI=buff current pointer, ECX=buff size left.
        invoke    Recv_Data, hSock, esi, ecx

        ; --- Check retry count.
        mov       al,[MAXRETRIES]
        cmp       byte ptr [find_buddy.lookup_attempts],al
        jne       surname_retry

        ; --- Check submit count.
        cmp       word ptr [MAXSUBMITS],0
        jg        surname_search

seq_max_exceeded:


        ; ================================= Save Buddy Search =================================
        push      esi 

        ; --- Create Buddy.txt data file.   
        invoke    PrintText, addr write_msg
        push      NULL				
        push      FILE_ATTRIBUTE_NORMAL		
        push      CREATE_ALWAYS			
        push      NULL				
        push      NULL				
        push      GENERIC_READ + GENERIC_WRITE
        push      offset buddy_filename
        call      CreateFileA                      
        mov       fhandle_txt,eax

        ; --- Total screen name data bytes received from BOS server!
        pop       esi
        push      esi               ; Save current pointer.
        sub       esi,pMem

        ; --- Write buddy data to file! :)
        push      NULL		
        push      offset bytes_write
        push      esi
        push      pMem	
        push      fhandle_txt		
        call      WriteFile                           

        ; --- Close buddy file.
        invoke    CloseHandle,fhandle_txt  

        ; --- Extract screen names!
        pop       esi               ; Restore current pointer.
        call      process_screen_names   

        ; --- Free allocated memory.
        invoke    GlobalFree, pMem

        ; --- Logout. Close connection.
        invoke    SequenceNumber, addr aim_logout.sequence_number
        invoke    Send_Data, hSock, addr aim_logout, SIZEOF aim_logout

        ; --- Close socket to Redirect BOS Server.
        invoke    closesocket, hSock


        ; ================================= CleanUp =================================  
        ; --- Terminate use of the Windows Sockets
        invoke    WSACleanup
        
        jmp       exit


        ; ================================= Errors ================================= 
bad_input:
        mov       al,byte ptr [type_err]
    .IF (al == 1)
        invoke    PrintText, addr user_err
    .ELSEIF (al == 2)
        invoke    PrintText, addr pass_err
    .ELSEIF (al == 3)
        invoke    PrintText, addr maxs_err
    .ELSEIF (al == 4)
        invoke    PrintText, addr maxr_err        
    .ELSE ; (al == 5)
        invoke    PrintText, addr odds_err        
    .ENDIF
        jmp       exit

memory_bad:
        invoke    PrintText, addr  szMEMfail
        jmp       exit

connect_failed:
        invoke    PrintText, addr  szCONfail
        

        ; ================================= Exit Program ================================= 
exit:
        ; --- That's all folks! ;)
        invoke    PrintText, addr  szDone    
        invoke    ReadConsole,hInput,ADDR SCREEN_NAME, 1,ADDR SCREEN_NAME_SIZE,NULL                          
        invoke    ExitProcess, 0


        ; ================================= Get Login Data ================================= 
Get_Login_Data:
        ; --- Get console handles.
        invoke    GetStdHandle,STD_OUTPUT_HANDLE
        mov       hOutPut, eax
        invoke    GetStdHandle,STD_INPUT_HANDLE
        mov       hInput, EAX
        cld
        
        ; --- Get Username.
        invoke    WriteFile, hOutPut, addr Username, SIZEOF Username, ADDR bWritten, NULL
        invoke    ReadConsole,hInput,addr SCREEN_NAME, SIZEOF SCREEN_NAME,addr SCREEN_NAME_SIZE,NULL
        dec       word ptr [SCREEN_NAME_SIZE] ; Remove: 0dh
        dec       word ptr [SCREEN_NAME_SIZE] ; Remove: 0ah    
        mov       ax,word ptr [SCREEN_NAME_SIZE]

    .IF ((ax >= 3) && (ax <= 16))
        jz        get_pass
    .ELSE
        mov       byte ptr [type_err],1
        ret
    .ENDIF

        ; --- Get Password.
get_pass:              
        invoke    WriteFile, hOutPut, addr Password, SIZEOF Password, ADDR bWritten, NULL
        invoke    ReadConsole,hInput,addr PASSWORD, SIZEOF PASSWORD,addr PASSWORD_SIZE,NULL
        dec       word ptr [PASSWORD_SIZE] 
        dec       word ptr [PASSWORD_SIZE]
        mov       ax,word ptr [PASSWORD_SIZE]

    .IF ((ax >= 4) && (ax <= 16))
        jz        get_max
    .ELSE
        mov       byte ptr [type_err],2
        ret
    .ENDIF

        ; --- Get Max. Submits. 
get_max:             
        invoke    WriteFile, hOutPut, addr MaxSubmits, SIZEOF MaxSubmits, ADDR bWritten, NULL
        invoke    ReadConsole,hInput,addr MaxSubmitsStr, SIZEOF MaxSubmitsStr,addr MaxSubmitsRead,NULL
        dec       word ptr [MaxSubmitsRead] 
        dec       word ptr [MaxSubmitsRead]

        ; Convert ascii to binary.      
        xor       edi,edi
        mov       di,[MaxSubmitsRead]
        mov       byte ptr [MaxSubmitsStr+di],00h
        xor       eax,eax     
        invoke    atodw, addr MaxSubmitsStr
        
    .IF ((eax >= 1) && (eax <= 65535))
        mov       [MAXSUBMITS],ax
        jz        get_retries
    .ELSE
        mov       byte ptr [type_err],3
        ret
    .ENDIF

        ; --- Get Retries per surname. 
get_retries:  
        invoke    WriteFile, hOutPut, addr MaxRetries, SIZEOF MaxRetries, ADDR bWritten, NULL
        invoke    ReadConsole,hInput,addr MaxRetriesStr, SIZEOF MaxRetriesStr,addr MaxRetriesRead,NULL
        dec       word ptr [MaxRetriesRead] 
        dec       word ptr [MaxRetriesRead]

        ; Convert ascii to binary.
        xor       edi,edi
        mov       di,[MaxRetriesRead]
        mov       byte ptr [MaxRetriesStr+di],00h
        xor       eax,eax     
        invoke    atodw, addr MaxRetriesStr
        
    .IF ((al >= 1) && (al <= 10))
        mov       byte ptr [MAXRETRIES],al
        jz        get_odds
    .ELSE
        mov       byte ptr [type_err],4
        ret
    .ENDIF

        ; --- Get Odds of random surname. 
get_odds:  
        invoke    WriteFile, hOutPut, addr MaxOdds, SIZEOF MaxOdds, ADDR bWritten, NULL
        invoke    ReadConsole,hInput,addr MaxOddsStr, SIZEOF MaxOddsStr,addr MaxOddsRead,NULL
        dec       word ptr [MaxOddsRead] 
        dec       word ptr [MaxOddsRead]

        ; Convert ascii to binary.
        xor       edi,edi
        mov       di,[MaxOddsRead]
        mov       byte ptr [MaxOddsStr+di],00h
        xor       eax,eax     
        invoke    atodw, addr MaxOddsStr
        
    .IF ((al >= 1) && (al <= 50))
        mov       byte ptr [ODDS],al
        jz        data_ok
    .ELSE
        mov       byte ptr [type_err],5
        ret
    .ENDIF


data_ok:
        ret


        ; ================================= Save Screen Names ================================= 
        ; (00,09)(00,NN)(Screen Name)
        ; (00,08)(00,NN)(City)
        ; (00,07)(00,NN)(State)
        ; (00,06)(00,NN)(Country)
        ; (00,02)(00,NN)(Last Name)
        ; (00,01)(00,NN)(First Name)

process_screen_names:
        mov       edi,esi
        mov       esi,pMem
        
        ; --- Create sn.txt data file.  
        push      edi
        push      esi 
        invoke    PrintText, addr write1_msg        
        push      NULL				
        push      FILE_ATTRIBUTE_NORMAL		
        push      CREATE_ALWAYS			
        push      NULL				
        push      NULL				
        push      GENERIC_READ + GENERIC_WRITE
        push      offset sn_filename
        call      CreateFileA                      
        mov       fhandle_txt,eax
        pop       esi
        pop       edi

find_data:    
        xor       eax,eax
        xor       ebx,ebx
        xor       ecx,ecx

        mov       al,byte ptr [esi+0]         ; Type
        mov       bl,byte ptr [esi+1] 
        mov       ah,byte ptr [esi+2]        
        mov       cl,byte ptr [esi+3]         ; Length
        mov       bh,byte ptr [esi+4]         ; Value        

     .IF ((al == 00h) && (bl == 09h) && (ah == 00h) && (bh != 00h))   
        add       esi,4                       ; Start of Screen Name.
        call      write_it
        add       esi,dword ptr [bytes_write] ; Start of next TLV.
        push      esi
        mov       esi,offset crlf             ; Start new line.
        mov       ecx,2
        call      write_it
        pop       esi
    .ELSE
        inc       esi
    .ENDIF

        cmp       esi,edi
        jl        find_data

        ; --- Close SN file.
        invoke    CloseHandle,fhandle_txt    

        ret 

        ; --- Write screen names to file! :)
write_it:        
        push      NULL		
        push      offset bytes_write
        push      ecx
        push      esi	
        push      fhandle_txt		
        call      WriteFile
        ret  

End     Main      ; End of Aimhol code! ;(