// BinaryTree.h: interface for the CBinaryTree class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BINARYTREE_H__4E140191_3CD1_4A65_ACC0_6A6BBACE25A2__INCLUDED_)
#define AFX_BINARYTREE_H__4E140191_3CD1_4A65_ACC0_6A6BBACE25A2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CBinaryTree  
{
public:
	void setThreadSafety(BOOL bSafety);
	void deleteNode(int iID);
	CBinaryTree* getNode(int iID);
	CBinaryTree* newNode(int iID);
	void* getData();
	void setData(void* vData);
	CBinaryTree();
	virtual ~CBinaryTree();

private:
	BOOL m_ThreadSafe;
	BOOL isLockedWrite();
	void LockWrite();
	void UnlockWrite();
	BOOL m_LockedWrite;
	BOOL isLocked();
	void Unlock();
	void Lock();
	BOOL m_Locked;
	int getID();
	void setID(int iID);
	int m_ID;
	void* m_Data;
	CBinaryTree* m_Right;
	CBinaryTree* m_Left;
};

#endif // !defined(AFX_BINARYTREE_H__4E140191_3CD1_4A65_ACC0_6A6BBACE25A2__INCLUDED_)
