// ICMPSocket.cpp: implementation of the CICMPSocket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ICMPSocket.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CICMPSocket::CICMPSocket() : CSpoofSocket()
{
}

CICMPSocket::~CICMPSocket()
{
	CSpoofSocket::~CSpoofSocket();
}

BOOL CICMPSocket::Create()
{
	SetProtocol(IPPROTO_ICMP);

	//Create the socket
	BOOL bResult;
	bResult=CSpoofSocket::Create(IPPROTO_ICMP);

	if (bResult)
		//Set async
		return SetAsync();
	else
		return FALSE;
}

BOOL CICMPSocket::SendUnreachable(LPCTSTR lpDestinationAddress,unsigned char cType)
{
	return Send(lpDestinationAddress,ICMP_Unreachable,cType);
}

LPICMPHeader CICMPSocket::ConstructICMP()
{
	//Constructs a basic ICMP header
	LPICMPHeader lpHead;
	lpHead=new ICMPHeader;

	//Set all as zeros
	memset(lpHead,0,ICMPHeaderLength);

	//Set the timestamp
	lpHead->ICMP_Originate_Timestamp=GetTickCount();

	//Return it
	return lpHead;
}

BOOL CICMPSocket::SendTime(LPCTSTR lpDestinationAddress, unsigned char cType)
{
	return Send(lpDestinationAddress,ICMP_Time,cType);
}

BOOL CICMPSocket::Send(LPCTSTR lpDestinationAddress, unsigned char cICMP, unsigned char cType)
{
	//Generic ICMP send
	LPICMPHeader lpHead;
	lpHead=ConstructICMP();

	lpHead->ICMPType=cICMP;
	lpHead->ICMPCode=cType;

	//And the checksum
	lpHead->ICMPChecksum=CalculateChecksum((unsigned short*)lpHead,ICMPHeaderLength);

	//Send it
	BOOL bSend;
	bSend=CSpoofSocket::Send(lpDestinationAddress,(char*)lpHead,ICMPHeaderLength);

	//Clear up
	delete lpHead;

	return bSend;
}

BOOL CICMPSocket::SendParameter(LPCTSTR lpDestinationAddress, unsigned char cError)
{
	LPICMPHeader lpHead;
	lpHead=ConstructICMP();

	lpHead->ICMPType=ICMP_Parameter;
	lpHead->ICMPCode=ICMP_Parameter_ERROR;
	lpHead->sICMP.sUC.uc1=cError;

	//And the checksum
	lpHead->ICMPChecksum=CalculateChecksum((unsigned short*)lpHead,ICMPHeaderLength);

	//Send it
	BOOL bSend;
	bSend=CSpoofSocket::Send(lpDestinationAddress,(char*)lpHead,ICMPHeaderLength);

	//Clear up
	delete lpHead;

	return bSend;
}

BOOL CICMPSocket::SendQuench(LPCTSTR lpDestinationAddress)
{
	return Send(lpDestinationAddress,ICMP_Quench,0);
}

BOOL CICMPSocket::SendRedirect(LPCTSTR lpDestinationAddress, unsigned char cType, LPCTSTR lpGatewayAddress)
{
	LPICMPHeader lpHead;
	lpHead=ConstructICMP();

	lpHead->ICMPType=ICMP_Redirect;
	lpHead->ICMPCode=cType;
	lpHead->sICMP.sUL=inet_addr(lpGatewayAddress);

	//And the checksum
	lpHead->ICMPChecksum=CalculateChecksum((unsigned short*)lpHead,ICMPHeaderLength);

	//Send it
	BOOL bSend;
	bSend=CSpoofSocket::Send(lpDestinationAddress,(char*)lpHead,ICMPHeaderLength);

	//Clear up
	delete lpHead;

	return bSend;
}

BOOL CICMPSocket::SendEcho(LPCTSTR lpDestinationAddress, BOOL bReply, unsigned short usIdentifier, unsigned short usSequence, unsigned long ulData)
{
	LPICMPHeader lpHead;
	lpHead=ConstructICMP();

	//Check if echo or reply
	if (bReply)
		lpHead->ICMPType=ICMP_Echo_Reply;
	else
		lpHead->ICMPType=ICMP_Echo;

	lpHead->ICMPCode=0;
	lpHead->sICMP.sUS.us1=htons(usIdentifier);
	lpHead->sICMP.sUS.us2=htons(usSequence);
	lpHead->ICMP_Originate_Timestamp=htonl(ulData);

	//And the checksum
	lpHead->ICMPChecksum=CalculateChecksum((unsigned short*)lpHead,ICMPHeaderLength);

	//Send it
	BOOL bSend;
	bSend=CSpoofSocket::Send(lpDestinationAddress,(char*)lpHead,ICMPHeaderLength);

	//Clear up
	delete lpHead;

	return bSend;
}

BOOL CICMPSocket::SendTimestamp(LPCTSTR lpDestinationAddress, BOOL bReply, unsigned short usIdentifier, unsigned short usSequence, unsigned long ulOriginateTimestamp, unsigned long ulReceiveTimestamp, unsigned long ulTransmitTimestamp)
{
	LPICMPHeader lpHead;
	lpHead=ConstructICMP();

	//Check if echo or reply
	if (bReply)
		lpHead->ICMPType=ICMP_Timestamp_Reply;
	else
		lpHead->ICMPType=ICMP_Timestamp;

	lpHead->ICMPCode=0;
	lpHead->sICMP.sUS.us1=htons(usIdentifier);
	lpHead->sICMP.sUS.us2=htons(usSequence);
	lpHead->ICMP_Originate_Timestamp=htonl(ulOriginateTimestamp);
	lpHead->ICMP_Receive_Timestamp=htonl(ulReceiveTimestamp);
	lpHead->ICMP_Transmit_Timestamp=htonl(ulTransmitTimestamp);

	//And the checksum
	lpHead->ICMPChecksum=CalculateChecksum((unsigned short*)lpHead,ICMPHeaderLength);

	//Send it
	BOOL bSend;
	bSend=CSpoofSocket::Send(lpDestinationAddress,(char*)lpHead,ICMPHeaderLength);

	//Clear up
	delete lpHead;

	return bSend;
}

BOOL CICMPSocket::SendInformation(LPCTSTR lpDestinationAddress, BOOL bReply, unsigned short usIdentifier, unsigned short usSequence)
{
	LPICMPHeader lpHead;
	lpHead=ConstructICMP();

	//Check if echo or reply
	if (bReply)
		lpHead->ICMPType=ICMP_Information_Reply;
	else
		lpHead->ICMPType=ICMP_Information;

	lpHead->ICMPCode=0;
	lpHead->sICMP.sUS.us1=htons(usIdentifier);
	lpHead->sICMP.sUS.us2=htons(usSequence);
	
	//And the checksum
	//Using only first 8 bytes
	lpHead->ICMPChecksum=CalculateChecksum((unsigned short*)lpHead,ICMP_Information_SIZE);

	//Send it
	BOOL bSend;
	bSend=CSpoofSocket::Send(lpDestinationAddress,(char*)lpHead,ICMP_Information_SIZE);

	//Clear up
	delete lpHead;

	return bSend;
}

BOOL CICMPSocket::SetAsync()
{
	//Set event to read / write / close / oob
	int iResult;

	iResult=WSAAsyncSelect(getHandle(),getWindowHandle(),WM_SOCKET_GENERAL,FD_WRITE | FD_READ);
	if (iResult)
	{
		SetLastError();
		return FALSE;
	}
	
	return TRUE;
}

BOOL CICMPSocket::OnSocketReceive(int iErrorCode)
{
	//Here we receive the data
	if (!iErrorCode)
	{
		//Buffer
		char* buf;
		buf=new char[ICMP_BUF];

		//Read the data
		int iRead;
		iRead=Receive(buf,ICMP_BUF);

		BOOL bResult=FALSE;

		//Only if not an error
		if (iRead!=SOCKET_ERROR)
			bResult=ProccessICMP(buf);
		
		//Clean up
		delete [] buf;
		return bResult;
	}
	else
		return FALSE;
}

BOOL CICMPSocket::ProccessICMP(char* buf)
{
	//Here we proccess the input we received
	//Create an IP header
	LPIpHeader lpHead;
	lpHead=&m_IPHeader;

	//Copy to buffer
	memcpy(lpHead,buf,IpHeaderLength);

	//Let's check for options
	unsigned char ucHeaderSize;
	ucHeaderSize=lpHead->HeaderLength_Version & 15;
	ucHeaderSize*=4;

	//Now check for total packet size
	unsigned short ucPacketSize;
	ucPacketSize=htons(lpHead->TotalLength);

	//Copy data to icmp
	memset(&m_ICMPHeader,0,ICMPHeaderLength);

	//How much to copy ?
	unsigned short ucCopy;
	ucCopy=ucPacketSize-ucHeaderSize;
	
	//Save the datasize
	m_DataSize=ucCopy;

	if (ucCopy>ICMPHeaderLength)
		ucCopy=ICMPHeaderLength;

	memcpy(&m_ICMPHeader,buf+ucHeaderSize,ucCopy);

	//Now I need to reverse the header
	ReverseHeader();

	return TRUE;
}

const LPICMPHeader CICMPSocket::GetLastICMPHeader()
{
	//Return the last header proccessed
	return &m_ICMPHeader;
}

const LPIpHeader CICMPSocket::GetLastIPHeader()
{
	return &m_IPHeader;
}

unsigned long CICMPSocket::GetLastDataSize()
{
	return m_DataSize;
}

void CICMPSocket::ReverseHeader()
{
	//Reverse timestamps
	if (m_ICMPHeader.ICMPType==ICMP_Timestamp || m_ICMPHeader.ICMPType==ICMP_Timestamp_Reply)
	{
		m_ICMPHeader.ICMP_Originate_Timestamp=htonl(m_ICMPHeader.ICMP_Originate_Timestamp);
		m_ICMPHeader.ICMP_Receive_Timestamp=htonl(m_ICMPHeader.ICMP_Receive_Timestamp);
		m_ICMPHeader.ICMP_Transmit_Timestamp=htonl(m_ICMPHeader.ICMP_Transmit_Timestamp);
	}


	//Reverse ID and Sequence
	if (m_ICMPHeader.ICMPType==ICMP_Echo || m_ICMPHeader.ICMPType==ICMP_Echo_Reply)
	{
		m_ICMPHeader.sICMP.sUS.us1=htons(m_ICMPHeader.sICMP.sUS.us1);
		m_ICMPHeader.sICMP.sUS.us2=htons(m_ICMPHeader.sICMP.sUS.us2);
	}
}
