/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#if !defined(AFX_SPOOFSOCKET_H__5BAEA068_961A_4652_8BBD_90B78F6FBB09__INCLUDED_)
#define AFX_SPOOFSOCKET_H__5BAEA068_961A_4652_8BBD_90B78F6FBB09__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SpoofSocket.h : header file
//

#include <winsock2.h>
#include <ws2tcpip.h>

/////////////////////////////////////////////////////////////////////////////
// CSpoofSocket command target
//////////////////////////////////////////////////////////////////
//																//
//							IP Header							//
//				Implementation of RFC791 IP Header				//
//																//
//////////////////////////////////////////////////////////////////

typedef struct _PseudoHeader
{
	unsigned int	SourceAddress;
	unsigned int	DestinationAddress;
	unsigned char	Zeros;
	unsigned char	PTCL;
	unsigned short	Length;
} PseudoHeader;

typedef PseudoHeader FAR * LPPseudoHeader;

#define PseudoHeaderLength sizeof(PseudoHeader)

#define tOptionType unsigned char

typedef struct _IPOption
{
	tOptionType		OptionType;
	unsigned char	OptionLength;
	unsigned char	OptionData;
} IPOption;

//IP Options flags (1bit)
#define IPOption_COPY 128
#define IPOption_DONT_COPY 0

//IP Options class (2 bits)
#define IPOption_CONTROL 0
#define IPOption_RESERVED 2
#define IPOption_DEBUGGING 64
#define IPOption_RESERVED2 6

//IP options type
#define IPOption_END_OPTION 0 //End of option list
#define IPOption_NO_OPERATION 1 //Do nothing
#define IPOption_SECURITY 2 //Security information
#define IPOption_LOOSE_ROUTING 3 //Loose routing options
#define IPOption_STRICT_ROUTING 9 //Strict source routing
#define IPOption_RECORD_ROUTE 7 //Record route on datagram
#define IPOption_STREAM 8 //Used to carry stream identifier
#define IPOption_TIMESTAMP 4 //Internet timestamp

//IP options extensions - Security
#define IPOption_SECURITY_LENGTH 11

#define IPOption_SECURITY_UNCLASSIFIED 0
#define IPOption_SECURITY_CONFIDENTIAL 0x1111000100110101b
#define IPOption_SECURITY_EFTO 0x0111100010011010b
#define IPOption_SECURITY_MMMM 0x1011110001001101b
#define IPOption_SECURITY_PROG 0x0101111000100110b
#define IPOption_SECURITY_RESTRICTED 0x1010111100010011b
#define IPOption_SECURITY_SECRET 0x1101011110001000b
#define IPOption_SECURITY_TOPSECRET 0x0110101111000101b
#define IPOption_SECURITY_RESERVED1 0x0011010111100010b
#define IPOption_SECURITY_RESERVED2 0x1001101011110001b 
#define IPOption_SECURITY_RESERVED3 0x0100110101111000b
#define IPOption_SECURITY_RESERVED4 0x0010010010111101b
#define IPOption_SECURITY_RESERVED5 0x0001001101011110b
#define IPOption_SECURITY_RESERVED6 0x1000100110101111b
#define IPOption_SECURITY_RESERVED7 0x1100010011010110b
#define IPOption_SECURITY_RESERVED8 0x1110001001101011b


//IP options extensions - Stream ID
#define IPOption_STREAM_LENGTH 4

//IP options extensions - Strict routing
#define IPOption_STRICT_ROUTING_LENGTH 3
#define IPOption_STRICT_ROUTING_POINTER 4

//IP options extensions - Time Stamp
#define IPOption_TIMESTAMP_LENGTH 5

#define IPOption_TIMESTAMP_ONLY 0
#define IPOption_TIMESTAMP_EACH 1
#define IPOption_TIMESTAMP_PRE 2

#define IPOption_TIMESTAMP_SIZE 8


typedef struct _IpHeader 
{
	unsigned char		HeaderLength_Version;
	unsigned char		TypeOfService;		// Type of service
	unsigned short		TotalLength;		// total length of the packet
	unsigned short		Identification;		// unique identifier
	unsigned short		FragmentationFlags; // flags
	unsigned char		TTL;				// Time To Live
	unsigned char		Protocol;           // protocol (TCP, UDP etc)
	unsigned short		CheckSum;			// IP Header checksum

	unsigned int		sourceIPAddress;	// Source address
	unsigned int		destIPAddress;		// Destination Address

} IpHeader;

typedef IpHeader FAR * LPIpHeader;

#define IpHeaderLength sizeof(IpHeader)

//Some IP constants
//Version
#define IpVersion 4

//Service types
#define IpService_NETWORK_CONTROL 111
#define IpService_INTERNETWORK_CONTROL 110
#define IpService_CRITIC_ECP 101
#define IpService_FLASH_OVERIDE 100
#define IpService_FLASH 011
#define IpService_IMMEDIATE 010
#define IpService_PRIORITY 001
#define IpService_ROUTINE 0

//Fragmetation flag
#define IpFragFlag_MAY_FRAG 0x0000
#define IpFragFlag_MORE_FRAG 0x2000
#define IpFragFlag_LAST_FRAG 0x5000
#define IpFragFlag_DONT_FRAG 0x4000
 
//Internet protocols
#define IpProtocol_ICMP 1
#define IpProtocol_TCP 6
#define IpProtocol_UDP 17

#define IP_DEF_TTL 128

#define IPOption_WRAPSIZE 4
#define IPOption_SIZE 40

#define IPOption_MAX_ROUTES 10

typedef struct _Routing
{
	int iRoutes;
	unsigned long ulRoutes[IPOption_MAX_ROUTES];
} tRouting;

class CBinaryTree;

class CIPOptions
{	
public:
	CIPOptions();
	virtual ~CIPOptions();
private:
	BOOL m_AutoPAD;
	int m_BufferLength;
	char* m_Buffer;
protected:
	void AddOption_Route(tOptionType tRouteType,tRouting tRoute);
	void AddToBuffer(char* buf,int BufLength);
	tOptionType GetOption(unsigned char CopyFlag,unsigned char ClassFlag,unsigned char TypeFlag);
public:
	void AddOption_Timestamp(tOptionType tFlags,int iMaxStamps);
	void AddOption_LooseRoute(tRouting tRoute);
	void AddOption_RecordRoute(int iMaxRoutes);
	void AddOption_StrictRoute(tRouting tRoute);
	void AddOption_Stream(unsigned short usStreamID);
	virtual void AddOption_Security(unsigned short usType);
	void Reset();
	void SetAutoPad(BOOL bAutoPAD);
	virtual void AddOption_ENDLIST();
	int GetBufferLength();
	const char* GetBuffer();
	virtual void AddOption_Nothing();
};

//Message handlers
#define WM_BASE				WM_USER
#define WM_SOCKET_GENERAL	WM_BASE+1
#define WM_SOCKET_ACCEPT	WM_BASE+2
#define WM_SOCKET_CONNECT	WM_BASE+3
#define WM_SOCKET_TIMEOUT	WM_BASE+4

//Window class name
#define CSpoofSocket_Class "CSpoofSocketClass"

class CSpoofSocket 
{
// Attributes
public:

// Operations
public:
	CSpoofSocket();
	virtual ~CSpoofSocket();

// Overrides
public:
	void SetBlocking(BOOL bBlock);
	BOOL ValidAddress(LPCTSTR lpAddress);
	BOOL KillTimer();
	BOOL SetTimeout(int iMs);
	char FAR * LongToString(long lAddr);
	virtual int Receive(char* buf,int bufLen);
	void SetInstance(HINSTANCE hInst);
	int GetSocketID();
	CIPOptions* GetOptions();
	void SetOptions(BOOL bOptions);
	void SetRaw(BOOL bRaw);
	BOOL ShutdownSockets();
	BOOL Listen(int iBackLog);
	void SetTTL(unsigned char ucTTL);
	unsigned short CalculatePseudoChecksum(char *buf, int BufLength,LPCSTR lpDestinationAddress,int iPacketLength);
	void SetSourceAddress(LPCSTR lpSourceAddress);
	BOOL InitializeSockets();
	BOOL Close();
	virtual BOOL Bind(LPCSTR lpSourceAddress,int iPort=0);
	int GetLastError();
	virtual BOOL Send(LPCSTR lpDestinationAddress,char* buf,int bufLength);
	BOOL Create(int iProtocol);
protected:
	void AssignSocket(SOCKET sok);
	CSpoofSocket(SOCKET sok);
	HWND getWindowHandle();
	BOOL RemoveHandlers();
	BOOL isRaw();
	virtual BOOL OnSocketTimeout();
	virtual BOOL OnSocketConnect(int iErrorCode);
	virtual BOOL OnSocketAccept(int iErrorCode);
	virtual BOOL OnSocketClose(int iErrorCode);
	virtual BOOL OnSocketOOB(int iErrorCode);
	virtual BOOL OnSocketWrite(int iErrorCode);
	virtual BOOL OnSocketReceive(int iErrorCode);
	virtual HINSTANCE GetInstance();
	BOOL SetHandlers();
	LPCSTR m_SourceAddress;
	void SetProtocol(int iProtocol);
	BOOL CheckSocketValid();
	unsigned short CalculateChecksum(unsigned short* usBuf,int iSize);
	BOOL ValidSocket();
	void SetLastError();
	SOCKET getHandle();
	virtual void InitializeIP();
	virtual void SetIPHeaderAddress(LPIpHeader lpHead,LPCSTR lpSourceAddress,LPCSTR lpDestinationAddress);
	virtual LPIpHeader ConstructIPHeader (unsigned char  ucProtocol,
										  unsigned short usFragmentationFlags,
										  unsigned char  ucTTL,
										  unsigned short usIdentification,
										  unsigned char  ucHeaderLength);
private:
	BOOL m_Async;
	void RemoveSocketFromList();
	void AddSocketToList();
	HINSTANCE m_Instance;
	static BOOL m_Window;
	BOOL RegisterWindow();
	static CSpoofSocket* GetSocketByID(int iSockID);
	int m_SocketID;
	static HWND m_WindowHandle;
	CIPOptions* m_IPOptions;
	BOOL m_Options;
	BOOL m_Raw;
	unsigned char m_TTL;
	unsigned char m_Protocol;
	int m_LastError;
	SOCKET m_SpoofSocket;
	static CBinaryTree* m_SocketTree;

	friend LRESULT CALLBACK SocketMessageHandler(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SPOOFSOCKET_H__5BAEA068_961A_4652_8BBD_90B78F6FBB09__INCLUDED_)
