// TCPSocket.h: interface for the CTCPSocket class.
//
//////////////////////////////////////////////////////////////////////
/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#if !defined(AFX_TCPSOCKET_H__77DA7F21_291E_4C2A_B12B_535ABA1E829C__INCLUDED_)
#define AFX_TCPSOCKET_H__77DA7F21_291E_4C2A_B12B_535ABA1E829C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SpoofSocket.h"

/////////////////////////////////////////////////////////////////////////////
// CSpoofSocket command target
//////////////////////////////////////////////////////////////////
//																//
//							TCP Header							//
//				Implementation of RFC793 TCP Header				//
//																//
//////////////////////////////////////////////////////////////////

typedef struct _TCPHeader
{
	//TCPPseudoHeader	PseudoHeader;
	unsigned short	SourcePort;
	unsigned short	DestinationPort;
	unsigned int	SequenceNumber;
	unsigned int	AcknowledgeNumber;
	//unsigned int	DataOffset:4;
	//unsigned int	Reserved:6;				//Must be zeros
	//unsigned int	ControlFlags:6;			//URG/ACK/SYN
	unsigned char	DataOffset;		//Crappy MFC can't use bits
	unsigned char	Flags;
	unsigned short	Windows;
	unsigned short	Checksum;
	unsigned short	UrgentPointer;
} TCPHeader;

typedef TCPHeader FAR * LPTCPHeader;

#define TCPHeaderLength sizeof(TCPHeader)

//All of the TRP header flags
#define TCPFlag_URG 0
#define TCPFlag_ACK 2
#define TCPFlag_PSH 4
#define TCPFlag_RST 8
#define TCPFlag_SYN 16
#define TCPFlag_FYN 32

//TCP Options
#define TCPOptions_END 0
#define TCPOptions_NO_OPERATION 1
#define TCPOptions_MAX_Segment 2

//Max segment size
#define TCPOptions_MAX_Segment_Length 4

class CTCPOptions : protected CIPOptions
{
public:
	void AddOption_SegmentSize(unsigned short usMax);
	CTCPOptions();
	virtual ~CTCPOptions();
	void Reset();
	void SetAutoPad(BOOL bAutoPAD);
	virtual void AddOption_ENDLIST();
	int GetBufferLength();
	const char* GetBuffer();
	virtual void AddOption_Nothing();
private:
};

class CTCPSocket : public CSpoofSocket
{
	//DECLARE_DYNCREATE(CTCPSocket)
public:
	long GetPeerAddress();
	BOOL Send(char* buf,char bufLen);
	BOOL Accept(CTCPSocket* tSok);
	CTCPSocket* Accept();
	BOOL Listen(int iBackLog);
	BOOL CreateRegular();
	CTCPOptions* GetTCPOptions();
	BOOL Connect(int iSourcePort,LPCSTR lpDestinationAddress,int iDestinationPort);
	BOOL Create();
	CTCPSocket();
	virtual ~CTCPSocket();
	void SetTCPOptions(BOOL bOptions);

private:
	sockaddr_in m_ConnectedTo;
	void InitializeTCP();
	CTCPSocket(SOCKET sok);
	BOOL SetAsync();
	CTCPOptions* m_TCPOptions;
	BOOL m_Options;
	void SetHeaderFlag(LPTCPHeader lpHead,int iFlag);
	static unsigned int m_Sequence;
	LPTCPHeader ConstructTCPHeader(int iSourcePort,int iDestinationPort,int iHeaderLength);
protected:
	virtual BOOL OnSocketConnect(int iErrorCode);
};

#endif // !defined(AFX_TCPSOCKET_H__77DA7F21_291E_4C2A_B12B_535ABA1E829C__INCLUDED_)
