// kping.cpp : Defines the entry point for the console application.
//
/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "PingSocket.h"
#include <windows.h>

void UsageErrorMessage(char* cProgramName)
{
	printf("Usage:\n");
	printf("%s <host>\n",cProgramName);
}

void HostErrorMessage(char* cHost)
{
	printf("Host:%s is invalid\n",cHost);
}

void GeneralErrorMessage(CPingSocket* icmp,char* cError)
{
	printf("%s\n",cError);

	icmp->Close();
	icmp->ShutdownSockets();

	delete icmp;
}

int main(int argc, char* argv[])
{
	//First check parameters
	if (argc<2)
	{
		UsageErrorMessage(argv[0]);
		return 1;
	}

	//Check address validity
	//Our IP address
	char IP[16]="";

	if (strlen(argv[1])>15)
	{
		HostErrorMessage(argv[1]);
		return 1;
	}

	memcpy(IP,argv[1],strlen(argv[1]));

	//Our socket
	CPingSocket* icmp;

	//Check validity
	if (!icmp->ValidAddress(IP))
	{
		HostErrorMessage(IP);
		return 1;
	}

	icmp=new CPingSocket;

	//Initalize data
	if (!icmp->InitializeSockets())
	{
		GeneralErrorMessage(icmp,"Sockets couldn't be initialized");
		return 1;
	}

	icmp->SetInstance(NULL);

	//Create and bind
	if (!icmp->Create())
	{
		GeneralErrorMessage(icmp,"Socket couldn't be created");
		return 1;
	}
	
	printf("Pinging:%s\n\n",IP);

	int iMaxCount=5;

	int iCount=iMaxCount;

	//If there is no message map, then receive won't work
	MSG msg;

	//Set the message map to zeros
	memset(&msg,0,sizeof(msg));

	while ((icmp->PingDone() || GetMessage(&msg, NULL, 0, 0)) && iCount) 
	{
		if (icmp->PingDone())
		{
			--iCount;

			//Ping
			icmp->Ping(IP);
		}
		
		//Only we had a message
		if (msg.hwnd)
		{
			//Dispatch the message
			TranslateMessage(&msg);
			DispatchMessage(&msg);

			//Again rezero
			memset(&msg,0,sizeof(msg));
		}
	}

	//Shutdown
	icmp->Close();
	icmp->ShutdownSockets();

	//Dispose
	delete icmp;

	return 0;
}
