/*
 *  Copyright (c) 2000-2003 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Contact info:
 * -------------
 *
 * Site:					http://www.komodia.com
 * Main contact:			barak@komodia.com
 * For custom projects, 
 * consulting, or other
 * paid services:			sales@komodia.com
 */

#include "stdafx.h"
#include "TCPRelayHTTP.h"

#include "ErrorHandlerMacros.h"

#ifdef _MEMORY_DEBUG 
	#define new	   DEBUG_NEW  
	#define malloc DEBUG_MALLOC  
    static char THIS_FILE[] = __FILE__;  
#endif

KOMODIA_NAMESPACE_START

#define CTCPRelayHTTP_Class "CTCPRelayHTTP"

CTCPRelayHTTP::CTCPRelayHTTP() : CTCPRelay()
{
	try
	{
		//Set our name
		SetName(CTCPRelayHTTP_Class);
	}
	ERROR_HANDLER("CTCPRelayHTTP")
}

CTCPRelayHTTP::~CTCPRelayHTTP()
{
}

BOOL CTCPRelayHTTP::Relay(const std::string& rBindAddress,
						  unsigned short usBindPort,
						  const std::string& rDestinationAddress,
						  unsigned short usDestinationPort)
{
	try
	{
		//Delegate
		return CTCPRelay::Relay(rBindAddress,
								usBindPort,
								rDestinationAddress,
								usDestinationPort);
	}
	ERROR_HANDLER_RETURN("Relay",FALSE)
}

BOOL CTCPRelayHTTP::Relay(IP aBindAddress,
						  unsigned short usBindPort,
						  IP aDestinationAddress,
						  unsigned short usDestinationPort)
{
	try
	{
		//Are we running
		if (IsRunning())
			return FALSE;

		//Save the addresses
		m_sBindAddress=CSocketBase::LongToStdString(aBindAddress);
		m_sTargetAddress=CSocketBase::LongToStdString(aDestinationAddress);

		//Delegate the call
		return CTCPRelay::Relay(aBindAddress,
								usBindPort,
								aDestinationAddress,
								usDestinationPort);
	}
	ERROR_HANDLER_RETURN("Relay",FALSE)
}

std::string CTCPRelayHTTP::ModifyReceiveString(BOOL bIncoming,
											   const char* pBuffer,
											   unsigned short usBufferSize)const
{
	try
	{
		//Only incoming
		if (!bIncoming)
			return "";

		//Convert to string
		std::string sData;
		sData=pBuffer;

		//Modify count
		int iModifyCount;
		iModifyCount=0;

		//Start to modify it
		while (ReplaceString(sData))
			++iModifyCount;

		//Did we modify it
		if (iModifyCount)
			return sData;
		else
			return "";
	}
	ERROR_HANDLER_RETURN("ModifyReceiveString","")
}

BOOL CTCPRelayHTTP::ReplaceString(std::string& rString)const
{
	try
	{
		//Find the string
		std::string::size_type aPos;
		aPos=rString.find(m_sBindAddress,
						  0);

		//Do we have it
		if (aPos!=std::string::npos)
		{
			std::string sNewString;
			sNewString.reserve(rString.size()+30);

			//Take the part before the host
			sNewString=rString.substr(0,
									  aPos);

			//Add the new address
			sNewString+=m_sTargetAddress;

			//Add what's left
			sNewString+=rString.substr(aPos+
									   m_sBindAddress.length(),
									   rString.length()-
									   aPos-
									   m_sBindAddress.length());

			//Give it to our string
			rString.swap(sNewString);

			//Done
			return TRUE;
		}
		else
			return FALSE;
	}
	ERROR_HANDLER_RETURN("ReplaceString",FALSE)
}

KOMODIA_NAMESPACE_END
