/*
 *  Copyright (c) 2000-2003 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Contact info:
 * -------------
 *
 * Site:					http://www.komodia.com
 * Main contact:			barak@komodia.com
 * For custom projects, 
 * consulting, or other
 * paid services:			sales@komodia.com
 */

#if !defined(AFX_UDPRELAY_H__364B884F_8339_4C12_B294_2783EB7ADF79__INCLUDED_)
#define AFX_UDPRELAY_H__364B884F_8339_4C12_B294_2783EB7ADF79__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Relay.h"

#include "UDPSocketAsync.h"

KOMODIA_NAMESPACE_START

class CGenericCriticalSection;

class CUDPRelay : public CRelay  
{
public:
	//Start the relay
	virtual BOOL Relay(const std::string& rBindAddress,
					   unsigned short usBindPort,
					   const std::string& rDestinationAddress,
					   unsigned short usDestinationPort);
	virtual BOOL Relay(IP aBindAddress,
					   unsigned short usBindPort,
					   IP aDestinationAddress,
					   unsigned short usDestinationPort);

	//Stop the relay
	virtual BOOL Stop();

	//Ctor and Dtor
	CUDPRelay();
	virtual ~CUDPRelay();
private:
	//Our listen socket
	class CListenSocket : public CUDPSocketAsync
	{
	public:
		//Ctor and Dtor
		CListenSocket(CUDPRelay* pFather);
		virtual ~CListenSocket();
	protected:
		//When socket has data in queue
		virtual BOOL OnSocketReceive(int iErrorCode);

		//No events
		NO_OnSocketOOB
		NO_OnSocketWrite
		NO_OnSocketTimeout
		NO_OnSocketConnect
		NO_OnSocketClose
		NO_OnSocketAccept
	private:
		//Our father
		CUDPRelay* m_pFather;
	};

	friend CListenSocket;
private:
	//Our client socket
	class CClientSocket : public CUDPSocketAsync
	{
	public:
		//Send data
		int SendData(const char* pBuffer,
					 unsigned long ulBufferSize);

		//Ctor and Dtor
		CClientSocket(CUDPRelay* pFather,
					  IP aSourceAddress,
					  unsigned short usSourcePort);
		virtual ~CClientSocket();
	protected:
		//When socket has data in queue
		virtual BOOL OnSocketReceive(int iErrorCode);

		//When a timeout occured (implemented at library level)
		//User should return 0, if proccessed the message
		virtual BOOL OnSocketTimeout();

		//No events
		NO_OnSocketOOB
		NO_OnSocketWrite
		NO_OnSocketConnect
		NO_OnSocketClose
		NO_OnSocketAccept
	private:
		//Our father
		CUDPRelay* m_pFather;

		//Source address
		IP m_aSourceAddress;

		//Source port
		unsigned short m_usSourcePort;

		//Our custome source port
		unsigned short m_usLocalPort;
	};

	friend CClientSocket;
private:
	//Our struct we use to ID an incoming connection
	typedef struct _ConnectionData
	{
		IP				aSourceIP;
		unsigned short	usSourcePort;

		//Compare operator
		bool operator<(const _ConnectionData& rData)const
		{
			if (aSourceIP==rData.aSourceIP)
				return usSourcePort<rData.usSourcePort;
			else
				return aSourceIP<rData.aSourceIP;
		}
	} ConnectionData;

	//Our map of connections
	typedef std::map<ConnectionData,CClientSocket*> SocketMap;
private:
	//No copy Ctor
	CUDPRelay(const CUDPRelay& rRelay);

	//No copy operator
	CUDPRelay& operator=(const CUDPRelay& rRelay);

	//Get target
	IP GetTarget()const;

	//Get target port
	unsigned short GetTargetPort()const;

	//Get the bind port
	unsigned short GetBindPort()const;

	//Send data
	void SendData(const char* pBuffer,
				  unsigned long ulBufferSize,
				  IP aDestinationIP,
				  unsigned short usDestinationPort);

	//Allocate a local port
	unsigned short AllocateLocalPort()const;

	//Create a socket
	CClientSocket* CreateSocket(IP aSourceAddress,
							    unsigned short usSourcePort);

	//Remove a socket
	void RemoveSocket(IP aSourceAddress,
					  unsigned short usSourcePort);

	//Our listening socket
	CListenSocket* m_pSocket;

	//Our CS
	CGenericCriticalSection* m_pCSection;

	//Our CS for port allocation
	CGenericCriticalSection* m_pCSectionPorts;

	//Are we created
	BOOL m_bCreated;

	//Our destination address
	IP m_aTarget;

	//Our target port
	unsigned short m_usTargetPort;

	//Our bind port
	unsigned short m_usBindPort;

	//Our socket map
	SocketMap m_aSocketMap;

	//Current local port
	mutable unsigned short m_usLocalPort;
};

KOMODIA_NAMESPACE_END

#endif // !defined(AFX_UDPRELAY_H__364B884F_8339_4C12_B294_2783EB7ADF79__INCLUDED_)
