/*
* WinfingerPrint 2 Development Code
* Copyright (C) 1999-2000 Kirby Kuehl (vacuum@technotronic.com)
* 
* Contributors:
* vacuum@technotronic.com
* Mike@eEye.com
* hoglund@ieway.com
* napster@napster.com
* Jason_Jordan@omron.com
* sfaust@hartco.com
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 1, or (at your option)
*  any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*/




#ifndef UNICODE
#define UNICODE
#endif
#include <stdio.h>
#include <windows.h>
#include <lm.h>
#include <stdlib.h>
#include <memory.h>
#include <direct.h>
#include <assert.h>
#include <string>

/* Now we link the following libs automatically
   this should stop the "It won't compile for me 
   emails :)
 */
#pragma comment( lib, "netapi32" )
#pragma comment( lib, "mpr" )
#pragma comment( lib, "advapi32" )
#pragma comment( lib, "shell32" )

using  namespace std;


int diskenum(LPWSTR);
int diskenum95(LPWSTR);
int querygroup(LPTSTR);
int queryuser(LPTSTR);
int queryservices(LPTSTR);
int NullSession(LPTSTR);
int NullDisconnect(LPTSTR);
int RegConnection(LPTSTR);
int winfingerprint(LPTSTR);
int querytransport(LPTSTR);
int querytime(LPTSTR);
void getnetwork(LPNETRESOURCE, char *);
void UnicodeToASCII(wchar_t *, char *);
void DisplayUsage (char *);
void options_launcher(int ,LPTSTR);
wstring ErrorHandle();


#define SZ_ENUM_BUF 4096
#define VERSION "Winfingerprint 2.26"

FILE *stream, *menu;

// I DECIDED TO PUT THE OPTIONS VAR GLOBALY 

/*********************************************
	The options will be split in the bits position
	Bits : 0 -> optdiskenum
		   1 -> optquerygroup
		   2 -> optqueryuser
		   3 -> optqueryservices
		   4 -> optnull
		   5 -> optservername
		   6 -> optreg
		   7 -> optmass
  
  -> Since the output option is not very related
     with the scanning methods and it is not use
     globally, we take it apart.

**********************************************/

union{
	int value;
	struct{
		unsigned int optdiskenum		: 1;
		unsigned int optquerygroup		: 1;
		unsigned int optqueryuser		: 1;
		unsigned int optqueryservices	: 1;
		unsigned int optnull			: 1;
		unsigned int optservername		: 1;
		unsigned int optreg				: 1;
		unsigned int optmass			: 1;
	}bits;
}options;



int wmain(int argc, wchar_t *argv[], char *newargv[]){

	LPTSTR pszServerName = NULL;
	LPNETRESOURCE cont_obj = NULL; // This is used when optmass is set
	char *filename;
	char opt;
	int output = 0;
	int i, j;
    FILE *frame;
	char buffer[_MAX_PATH];
    char cmd[_MAX_PATH];



	//initiate the options
	options.value = 0;

	// Fill another argv[] but we use this for getopt()
	for(j = 0; j < argc; j++){
		UnicodeToASCII(argv[j], newargv[j]);


	}

	if (argc <= 1)
		DisplayUsage(newargv[0]);
                                                                                                                                                                                                           
	for(i = 1; i < argc; i++){
		if((strncmp(newargv[i], "-", 1) == 0) || (strncmp(newargv[i], "/", 1) == 0)){


			newargv[i] += 1;
			opt = (char)newargv[i][0];


			switch(toupper(opt)){

				case 'D': // Enumerate NetBIOS Shares.
					options.value |= 0x01;  //00000001
					break;
				case 'G': // Enumerate Groups.
					options.value |= 0x02;  //00000010
					break;
				case 'U': // Enumerate Users.
					options.value |= 0x04;  //00000100
					break;
				case 'S': // Enumerate Services.
					options.value |= 0x08;  //00001000
					break;
				case 'N':  // Creates Null Session
					options.value |= 0x10;  //00010000
					break;
				case 'T': // Computer name is here.
					if(argv[i + 1] != NULL)
					pszServerName = argv[i + 1];
					options.value |= 0x20;   //00100000
					break;
				case 'R':  // Registry Manipulation
					options.value |= 0x40;   //01000000
					break;
				case 'M':  // 'Network Neighborhood' Scan
					options.value |= 0x80;   //10000000
					break;
				case 'A': // We do all.
					options.value |= 0x4F; //01001111
					break;
				case 'O':  // HTML Output filename
					output = 1;
					filename = newargv[i +1];
					break;
				case 'H': // Show usage.
					DisplayUsage(newargv[0]);
					break;
				case '?': // Show usage.
					DisplayUsage(newargv[0]);
					break;
				default: // We do all.
					DisplayUsage(newargv[0]);
			}
		}
	}
	

	printf("%s by vacuum@technotronic.com & Mike@eEye.com 1999-2000\n", VERSION);

	if((!options.bits.optmass) && (!options.bits.optservername)){
		fprintf(stderr, "You must specify a 'Network Neighboorhood' scan <-m> or Computername. <-t \\\\computername>\n");
		exit(1);
	}
	
	if((options.bits.optmass) && (options.bits.optservername)){
		fprintf(stderr, "You specified a 'Network Neighboorhood' scan and a Computername.\nPlease choose one or the other.\n");
		exit(1);
	}

	if(options.bits.optnull && !options.bits.optmass && !options.bits.optservername){
		fprintf(stderr, "You specified a 'Null Session' scan and did not choose a mass scan or a Servername.\nPlease choose one and try again.\n");
		exit(1);
	}


	if(!output)
		filename = "winfingerprint.html";

	if( (stream = fopen(filename, "w" )) == NULL ){
		fprintf(stderr, "The file '%s' was not opened\n",filename);
		exit(-1);
	}
		fprintf(stream, "<html>\n<head>\n<title>%s output</title>\n</head>\n", VERSION);
		fprintf(stream, "<BODY BGCOLOR = \"#FFFFFF\">\n<font size = \"-1\" face=\"Verdana,Arial\">\n");
		fprintf(stream, "<CENTER><a href=\"http://www.technotronic.com/winfingerprint/\"><IMG border=0 alt=\"%s\"SRC = \"winfingerprint.jpg\"></a><BR>\n", VERSION);
		fprintf(stream, "by <A HREF = \"mailto:vacuum@technotronic.com\">vacuum@technotronic.com</A>\n");
		fprintf(stream, "<a href=\"aboutwinfingerprint.html\">About %s</a><BR>\n", VERSION);
		
	
	if( (menu = fopen("menu.html", "w" )) == NULL ){
		fprintf(stderr, "The file 'menu.html' was not opened\n");
		exit(-1);
		}
		fprintf(menu,"<html>\n<head>\n<title>Winfingerprint Menu</title>\n</head>\n<body>\n");
        fclose(menu);
	if( (frame = fopen("frame.html", "w" )) == NULL ){
		fprintf(stderr, "The file 'frame.html' was not opened\n");
		exit(-1);
		}
    	fprintf(frame, "<html>\n<head>\n<title>Winfingerprint</title>\n</head>\n");
		fprintf(frame, "<frameset framespacing=\"0\" border=\"false\" frameborder=\"0\" cols=\"145,*\">\n");
		fprintf(frame, "<frame src=\"menu.html\" name=\"menu\">\n");
		fprintf(frame, "<frame src=\"%s\" name=\"main\">\n",filename);
		fprintf(frame, "</frameset>\n</html>\n");
		fclose(frame);

		fprintf(stdout, "Enumerating Available Servers, Please wait ...\n");

	
	if(options.bits.optmass){
		
		
		// we need to pass a NULL one at first and then collect the servernames
		
		getnetwork(cont_obj, filename);
	}
	else{    
		if( (menu = fopen("menu.html", "w" )) == NULL ){
		fprintf(stderr, "The file 'menu.html' was not opened\n");
		exit(-1);
		}
		fprintf(menu,"<font size = \"-1\" face=\"Verdana,Arial\">%S<br>\n", pszServerName + 2);
		fprintf(menu,"<ul><li><a href=\"%s#%S-diskenum\" target=main>Shares</a>\n",filename, pszServerName + 2);
		fprintf(menu,"<li><a href=\"%s#%S-group\" target=main>Groups</a>\n",filename, pszServerName + 2);
		fprintf(menu,"<li><a href=\"%s#%S-user\" target=main>Users</a>\n",filename, pszServerName + 2);
		fprintf(menu,"<li><a href=\"%s#%S-services\" target=main>Services</a>\n",filename, pszServerName + 2);
		fprintf(menu,"<li><a href=\"%s#%S-registry\" target=main>Registry</a></ul></font>\n",filename, pszServerName + 2);
		options_launcher(winfingerprint(pszServerName), pszServerName);
		}

	fprintf(stdout,"\nDone.\n\n");
	fprintf(stream,"</CENTER></BODY>\n</HTML>\n");
	fclose(stream);
	fclose(menu);
	
	if( _getcwd( buffer, _MAX_PATH ) == NULL )
      fprintf(stderr, "_getcwd error\n");
    else{
    strcat(buffer, "\\frame.html");
    fprintf(stderr, "Launching explorer\n");
   
	_snprintf(cmd, sizeof(cmd), "file://%s",buffer);
	ShellExecuteA(NULL, "open", cmd, NULL, NULL, SW_SHOWNORMAL);
	}

	return 0;
}

int diskenum(LPWSTR computername){

	PSHARE_INFO_502 BufPtr,p;
	NET_API_STATUS res;
	DWORD i;
	DWORD entriesread=0, resume_handle=0, totalentries=0;


	fprintf(stream,"<p>NetBIOS Share Results:<BR><TABLE BORDER=1 WIDTH =\"600\"\n");
	if(computername == NULL)
		fprintf(stream, "<TR><TD><B>Shares:</B></TD><TD><B>Local Path:</B></TD><TD><B>Uses:</B></TD><TD><B>Descriptor:</B></TD></TR>\n");
	else
	{
		fprintf(stream, "<a name=\"%S-diskenum\">\n",computername + 2); 
		fprintf(stream, "<TR><TD><B>%S's Shares:</B></TD><TD><B>Local Path:</B></TD><TD><B>Uses:</B></TD><TD><B>Descriptor:</B></TD></TR>\n", computername + 2);
	}
	do{
		res = NetShareEnum(computername,
							 502, 
							 (LPBYTE *) &BufPtr,
							 0xFFFFFFFF,
							 &entriesread,
							 &totalentries,
							 &resume_handle);

		if(res == ERROR_SUCCESS || res == ERROR_MORE_DATA){
			p=BufPtr;

			for(i=1;i<=entriesread;i++){
				// fprintf(stream,"<TR><TD><%-20S</TD><TD>%-30S</TD><TD>%-8u</TD>",p->shi502_netname, p->shi502_path, p->shi502_current_uses);

				fprintf(stream,"<TR><TD><a href=\"%S\\%-20S\">%-20S</a></TD><TD>%-30S</TD><TD>%-8u</TD>",computername,p->shi502_netname,p->shi502_netname, p->shi502_path, p->shi502_current_uses);

				if (IsValidSecurityDescriptor(p->shi502_security_descriptor))
					fprintf(stream,"<TD>Yes</TD></TR>\n");
				else
					fprintf(stream,"<TD>No</TD></TR>\n");

				p++;
			}
			NetApiBufferFree(BufPtr);
			fprintf(stream,"</TABLE>");
			return(0);
		}
		else {
			fprintf(stderr,"Share Enumeration Error (%d):\n %S\n" ,GetLastError(), ErrorHandle().begin());
			return(3);      // Return 3 on error so we can run diskenum95()
		}
	}while (res==ERROR_MORE_DATA);

	fprintf(stream,"</TABLE>");
	return(0);

}

int diskenum95(LPTSTR computername){

	PSHARE_INFO_1 BufPtr,p;
	NET_API_STATUS res;
	DWORD i = 0;
	DWORD entriesread=0, resume_handle=0, totalentries=0;
	

	fprintf(stream, "<p><TABLE BORDER = 1 WIDTH = \"600\">\n");
	if(computername == NULL)
		fprintf(stream,"<TR><TD><B>Shares:</B></TD><TD><B>Type:</B></TD><TD><B>Comment:</B></TD></TR>\n");
	else
	{
		fprintf(stream, "<a name=\"%S-diskenum\">\n",computername + 2); 
		fprintf(stream,"<TR><TD><B>%S's Shares:</B></TD><TD><B>Type:</B></TD><TD><B>Comment:</B></TD></TR>\n", computername + 2);
	}
	do{
		res = NetShareEnum(computername,
							 1,
							 (LPBYTE *) &BufPtr,
							 0xFFFFFFFF,
							 &entriesread,
							 &totalentries,
							 &resume_handle);

		if(res == ERROR_SUCCESS || res == ERROR_MORE_DATA){
			p = BufPtr;
			for(i=0;i<entriesread;i++){
				 fprintf(stream,"<TR><TD><a href=\"%S\\%S\">%S</a></TD><TD>%u</TD><TD>%S</TD>",computername, p->shi1_netname, p->shi1_netname, p->shi1_type, p->shi1_remark);
				// fprintf(stream,"<TR><TD><a href=\"%S\\%0S\">%S</a></TD><TD>%-30S</TD><TD>%-8u</TD>",computername,p->shi1_netname,p->shi1_netname, p->shi1_type, p->shi1_remark);

				p++;
			}
			NetApiBufferFree(BufPtr);
		}
		else{
			fprintf(stderr,"Share Enumeration Error (%d):\n %S\n" ,GetLastError(), ErrorHandle().begin());

			printf("Attempting to obtain NetBIOS shares using lower security setting\n");
			return(-1);
		}
	}while (res==ERROR_MORE_DATA);

	fprintf(stream,"</TABLE>");
	return(0);
}

int querygroup(LPTSTR szServer){

	PNET_DISPLAY_GROUP pBuff, p;
	DWORD res, dwRec, i = 0;

	do{
		res = NetQueryDisplayInformation(szServer, 3, i, 1000, 25, &dwRec, (PVOID *)&pBuff);

		if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA)){

			p = pBuff;
			fprintf(stream, "<a name=\"%S-group\">\n",szServer + 2); 
			fprintf(stream, "<p>Group Query Results:<BR><TABLE BORDER=1 WIDTH =\"600\">\n");
			fprintf(stream, "<TR><TD><b>Name:</B></TD><TD><b>Comment:</b></TD><TD><b>Group ID:</b></TD><TD><b>Attributes:</b></TD></TR>\n");

			for(;dwRec>0;dwRec--)
			{
				fprintf(stream,"<TR><TD>%S</TD>\n"
					  "<TD>%S</TD>\n"
				"<TD>%u</TD>\n"
					  "<TD>%u</TD>\n"
				"</TR>\n",
				p->grpi3_name,
					  p->grpi3_comment,
				p->grpi3_group_id,
					  p->grpi3_attributes);

				i = p->grpi3_next_index;  //if there is more then set the index
				p++;
			}
			NetApiBufferFree(pBuff);
			fprintf(stream, "</TABLE>\n");
			return(0);
		}
		else{
			if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA))
			fprintf(stderr,"Group Enumeration Error:(%u)\n %S\n" ,res, ErrorHandle().begin());
			return(-1);
			}
	}while (res==ERROR_MORE_DATA);
}

int queryuser(LPTSTR szServer){

	PNET_DISPLAY_USER pBuff, p;
	DWORD res, dwRec, i = 0;


	do{
		res = NetQueryDisplayInformation(szServer, 1, i, 1000, 1000*sizeof(NET_DISPLAY_USER), &dwRec, (PVOID *)&pBuff);
		if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA)){


			p = pBuff;
			fprintf(stream, "<a name=\"%S-user\">\n",szServer); 
			fprintf(stream, "<p>User Query Results:<BR><TABLE BORDER=1 WIDTH =\"600\">\n");
			fprintf(stream, "<TR><TD><b>Name:</b></TD><TD><b>Comment:</b></TD><TD><b>Full Name:</b></TD><TD><b>User ID:</b></TD></TR>\n");

			for(;dwRec>0;dwRec--){
				fprintf(stream,
					"<TR><TD>%S</TD>\n"
					"<TD>%S</TD>\n"
					"<TD>%S</TD>\n"
					"<TD>%u</TD>\n"
					"</TR>\n",
					p->usri1_name,
					p->usri1_comment,
					p->usri1_full_name,
					p->usri1_user_id);

				if (p->usri1_flags & UF_SCRIPT)
					fprintf(stream,"<TR><TD COLSPAN=4>(The logon script executed. This value must be set for LAN Manager 2.0 or Windows NT.)</TD></TR>\n");
				if (p->usri1_flags & UF_ACCOUNTDISABLE)
					fprintf(stream,"<TR><TD COLSPAN=4>(The user's account is disabled.)</TD></TR>\n");
				if (p->usri1_flags & UF_HOMEDIR_REQUIRED)
					fprintf(stream,"<TR><TD COLSPAN=4>(The home directory is required. Windows NT ignores this value.)</TD></TR>\n");
				if (p->usri1_flags & UF_PASSWD_NOTREQD)
					fprintf(stream,"<TR><TD COLSPAN=4>(No password is required.)</TD></TR>\n");
				if (p->usri1_flags & UF_PASSWD_CANT_CHANGE )
					fprintf(stream,"<TR><TD COLSPAN=4>(The user cannot change the password.)</TD></TR>\n");
				if (p->usri1_flags & UF_LOCKOUT)
					fprintf(stream,"<TR><TD COLSPAN=4>(The Account is Locked)</TD></TR>\n");
				if (p->usri1_flags & UF_DONT_EXPIRE_PASSWD)
					fprintf(stream,"<TR><TD COLSPAN=4>(Password does not expire)</TD></TR>\n");

				i = p->usri1_next_index;  //if there is more then set the index
				p++;
			}
			NetApiBufferFree(pBuff);
			fprintf(stream,"</TABLE>\n");
			return(0);
		}
		else{
			fprintf(stderr, "User Enumeration Error:(%u)\n %S\n" ,res, ErrorHandle().begin());
			// break;
			return(-1);
		}
	}while (res==ERROR_MORE_DATA);
}

int queryservices(LPTSTR szServer){

	SC_HANDLE scm;
	BOOL success;
	LPENUM_SERVICE_STATUS status;
	DWORD numServices=0, sizeNeeded=0, resume=0;
	char *svc = "W3SVC";


	// Open a connection to the SCM
	scm = OpenSCManager(szServer, 0,
						SC_MANAGER_ALL_ACCESS);
	if (!scm){
		fprintf(stderr,"Error with OpenSCManager\n");
		return(-1);
	}

	// get the number of bytes to allocate

	success = EnumServicesStatus(scm,
								SERVICE_WIN32 | SERVICE_DRIVER,
	                            SERVICE_ACTIVE | SERVICE_INACTIVE,
	                            0, 0, &sizeNeeded,
								&numServices, &resume);

	if (GetLastError() != ERROR_MORE_DATA){
		fprintf(stderr,"Error with EnumServicesStatus\n");
		return(-1);
	}

	// Allocate space
	status = (LPENUM_SERVICE_STATUS)
	LocalAlloc(LPTR, sizeNeeded);


	// Get the status records. Making an assumption
	// here that no new services get added during
	// the allocation (could lock the database to
	// guarantee that...)
	resume = 0;
	success = EnumServicesStatus(scm,
								 SERVICE_WIN32 | SERVICE_DRIVER,
	                             SERVICE_ACTIVE,
	                             status, sizeNeeded, &sizeNeeded,
	                             &numServices,
								 &resume);
	if (!success){
		printf("Error with EnumServicesStatus\n");
		return(-1);
	}

	DWORD i;
	fprintf(stream, "<a name=\"%S-services\">\n",szServer + 2); 
	fprintf(stream, "<p>Service Enumeration Results:<BR><TABLE BORDER=1 WIDTH =\"600\">\n");

	for (i=0; i < numServices; i++)
		
		fprintf(stream,"<TR><TD>%d %S -- %S</TD></TR>\n",i,status[i].lpServiceName,status[i].lpDisplayName);
	// Clean up
	LocalFree(status);
	CloseServiceHandle(scm);
	fprintf(stream, "</TABLE>\n");
	return(0);
}

void UnicodeToASCII(wchar_t *wcs, char *mbs){
	if (wcs)
	wcstombs (mbs, wcs, (wcslen (wcs) + 1) * sizeof (WCHAR));
	else
	*mbs = '\0';
}

int winfingerprint(LPTSTR pszServerName){

	DWORD dwLevel			= 101;
	LPSERVER_INFO_101 pBuf	= NULL;
	LPWKSTA_INFO_102  pwBuf = NULL; 
	NET_API_STATUS nStatus;

	nStatus = NetServerGetInfo(pszServerName,
							   dwLevel,
							   (LPBYTE *)&pBuf);


	if (nStatus == NERR_Success){
		fprintf(stream, "<a name=\"%S\">\n",pBuf->sv101_name); 
		fprintf(stream,"<p>SMB Query Results:<BR><TABLE BORDER=1 WIDTH =\"600\">\n");

		if (pBuf->sv101_type & SV_TYPE_DOMAIN_CTRL)
			fprintf(stream,"<TR><TD bgcolor = \"#28c9fe\" COLSPAN=5><CENTER><B>%S</B> is a PDC.</CENTER></TD></TR>\n", pBuf->sv101_name);
		else if (pBuf->sv101_type & SV_TYPE_DOMAIN_BAKCTRL)
			fprintf(stream,"<TR><TD bgcolor = \"#28c9fe\" COLSPAN=5><CENTER><B>%S</B> is a BDC.</CENTER></TD></TR>\n", pBuf->sv101_name);
		else if (pBuf->sv101_type & SV_TYPE_SERVER_NT )
			fprintf(stream,"<TR><TD bgcolor = \"#28c9fe\" COLSPAN=5><CENTER><B>%S</B> is an NT MEMBER SERVER.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type &  SV_TYPE_NT )
			fprintf(stream,"<TR><TD bgcolor = \"#28c9fe\" COLSPAN=5><CENTER><B>%S</B> is an NT WORKSTATION.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type & SV_TYPE_SQLSERVER)
			fprintf(stream,"<TR><TD bgcolor = \"#28c9fe\" COLSPAN=5><CENTER><B>%S</B> is running SQL.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type &  SV_TYPE_NOVELL )
			fprintf(stream,"<TR><TD bgcolor = \"#28c9fe\" COLSPAN=5><CENTER><B>%S</B> is a Novell Netware Server.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type &  SV_TYPE_WINDOWS )
			fprintf(stream,"<TR><TD bgcolor = \"#28c9fe\" COLSPAN=5><CENTER><B>%S</B> is running Windows 9x.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type & SV_TYPE_WFW )
			fprintf(stream,"<TR><TD bgcolor = \"#28c9fe\" COLSPAN=5><CENTER><B>%S</B> is Windows for Workgroups.</CENTER></TD></TR>\n",pBuf->sv101_name);
		
		fprintf(stream,"<TR><TD><B>Platform:</B></TD><TD><B>Name:</B></TD>\n");
		fprintf(stream,"<TD><B>Version:</B></TD><TD><B>Type:</B></TD>\n");
		fprintf(stream,"<TD><B>Comment:</B></TD></TR>\n");

		fprintf(stream, "<TR><TD> %d</TD>\n", pBuf->sv101_platform_id);
		fprintf(stream, "<TD>%S</TD>\n", pBuf->sv101_name);
		fprintf(stream, "<TD>%d.%d</TD>\n", pBuf->sv101_version_major, pBuf->sv101_version_minor);
		fprintf(stream, "<TD>%d</TD>\n", pBuf->sv101_type);
		fprintf(stream, "<TD>%S</TD></TR></TABLE>\n", pBuf->sv101_comment);
	}
	
	else{
		fprintf(stderr, "OS Detection Error %d: %S\n" ,nStatus, ErrorHandle().begin());
		if (pBuf != NULL)
		NetApiBufferFree(pBuf);
		return(-1);
	}
	
	nStatus = NetWkstaGetInfo(pszServerName, 
                             dwLevel, 
                             (LPBYTE *)&pwBuf);
	
	if (nStatus == NERR_Success) { 
      fprintf(stream, "Domain:   %s\n", pwBuf->wki102_langroup); 
      fprintf(stream, "Lan Root: %s\n", pwBuf->wki102_lanroot); 
      fprintf(stream, "# Logged On Users: %d<BR>\n", pwBuf->wki102_logged_on_users); 
   } 
   
	else {
		fprintf(stderr, "OS Detection Error %d: %S\n" ,nStatus, ErrorHandle().begin());
 		if (pwBuf != NULL) 
		NetApiBufferFree(pwBuf); 
		return (-1); 
	}




	

	if (pBuf->sv101_type & (SV_TYPE_NOVELL | SV_TYPE_WFW | SV_TYPE_WINDOWS)){
		fprintf(stream,"Not running Group/User Enumeration. Machine does not support it.<BR>");
		return(5); // Have to flag Windows 9x machines
	}

	if (pBuf != NULL)
		NetApiBufferFree(pBuf);
	return(0);
}

void getnetwork(LPNETRESOURCE cont_obj, char *filename){   // the concept is this is null for the first time. Then it is reused.

	HANDLE enumHandle;
	LPNETRESOURCE buffer;
	DWORD bufferSize = 16384;
	DWORD numEntries = 0xFFFFFFFF;
	DWORD result;

	buffer = (LPNETRESOURCE) GlobalAlloc( GPTR, bufferSize);

	result = WNetOpenEnum(
							RESOURCE_GLOBALNET,  // scope of enumeration
							RESOURCETYPE_ANY,    // resource types to list
							0,                   // resource usage to list
							cont_obj,            // pointer to resource structure
							&enumHandle);        // pointer to enumeration handle buffer

	if (result != NO_ERROR){
		fprintf(stderr,"WNetOpenEnum Error: %d\n",result);
		return;
	}

	result = WNetEnumResource(
								enumHandle,                     // handle to enumeration
								&numEntries,                    // pointer to entries to list
								buffer,                         // pointer to buffer for results
								&bufferSize);                   // pointer to buffer size variable


	if (result == NO_ERROR){
	
		for(int i = 0; i < numEntries; i++){
			// if the object is a server
			if(buffer[i].dwDisplayType == RESOURCEDISPLAYTYPE_SERVER){
				printf("\nEnumerating [%S]. . .\n", buffer[i].lpRemoteName + 2);
				if( (menu = fopen("menu.html", "a" )) == NULL ){
					fprintf(stderr, "The file 'menu.html' was not opened\n");
					exit(-1);
				}
				fprintf(menu,"<li><font size = \"-1\" face=\"Verdana,Arial\"><a href=\"%s#%S\" target=main>%S</a></font><br>\n",filename, buffer[i].lpRemoteName + 2, buffer[i].lpRemoteName + 2);
				fclose(menu);
				//fprintf(stderr,"<li><font size = \"-1\" face=\"Verdana,Arial\"><a href=\"%s#%S\" target=main>%S</a></font><br>\n",filename, buffer[i].lpRemoteName + 2, buffer[i].lpRemoteName + 2);
				
				options_launcher(winfingerprint(buffer[i].lpRemoteName), buffer[i].lpRemoteName) ;
			}

			// if the object is a container ( and not a server )
			if( (buffer[i].dwUsage & RESOURCEUSAGE_CONTAINER) && (buffer[i].dwDisplayType != RESOURCEDISPLAYTYPE_SERVER) )
				getnetwork(&buffer[i], filename);  // we found a container, we repass it to the filtering function
		}
	}
	GlobalFree(buffer);
	result = WNetCloseEnum(enumHandle);
	if (result != NO_ERROR)
		printf("WNetCloseEnum ERROR: %d\n",result);
}


int NullSession(LPTSTR Server){

	LPCWSTR szIpc = L"\\IPC$";
	WCHAR RemoteResource[UNCLEN + 5 + 1]; // UNC len + \IPC$ + NULL
	DWORD cchServer;

	NET_API_STATUS nas;
	NETRESOURCE     nr;

	cchServer = lstrlenW( Server );
	if(Server[0] != L'\\' && Server[1] != L'\\') {
		//
		// prepend slashes and NULL terminate
		//
		RemoteResource[0] = L'\\';
		RemoteResource[1] = L'\\';
		RemoteResource[2] = L'\0';
	}
	else{
		cchServer -= 2; // drop slashes from count
		RemoteResource[0] = L'\0';
	}
	if(cchServer > CNLEN){
		SetLastError(ERROR_INVALID_COMPUTERNAME);
		printf("Error in Null Session Routine\n");
		return(-1);
	}
	if(lstrcatW(RemoteResource, Server) == NULL)
		printf("Error in Null Session Routine\n");
	if(lstrcatW(RemoteResource, szIpc) == NULL)
		printf("Error in Null Session Routine\n");

	nr.dwType = RESOURCETYPE_ANY;
	nr.lpLocalName = NULL;
	nr.lpProvider = NULL;
	nr.lpRemoteName = (LPTSTR) RemoteResource;

	nas = WNetAddConnection2(&nr, (LPTSTR) L"", (LPTSTR) L"", 0);
	if( nas == NERR_Success ){
		return(0);}
	else{
		fprintf(stderr,"Null Session NOT Established Error: %d.\n", nas);
		return(-1);
	}
}

int RegConnection(LPTSTR szServer){

	LONG result;
	HKEY hKey, phkResult;
	DWORD dwType;
	WCHAR lpData[MAX_PATH];
	DWORD dwBufLen;
	TCHAR lpName[1024];
	DWORD lpcbName = 1024;
	FILETIME time;
	DWORD index ;

	result = RegConnectRegistry(szServer,            // address of name of remote computer
								HKEY_LOCAL_MACHINE,  // predefined registry handle
								&hKey);              // address of buffer for remote registry handle

	if (result != ERROR_SUCCESS){
		fprintf(stderr,"RegConnectRegistry ERROR: %d\n",result);
		return(-1);
	}
	
	result = RegOpenKeyEx(hKey,                  // handle to open key
						  L"Software\\Microsoft\\Windows NT\\CurrentVersion",// address of name of subkey to open
						  0,                     // reserved
						  KEY_QUERY_VALUE,       // security access mask
						  &phkResult);           // address of handle to open key

	if (result != ERROR_SUCCESS){
		fprintf(stderr,"RegOpenKeyEx ERROR: %d",result);
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
					  NULL,
				      GetLastError(),
					  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
					  (LPTSTR) &result,
					  0,
					  NULL);

		fprintf(stderr, " %S\n",  (LPCTSTR)result);
		return(-1);
	}
	else{
		//
		// Determine how large of a buffer to allocate.
		//
		result = RegQueryValueEx(phkResult,          // handle to key to query
								 L"CSDVersion",      // address of name of value to query
								 NULL,               // reserved
								 &dwType,            // address of buffer for value type
								 (LPBYTE) lpData,    // address of data buffer
								 &dwBufLen);         // address of data buffer size
		dwBufLen = sizeof(lpData);
	}

	result = RegQueryValueEx(phkResult,          // handle to key to query
					         L"CSDVersion",      // address of name of value to query
							 NULL,               // reserved
							 &dwType,            // address of buffer for value type
		                     (LPBYTE) lpData,    // address of data buffer
		                     &dwBufLen);         // address of data buffer size

	if (result != ERROR_SUCCESS){
		fprintf(stderr, "RegQueryValueEx ERROR %d: %S\n",result, ErrorHandle().begin());
		return(-1);
	}
	else{
		fprintf(stream, "<a name=\"%S-registry\">\n",szServer + 2); 
		fprintf(stream, "<p> <TABLE BORDER=1 WIDTH =\"600\">\n");
		fprintf(stream, "<TR><td colspan = \"2\"><b>%S</b> %S</TD></TR>\n",szServer +2, lpData);
		fprintf(stream, "<TR><TD><B>Hotfix:</B></TD><TD><B>Description</b></TD></TR>\n");
	}

	RegCloseKey(hKey);
	fprintf(stream, "<BR>Registry Query Results:<BR>\n");
	result = RegConnectRegistry(szServer,            // address of name of remote computer
								HKEY_LOCAL_MACHINE,  // predefined registry handle
								&hKey);              // address of buffer for remote registry handle

	if (result != ERROR_SUCCESS){
		printf("RegConnectRegistry ERROR: %d\n",result);
		return(-1);
	}

	result = RegOpenKeyEx(hKey,                  // handle to open key
						  L"Software\\Microsoft\\Windows NT\\CurrentVersion\\Hotfix",// address of name of subkey to open
						  0,                     // reserved
						  KEY_ENUMERATE_SUB_KEYS,// security access mask
						  &phkResult);           // address of handle to open key

	if (result == ERROR_SUCCESS){
		index = 0;
		lpcbName = sizeof(lpName);

		result = RegEnumKeyEx(phkResult,          // handle to key to enumerate
							  index,              // index of subkey to enumerate
							  lpName,             // address of buffer for subkey name
							  &lpcbName,          // address for size of subkey buffer
							  NULL,               // reserved
							  NULL,               // address of buffer for class string
							  NULL,               // address for size of class buffer
							  &time);

	for(index = 0; result != ERROR_NO_MORE_ITEMS; index++){

		lpcbName = sizeof(lpName);
		result = RegEnumKeyEx(phkResult,          // handle to key to enumerate
							  index,              // index of subkey to enumerate
							  lpName,             // address of buffer for subkey name
							  &lpcbName,          // address for size of subkey buffer
							  NULL,               // reserved
							  NULL,               // address of buffer for class string
							  NULL,               // address for size of class buffer
							  &time);

			if (result == ERROR_NO_MORE_ITEMS){
				RegCloseKey(hKey);
				fprintf(stream, "</TABLE>\n");
				return(0);
			}
			else{
				HKEY hkey_q;
				int rval;
				DWORD lpType,lpcbData=8192;
				TCHAR result[8192];
				rval=RegOpenKeyEx(phkResult,lpName,0,KEY_READ,&hkey_q);
				rval=RegQueryValueEx(hkey_q,TEXT("Comments"),NULL,&lpType,(LPBYTE) result,&lpcbData);
				fprintf(stream, "<TR><TD>%S</TD><TD>%S</TD></TR>\n",lpName, result);
			}
		}
		fprintf(stream, "</TABLE>\n");
		RegCloseKey(hKey);
		return(0);
	}
	return 0;
}

int NullDisconnect(LPTSTR Server)
	{
	LPCWSTR szIpc = L"\\IPC$";
	WCHAR RemoteResource[UNCLEN + 5 + 1]; // UNC len + \IPC$ + NULL
	DWORD cchServer, result;


	cchServer = lstrlenW( Server );
	if(Server[0] != L'\\' && Server[1] != L'\\') {
	//
	// prepend slashes and NULL terminate
	//
	RemoteResource[0] = L'\\';
	RemoteResource[1] = L'\\';
	RemoteResource[2] = L'\0';
	}
	else
	{
	cchServer -= 2; // drop slashes from count
	RemoteResource[0] = L'\0';
	}
	if(cchServer > CNLEN)
	{
	SetLastError(ERROR_INVALID_COMPUTERNAME);
	printf("Error in Null Session Routine\n");
	return(-1);
	}
	if(lstrcatW(RemoteResource, Server) == NULL) printf("Error in Null Session Routine\n");
	if(lstrcatW(RemoteResource, szIpc) == NULL) printf("Error in Null Session Routine\n");

	result = WNetCancelConnection2(
	RemoteResource,  // pointer to resource name to disconnect
	0,    // connection type flags
	1);     // flag for unconditional disconnect

	if(result == NO_ERROR ){
	printf("Null IPC$ Session Terminated [%S].\n",Server +2);
	return(0);}
	else {
	fprintf(stderr,"Null Session NOT Terminated Error: %d.\n", result);
	return(-1);}
	}

	wstring ErrorHandle()
	{
	LPVOID lpMsgBuf;

	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
	FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
	NULL,
	GetLastError(),
	MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
	(LPTSTR) &lpMsgBuf,
	0,
	NULL);
	wstring str((LPCTSTR)lpMsgBuf);
	LocalFree(lpMsgBuf);
	return(str);
}

int querytransport(LPTSTR pszServerName){
   LPSERVER_TRANSPORT_INFO_0 pBuf = NULL;
   LPSERVER_TRANSPORT_INFO_0 pTmpBuf;
   DWORD dwLevel = 0;
   DWORD dwPrefMaxLen = 256;//-1
   DWORD dwEntriesRead = 0;
   DWORD dwTotalEntries = 0;
   DWORD dwResumeHandle = 0;
   DWORD dwTotalCount = 0;
   NET_API_STATUS nStatus;
   DWORD i;

   //
   // Call the NetServerTransportEnum function; specify level 0.
   //
   do // begin do
   {
      nStatus = NetServerTransportEnum(pszServerName,
                                       dwLevel,
                                       (LPBYTE *) &pBuf,
                                       dwPrefMaxLen,
                                       &dwEntriesRead,
                                       &dwTotalEntries,
                                       &dwResumeHandle);
      //
      // If the call succeeds,
      //
      if ((nStatus == NERR_Success) || (nStatus == ERROR_MORE_DATA))
      {
         if ((pTmpBuf = pBuf) != NULL)
         {
            //
            // Loop through the entries;
            //  process access errors.
            //
			 fprintf(stream, "Transports:<br>\n");
			 fprintf(stream, "<TABLE BORDER=1 WIDTH =\"600\">\n");
            for (i = 0; i < dwEntriesRead; i++)
            {
               assert(pTmpBuf != NULL);

               if (pTmpBuf == NULL)
               {
                  fprintf(stderr, "An access violation has occurred\n");
                  break;
               }
               //
               // Print the transport protocol name. 
               //
               fwprintf(stream, L"<TR><TD>Transport:</TD><TD>%s</TD></TR>\n", pTmpBuf->svti0_transportname);
			   fwprintf(stream, L"<TR><TD>Network Address:</TD><TD>%s</TD></TR>\n", pTmpBuf->svti0_networkaddress);
               pTmpBuf++;
               dwTotalCount++;
            }
			fprintf(stream, "</TABLE>\n");
         }
      }
      //
      // Otherwise, indicate a system error.
      //
      else
         fprintf(stderr, "A system error has occurred: %d\n", nStatus);

      //
      // Free the allocated buffer.
      //
      if (pBuf != NULL)
      {
         NetApiBufferFree(pBuf);
         pBuf = NULL;
      }
   // 
   // Continue to call NetServerTransportEnum while 
   //  there are more entries. 
   // 
   }
   while (nStatus == ERROR_MORE_DATA); // end do

   // Check again for an allocated buffer.
   //
   if (pBuf != NULL)
      NetApiBufferFree(pBuf);
   //
   // Print the final count of transports enumerated.
   //
   fprintf(stderr, "\nTotal of %d entries enumerated\n", dwTotalCount);

   return 0;


}
int querytime(LPTSTR pszServerName){
   LPTIME_OF_DAY_INFO pBuf = NULL;
   NET_API_STATUS nStatus;
   //
   // Call the NetRemoteTOD function.
   //
   nStatus = NetRemoteTOD(pszServerName,
                          (LPBYTE *)&pBuf);
   //
   // If the function succeeds, display the current date and time.
   //
   if (nStatus == NERR_Success)
   {
      if (pBuf != NULL)
      {
         fprintf(stream,"Date and Time:<br>\n");
		 fprintf(stream, "<TABLE BORDER=1 WIDTH =\"600\"><TR><TD>The current date is:</TD><TD>%d/%d/%d</TD></TR>\n",
                 pBuf->tod_month, pBuf->tod_day, pBuf->tod_year);
         fprintf(stream, "<TR><TD>The current time is:</TD><TD>%d:%d:%d</TD></TR></TABLE>\n",
                 pBuf->tod_hours, pBuf->tod_mins, pBuf->tod_secs);
      }
   }
   //
   // Otherwise, display a system error.
   else
      fprintf(stderr, "A system error has occurred: %d\n", nStatus);
   //
   // Free the allocated buffer.
   //
   if (pBuf != NULL)
      NetApiBufferFree(pBuf);

   return 0;

   
}

void DisplayUsage (char *arg){

	printf("%s vacuum@technotronic.com & Mike@eEye.com\n\n", VERSION);
	printf("Usage: %s [-t \\\\COMPUTERNAME] [-a -d -g -m -n -o -r -s -u -h]\n", arg);
	printf(" -a Enumerates NetBIOS Shares, Users, Groups, Transports,\n    Date & Time, and Services\n");
	printf(" -d Enumerates Shares\n");
	printf(" -g Enumerates Groups\n");
	printf(" -m Scan entire 'Network Neighborhood'\n");
	printf(" -n Establishes Null Session\n");
	printf(" -r Registry Querying\n");
	printf(" -s Enumerates Services, Transports, Date & Time\n");
	printf(" -u Enumerates Users\n");
	printf(" -o Output filename 'e.g. myscan.html'\n");
	printf(" -h Shows Usage\n");
	exit(1);
}

void options_launcher(int os_type, LPTSTR server){

	int rdata;

	switch(os_type){
		case 5:
			// 95, 98, Novell.
			if(options.bits.optnull)
				NullSession(server);
			if(options.bits.optdiskenum)
				diskenum95(server);
			if(options.bits.optnull)
				NullDisconnect(server);
			break;
		case -1:
			// An error occured.
			break;
		case 0:
			// NT box.
			if(options.bits.optnull)
				NullSession(server);
			if(options.bits.optreg)
				RegConnection(server);
			if(options.bits.optdiskenum){
				rdata = diskenum(server);
				// Try to get shares without Administrator access.
				if(rdata == 3)
					diskenum95(server);
			}
			if(options.bits.optquerygroup)
				querygroup(server);
			if(options.bits.optqueryuser)
				queryuser(server);
			if(options.bits.optqueryservices)
				queryservices(server);
			    querytransport(server); //Transport Enumeration
				querytime(server);      // Query Time
			if(options.bits.optnull)
				NullDisconnect(server);
			break;
		default:
			break;
	}
}





