#include <stdio.h>
#include<winsock2.h>
#include <string.h>
#include <ws2tcpip.h> 
#include <stdlib.h>
#include <process.h>
#include <windows.h>


#pragma comment(lib, "ws2_32")

/*
	WHAT IS THIS
	Ibis ver. 1.8 coded by LeVante^   levante@manicomio.org  or  m.levante@gmail.com
	This is a multithreaded broadcast address scanner for Windows
	It's useful to discover any IP Address that gives you back one or more than one ping reply
	and, as everybody knows, it can be used to get a list of smurf amplifiers; that's to say
	it can be used with smurf/papasmurf/WinSmurf/Smurf2K/WSmurf... (as many as you know...so *murf*  ;-D)
	Though I prefer to say it can also be used to discover which addresses respond to ICMP ECHO REQUEST and with how many replies.
	Excluding Nmap (which is much much more than a broadcast scanner) on Windows I believe that there is only one 
	broadcast scanner whose name is Ultimate Broadcast Scan coded by JC`zic. 
	Even if they're both excellent programs I could not get nmap to work (maybe because on windows it requires some plugin 
	or WinPcap libraries I don't know, I also tried to install WinPcap but got no result) and UBS is too fast for my 
	CPU/connection (my system becomes very slow and my Internet connection too and after a few minutes I'm offline)
	so I decided to code one by myself. That's Ibis (Italian Broadcast Ip Scanner).

	MAIN FEATURES
	With Ibis you can choose how fast must be your scan (setting a delay parameter), you can choose to save only those Ip
	with a certain number of DUPs, you can save the output in 3 different ways, you can run it silently or displaying every
	ping request/reply event, you can scan the whole Internet or a specific space of addresses.
	Moreover Ultimate Broadcast Scan and many other broadcast scanners only ping addresses ending with 0 or 255, I believe 
	that's not correct or not enough! There are a lot of Ip addresses that end with any other number and return many ICMP Echo Replies, anyway
	you can always choose this way of scanning by setting the -big parameter.
	
	REQUIREMENTS
	Ibis is very personalizable (sorry for my English ;=P) so you don't need any special feature.
	I only want to give a warning to Windows XP Service Pack 2 users. This program was only tested on Windows XP SP1
	Ibis uses Raw Socket support which was native from the times of Windows NT. I heard that this feature was suppressed
	in Service Pack 2 and I heard it was suppressed also for all Windows users who made the MS05-019 update. Anyway ONLY IF
	YOU CANNOT GET IBIS TO WORK you can find information about how to re-enable the support at 
	http://seclists.org/lists/nmap-hackers/2005/Apr-Jun/0001.htm.
*/

typedef struct iphdr { 
	unsigned char  ver_len;
	unsigned char  tos;
	unsigned short tot_len;
	unsigned short id;
	unsigned short offset;
	unsigned char  ttl;
	unsigned char  protocol;
	unsigned short checksum;
	unsigned int   source;
	unsigned int   destination;
} IP_HDR;
#define IP_HDR_LEN sizeof(IP_HDR)

typedef struct icmphdr {
	unsigned char  type;
	unsigned char  code;
	unsigned short checksum;
	unsigned short id;  //this is extremely useful to calculate DUPs of any IP
	unsigned short sequence;
	unsigned long  timestamp;
} ICMP_HDR;

typedef struct broadcast {
	int id;
	char ip[16];
	int dup;
} BROAD;


struct broadcast results[1024]; //so it will check 1024 ip each time
SOCKET sock;
unsigned short ip_len;
unsigned char packet[32];
int mindup = 1, show = 1;
int initWinsock(void); //a function to initialize Winsock
SOCKET CreateSocket(void); //this is the function that creates the socket and sets the socket options we need
void printHelp(char *pname); //this function simply prints out the help in case of errors
unsigned short in_cksum(unsigned short *addr, int len); //a common checksum calculation
HANDLE mutex; //semaphore for mutual exclusion when working on the same struct from different threads
void receive(void *p);//the real thread

int main(int argc, char *argv[]){

	int a = 0, b = 0, c = 0, d = 0, i, delay = 70, big = 0, ot = 1;
	char scanip[16], endip[16] = "254.255.255.255", savepath[256] = "C:\\ibis.txt"; //some default values
	unsigned short myid = 0, ip_v, totalsize;
	struct iphdr *ip = (struct iphdr *) packet;
	struct icmphdr *icmp = (struct icmphdr *) (packet + 20); //20 bytes is the length of Ip header
	struct sockaddr_in sin;
	FILE *fp;

	if(argc > 18 || argc < 2) {
		printf("\n\tERROR! You have entered a wrong number of parameters!\n");
		Sleep(1500);
		printHelp(argv[0]);
	}
	//it's necessary to specify the source Ip Address since we are building the raw packet
	if(strlen(argv[1]) < 7 || strlen(argv[1]) > 15) {
		printf("\n\tERROR! You MUST specify your own IP Address first!\n\tUsage: %s <own IP Address> [options]\n", argv[0]);
		Sleep(1500);
		printHelp(argv[0]);
	}

	//parsing of options
	for(i=2;i<argc;i++) {
		if(!strcmp(argv[i], "-sa")) {
			if(strlen(argv[i+1]) < 7 || strlen(argv[i+1]) > 15 || sscanf(argv[i+1], "%d.%d.%d.%d", &a, &b, &c, &d) != 4) {
				printf("\n\tERROR! You haven't specified a correct start address (-sa)!\n\tUsage: %s ... -sa xxx.xxx.xxx.xxx ...\n", argv[0]);
				Sleep(1500);
				printHelp(argv[0]);
			}
			else {
				i++;
				continue;
			}
		}
		
		if(!strcmp(argv[i], "-ea")) {
			if(strlen(argv[i+1]) >= 7 && strlen(argv[i+1]) <= 15) {
				strcpy(endip, argv[i+1]);
				i++;
				continue;
			}
			else {
				printf("\n\tERROR! You haven't specified a correct end address (-ea)!\n\tUsage: %s ... -ea xxx.xxx.xxx.xxx ...\n", argv[0]);
				Sleep(1500);
				printHelp(argv[0]);
			}
		}
		

		if(!strcmp(argv[i], "-d")) {
			delay = atoi(argv[i+1]);
			if(delay >= 0) {
				i++;
				continue;
			}
			else {
				printf("\n\tERROR! Delay MUST be a number greater than 0.\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}

		if(!strcmp(argv[i], "-dup")) {
			mindup = atoi(argv[i+1]);
			if(mindup > 0) {
				i++;
				continue;
			}
			else {
				printf("\n\tERROR! Minimum number of DUPs MUST be at least 1.\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}

		if(!strcmp(argv[i], "-big")) {
			big = atoi(argv[i+1]);
			if(big == 0 || big == 1) {
				i++;
				continue;
			}
			else {
				printf("\n\tERROR! The -big parameter MUST be 0 or 1\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}
	
		if(!strcmp(argv[i], "-ot")) {
			ot = atoi(argv[i+1]);
			if(ot == 1 || ot == 2 || ot == 3) {
				i++;
				continue;
			}
			else {
				printf("\n\tERROR! The -ot parameter MUST be 1 or 2 or 3\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}

		if(!strcmp(argv[i], "-show")) {
			show = atoi(argv[i+1]);
			if(show == 1 || show == 2 || show == 3) {
				i++;
				continue;
			}
			else {
				printf("\n\tERROR! The -show parameter MUST be 1 or 2 or 3\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}

		if(!strcmp(argv[i], "-of")) {
			strcpy(savepath, argv[i+1]);
			i++;
			continue;
		}
		
	}

	if((fp = fopen(savepath, "w")) == NULL) {
		fprintf(stderr, "\n\nERROR! Unable to open %s\n", savepath);
		exit(-1);
	}

	//Winsock initialization and creation
	initWinsock();
	sock = CreateSocket();

	mutex = CreateMutex(NULL, FALSE, NULL);
	_beginthread( receive, 0, NULL); //thread to receive replies started here
	
	memset(packet, 0, 32);
	//Now we're gonna build the packet, first the Ip fields...
	ip_len = sizeof(struct iphdr) / sizeof(unsigned long);
	totalsize = sizeof(struct iphdr) + sizeof(struct icmphdr);
	ip_v = 4;
	ip->ver_len   = (ip_v << 4) | ip_len;
	ip->tos      = 0;
	ip->tot_len  = htons(totalsize);
	ip->id       = 1;
	ip->offset   = 0;
	ip->ttl      = 255;
	ip->protocol = IPPROTO_ICMP;
	ip->source    = inet_addr(argv[1]); //the IP source we specified as first argument on the command line
	//...and now the ICMP fields
	icmp->type     = 8;  //type: ICMP ECHO REQUEST
	icmp->code     = 0;
	//All the other IP and ICMP fields like ip destination, ip and icmp checksum will be naturally modified and recalculated each time
	
	//If the user specify a start address (-sa option) the address must be initialized BEFORE the cycle or 
	//the first cycle will increase it and THEN will send the packet excluding the start address specified by the user. 
	if(!(a == 0 && b == 0 && c == 0 && d == 0)) {
		if(big == 1) {
			if(d == 255)
				d = 0; //in case start address ends with 255 d = 0 so at the first cycle it'll be increased and it will become our 255
			else
				d = 255;  //in case start address ends with 0 or with any other number then d = 255 so at the first cycle it will start from 0
		}
		else {
			/*
				This was corrected from vers. 1.7 to 1.8
				We have to decrease by 1 the Ip address so that the first cycle will increase it by 1. Though we have to check
				that numbers are between 0 and 255. The error was that in vers. 1.7 I only decreased d by 1, thinking that even if
				it was 0, d-- would have been -1 and the first cycle would have increased it to 0 again. This was absolutely wrong!!
				And I only noticed the error 2 days after. In fact if d-- is neative, it's true that the first cycle will restore 
				it to 0 but then it will also increase c causing the program to start from completelty another address and so on.
				Now it's corrected, and I hope it will be fine. Sorry
			*/
			d--;
			if(d < 0) {
				d = 255;
				c--;
				if(c < 0) {
					c = 255;
					b--;
					if(b < 0) {
						b = 255;
						a--;
					}
				}
			}
		}
	}
	sin.sin_family = AF_INET;
	
	while(a <= 254) {
		if(!big) d = (d + 1) % 256;
		else {
			if(!d) d += 255;
			else if(d == 255) d -= 255;
		}
		if(!d) {
			c = (c + 1) % 256;
			if(!c) {
				b = (b + 1) % 256;
				if(!b) {
					a++;
				}
			}
		}
		
		sprintf(scanip,"%d.%d.%d.%d\0",a,b,c,d);
		if(show == 1)
			printf("Sending ping request to %s\n", scanip);
		//dynamic ip and icmp fields in the program
		ip->destination    = inet_addr(scanip);
		ip->checksum = 0;
		ip->checksum = in_cksum((unsigned short *)ip, sizeof(struct iphdr));  //checksum for IP
		icmp->id       = htons(myid);  //myid starts from 0 and fills all the 1024 locations of the structure, so we can distinguish the replies
		icmp->sequence = (USHORT) htonl(rand()); 
		icmp->checksum = 0;
		icmp->checksum = in_cksum((unsigned short *)icmp, sizeof(struct icmphdr));  //checksum for ICMP
		//when we have exclusive access to the structure we set every field except for the DUPs.
		//since the structure is global it's shared with the thread that will fill the DUPs fields when receiving any reply
		WaitForSingleObject(mutex, INFINITE); 
		results[myid].id = myid;
		strcpy(results[myid].ip, scanip);
		results[myid].dup = 0;
		ReleaseMutex(mutex);
		myid++;
		//send the packet
		if(sendto(sock, packet, totalsize, 0x0, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) == SOCKET_ERROR) {
			printf("Errore: %d\n", WSAGetLastError());	
			free(ip);
			free(icmp);
			WSACleanup();
			exit(-1);
		}
		//Are we at the end?
		if(!strcmp(scanip, endip)) {
			Sleep(2000); //waits for last ping replies to arrive
			WaitForSingleObject(mutex, INFINITE);
			for(i=0;i<myid;i++) {
				if(results[i].dup >= mindup) {
					if(ot == 1) {
						fprintf(fp, "%s\n", results[i].ip);
						fflush(fp);
					}
					else if(ot == 2) {
						fprintf(fp, "%s %d\n", results[i].ip, results[i].dup);
						fflush(fp);
					}
					else if(ot == 3) {
						fprintf(fp, "%s\t%d\n", results[i].ip, results[i].dup);
						fflush(fp);
					}
				}
			}
			if(show < 3)
				printf("\n\n---------IBIS Scan Terminated---------\nCheck the output file in %s\n", savepath);
			CloseHandle(mutex);
			fclose(fp);
			closesocket(sock);
			WSACleanup();
			exit(0);
		}


		sprintf(scanip, "");
		//every 1024 ip we're going to empty the whole array
		if(myid == 1024) {
			Sleep(1500); //waits for last ping replies to arrive
			WaitForSingleObject(mutex, INFINITE);
			
			for(i=0;i<1024;i++) {
				if(results[i].dup >= mindup) {
					if(ot == 1) {
						fprintf(fp, "%s\n", results[i].ip);
						fflush(fp);
					}
					else if(ot == 2) {
						fprintf(fp, "%s %d\n", results[i].ip, results[i].dup);
						fflush(fp);
					}
					else if(ot == 3) {
						fprintf(fp, "%s\t%d\n", results[i].ip, results[i].dup);
						fflush(fp);
					}
				}
				//and naturally we need to reset everything
				results[i].dup = 0;
				results[i].id = 0;
				strcpy(results[i].ip, "");
			}
			myid = 0;
			ReleaseMutex(mutex);
		}
		//delay for the whole scan
		if(delay > 0) Sleep(delay);
	}
    WSACleanup();
	exit(0);
}

int initWinsock(void){
 	WSADATA WSAData;
 	int err;
	if((err = WSAStartup(MAKEWORD(2,0), &WSAData)) != 0) {
		printf("\nUnable to initialize Winsock\n");
		exit(-1);
	}
	return(0);
}

SOCKET CreateSocket(void){
	int optval = 1;
	SOCKET socket;
	ULONG NonBlock;
	//Ip protocol in RAW mode
	if((socket = WSASocket(AF_INET, SOCK_RAW, IPPROTO_ICMP, NULL, 0,0)) == INVALID_SOCKET){
		printf("\nERROR! Function() Raw Socket : %d\n", WSAGetLastError());
		WSACleanup();
		exit(-1);
	}
	
	if(setsockopt(socket, IPPROTO_IP, 2, (char *)&optval, sizeof(optval)) == SOCKET_ERROR)	{
   		printf("\nERROR! Function setsockopt() : %d\n", WSAGetLastError());
		WSACleanup();
   		exit(-1);
	}

	NonBlock = 1;
	//it's of paramount importance that socket MUST be nonblocking or the cycle will stop
     if(ioctlsocket(socket, FIONBIO, &NonBlock) == SOCKET_ERROR) {
          printf("\nERROR! ioctlsocket() failed \n");
          exit(-1);
     }
	 
	 if(setsockopt(socket, SOL_SOCKET, SO_BROADCAST, (const char *)&optval, sizeof(int) ) == SOCKET_ERROR) {
		printf("\nERROR! Function setsockopt() : %d\n", WSAGetLastError());
		WSACleanup();
   		exit(-1);
	 }
	
	return(socket);
}

unsigned short in_cksum(unsigned short *addr, int len){

    register int nleft = len;
    register u_short *w = addr;
    register int sum = 0;
    u_short answer = 0;

    while (nleft > 1) {
	sum += *w++;
	nleft -= 2;
    }

    if (nleft == 1) {
	*(u_char *) (&answer) = *(u_char *) w;
	sum += answer;
    }

    sum = (sum >> 16) + (sum & 0xffff);
    sum += (sum >> 16);
    answer = ~sum;

    return (answer);
}

//This is the thread always active to receive the ICMP ECHO REPLIES 
void receive(void *p) {
	int RetVal, typecheck;
	unsigned short idcheck;
	socklen_t clilen;
	struct sockaddr_in cliaddr;
	char buffer[1024];
	struct icmphdr *hdrICMPHeader;

	clilen = sizeof(cliaddr);
	for(;;) {
		memset((char *) &cliaddr, 0, sizeof(cliaddr));
		if((RetVal = recvfrom(sock, buffer, 1024, 0,(struct sockaddr *) &cliaddr, &clilen)) >= 0) {
			if (buffer[0] == 0x45)
				hdrICMPHeader = (struct icmphdr *) &(buffer[IP_HDR_LEN]);
			else
				hdrICMPHeader = (struct icmphdr *) buffer;

			idcheck = ntohs(hdrICMPHeader->id); //we get back the ID field
			typecheck = (int) hdrICMPHeader->type; //and we also get back the type. We only need the type 0 -> ECHO REPLY!!!
			
			WaitForSingleObject(mutex, INFINITE);
			//If the ID match we can add a DUP to one ofthe IPs in the shared structure
			if(typecheck == 0 && idcheck < 1024 && results[idcheck].id == idcheck) {
				results[idcheck].dup++;
				if(show < 3)
					printf("\nReceived a ping reply. Added one DUP to %s\n", results[idcheck].ip);
			}
			ReleaseMutex(mutex);
		}
	}
}

void printHelp(char *pname) {
	fprintf(stderr, "\n\n\tItalian Broadcast Ip Scanner ver. 1.7 by LeVante^\n\nUsage: %s <own IP address> [options]\n\nOptions List:\n -sa <start IP Address (default 0.0.0.1)>\n -ea <end IP Address (default 254.255.255.255)>\n -d <delay in milliseconds (default 70)>\n -dup <minimum number of dups to save (default 1)>\n -big <0 to scan every IP address | 1 to scan only addresses\n       ending with 0 or 255 (default 0)>\n -ot <1 to have simple list of IP in the output file | 2 to have a list of\n      IP and it's respective DUP on each line separated by a SPACE | 3 to have\n      IP and it's respective DUP on each line separated by a TAB (default 1)>\n -of <file to save output (default C:\\ibis.txt)>\n -show <1 to show everything | 2 to show only ping reply events | 3 to\n       show nothing, silent mode. (default 1)>\n\nCheck the help file if you get any error or you want to see examples of use\n", pname);
	WSACleanup();
	exit(-1);
}

