/* CiscoPW 1.0 - February, this year of our Bob, 1998.
 *
 * hacked from: sample code for the ASDK tutorial
 *
 * this code will degenerate Ciscos
 * 
 * Once upon a time, on a hard disk far, far away,
 * this code was written by:
 * Andrew Howlett
 * howlett@iosphere.net
 * June 1997
 *
 * It was then sorely abused by Major Malfunction, 
 * of The Church of The Wibbly Wobbly Web...
 * majormal@wownet.org
 *
 * Current version(s) can be found at:
 * 
 * http://www.alcrypto.co.uk/cisco
 *
 * This collection of bytes is BobbyWrite(b) Sometime, 
 * Major Malfunction, All Writes Reneged, All Wrongs 
 * are, well, Bad Things(tm)...
 *
 * There is nothing original in this code whatsoever. 
 * All I did was glue some other stuff together and hit 
 * the compile button... go on... be a hacker... you 
 * know it makes sense! :)
 */



#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "ciscopw.h"
#define CiscoPW_AppID    'MMCi'
#define CiscoPW_DBType   'Data'   // 0x64415441 in hexadecimal

static int StartApplication(void);
static Boolean OpenDatabase(void);
static void EventLoop(void);
static void EventLoop(void);
static void StopApplication(void);
static Boolean ciscopw(EventPtr event);
static void MMDecrypt(void);
static char MMToUpper(char x);
static int MMIsDigit(char x);

FieldPtr	fieldptr_hex; 
FieldPtr	fieldptr_text;
DmOpenRef	CiscoPW_DB;
char            CiscoPW_DBName[] = "CiscoPW_DB";

char		hex[60];



DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
  int error;

  if (cmd == sysAppLaunchCmdNormalLaunch)
 {

    error = StartApplication();	// Application start code
    if (error) return error;

    EventLoop();	// Event loop

    StopApplication ();	// Application stop code
  }
  return 0;
}

static int StartApplication(void)
{
  int error;

  error = OpenDatabase();
  if (error) return error;

  FrmGotoForm(formID_ciscopw);
}

static Boolean OpenDatabase(void)
{
  UInt          index = 0;
  VoidHand      RecHandle;
  Ptr           RecPointer;
  char          nullstring = 0;

  CiscoPW_DB = DmOpenDatabaseByTypeCreator(CiscoPW_DBType, CiscoPW_AppID, dmModeReadWrite);
  if (!CiscoPW_DB) {
    if (DmCreateDatabase(0, CiscoPW_DBName, CiscoPW_AppID, CiscoPW_DBType, false)) return 1;
    CiscoPW_DB = DmOpenDatabaseByTypeCreator(CiscoPW_DBType, CiscoPW_AppID, dmModeReadWrite);
    RecHandle = DmNewRecord(CiscoPW_DB, &index, 1);
    RecPointer = MemHandleLock(RecHandle);
    DmWrite(RecPointer, 0, &nullstring, 1);
    MemPtrUnlock(RecPointer); 
    DmReleaseRecord(CiscoPW_DB, index, true);  
  }
  return 0;
}

static void EventLoop(void)
{
  short err;
  int formID;
  FormPtr form;
  EventType event;

  do
  {

    EvtGetEvent(&event, 200);

    if (SysHandleEvent(&event)) continue;
    if (MenuHandleEvent((void *)0, &event, &err)) continue;

    if (event.eType == frmLoadEvent)
    {
      formID = event.data.frmLoad.formID;
      form = FrmInitForm(formID);
      FrmSetActiveForm(form);
      switch (formID) 
      {
      case formID_ciscopw:
        FrmSetEventHandler(form, (FormEventHandlerPtr) ciscopw);
        break;
      }
    } 
    FrmDispatchEvent(&event);
  } while(event.eType != appStopEvent);
}



static void StopApplication(void)
{
  FldSetTextHandle(fieldptr_text, NULL);
  DmReleaseRecord(CiscoPW_DB, 0, false);
  DmCloseDatabase(CiscoPW_DB);
}

static Boolean ciscopw(EventPtr event)
{
  FormPtr   	form;
  int       	handled = 0;
  VoidHand  	bitmaphandle;
  BitmapPtr 	bitmap;

  switch (event->eType) 
  {
  case frmOpenEvent:
    form = FrmGetActiveForm();
    fieldptr_text = FrmGetObjectPtr(form, FrmGetObjectIndex(form, fieldID_text));
    FldSetTextHandle (fieldptr_text, (Handle) DmGetRecord(CiscoPW_DB, 0));
    fieldptr_hex = FrmGetObjectPtr(form, FrmGetObjectIndex(form, fieldID_hex));
    FrmDrawForm(form);
    bitmaphandle= DmGetResource('Tbmp',bitmapID_cisco);
    bitmap= MemHandleLock(bitmaphandle);
    WinDrawBitmap(bitmap,20,120);
    MemHandleUnlock(bitmaphandle);
    handled = 1;
    break;
    
  case ctlSelectEvent:  // A control button was pressed and released.
    if (event->data.ctlEnter.controlID== buttonID_convert)
    {
      MMDecrypt();
      handled = 1;
    }
    break;

  case menuEvent:
    switch (event->data.menu.itemID)
    {
    case menuitemID_convert:
      MMDecrypt();
      break;
    case menuitemID_about:
      FrmAlert(alertID_about);
      break;
    case menuitemID_copy:
      FldCopy(fieldptr_text);   // user has to select (highllight) the text to copy
      break;
    case menuitemID_paste:
      FldPaste(fieldptr_text);
      break;
    }
    handled = 1;
    break;

  case nilEvent:
    handled = 1;
    break;
  }
  return handled;
}

static char MMToUpper(char x)
{
  char		ret;

  if (x < 'a' || x > 'z')
    return x;
  ret= (x - 'a') + 'A';
  return ret;
}

static int MMIsDigit(char x)
{
  if(x >= '0' && x <= '9')
    return 1;
  return 0;
}

static void MMDecrypt(void)
{
  int			seed, i, enc_len, val = 0;
  CharPtr		enc_pw;
  char			*dec_pw;
  static char		encrypted[60], decrypted[60];
  static char 		xlat[] = {0x64, 0x73, 0x66, 0x64, 0x3b, 0x6b, 0x66, 0x6f, \
                                  0x41, 0x2c, 0x2e, 0x69, 0x79, 0x65, 0x77, 0x72, \
                                  0x6b, 0x6c, 0x64, 0x4a, 0x4b, 0x44, 0x48, 0x53, \
                                  0x55, 0x42};

  enc_pw= FldGetTextPtr(fieldptr_text);
  enc_len= FldGetTextLength(fieldptr_text);
  dec_pw= decrypted;
  
  if(enc_len & 1)
    {
    FrmAlert(alertID_errordufflength);
    return;
    }
  if(! enc_len)
    {
    FrmAlert(alertID_errornullstring);
    return;
    }

  for (i = 0 ; i < enc_len ; ++i)
	encrypted[i]= MMToUpper(enc_pw[i]);
  enc_pw= encrypted;

  seed = (enc_pw[0] - '0') * 10 + enc_pw[1] - '0';
  if (seed > 15 || ! MMIsDigit(enc_pw[0]) || ! MMIsDigit(enc_pw[1]))
    {
    FrmAlert(alertID_errorduffseed);
    return;
    }
  for (i = 2 ; i <= enc_len ; i++) 
    {
    if(i != 2 && ! (i & 1)) 
      {
      dec_pw[i / 2 - 2]= val ^ xlat[seed++];
        val= 0;
      }
    val *= 16;
    if(MMIsDigit(enc_pw[i])) 
      {
      val += enc_pw[i] - '0';
      continue;
     }
    if(enc_pw[i] >= 'A' && enc_pw[i] <= 'F') 
      {
      val += enc_pw[i] - 'A' + 10;
      continue;
      }
    if(enc_len != i)
      {
      FrmAlert(alertID_errorduffstring);
      return;
      }
    }
  dec_pw[++i / 2] = 0;
  FldSetTextPtr(fieldptr_hex, dec_pw);
  FldRecalculateField(fieldptr_hex, true);
  FrmDrawForm(FrmGetActiveForm());
}
