#!/usr/bin/perl
eval ("use Getopt::Long;");die "[error] Getopt::Long perl module is not installed \n" if $@;

my $VERSION = "0.1";
print "$0, $PgmName, V $VERSION \n";
GetOptions ( 
            "help" =>\$usage, 
            "unpack=s" =>\$image,
            "pack=s"=>\$pack,
            "checksum=s"=>\$checksum,
            "head=s"=>\$head,
            "body=s"=>\$body,
            "readheader=s"=>\$findentry
            );

if($image){print "Unpacking image: $image \n"; unpack_i();}
elsif ($findentry){print "Print ELF headers \n"; read_elf($findentry); }
elsif($checksum){print "Calculate checksum for file $checksum \n"; checksum($checksum);}
elsif($pack && $head && $body){print "Packing image:$body Header:$header  \n"; pack_i();}
elsif ($usage){usage();}
else {&usage;} 




sub unpack_i {
my ($buff,$head,$num,$usize,$csize,$csum,$usum,$buff,$count);
my (undef, undef, undef, undef, undef, undef, undef, $size, undef, undef, undef, undef, undef) = stat($file);
open(F, "< $image") or die "Unable to open  $file ";
#Here we go with the binary mode
     binmode(F);   
#Open file to write the extractor head 
$head=$image.".head";    
open(FE, ">$head") || die "$!";
binmode(FE);      # The filehandle is now in binary.     
        
while ($num=sysread(F,$buff,4)) # Read the image	
{
#Write the head file
print FE $buff;	
$count++;
if (unpack("H*",$buff) =~ /feedface/){          #Find the magic ID offset	 
print "Written $count byte to $head \a\n";
print "Magic is found, reading the archive info \n";
close (FE); #closing the header file
#Read header 
$num=sysread(F,$buff,16);
$csize=unpack("N",substr($buff,0,4));
$usize=unpack("N",substr($buff,4,4));
$csum=unpack("H8",substr($buff,8,4));
$usum=unpack("H8",substr($buff,12,4));
print "Compressed size:$csize byte. Compressed size:$usize byte \n";
print "Compressed checksum: 0x$csum Uncompressed checksum: 0x$usum\n";
my $filename=$image.".zip";
open(FH, ">$filename") || die "$!";
binmode(FH);      # The filehandle is now in binary.
$count=0;
while ($num=sysread(F,$buff,1024)){	
print FH $buff;
$count++;
}
print "Written Kb$count to $filename \a\n";
close(F);
close(FH);  
print "uzip $filename \n";
open (UNZIP, "unzip $filename |");
while (<UNZIP>){
        print $_;      
}
print "All done!\n";
close UNZIP;
unlink ($filename);
exit (0);
}

}
close (FE);
close(F);
close(FE);
unlink($head);
print "Magic ID is not found, bad file ??? \n";
exit(1);
}


sub pack_i {
my ($buff,$pkt,);
 	#Zip file
my $ach= zip_im();
my $new_sums =pack_head($ach);
# Read header
open(F, "<$head") || die "$!";
binmode(F);      # The filehandle is now in binary.
#Open a new image for write and write header
open(FH, ">$pack") || die "$!";
binmode(FH);      # The filehandle is now in binary.
while (unpack("H*",$buff) !~ /feedface/){ 
$num=sysread(F,$buff,4); # Read the header
#print unpack("H*",$buff);
print FH $buff;		
}
close (F);
#Write all sums 
print FH $new_sums;
## Read the Archive
open(F, "<$ach") || die "$!";
binmode(F);      # The filehandle is now in binary.
print "Write arch \n";
while ($num=sysread(F,$buff,1024)){	
print FH $buff;
}
close (F);
print "All done \n";
close (FH);
exit 0;	
}


sub zip_im {
	#Zip file
print "zip $body \n";
my $archname=$body."."."zip"; 
open (ZIP, "zip -q -k -D $archname $body |");
while (<ZIP>){
        print $_;      
}
print "\a done!\n";
close ZIP;
return $archname;
	 }


sub pack_head {
my $archname=shift;	
#Pack arch header
my $usize= (stat( $body ))[7];
my $csize=(stat( $archname ))[7];
print "Calculating the unpacked checksum \n";
my $ucsum=checksum($body);
print "Calculating packed checksum \n";
my $csum=checksum($archname);
my $pkt=pack('LLLL',$csize,$usize,$csum,$ucsum);
return $pkt;
}

sub set_mashine {
my $mashine=shift;
open(F, "< $file") or die "Unable to open  $file ";
print "Read the ELF header from image $file\n";
#Here we go with the binary mode
binmode(F);
#Read the header 
     
     
     
close(F);     
}

sub read_elf {
my $file=shift;	
open(F, "< $file") or die "Unable to open  $file ";
print "Read ELF header from image $file\n";
#Here we go with the binary mode
binmode(F);
my $num=sysread(F,$buff,4);

if (unpack("H*",$buff) =~ /7f454c46/){
print "* ELF header at offset 00000000 \n";
print "ident \n";
print "magic 			    	   7f 45 4c 46 = ELF \n";
}else{ print "Not ELF file \n"; close_cor();}
$num=sysread(F,$buff,1);

if (unpack("H*",$buff) =~ /01/){
print "   class 			   01 = 32-bit objects  \n";
}elsif (unpack("H",$buff) =~ /02/){
print "   class 			   02 = 64-bit objects  \n";
}else{ close_cor();}	  
$num=sysread(F,$buff,1);
if (unpack("H*",$buff) =~ /01/){
print "   data  			   01 = LSB encoding \n";
}elsif (unpack("H*",$buff) =~ /02/){
print "   data  			   02 = MSB encoding \n";
}else{ close_cor();}	
$num=sysread(F,$buff,1);
print "   version 			   ".unpack("H*",$buff)."\n";	 
$num=sysread(F,$buff,1);
print "   OS ABI 			   ".unpack("H*",$buff)."\n";
$num=sysread(F,$buff,8);
print "   reserved 			   ".unpack ("H*",$buff)."\n";
$num=sysread(F,$buff,4);
my ($type,$machine)=unpack("H4H4",$buff);
if ($type =~ /0002/){
print "type  				   $type = executable \n";  
}else{
print "type  				   $type = unknown \n"; }
print "Arhitecture (machine)   	   $machine \n";
$num=sysread(F,$buff,20);
my ($version,$entrypoint,$program_h_off,$section_h_off,$flags)=unpack('H8H8H8H8H8',$buff);
print <<EOF ;
version 			   $version
enrtrypoint			   $entrypoint
program header offset  		   $program_h_off
section header offset 		   $section_h_off 
flags 				   $flags 
EOF
$num=sysread(F,$buff,24);
my ($elf_h_size,$prog_h_e_size,$prog_h_count,$sect_h_e_size,$sect_h_count,
$sect_h_ind)=unpack('H4H4H4H4H4H4',$buff);
print <<EOF ;
elf header size 	    	   $elf_h_size 
program header entry size      	   $prog_h_e_size
program header count           	   $prog_h_count
section header entry size	   $sect_h_e_size
section header count 		   $sect_h_count
section header strtab index	   $sect_h_ind
EOF
close(F);
exit (0);
}



sub close_cor {
	print " \a *Corrupted ELF file header \n";
	close(F); 
	exit(0);
	}


#My cisco checksum 

sub checksum {
my $file=shift;
open(F, "< $file") or die "Unable to open  $file ";
print "Calculating the checksum for file $file\n";
#Here we go with the binary mode
     binmode(F);
my $len =  (stat( $file ))[7];
my $words = $len / 4;
print "File size is $len bytes ($words words)\n"; 
my $cs = 0;
my ($rsize,$buff,@wordbuf);
print "This may take a few minutes... please wait \n";
for(;$words; $words-=$rsize)
{
       $rsize = $words < 16384 ? $words : 16384;
       read F, $buff, 4*$rsize or die "Can't read file $file : $!\n";

       @wordbuf = unpack "N*",$buff;
       foreach (@wordbuf)
       {
               $cs += $_;


# Avoid Perl integer overflow warning
# Use two multiplies by 0x10000 instead of one  0x100000000

               $cs = ($cs + 1) % (0x10000 * 0x10000) if $cs > 0xffffffff;
       }
}

printf "The checksum is 0x%lx\n",$cs;
return (sprintf("%lx", $cs)); 	
close(F);	
}




 
#Utils

sub hex2dec($) { return hex $_[0] }

sub dec2hex($) { return sprintf("%lx", $_[0])} 



sub usage {
  print <<EOF ;
This program was originally published for the book "Hacking Exposed: Cisco Networks"  
Authors Janis Vizulis, Arhont Ltd. (License GPL-2 ) Please send bugs and comments to
info[dot]arhont.com 

usage: $0  [--unpack=imagename ] 

Options:
  --upack                  Upack cisco IOS <mz> image
  --pack		   Pack new imagename
  --head		   Head (Self extractor) to pack
  --body                   Body (IOS body) to pack
  --readheader		   Read the file header
  --help                   This message
Examples :
./ciscopack.pl --unpack c2600-ik9o3s3-mz.123-6.bin
./ciscopack.pl --pack c2600-ik9o3s3-mz.123-6.bin.new --head c2600-ik9o3s3-mz.123-6.bin.head --body C2600-IK.BIN
  
EOF
  
  exit shift;
}


