


#define FIN     1
#define SYN     2
#define RST     4
#define PSH     8
#define ACK    16
#define URG    32



struct {
    unsigned int dos_delay;
    unsigned int dos_size;
    unsigned int dos_time;
    unsigned int fdsetsec;
    unsigned int fdsetusec;
} setting;



struct pseudo_header {
    unsigned long src;   // 32
    unsigned long dest;  // 32
    unsigned char res;   // 8
    unsigned char prot;  // 8
    unsigned short tot;  // 16
};



struct ip_header {
    unsigned char ihl_ver; // 4 4
    unsigned char tos;     // 8
    unsigned short len;    // 16
    unsigned short id;     // 16
    unsigned short frag;   // 16
    unsigned char ttl;     // 8
    unsigned char proto;   // 8
    unsigned short check;  // 16
    unsigned long src;     // 32
    unsigned long dest;    // 32
};



struct tcp_header {
    unsigned short srcp;           // 16
    unsigned short destp;          // 16
    unsigned long seq;             // 32
    unsigned long ackseq;          // 32
    unsigned short doff_res_flags; // 4 6 1 1 1 1 1 1
    unsigned short win;            // 16
    unsigned short check;          // 16
    unsigned short urgptr;         // 16
};



struct udp_header {
    unsigned short srcp;   // 16
    unsigned short destp;  // 16
    unsigned short len;    // 16
    unsigned short check;  // 16
};



struct icmp_header {
    unsigned char type;    // 8
    unsigned char code;    // 8
    unsigned short check;  // 16
    unsigned long data;    // 32
};
