


#include <netinet/in.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include "Flitz.h"
#include "Flitz-slave.h"
#include "net.h"
#include "proc.h"
#include "xwrapper.h"



static struct {
    int socket;
    char *inbuf;
    unsigned long who;
} masterlisten;



int net_udplisten(int port)
{
    int s, arg;
    struct sockaddr_in addr;

    memset(&addr, 0x00, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = htons(port);

    if ((s = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0) {
        return(-1);
    }

    arg = 1;
    setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, &arg, sizeof(arg));
    arg = 0;
    setsockopt(s, SOL_SOCKET, SO_LINGER, &arg, sizeof(arg));
    arg = 1;
    setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &arg, sizeof(arg));

    if (bind(s, (struct sockaddr *) &addr, sizeof(struct sockaddr)) < 0) {
        close(s);
        return(-1);
    }
    return(s);
}



int net_setupudp()
{
    int udp;

    memset(&masterlisten, 0x00, sizeof(masterlisten));
    udp = net_udplisten(SLAVE_PORT);

    if (udp < 0) {
        return(-1);
    }
    masterlisten.socket = udp;
    return(1);
}



void net_read()
{
    int re, len;
    char data[1024], *str_ptr;
    fd_set set;
    struct timeval tm;
    struct sockaddr_in th_addr;

    memset(&th_addr, 0x00, sizeof(struct sockaddr_in));
    tm.tv_sec = setting.fdsetsec;
    tm.tv_usec = setting.fdsetusec;
    FD_ZERO(&set);

    FD_SET(masterlisten.socket, &set);

    re = select(FD_SETSIZE, &set, NULL, NULL, &tm);
    if (re > 0) {
        if (FD_ISSET(masterlisten.socket, &set)) {

            memset(&data, 0x00, sizeof(data));
            re = recvfrom(masterlisten.socket, data, 1023, 0,
                          (struct sockaddr *) &th_addr, &len);

            masterlisten.who = th_addr.sin_addr.s_addr;
            if (re > 0) {
                if (masterlisten.inbuf == NULL) {
                    str_ptr = masterlisten.inbuf;
                    masterlisten.inbuf = (char *) xmalloc(strlen(data) + 1);
                    strcpy(masterlisten.inbuf, data);
                }
                else {
                    str_ptr = masterlisten.inbuf;
                    masterlisten.inbuf = (char *) xmalloc(strlen(str_ptr) +
                                                         strlen(data) + 1);
                    strcpy(masterlisten.inbuf, str_ptr);
                    strcat(masterlisten.inbuf, data);
                    free(str_ptr);
                }
            }
        }
    }
    return;
}



void net_parse()
{
    int d1, d2, c;
    char temp[1024];

    if (masterlisten.inbuf != NULL) {
        if (strlen(masterlisten.inbuf) > 1023) {
            free(masterlisten.inbuf);
            masterlisten.inbuf = NULL;
            return;
        }
        d1 = 0;
        d2 = 0;
        c = 0;
        while (masterlisten.inbuf[d1] != '\0') {
            if ((masterlisten.inbuf[d1] != '\n') &&
                (masterlisten.inbuf[d1] != '\r')) {
                temp[d2] = masterlisten.inbuf[d1];
            }
            else if (masterlisten.inbuf[d1] == '\r') {
                --d2;
            }
            else if (masterlisten.inbuf[d1] == '\n') {
                temp[d2] = '\0';
                proc_line(masterlisten.who, temp);
                c = d1;
                ++c;
                if (masterlisten.inbuf[c] == '\0') {
                    free(masterlisten.inbuf);
                    masterlisten.inbuf = NULL;
                    return;
                }
                d2 = -1;
            }
            ++d1;
            ++d2;
        }
        temp[d2] = '\0';
        free(masterlisten.inbuf);
        masterlisten.inbuf = (char *) xmalloc(strlen(temp) + 1);
        strcpy(masterlisten.inbuf, temp);
    }
    return;
}



void net_send(unsigned long m, char *line)
{
    int s;
    struct sockaddr_in addr;

    memset(&addr, 0x00, sizeof(struct sockaddr_in));
    s = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = m;
    addr.sin_port = htons(PING_PORT);

    sendto(s, line, strlen(line), 0, (struct sockaddr *) &addr, sizeof(addr));
    close(s);
    return;
}
