#!/usr/bin/perl

require 'common.pl';
use File::Copy;
use Net::Ping;
use Socket;
use Curses;

$SIG{KILL} = $sit{TERM} = $SIG{INT} = \&stop_kill;
$SIG{ALRM} = \&stop_alarm;
$SIG{PIPE} = 'IGNORE';

#
# input daten werden ausgewertet und 
# entsprechende aktionen ausgefuehrt
#

help() unless (@ARGV == 2) || (@ARGV == 3) || (@ARGV == 4);

my($pair) = shift;
my($bereich) = shift;
local($pool) = shift;
local($session_id) = shift;
my($pool_entry);
my(@hosts) = ();
my(@pool) = ();
my($conf_stat) = 0;
local($pool_count) = 0;
help() unless ($bereich =~ /\d{1}\-\d{1}/);
($username, $password) = split(/:/, $pair, 2);
my($min, $max) = split(/-/, $bereich, 2);

if ((!$pool) || ($pool !~ /\d{1}/)) {
   $pool = 0 ;
} else {
   chomp($pool);
}   


#help() if ($min > $max) || ($min < 1) || ($max > 8) || ($min >= $max);
help() if ($min > $max) || ($min < 4) || ($max > 8);


#
# das konfigurations file wird eingelesen, 
# ausgewertet. gueltige hoststs auf connectivity
# abchecken
#

($characters, @hosts) = get_config();

#
# pool, zeichen und stellen vorbereiten fuer
# die serveranfrage
#

if (-e $session_dir . $session_id) {
   print "\n\n\n\n\n\n\n\n\n";
   print "es existiert bereits eine session \"$session_id\". \n";
   print "soll an dieser session weitergearbeitet werden? [j|n] : ";
   my($decision);
   chomp($decision = <STDIN>);
   if ($decision =~ /^[yYjJ]{1}/) {
      print "ok, alte session wird weiter verwendet\n";
      copy($session_dir . $session_id, $pool_file);
      local($pool_count) = 0;
      $max_pools = get_max_pools($session_dir . $session_id);
   } elsif ($decision =~ /^[Nn]{1}/) {
      print "neue session wird begonnen\n";
      open(POOLS, ">$pool_file") || give_up($pool_file, $!, "permissions vom lokalem verzeichnis ueberpruefen");
      @pool = make_pool($characters, $min, $max);
      foreach $i (@pool) {
         print POOLS "$i\n";
      }
      close(POOLS) || give_up($pool_file, $!, "permissions vom lokalem verzeichnis ueberpruefen");
      $max_pools = get_max_pools($pool_file);
   } else {
      print "falsche eingabe. abbruch\n";
      exit(1);
   }
} else {
   open(POOLS, ">$pool_file") || give_up($pool_file, $!, "permissions vom lokalem verzeichnis ueberpruefen");
   @pool = make_pool($characters, $min, $max);
   foreach $i (@pool) {
      print POOLS "$i\n";
   }
   close(POOLS) || give_up($pool_file, $!, "permissions vom lokalem verzeichnis ueberpruefen");
   $max_pools = get_max_pools($pool_file);
}

#
# ok baby, lets rock n rol. sockets werden geoeffnet
# und es wird abgecrackt. 
#

my $status = 1;
my $anzahl_sockets = @hosts;
connects(@hosts);

my @splitter;
my $start_time = time;
$| = 1;

#
# statistiken initialisieren
#

init_file($statistik);
init_file($statistik_roh);
init_file($new_statistik_roh);
init_file($new_statistik);
init_file($act_pool_file);
initscr();
noecho();
sleep(2);
while($status) {

#
# servereintraege aus der hostliste in array stopfen, und
# hosts_liste wieder fuer updates und deletes freigeben.
#

   @hosts = get_hosts();
   foreach $server_addr (@hosts) {
      my $buff = '';
      my $socket_name = "SOCKET" . $server_addr;
      if ( send $socket_name, "STAT  ", 0) {
         recv $socket_name, $buff, 512, 0;
         $buff =~ s/\\n//g;
         @splitter = split(/:/, $buff, 5);
         chomp($splitter[4]);
	 if (send $socket_name, "AYT  ", 0) {
	    undef($ayt_buff);
            recv $socket_name, $ayt_buff, 512, 0;
	    $ayt_buff =~ /(\d+)/;
	 } else {
            del_host($socket_name);
   	    del_stat($socket_name);
	    close($socket_name) || give_up($socket_name, $!, "internet socket fehler");
	    add_old_pool_to_stack($socket_name);
	    next;
	 }   
      } else {
         del_host($socket_name);
	 del_stat($socket_name);
	 close($socket_name) || give_up($socket_name, $!, "internet socket fehler");
	 add_old_pool_to_stack($socket_name);
	 next;
      }
#
# status: noch nicht gestartet
#
      if ($buff =~ /:waiting/) {
         if (defined($pool_entry = get_next_pool())) {
            if (send $socket_name, "DATA $pair:$pool_entry  ",0) {
               recv $socket_name, $buff, 512, 0;
	       screen(0);
	       update_act_pool_file($socket_name, $pool_entry);
	    } else {
               del_host($socket_name);
	       del_stat($socket_name);
	       close($socket_name) || give_up($socket_name, $!, "internet socket fehler");
	       add_old_pool_to_stack($socket_name);
  	       next;
	    }   
	 } else {
	    suspend_host($socket_name);
	 }
#
# status: neuer pool
#
      } elsif ($buff =~ /:next/) {
         $buff =~ s/OK//g;
         $buff =~ s/\s+?//g;
         @splitter = split(/:/, $buff);
         statistik_roh($socket_name, $splitter[0], $splitter[1], $splitter[2], $splitter[3], $splitter[4]);
         if (defined($pool_entry = get_next_pool())) {
            if (send $socket_name, "DATA $pair:$pool_entry  ", 0) {
               recv $socket_name, $buff, 512, 0;
	       screen(0);
	       $pool_count++;
	       update_act_pool_file($socket_name, $pool_entry);
	    } else {
               del_host($socket_name);
	       del_stat($socket_name);
	       close($socket_name) || give_up($socket_name, $!, "internet socket fehler");
	       add_old_pool_to_stack($socket_name);
  	       next;
	    }   
	 } else {
	    suspend_host($socket_name);
	 }

#
# status: geknackt
#
      } elsif ($buff =~ /:cracked:/) {
         $buff =~ s/OK//g;
         $buff =~ s/\s+?//g;
         @splitter2 = split(/:/, $buff);
         statistik_roh($socket_name, $splitter2[0], $splitter2[1], $splitter2[2], $splitter2[3], $splitter[4]);
	 screen(1, $splitter2[4],$splitter2[5]);
  	 $status = 0;
         last;
#
# status: immer noch am cracken
#
      } elsif ($buff =~ /:continue/) {
         $buff =~ s/OK//g;
         $buff =~ s/\s+?//g;
 	 @splitter = split(/:/, $buff);
         statistik_roh($socket_name, $splitter[0], $splitter[1], $splitter[2], $splitter[3], $splitter[4]);
   	 screen(0);
      }
   }
   sleep(2);
   $conf_stat = check_stat();
   if ($conf_stat == 0) {
#     noop =)
   } elsif ($conf_stat == 1) {
      screen(3);
      copy($pool_file, $session_dir . $session_id);
      last;
   } elsif ($conf_stat == 2) {
      screen(2);
   } elsif ($conf_stat == 3) {
      screen(3);
      copy($pool_file, $session_dir . $session_id);
      last;
   } elsif ($conf_stat == 4) {
      screen(4);
      copy($pool_file, $session_dir . $session_id);
      last;
   } else {
      
   }
}
unlink($session_dir . $session_id);
reactivate_hosts();
close_connections();

