#ifndef CONFIG_H
#define CONFIG_H

#define SUCCESS 0
#define FAILURE 0

/*
 * Minimum number of matches to occur before we decide a host is infected
 */
#define INFECTED 2

/* 
 * Memory for miscellaneous buffers
 */
#define BUFSIZE 512

/*
 * Where to read config data of what to send/recv
 */
#define DEFAULT_YYIN "config.txt"

/*
 * designed for struct timeval where u_sec is in microsecs
 */
#define TIMEVAL_SUBTRACT(a,b) (((a).tv_sec - (b).tv_sec) * 1000000 + (a).tv_usec - (b).tv_usec)

#endif
