%{
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "y.tab.h"
/* 
  our grammer for the config file is:
	begin <ID>
	  send <PROTOCOL> <OPTIONS>
	  recv <PROTOCOL> <OPTIONS>
	end <ID>

	PROTOCOLS are:
	  ICMP, UDP, TCP

	OPTIONS are name=value:
	  ICMP: <seq>|<id>|<type>|<code>|<data>
	  UDP: <sport>|<dport>|<data>
	  TCP: <sport>|<dport>|<seq>|<ack>|<win>|<data>

	NOTE: We treat numbers as strings and let the compiler worry about
		conversions internally 
*/
%}

ws	[ \t]+
nl	\n
comment	#.*
ident	[a-zA-Z][a-zA-Z0-9]*
num	[0-9]+
qt	\"[^\"\n]*[\"\n]
%%
{ws}		;
{comment}	;
send		{ return SEND; }
recv		{ return RECV; }
start		{ return START; }
icmp		{ return ICMP; }
tcp		{ return TCP; }
udp		{ return UDP; }
sport=		{ return SPORT; }
dport=		{ return DPORT; }
seq=		{ return SEQ; }
id=		{ return ID; }
type=		{ return TYPE; }
code=		{ return CODE; }
data=		{ return DATA; }
ack=		{ return ACK; }
win=		{ return WIN; }
nmatch=		{ return NMATCH; }
end		{ return END; }
{ident}		{ yylval.string = (char *)strdup(yytext); return QSTRING; }
{num}		{ yylval.string = (char *)strdup(yytext); return QSTRING; }
{qt}		{ yylval.string = (char *)strdup(yytext + 1);  /* Skip quote */
		   if(yylval.string[yyleng-2] != '"')
			fprintf(stderr, "Unterminated string");
		   else 
			yylval.string[yyleng-2]='\0';
		   return QSTRING;
		}
{nl}		{ ; }
.		{ return yytext[0]; }
%%
int yywrap() { return 1; }
