
# line 2 "parser.y"
#include <stdio.h>
#include <strings.h>
#include "config.h"
#include "netconfig.h"

extern struct icmp_item *ICMP_Send;
extern struct icmp_item *ICMP_Recv;
extern struct udp_item *UDP_Send;
extern struct udp_item *UDP_Recv;
extern u_short ConfigNum;

/* Fields that might be set */
u_long sport=-1, dport=-1, seq=-1, id=-1, type=-1, code=-1, ack=-1, win=-1;
u_long nmatch=-1;

/* Data in the packet */
char *data;

/* Name of current ddos we're working on */
char ddos_name[BUFSIZE];

extern int errno;

# line 26 "parser.y"
typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
	char *string;
	u_short us;
	u_long ul;
} YYSTYPE;
# define START 257
# define END 258
# define SEND 259
# define RECV 260
# define ICMP 261
# define UDP 262
# define TCP 263
# define SPORT 264
# define DPORT 265
# define SEQ 266
# define ID 267
# define TYPE 268
# define CODE 269
# define DATA 270
# define ACK 271
# define WIN 272
# define NMATCH 273
# define QSTRING 274

#include <inttypes.h>

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
#ifndef yyerror
#if defined(__cplusplus)
	void yyerror(const char *);
#endif
#endif
#ifndef yylex
	int yylex(void);
#endif
	int yyparse(void);
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#endif

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 110 "parser.y"


add_icmp(struct icmp_item **Head)
{
  struct icmp_item *current = malloc(sizeof(struct icmp_item));
  if(current==NULL){
	perror("malloc failed. aborting.\n");
	exit(FAILURE);
  }

 current->string = data;
 strncpy(current->name, ddos_name, BUFSIZE-1);
 current->type = type;
 current->id = id;
 current->code = code;
 current->seq = seq;
 current->nmatch = nmatch;
 current->Next = NULL;

 if(*Head == NULL){
   *Head = current;
 } else {
   current->Next = *Head;
   *Head = current;
 }
}

add_udp(struct udp_item **Head)
{
 struct udp_item *current = malloc(sizeof(struct udp_item));
 if(current==NULL){
    perror("malloc failed. *aborting*\n");
	exit(FAILURE);
 }
 current->sport = sport;
 current->dport = dport;
 strncpy(current->name, ddos_name, BUFSIZE-1);
 current->string = data;
 current->nmatch=nmatch;
 current->Next = NULL;
 if(*Head == NULL){
	*Head = current;
 } else {
   current->Next = *Head;
   *Head = current;
 }
}
static void
yyerror(char *msg)
{
  fprintf(stderr, "%s\n", msg);
  exit(0);
}

static const yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 32
# define YYLAST 47
static const yytabelem yyact[]={

    27,    28,    29,    30,    31,    34,    35,    32,     4,    47,
    46,    36,    45,    44,    37,    33,    43,    42,    41,    40,
    39,    38,    14,    11,    18,    20,    19,     8,     9,    10,
    17,    16,    15,     7,     6,    25,    26,    24,     5,    13,
    12,    21,    22,    23,     3,     2,     1 };
static const yytabelem yypact[]={

-10000000,  -249,-10000000,  -231,  -251,  -231,-10000000,-10000000,  -252,  -237,
  -237,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,  -266,  -259,-10000000,  -253,  -254,  -255,
  -256,  -257,  -258,-10000000,  -261,  -262,  -264,  -265,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000 };
static const yytabelem yypgo[]={

     0,    46,    45,    44,    38,    34,    33,    32,    31,    30,
    37,    36,    35,    15 };
static const yytabelem yyr1[]={

     0,     1,     1,     2,     2,     4,     4,     6,     6,     6,
     6,     6,     6,     7,    10,    10,    11,    11,    11,    11,
    11,    11,     9,    12,    12,    13,    13,    13,    13,     8,
     3,     5 };
static const yytabelem yyr2[]={

     0,     0,     4,     6,     4,     2,     4,     5,     4,     5,
     5,     4,     5,     4,     0,     4,     5,     5,     5,     5,
     5,     5,     4,     0,     4,     5,     5,     5,     5,     3,
     5,     5 };
static const yytabelem yychk[]={

-10000000,    -1,    -2,    -3,   257,    -4,    -5,    -6,   258,   259,
   260,   274,    -5,    -6,   274,    -7,    -8,    -9,   261,   263,
   262,    -9,    -8,    -7,   -10,   -12,   -11,   266,   267,   268,
   269,   270,   273,   -13,   264,   265,   270,   273,   274,   274,
   274,   274,   274,   274,   274,   274,   274,   274 };
static const yytabelem yydef[]={

     1,    -2,     2,     0,     0,     0,     4,     5,     0,     0,
     0,    30,     3,     6,    31,     7,     8,     9,    14,    29,
    23,    10,    11,    12,    13,    22,    15,     0,     0,     0,
     0,     0,     0,    24,     0,     0,     0,     0,    16,    17,
    18,    19,    20,    21,    25,    26,    27,    28 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"START",	257,
	"END",	258,
	"SEND",	259,
	"RECV",	260,
	"ICMP",	261,
	"UDP",	262,
	"TCP",	263,
	"SPORT",	264,
	"DPORT",	265,
	"SEQ",	266,
	"ID",	267,
	"TYPE",	268,
	"CODE",	269,
	"DATA",	270,
	"ACK",	271,
	"WIN",	272,
	"NMATCH",	273,
	"QSTRING",	274,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"ddoses : /* empty */",
	"ddoses : ddoses ddos",
	"ddos : ddos_name ddos_contents ddos_terminator",
	"ddos : ddos_name ddos_terminator",
	"ddos_contents : ddos_content",
	"ddos_contents : ddos_contents ddos_content",
	"ddos_content : SEND proto_icmp",
	"ddos_content : SEND proto_tcp",
	"ddos_content : SEND proto_udp",
	"ddos_content : RECV proto_udp",
	"ddos_content : RECV proto_tcp",
	"ddos_content : RECV proto_icmp",
	"proto_icmp : ICMP icmp_options",
	"icmp_options : /* empty */",
	"icmp_options : icmp_options icmp_option",
	"icmp_option : SEQ QSTRING",
	"icmp_option : ID QSTRING",
	"icmp_option : TYPE QSTRING",
	"icmp_option : CODE QSTRING",
	"icmp_option : DATA QSTRING",
	"icmp_option : NMATCH QSTRING",
	"proto_udp : UDP udp_options",
	"udp_options : /* empty */",
	"udp_options : udp_options udp_option",
	"udp_option : SPORT QSTRING",
	"udp_option : DPORT QSTRING",
	"udp_option : DATA QSTRING",
	"udp_option : NMATCH QSTRING",
	"proto_tcp : TCP",
	"ddos_name : START QSTRING",
	"ddos_terminator : END QSTRING",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.15	97/12/08 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yymaxdepth * sizeof (type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt = 0;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside
	switch should never be executed
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			long yyps_index = (yy_ps - yys);
			long yypv_index = (yy_pv - yyv);
			long yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register const int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 7:
# line 47 "parser.y"
{ 
			add_icmp(&ICMP_Send); data = NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
		  } break;
case 9:
# line 52 "parser.y"
{
			add_udp(&UDP_Send); data = NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
		} break;
case 10:
# line 56 "parser.y"
{
			add_udp(&UDP_Recv); data = NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
		} break;
case 12:
# line 61 "parser.y"
{
			add_icmp(&ICMP_Recv); data=NULL;
			nmatch=sport=dport=seq=id=type=code=ack=win=-1;
	} break;
case 16:
# line 71 "parser.y"
{ seq = atoi(yypvt[-0].string); } break;
case 17:
# line 72 "parser.y"
{ id = atoi(yypvt[-0].string); } break;
case 18:
# line 73 "parser.y"
{ type = atoi(yypvt[-0].string); } break;
case 19:
# line 74 "parser.y"
{ code = atoi(yypvt[-0].string); } break;
case 20:
# line 75 "parser.y"
{ 
	      data = malloc(strlen(yypvt[-0].string) * (sizeof(char))); 
	      if(data == NULL){
		  fprintf(stderr, "malloc error. *aborting*\n");
		  exit(FAILURE);
	      }
	     strcpy(data, yypvt[-0].string);
	  } break;
case 21:
# line 83 "parser.y"
{ nmatch = atoi(yypvt[-0].string); } break;
case 25:
# line 90 "parser.y"
{ sport = atoi(yypvt[-0].string); } break;
case 26:
# line 91 "parser.y"
{ dport = atoi(yypvt[-0].string); } break;
case 27:
# line 92 "parser.y"
{
		data = malloc(strlen(yypvt[-0].string) * (sizeof(char)));
		if(data == NULL){
			fprintf(stderr, "malloc error. *aborting*\n");
			exit(FAILURE);
		}
		strcpy(data, yypvt[-0].string);
	} break;
case 28:
# line 100 "parser.y"
{ nmatch = atoi(yypvt[-0].string); } break;
case 29:
# line 102 "parser.y"
{ printf("TCP Not implemented\n"); } break;
case 30:
# line 104 "parser.y"
{ strncpy(ddos_name, (yypvt[-0].string), sizeof(ddos_name)); } break;
case 31:
# line 106 "parser.y"
{ ConfigNum++; 
	    bzero(ddos_name, sizeof(ddos_name));
	} break;
# line	531 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

