# this module contains global variables used by the system.

package SM::GV;
use SM::Conf;
use strict;
use warnings;

our(@ISA, @EXPORT_OK);

@ISA    = qw(Exporter);
@EXPORT_OK = qw(%log_record);

# data sctructure to hold the weights
# for the simple weighted average
our @sum;

# predefine the array size
$#sum=$SM::Conf::WMA_2_EWMA;

# variable for marking
# the first run
our $firstrun=1;

# will contain a timestamp
# with the point in time
# of the last statistical
# calculations
our $last_written_stat=0;

# this variable will
# contain the load
# average value from 
# the proc filesystem
our $load_average=0;

# number of months since januar
# needed to convert a timestamp from a logfile to the number of
# seconds since January 1, 1970 (on Posix systems)
our %month = (Jan=>0, Feb=>1, Mar=>2, Apr=>3, May=>4, Jun=>5,
          Jul=>6, Aug=>7, Sep=>8, Oct=>9, Nov=>10, Dec=>11);


1;
