# this module intializes the system including datastructure,
# logfiles and signal handlers

package SM::Init;

use SM::Defs;
use SM::GV;
use SM::Tools;
use SM::Blacklist;
use SM::HashTable;
require File::Tail if ($SM::Conf::HAVE_FILE_TAIL); 

use strict;
use warnings;

# parse the comand line arguments.
# currently we just look if we should read from STDIN
# or open a logfile.
sub parse_cmd_args {
	# get filehandle from stdin
	if($_[0] && $_[0] eq "-") {
	    	*FH = *STDIN;
	# or from the specified logfile
	} else {
   	 	*FH=SM::Init::open_logfile(shift());
	}
	return *FH;
}

# this functions constructs a static array used for the weighted
# moving average. it will just be used aslong as not values are
# there to do an exponential average. 
sub init_sum {
	$SM::GV::sum[0]=0;	
	for(my $i=1;$i<=$SM::Conf::WMA_2_EWMA;$i++) {
		$SM::GV::sum[$i]=$SM::GV::sum[$i-1]+$i;
	}
}


# initialize the main datastructure. its an array that gets used
# as hashtable. each array element is a container for a linked
# list which gets used if a hashkey collision occures.
sub init_struct {
	for(my $i=0;$i<$SM::Conf::HASH_TBL_SIZE;$i++) {
		$SM::HashTable::htbl[$i] = [undef, undef, 0];
		$SM::HashTable::htbl[$i][NEXT] = 
		$SM::HashTable::htbl[$i][PREV] = $SM::HashTable::htbl[$i];
	}
}

# open the logfile. there are two methods.
# LIVE mode, where only new lines inthe logfile are read,
#            this can be seen as continiously reading from it and
# DEAD mode, where a finished logfile is read 
#			 and processed at maximum speed
sub open_logfile {

	# if no argument is given, thake the default logfile.	
	my $file=shift() || $SM::Conf::DEF_LOGFILE;

	# extract the base filename.
	my ($filename)=($file=~m/([^\/]+)$/);

	# open the logfile in ...
	# ...LIVE mode
	if($SM::Conf::MODE==LIVE) {

		if(!$SM::Conf::HAVE_FILE_TAIL) {
			SM:Tools::cleanup("you configured to not use the module File::Tail \n" .
				"enable and install it if neccessary\n"); 
		}

		# open the file for continously reading in 'tie' mode
		# that we can read from <FH> and don't hava a wrapper
		# object around the filehandle
		my $ref=tie *FH,"File::Tail",(name=>$file);
	
		# wait for X seconds after startup before try to read new data 
		$ref->interval(0.5);
	
		# the Tail module tries to predict when new data should
		# be rady to read. until then it sleeps...
		# maxinterval sets the maximal number of seconds
		# until the module tries to read new data 
		$ref->maxinterval($SM::Conf::FH_MAXINTERVAL);
	
	# ...DEAD mode
	} else {
		# open a normal filehandle to $file
		open(FH, $file) || cleanup("could not open file $file: $!");
	}
	return *FH;
}

# check if the applications specified in the config file are in place
sub check_ext_apps {
	my $prog;
	foreach $prog (keys %SM::Conf::CMD) {
		cleanup("$SM::Conf::CMD{$prog}: $!") if (! -f $SM::Conf::CMD{$prog});
	}
}

# register some signal handlers.
sub register_sig_handler {

	# if we get a USR1 Signal call the handle_signal function
	$SIG{USR1} = \&SM::Tools::handle_signal;

	# the interrupt signal will cause the program to end
	# so we have to remove the pidfile
	$SIG{INT} = \&SM::Tools::remove_pid_file; 
}

# open the alert logfiles
sub open_alert_logs {
	# for each alert level a separate logfile
	open(FH0, ">", $SM::Conf::ALERT_LOG_PREFIX."0") || cleanup("$!");
	open(FH1, ">", $SM::Conf::ALERT_LOG_PREFIX."1") || cleanup("$!");
	open(FH2, ">", $SM::Conf::ALERT_LOG_PREFIX."2") || cleanup("$!");

	# save the filehandles
	# as global variables
	*SM::GV::FHA0=*FH0;
	*SM::GV::FHA1=*FH1;
	*SM::GV::FHA2=*FH2;
}

1;
