# this module is just used for debuging purposes.
# you can give it a reference to a datastructure
# and it will be printed in a perl hacker
# readable fashion. so if you understand the
# output, you won't need comments for this code,
# this is why it isn't documented... 

package SM::PP; # pretty print :-)
use strict;
use warnings;

my $level=-1; # Level of indentation
my $label=0;
my %already_seen;

sub pretty_print {
	my $var;
	foreach $var (@_) {
		if (ref ($var)) {
			print_ref($var);
		} else {
			print_scalar($var);
		}
	}
	%already_seen=();
}

sub print_scalar {
	++$level;
	my $var = shift;
	print_indented ($var);
	--$level;
}

sub print_ref {
	my $r = shift;
	if (exists ($already_seen{$r})) {
		++$level;
		print_indented ("$r (Seen earlier) #" . $already_seen{$r});
		--$level;
		return;
	} else {
		$already_seen{$r}=++$label;
	}
	my $ref_type = ref($r);
	if ($ref_type eq "ARRAY") {
		print_array($r);
	} elsif ($ref_type eq "SCALAR") {
		print "Ref -> $r";
		print_scalar($$r);
	} elsif ($ref_type eq "HASH") {
		print_hash($r);
	} elsif ($ref_type eq "REF") {
		++$level;
		print_indented("Ref -> ($r)");
		print_ref($$r);
		--$level;
	} else {
		print_indented ("$ref_type (not supported)");
	}
}

sub print_array {
	my ($r_array) = @_;
	my ($var);
	++$level;
	print_indented ("[ # $r_array - $label");
	foreach $var (@$r_array) {
		if (ref ($var)) {
			print_ref($var);
		} else {
			print_scalar($var);
		}
	}
	print_indented ("]");
	--$level;
}

sub print_hash {
	my($r_hash) = @_;
	my($key, $val);
	++$level; 
	print_indented ("{ # $r_hash - $label");
	while (($key, $val) = each %$r_hash) {
		$val = ($val ? $val : '""');
		++$level;
		if (ref ($val)) {
			print_indented ("$key => ");
			print_ref($val);
		} else {
			print_indented ("$key => $val");
		}
		--$level;
	}
	print_indented ("}");
	--$level;
}

sub print_indented {
	my $spaces = ":  " x $level;
	if(defined($_[0])) {
		print "${spaces}$_[0]\n";
	}
}
1;
