# this module creates and maintains the round robin database 
# for the key data of the scrutinizer system.

package SM::RRD;
use SM::Conf;
use warnings;
use strict;

use RRDs;

# the initialization creates the database with its final size.
# one of the key features of a rrd is that its not expanding
# over time.
sub init {

	# get the argument (start time)
	my ($timestamp) = @_;
	my ($filename);


	# if the file doesn't already exist and the
	# destination is writeable, create a new db
	if(! -e $SM::Conf::RRD_DB || ! -R $SM::Conf::RRD_DB) {
		RRDs::create(
			# define the db-name, stepwith (one second)
		    $SM::Conf::RRD_DB, "--step=1",
			# the point in time of the start
		    "--start=" . ($timestamp-10),
			# define different data sources
		    "DS:requests:GAUGE:1:U:U",		# requests
		    "DS:transfered:GAUGE:1:U:U",	# bytes transfered
		    "DS:alert:GAUGE:1:U:U",			# alert level
		    "DS:entries:GAUGE:1:U:U",		# entries in datastructure
		    "DS:cpu:GAUGE:1:U:U",			# cpu load
			# define different archives
			# which will contain the data
			# in different densities
			# one for average values
		    "RRA:AVERAGE:0.9:1:600",	  	# sec -> 10min
		    "RRA:AVERAGE:0.9:60:1440", 		# min -> day
		    "RRA:AVERAGE:0.9:600:1008", 	# 10min -> week
		    "RRA:AVERAGE:0.9:3600:720", 	# hour -> month 
		    "RRA:AVERAGE:0.9:86400:365", 	# day -> year 
		    "RRA:AVERAGE:0.9:604800:260", 	# week -> decade/2 
			# one for the peak values
		    "RRA:MAX:0.9:1:600",		  	# sec -> 10min
		    "RRA:MAX:0.9:60:1440", 			# min -> day
		    "RRA:MAX:0.9:600:1008", 		# 10min -> week
		    "RRA:MAX:0.9:3600:720", 		# hour -> month 
		    "RRA:MAX:0.9:86400:365", 		# day -> year 
		    "RRA:MAX:0.9:604800:260",	 	# week -> decade/2 

		# if the file can't be created,
		# print an error
		) or SM::Tools::cleanup("Cannot create rrd ($RRDs::error)");

	}	
}

# update the database
sub update {
	# get the values as arguments
	my (@values) = @_;

	# create an entry from the arguments
	my $entry = join(":",@values);

	# update the db with all values
    RRDs::update($SM::Conf::RRD_DB, $entry)
		# print an error if it fails
		or warn "Cannot update rrd avg ($!) -> $entry";
}

1;
