# this module creates ALL statistics used by scrutinizer. 
# It loops thru all defined statistical tests and write 
# the results into the corresponding logfile for later plotting.

package SM::Statistic;
use SM::Defs;
use SM::Conf;
use SM::GV;
use SM::HashTable;
use strict;
use warnings;

our (%stat); # the hash to hold all the statistics

# this prints in a simple manner whats currently
# stored in our hashtable.
sub data_struct {
	# loop thru all elements of the data structure
	for(my $i=0;$i<$SM::Conf::HASH_TBL_SIZE;$i++) {

		# skip empty ones
		next if($SM::HashTable::htbl[$i][VAL] == 0);

		# grab a non-empty one
		my $cur=\@{$SM::HashTable::htbl[$i][NEXT]};
	
		# for each element of the linked list
		for(my $j=0;$j<$SM::HashTable::htbl[$i][VAL];$j++) {
			# print out the content
			print($i, " ", $SM::HashTable::htbl[$i][VAL], " " ,
				" "x$j, $cur->[VAL]->{ip}, " [", $cur->[VAL]->{count}, "]",
				" " , $cur->[VAL]->{last_ts}, "\n");
			# grab the next
			$cur=$cur->[NEXT];
		}
	}
}

# write down all statistics
sub write_stat {

	# the keys of %stat are the different tests
	foreach my $key (keys %stat) {

		# print out debug informations if enabled
		print STDERR "creating stat_$key.log\n" if ($SM::Conf::DEBUG>0); 

		# open the to the statistic corresponding logfile
		open(FH, ">" . $SM::Conf::LOG_DIR . "stat_$key.log") ||
			warn "Write stat_$key.log failed: $!";

		# create variables for
		# storing sub results
		my($sum,$cdf,$elements);
		my(@susp_periode,@susp_ma);

		# get the number of elements
		# contained by the stat{key} array
		$elements=scalar(@{$stat{$key}});

		# count the sum of all elements	
		for(my $i=0,$sum=0;$i<=$elements;$i++) {
			# increment the sum
			$sum+=$stat{$key}[$i] if(defined($stat{$key}[$i]));
		}

		# print the index, count, probability and cdf value for all elements
		for(my $i=0,$cdf=0;$i<=$elements;$i++) {
			# only if a element is stored
			if(defined($stat{$key}[$i])) {
				# increment the prob. distr. function
				$cdf+=$stat{$key}[$i]/$sum;
				# write the statistics into the corresponding logfile
				print(FH $i, " ", $stat{$key}[$i]," ",
					$stat{$key}[$i]/$sum," ", $cdf, "\n");
			}
		}
		# close the filehandle
		close(FH);
	}
}
1;
