# perl script which generates the graphs for the webgui

use RRDs;
use File::Copy;

# get the parameters
my ($DB, $destination_dir) = @ARGV;

# get the last timestamp
$rrd_last = RRDs::last $DB;

# create these graphs
%graphs = 	(
				1 => "alert",
				2 => "requests",
				3 => "transfered",
				4 => "entries",
				5 => "cpu"
			);

# with these according labels
%g_labels =	(
				1 => "alert level",
				2 => "requests per second",
				3 => "bytes per second",
				4 => "number of entries",
				5 => "number of concurrent processes"
			);

# for these durations back
# in time
%lasts =	(
				1 => int($rrd_last/60)*60,
				2 => int($rrd_last/600)*600,
				3 => int($rrd_last/3600)*3600,
				4 => $rrd_last,
				5 => $rrd_last,
				6 => $rrd_last,
				7 => $rrd_last
			);

# get the according start
# points in time
%firsts = 	(
				1 => ($lasts{1} - 60),
				2 => ($lasts{2} - 900),
				3 => ($lasts{3} - 3600),
				4 => ($lasts{4} - 86400),
				5 => ($lasts{5} - 604800),
				6 => ($lasts{6} - 2592000),
				7 => ($lasts{7} - 31536000)
			);

# set the titles
%f_labels =	(
				1 => "minute",
				2 => "15 minutes",
				3 => "hour",
				4 => "24 hours",
				5 => "week",
				6 => "month",
				7 => "year"
			);

# set the filename-part
%f_fnames =	(
				1 => "min",
				2 => "15min",
				3 => "hour",
				4 => "day",
				5 => "week",
				6 => "month",
				7 => "year"
			);

# do for each graph
foreach $key (keys %graphs)
{
	my $g = $graphs{$key};
	my $l = $g_labels{$key};

	# for each duration
	foreach $f_key (keys %firsts)
	{	
		# get the name & timestamps
		my $d = $f_fnames{$f_key};
		my $t = $f_labels{$f_key};
		my $first = $firsts{$f_key};
		my $last = $lasts{$f_key};

		# create the filename
		my $filename =$g."_".$d.".png"; 

		# create the gaph
		RRDs::graph $filename, 
		  "--title", "Last ".$t.": ".uc($g), 
		  "--start", "$first",
		  "--end", "$last",
		  "--interlace", 
		  "--imgformat","PNG",
		  "--width=500",
		  "--height=150",
		  "--vertical-label", $l,
		  "DEF:".$g."_avg=$DB:".$g.":AVERAGE",
		  "LINE2:".$g."_avg#00FF00:Average",
		  "DEF:".$g."_max=$DB:".$g.":MAX",
		  "LINE2:".$g."_max#FF0000:Maximum";

		my $ERROR = RRDs::error;
		print "$0: unable to create ".$g."_".$d.".png: ".$ERROR."\n" if $ERROR;

		# move the graphic to its destination folder
		File::Copy::move($filename, $destination_dir) || 
			die("Unable to move $filename to $destination_dir");
	}

}

