/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.InodePtr;

public class FsObjectTreeNode
implements TreeNode {
    private FsObject fileSystemObj;
    private FileSystem fileSys;
    private TreeNode parentNode;
    private Map inodePtrMap;
    private Map inodeMap;
    private List childList;
    private String name;
    private Inode inode;

    public FsObjectTreeNode(FileSystem fs, TreeNode parent, FsObject fsObj, Inode inode, String name) {
        this.fileSys = fs;
        this.parentNode = parent;
        this.fileSystemObj = fsObj;
        this.inode = inode;
        this.name = name;
        this.childList = new Vector();
        if (!(this.fileSystemObj instanceof Directory)) {
            return;
        }
        this.inodePtrMap = ((Directory)this.fileSystemObj).getInodePtrMap();
        try {
            this.inodeMap = new HashMap();
            Vector childNameList = new Vector();
            childNameList.addAll(this.inodePtrMap.keySet());
            Collections.sort(childNameList);
            Iterator itr = childNameList.iterator();
            while (itr.hasNext()) {
                String child = (String)itr.next();
                Inode childInode = fs.getInode((InodePtr)this.inodePtrMap.get(child));
                this.inodeMap.put(child, childInode);
                this.childList.add(child);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected FsObjectTreeNode createNode(String child) {
        try {
            Inode childInode = (Inode)this.inodeMap.get(child);
            FsObject childObj = this.fileSys.getObject(childInode);
            return new FsObjectTreeNode(this.fileSys, this, childObj, childInode, child);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public Inode getInode() {
        return this.inode;
    }

    public FsObject getFsObject() {
        return this.fileSystemObj;
    }

    public int getMode() {
        return this.inode.getMode();
    }

    protected String getName() {
        return this.name;
    }

    public Enumeration children() {
        return new Enumeration(){
            int idx = 0;

            public boolean hasMoreElements() {
                return this.idx < FsObjectTreeNode.this.childList.size();
            }

            public Object nextElement() {
                return FsObjectTreeNode.this.getChildAt(this.idx++);
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int idx) {
        return this.createNode((String)this.childList.get(idx));
    }

    public int getChildCount() {
        return this.childList.size();
    }

    public int getIndex(TreeNode node) {
        String child = ((FsObjectTreeNode)node).getName();
        for (int i = 0; i < this.childList.size(); ++i) {
            if (!child.equals(this.childList.get(i))) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parentNode;
    }

    public boolean isLeaf() {
        return this.childList.size() == 0;
    }

    public List getChildList() {
        return this.childList;
    }

    public Map getInodeMap() {
        return this.inodeMap;
    }
}

