/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import rossi.fstools.fs.SymLink;
import rossi.fstoolsui.fstree.FsObjectTreeNode;

public class FsTreeRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof FsObjectTreeNode) {
            int mode = ((FsObjectTreeNode)value).getMode();
            JLabel lbl = (JLabel)renderer;
            FsObjectTreeNode node = (FsObjectTreeNode)value;
            if ((mode & 0xF000) == 8192) {
                lbl.setForeground(Color.red);
            }
            if ((mode & 0xF000) == 24576) {
                lbl.setForeground(Color.red.darker());
            }
            if ((mode & 0xF000) == 4096) {
                lbl.setForeground(Color.green);
            }
            if ((mode & 0xF000) == 16384) {
                lbl.setForeground(Color.blue);
            }
            if ((mode & 0xF000) == 49152) {
                lbl.setForeground(Color.orange);
            }
            if ((mode & 0xF000) == 40960) {
                lbl.setText(node.getName() + " -> " + ((SymLink)node.getFsObject()).getLink());
                lbl.setForeground(Color.cyan);
            }
        }
        return renderer;
    }
}

