/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.RandomAccessFile;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.reiserfs.ReiserFileSystem;
import rossi.fstools.io.BlockIO;
import rossi.fstoolsui.actions.ExitAction;
import rossi.fstoolsui.actions.ExtractFileAction;
import rossi.fstoolsui.actions.OpenPartitionAction;
import rossi.fstoolsui.fstree.FsViewPanel;

public class FsViewFrame
extends JFrame {
    protected FsViewPanel fsview;
    protected JMenuBar menuBar;
    protected HashMap actionMap;

    public FsViewFrame() {
        this.initialize();
    }

    public FsViewPanel getFsViewPanel() {
        return this.fsview;
    }

    protected void initialize() {
        this.fsview = new FsViewPanel();
        this.fsview.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Action extractAction = (Action)FsViewFrame.this.actionMap.get("extractFile");
                FsObject fsobj = FsViewFrame.this.fsview.getCurrentFsObject();
                extractAction.setEnabled(fsobj != null && (fsobj instanceof File || fsobj instanceof Directory));
            }
        });
        this.menuBar = new JMenuBar();
        this.setupActions();
        this.setupMenuBar();
        this.setJMenuBar(this.menuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.fsview, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Action action = (Action)FsViewFrame.this.actionMap.get("exit");
                action.actionPerformed(new ActionEvent(this, 1001, "Exit"));
            }
        });
        this.setSize(600, 500);
        this.show();
    }

    protected void setupActions() {
        this.actionMap = new HashMap();
        AbstractAction a = new ExtractFileAction();
        a.setEnabled(false);
        a.putValue("frame", this);
        this.actionMap.put("extractFile", a);
        a = new OpenPartitionAction();
        a.putValue("frame", this);
        this.actionMap.put("openPartition", a);
        a = new ExitAction();
        a.putValue("frame", this);
        this.actionMap.put("exit", a);
    }

    protected void setupMenuBar() {
        JMenu m = new JMenu("File");
        m.add((Action)this.actionMap.get("extractFile"));
        m.add((Action)this.actionMap.get("openPartition"));
        m.add((Action)this.actionMap.get("exit"));
        this.menuBar.add(m);
    }

    public void setFileSystem(FileSystem fs) throws Exception {
        this.fsview.setFileSystem(fs);
    }

    public FileSystem getFileSystem() {
        return this.fsview.getFileSystem();
    }

    public static void main(String[] args) throws Exception {
        FsViewFrame frame = new FsViewFrame();
        long offset = 0L;
        if (args.length == 0) {
            return;
        }
        if (args.length > 1) {
            offset = Long.parseLong(args[1]);
        }
        RandomAccessFile rafile = new RandomAccessFile(args[0], "r");
        BlockIO blkio = new BlockIO(rafile, 4096, offset);
        ReiserFileSystem fs = new ReiserFileSystem();
        fs.open(blkio);
        frame.setFileSystem(fs);
    }
}

