/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import rossi.fstools.fs.Device;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.Inode;
import rossi.fstoolsui.fstree.FsObjectTreeNode;
import rossi.fstoolsui.fstree.InodeTableModel;

public class InodeTablePanel
extends JPanel
implements MouseListener {
    protected JTable tbl;
    protected TableModel model;
    protected Map inodeMap;
    protected List fileNameList;
    protected FileSystem fs = null;
    protected FsObjectTreeNode currentNode = null;
    protected List actionListeners = new Vector();

    public InodeTablePanel() {
        this.initialize();
    }

    protected void initialize() {
        this.fileNameList = new Vector();
        this.inodeMap = new HashMap();
        this.model = this.getModel(this.fileNameList, this.inodeMap);
        TableColumnModel cm = this.getColumnModel(this.model);
        this.tbl = new JTable(this.model, cm);
        this.tbl.setSurrendersFocusOnKeystroke(true);
        this.tbl.setAutoResizeMode(0);
        this.tbl.addMouseListener(this);
        this.tbl.getTableHeader().addMouseListener(this);
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.tbl);
        this.add((Component)sp, "Center");
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public void setFileSystem(FileSystem aFs) {
        this.fs = aFs;
        ((InodeTableModel)this.model).setFileSystem(this.fs);
    }

    protected TableModel getModel(List nameList, Map inodeMap) {
        return new InodeTableModel(nameList, inodeMap);
    }

    protected TableColumnModel getColumnModel(TableModel model) {
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        DefaultTableCellRenderer def = new DefaultTableCellRenderer();
        TableCellRenderer[] rend = new TableCellRenderer[]{new NameColumnRenderer(), new ModeColumnRenderer(), def, def, def, new SizeColumnRenderer(), def, def, def};
        int[] width = new int[]{200, 55, 45, 45, 45, 65, 150, 150, 150};
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn c = new TableColumn(i, width[i]);
            c.setHeaderValue(model.getColumnName(i));
            c.setCellRenderer(rend[i]);
            cm.addColumn(c);
        }
        return cm;
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt)) {
            if (evt.getSource() == this.tbl.getTableHeader()) {
                int col = this.tbl.columnAtPoint(new Point(evt.getX(), evt.getY()));
                this.sortModel(col);
            } else if (evt.getClickCount() == 2) {
                this.handleDoubleClick();
            }
        }
    }

    protected void handleDoubleClick() {
        int row = this.tbl.getSelectedRow();
        if (row == -1) {
            return;
        }
        Inode inode = (Inode)this.inodeMap.get(this.fileNameList.get(row));
        if ((inode.getMode() & 0xF000) == 16384) {
            try {
                Directory dir = (Directory)this.fs.getObject(inode);
                FsObjectTreeNode fsn = new FsObjectTreeNode(this.fs, this.currentNode, dir, inode, (String)this.fileNameList.get(row));
                this.setFsObjectNode(fsn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public FsObject getSelectedFsObject() throws IOException, FsException {
        int row = this.tbl.getSelectedRow();
        if (row == -1) {
            return null;
        }
        Inode inode = (Inode)this.inodeMap.get(this.fileNameList.get(row));
        return this.fs.getObject(inode);
    }

    public String getSelectedFilename() {
        int row = this.tbl.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (String)this.fileNameList.get(row);
    }

    public JTable getTable() {
        return this.tbl;
    }

    public FsObjectTreeNode getFsObjectNode() {
        return this.currentNode;
    }

    public void setFsObjectNode(FsObjectTreeNode node) {
        this.currentNode = node;
        this.setData(node.getChildList(), node.getInodeMap());
        this.fireActionEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionEvent() {
        ActionEvent evt = new ActionEvent(this, 1001, "cmd");
        List list = this.actionListeners;
        synchronized (list) {
            Iterator itr = this.actionListeners.iterator();
            while (itr.hasNext()) {
                ActionListener al = (ActionListener)itr.next();
                al.actionPerformed(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener al) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.add(al);
        }
    }

    protected void setData(List nameList, Map iMap) {
        while (this.fileNameList.size() != 0) {
            this.fileNameList.remove(0);
        }
        this.fileNameList.addAll(nameList);
        this.inodeMap.clear();
        this.inodeMap.putAll(iMap);
        ((AbstractTableModel)this.tbl.getModel()).fireTableDataChanged();
    }

    protected void sortModel(final int col) {
        Collections.sort(this.fileNameList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = (String)o1;
                String name2 = (String)o2;
                Comparable cell1 = (Comparable)((InodeTableModel)InodeTablePanel.this.model).cellFromName(name1, col);
                Comparable cell2 = (Comparable)((InodeTableModel)InodeTablePanel.this.model).cellFromName(name2, col);
                return cell1.compareTo(cell2);
            }
        });
        ((AbstractTableModel)this.model).fireTableDataChanged();
        ((AbstractTableModel)this.model).fireTableChanged(new TableModelEvent(this.model));
    }

    class SizeColumnRenderer
    extends DefaultTableCellRenderer {
        SizeColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableModel model = table.getModel();
            int mode = (Integer)model.getValueAt(row, 1);
            long size = (Long)model.getValueAt(row, 5);
            JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            lbl.setHorizontalAlignment(4);
            if ((mode & 0xF000) == 8192 || (mode & 0xF000) == 24576) {
                try {
                    Inode inode = (Inode)InodeTablePanel.this.inodeMap.get(InodeTablePanel.this.fileNameList.get(row));
                    Device dev = (Device)InodeTablePanel.this.fs.getObject(inode);
                    String devstr = Integer.toString(dev.getMajor()) + ", " + Integer.toString(dev.getMinor());
                    lbl.setText(devstr);
                }
                catch (Exception ex) {
                    lbl.setText(ex.getClass().getName() + ": " + ex.getMessage());
                }
            } else {
                lbl.setText(Long.toString(size));
            }
            return lbl;
        }
    }

    class ModeColumnRenderer
    extends DefaultTableCellRenderer {
        ModeColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableModel model = table.getModel();
            int mode = (Integer)model.getValueAt(row, 1);
            String modestr = "";
            JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            modestr = "-";
            if ((mode & 0xF000) == 8192) {
                modestr = "c";
            }
            if ((mode & 0xF000) == 24576) {
                modestr = "b";
            }
            if ((mode & 0xF000) == 4096) {
                modestr = "p";
            }
            if ((mode & 0xF000) == 16384) {
                modestr = "d";
            }
            if ((mode & 0xF000) == 49152) {
                modestr = "s";
            }
            if ((mode & 0xF000) == 40960) {
                modestr = "l";
            }
            int wr = 256;
            int rd = 128;
            int ex = 64;
            for (int i = 0; i < 3; ++i) {
                modestr = (mode & wr) != 0 ? modestr + "w" : modestr + "-";
                modestr = (mode & rd) != 0 ? modestr + "r" : modestr + "-";
                modestr = (mode & ex) != 0 ? modestr + "x" : modestr + "-";
            }
            lbl.setText(modestr);
            lbl.setToolTipText("0" + Integer.toOctalString(mode));
            return lbl;
        }
    }

    class NameColumnRenderer
    extends DefaultTableCellRenderer {
        NameColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableModel model = table.getModel();
            int mode = (Integer)model.getValueAt(row, 1);
            JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            lbl.setForeground(Color.black);
            if ((mode & 0xF000) == 8192) {
                lbl.setForeground(Color.red);
            }
            if ((mode & 0xF000) == 24576) {
                lbl.setForeground(Color.red.darker());
            }
            if ((mode & 0xF000) == 4096) {
                lbl.setForeground(Color.green);
            }
            if ((mode & 0xF000) == 16384) {
                lbl.setForeground(Color.blue);
            }
            if ((mode & 0xF000) == 49152) {
                lbl.setForeground(Color.orange);
            }
            if ((mode & 0xF000) == 40960) {
                lbl.setForeground(Color.cyan);
            }
            return lbl;
        }
    }
}

