/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs;

public class FsUtils {
    public static boolean bigEndian = false;

    public static long getU64(byte[] buffer, int offset) {
        long r = 0L;
        int inc = bigEndian ? 1 : -1;
        int pos = bigEndian ? offset : offset + 7;
        r |= ((long)buffer[pos] & 0xFFL) << 56;
        r |= ((long)buffer[pos += inc] & 0xFFL) << 48;
        r |= ((long)buffer[pos += inc] & 0xFFL) << 40;
        r |= ((long)buffer[pos += inc] & 0xFFL) << 32;
        r |= ((long)buffer[pos += inc] & 0xFFL) << 24;
        r |= ((long)buffer[pos += inc] & 0xFFL) << 16;
        r |= ((long)buffer[pos += inc] & 0xFFL) << 8;
        return r |= (long)buffer[pos += inc] & 0xFFL;
    }

    public static long getS64(byte[] buffer, int offset) {
        return FsUtils.getU64(buffer, offset);
    }

    public static long getU32(byte[] buffer, int offset) {
        long r = 0L;
        int inc = bigEndian ? 1 : -1;
        int pos = bigEndian ? offset : offset + 3;
        r |= ((long)buffer[pos] & 0xFFL) << 24;
        r |= ((long)buffer[pos += inc] & 0xFFL) << 16;
        r |= ((long)buffer[pos += inc] & 0xFFL) << 8;
        return r |= (long)buffer[pos += inc] & 0xFFL;
    }

    public static long getS32(byte[] buffer, int offset) {
        long r = FsUtils.getU32(buffer, offset);
        if ((r & Integer.MIN_VALUE) != 0L) {
            r |= 0xFFFFFFFF00000000L;
        }
        return r;
    }

    public static int getU16(byte[] buffer, int offset) {
        int r = 0;
        int inc = bigEndian ? 1 : -1;
        int pos = bigEndian ? offset : offset + 1;
        r |= (buffer[pos] & 0xFF) << 8;
        return r |= buffer[pos += inc] & 0xFF;
    }

    public static int getS16(byte[] buffer, int offset) {
        int r = FsUtils.getU16(buffer, offset);
        if ((r & 0x8000) != 0) {
            r = (int)((long)r | 0xFFFF0000L);
        }
        return r;
    }
}

