/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.ext2fs;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;

public class DirEntry
implements DiskStructure {
    protected long inode;
    protected int recordLen;
    protected int nameLen;
    protected int type;
    protected String name;
    public static final int EXT2_FT_UNKNOWN = 0;
    public static final int EXT2_FT_REG_FILE = 1;
    public static final int EXT2_FT_DIR = 2;
    public static final int EXT2_FT_CHRDEV = 3;
    public static final int EXT2_FT_BLKDEV = 4;
    public static final int EXT2_FT_FIFO = 5;
    public static final int EXT2_FT_SOCK = 6;
    public static final int EXT2_FT_SYMLINK = 7;

    public int getDataSize() {
        return this.getRecordLen();
    }

    public long getInode() {
        return this.inode;
    }

    public void setInode(long aInode) {
        this.inode = aInode;
    }

    public int getRecordLen() {
        return this.recordLen;
    }

    public void setRecordLen(int aRecordLen) {
        this.recordLen = aRecordLen;
    }

    public int getNameLen() {
        return this.nameLen;
    }

    public void setNameLen(int aNameLen) {
        this.nameLen = aNameLen;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int aType) {
        this.type = aType;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        this.setInode(FsUtils.getU32(buffer, offset + 0));
        this.setRecordLen(FsUtils.getU16(buffer, offset + 4));
        this.setNameLen(buffer[offset + 6] & 0xFF);
        this.setType(buffer[offset + 7] & 0xFF);
        try {
            this.name = new String(buffer, offset + 8, this.getNameLen(), "ISO-8859-1");
            int zeroidx = this.name.indexOf(0);
            if (zeroidx > 0) {
                this.name = this.name.substring(0, zeroidx);
            }
        }
        catch (Exception ex) {
            FsException fsex = new FsException("Error parsing filename");
            fsex.initCause(ex);
            throw fsex;
        }
    }
}

