/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.ext2fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.ext2fs.DirEntry;
import rossi.fstools.fs.ext2fs.Ext2InodePtr;
import rossi.fstools.io.BlockPointerInputStream;

public class Ext2Directory
implements Directory {
    private Map dirMap = new HashMap();
    private boolean atEOF = false;

    public Ext2Directory(File file) throws IOException, FsException {
        this.load(file);
    }

    private void load(File file) throws IOException, FsException {
        int bytesRead;
        BlockPointerInputStream in = file.getData();
        DirEntry dirEntry = new DirEntry();
        int offset = 0;
        int availData = 0;
        byte[] buffer = new byte[4096];
        while ((availData += (bytesRead = this.fillBuffer(in, buffer, offset))) >= 8) {
            dirEntry.loadFromBuffer(buffer, 0);
            Ext2InodePtr inodePtr = new Ext2InodePtr(dirEntry.getInode());
            if (dirEntry.getNameLen() > 0) {
                String name = dirEntry.getName();
                this.dirMap.put(name, inodePtr);
            }
            offset = buffer.length - dirEntry.getRecordLen();
            System.arraycopy(buffer, dirEntry.getRecordLen(), buffer, 0, offset);
            availData -= dirEntry.getRecordLen();
        }
    }

    private int fillBuffer(InputStream in, byte[] buffer, int startoffset) throws IOException {
        int totalBytesRead;
        int bytesRead;
        int bytesToRead = buffer.length;
        if (this.atEOF) {
            return 0;
        }
        for (totalBytesRead = startoffset; totalBytesRead < bytesToRead; totalBytesRead += bytesRead) {
            bytesRead = in.read(buffer, totalBytesRead, bytesToRead - totalBytesRead);
            if (bytesRead != -1) continue;
            this.atEOF = true;
            return totalBytesRead - startoffset;
        }
        return totalBytesRead - startoffset;
    }

    public Map getInodePtrMap() {
        return this.dirMap;
    }
}

