/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.ext2fs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.ext2fs.Ext2SuperBlock;
import rossi.fstools.io.BlockPointer;
import rossi.fstools.io.BlockPointerInputStream;
import rossi.fstools.io.BlockReader;

public class Ext2File
implements File {
    protected List blkPointerList = new ArrayList();
    protected List slackList = new ArrayList();
    protected long size;
    protected long sizeRemaining;
    protected BlockReader reader;
    protected Ext2SuperBlock sb;

    public Ext2File(Ext2SuperBlock sb, long fileSize, BlockReader reader) {
        this.size = fileSize;
        this.reader = reader;
        this.sb = sb;
        this.sizeRemaining = this.size;
    }

    public void addDirectBlock(long blocknum) {
        BlockPointer bp;
        int curSize;
        BlockPointer lastBp = null;
        int lastend = 0;
        int lastendoffset = 0;
        int blksize = (int)this.sb.getBlockSize();
        int n = curSize = this.sizeRemaining < (long)blksize ? (int)this.sizeRemaining : blksize;
        if (this.blkPointerList.size() != 0) {
            lastBp = (BlockPointer)this.blkPointerList.get(this.blkPointerList.size() - 1);
            lastend = lastBp.getBlockNum() + (lastBp.getOffset() + lastBp.getLength()) / blksize;
            lastendoffset = (lastBp.getOffset() + lastBp.getLength()) % blksize;
        }
        if (lastBp != null && (long)lastend == blocknum && lastendoffset == 0) {
            lastBp.setLength(lastBp.getLength() + curSize);
        } else {
            bp = new BlockPointer();
            bp.setBlockNum((int)blocknum);
            bp.setOffset(0);
            bp.setLength(curSize);
            bp.setBlockSize(blksize);
            this.blkPointerList.add(bp);
        }
        if (curSize != blksize) {
            bp = new BlockPointer();
            bp.setBlockNum((int)blocknum);
            bp.setOffset(curSize);
            bp.setLength(blksize - curSize);
            bp.setBlockSize(blksize);
            this.slackList.add(bp);
        }
        this.sizeRemaining -= (long)curSize;
    }

    public void addIndirectBlock(long blocknum, int level) throws IOException {
        int blksize = (int)this.sb.getBlockSize();
        if (level == 0) {
            this.addDirectBlock(blocknum);
            return;
        }
        byte[] buffer = this.reader.getBlock((int)blocknum);
        for (int i = 0; i < blksize / 4 && this.sizeRemaining != 0L; ++i) {
            this.addIndirectBlock(FsUtils.getU32(buffer, i * 4), level - 1);
        }
    }

    public BlockPointerInputStream getData() {
        return new BlockPointerInputStream(this.reader, this.blkPointerList);
    }

    public BlockPointerInputStream getSlack() {
        return new BlockPointerInputStream(this.reader, this.slackList);
    }
}

