/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.ext2fs;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.Inode;

public class Ext2Inode
implements DiskStructure,
Inode {
    protected int mode;
    protected int uidLow;
    protected long sizeLow;
    protected long accessTime;
    protected long modifyTime;
    protected long changedTime;
    protected long deletedTime;
    protected int gidLow;
    protected int numLinks;
    protected long blocks;
    protected long flags;
    protected long[] directBlocks;
    protected long indirectBlock;
    protected long doubleIndirectBlock;
    protected long tripleIndirectBlock;
    protected byte[] blockData;
    protected long fileVersion;
    protected long fileACL;
    protected long dirACL;
    protected long fragAddr;
    protected int fragNum;
    protected int fragSize;
    protected int uidHigh;
    protected int gidHigh;
    public static int EXT2_NDIR_BLOCKS = 12;
    public static int EXT2_N_BLOCKS = 15;
    public static int EXT2_GOOD_OLD_INODE_SIZE = 128;

    public int getDataSize() {
        return 32;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int aMode) {
        this.mode = aMode;
    }

    public int getUidLow() {
        return this.uidLow;
    }

    public void setUidLow(int aUidLow) {
        this.uidLow = aUidLow;
    }

    public long getSizeLow() {
        return this.sizeLow;
    }

    public void setSizeLow(long aSizeLow) {
        this.sizeLow = aSizeLow;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long aAccessTime) {
        this.accessTime = aAccessTime;
    }

    public long getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(long aModifyTime) {
        this.modifyTime = aModifyTime;
    }

    public long getChangedTime() {
        return this.changedTime;
    }

    public void setChangedTime(long aChangedTime) {
        this.changedTime = aChangedTime;
    }

    public long getDeletedTime() {
        return this.deletedTime;
    }

    public void setDeletedTime(long aDeletedTime) {
        this.deletedTime = aDeletedTime;
    }

    public int getGidLow() {
        return this.gidLow;
    }

    public void setGidLow(int aGidLow) {
        this.gidLow = aGidLow;
    }

    public long getNumLinks() {
        return this.numLinks;
    }

    public void setNumLinks(long aNumLinks) {
        this.numLinks = (int)aNumLinks;
    }

    public long getBlocks() {
        return this.blocks;
    }

    public void setBlocks(long aBlocks) {
        this.blocks = aBlocks;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long aFlags) {
        this.flags = aFlags;
    }

    public long[] getDirectBlocks() {
        return this.directBlocks;
    }

    public void setDirectBlocks(long[] aDirectBlocks) {
        this.directBlocks = aDirectBlocks;
    }

    public long getDirectBlock(int blocknum) {
        return this.getDirectBlocks()[blocknum];
    }

    public long getIndirectBlock() {
        return this.indirectBlock;
    }

    public void setIndirectBlock(long aIndirectBlock) {
        this.indirectBlock = aIndirectBlock;
    }

    public long getDoubleIndirectBlock() {
        return this.doubleIndirectBlock;
    }

    public void setDoubleIndirectBlock(long aDoubleIndirectBlock) {
        this.doubleIndirectBlock = aDoubleIndirectBlock;
    }

    public long getTripleIndirectBlock() {
        return this.tripleIndirectBlock;
    }

    public void setTripleIndirectBlock(long aTripleIndirectBlock) {
        this.tripleIndirectBlock = aTripleIndirectBlock;
    }

    public byte[] getBlockData() {
        return this.blockData;
    }

    public void setBlockData(byte[] aBlockData) {
        this.blockData = aBlockData;
    }

    public long getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(long aFileVersion) {
        this.fileVersion = aFileVersion;
    }

    public long getFileACL() {
        return this.fileACL;
    }

    public void setFileACL(long aFileACL) {
        this.fileACL = aFileACL;
    }

    public long getDirACL() {
        return this.dirACL;
    }

    public void setDirACL(long aDirACL) {
        this.dirACL = aDirACL;
    }

    public long getFragAddr() {
        return this.fragAddr;
    }

    public void setFragAddr(long aFragAddr) {
        this.fragAddr = aFragAddr;
    }

    public int getFragNum() {
        return this.fragNum;
    }

    public void setFragNum(int aFragNum) {
        this.fragNum = aFragNum;
    }

    public int getFragSize() {
        return this.fragSize;
    }

    public void setFragSize(int aFragSize) {
        this.fragSize = aFragSize;
    }

    public int getUidHigh() {
        return this.uidHigh;
    }

    public void setUidHigh(int aUidHigh) {
        this.uidHigh = aUidHigh;
    }

    public int getGidHigh() {
        return this.gidHigh;
    }

    public void setGidHigh(int aGidHigh) {
        this.gidHigh = aGidHigh;
    }

    public long getUserId() {
        return this.getUidHigh() << 16 | this.getUidLow();
    }

    public void setUserId(long uid) {
        this.setUidHigh((int)(uid >> 16) & 0xFFFF);
        this.setUidLow((int)uid & 0xFFFF);
    }

    public void setGroupId(long gid) {
        this.setGidHigh((int)(gid >> 16) & 0xFFFF);
        this.setGidLow((int)gid & 0xFFFF);
    }

    public long getGroupId() {
        return this.getGidHigh() << 16 | this.getGidLow();
    }

    public long getSize() {
        if ((this.getMode() & 0x8000) == 32768) {
            return this.getDirACL() << 32 | this.getSizeLow();
        }
        return this.getSizeLow();
    }

    public void setSize(long s) {
        if ((this.getMode() & 0x8000) == 32768) {
            this.setDirACL(s >> 32 & 0xFFFFFFFFFFFFFFFFL);
        }
        this.setSizeLow(s & 0xFFFFFFFFFFFFFFFFL);
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        this.setMode(FsUtils.getU16(buffer, offset + 0));
        this.setUidLow(FsUtils.getU16(buffer, offset + 2));
        this.setSizeLow(FsUtils.getU32(buffer, offset + 4));
        this.setAccessTime(FsUtils.getU32(buffer, offset + 8));
        this.setChangedTime(FsUtils.getU32(buffer, offset + 12));
        this.setModifyTime(FsUtils.getU32(buffer, offset + 16));
        this.setDeletedTime(FsUtils.getU32(buffer, offset + 20));
        this.setGidLow(FsUtils.getU16(buffer, offset + 24));
        this.setNumLinks(FsUtils.getU16(buffer, offset + 26));
        this.setBlocks(FsUtils.getU32(buffer, offset + 28));
        this.setFlags(FsUtils.getU32(buffer, offset + 32));
        this.directBlocks = new long[EXT2_NDIR_BLOCKS];
        for (int i = 0; i < EXT2_NDIR_BLOCKS; ++i) {
            this.directBlocks[i] = FsUtils.getU32(buffer, offset + 40 + i * 4);
        }
        this.blockData = new byte[EXT2_N_BLOCKS * 4];
        System.arraycopy(buffer, offset + 40, this.blockData, 0, EXT2_N_BLOCKS * 4);
        this.setIndirectBlock(FsUtils.getU32(buffer, offset + 88));
        this.setDoubleIndirectBlock(FsUtils.getU32(buffer, offset + 92));
        this.setTripleIndirectBlock(FsUtils.getU32(buffer, offset + 96));
        this.setFileVersion(FsUtils.getU32(buffer, offset + 100));
        this.setFileACL(FsUtils.getU32(buffer, offset + 104));
        this.setDirACL(FsUtils.getU32(buffer, offset + 108));
        this.setFragAddr(FsUtils.getU32(buffer, offset + 112));
        this.setFragNum(buffer[offset + 116]);
        this.setFragSize(buffer[offset + 117]);
        this.setUidHigh(FsUtils.getU16(buffer, offset + 120));
        this.setGidHigh(FsUtils.getU16(buffer, offset + 122));
    }
}

