/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;

public class DirEntry {
    protected long hash;
    protected long parentDirId;
    protected long objectId;
    protected int location;
    protected int state;
    protected String name;
    private int dirhsize = 16;

    public long getHash() {
        return this.hash;
    }

    public void setHash(long aHash) {
        this.hash = aHash;
    }

    public long getParentDirId() {
        return this.parentDirId;
    }

    public void setParentDirId(long aParentDirId) {
        this.parentDirId = aParentDirId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long aObjectId) {
        this.objectId = aObjectId;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int aLocation) {
        this.location = aLocation;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int aState) {
        this.state = aState;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void loadFromBuffer(byte[] buffer, int itemoffset, int entrynum, int end) throws FsException {
        this.setHash(FsUtils.getU32(buffer, itemoffset + entrynum * this.dirhsize + 0));
        this.setParentDirId(FsUtils.getU32(buffer, itemoffset + entrynum * this.dirhsize + 4));
        this.setObjectId(FsUtils.getU32(buffer, itemoffset + entrynum * this.dirhsize + 8));
        this.setLocation(FsUtils.getU16(buffer, itemoffset + entrynum * this.dirhsize + 12));
        this.setState(FsUtils.getU16(buffer, itemoffset + entrynum * this.dirhsize + 14));
        try {
            this.name = new String(buffer, itemoffset + this.getLocation(), end - this.getLocation(), "ISO-8859-1");
            int zeroidx = this.name.indexOf(0);
            if (zeroidx > 0) {
                this.name = this.name.substring(0, zeroidx);
            }
        }
        catch (Exception ex) {
            FsException fsex = new FsException("Error parsing filename");
            fsex.initCause(ex);
            throw fsex;
        }
    }
}

