/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.reiserfs.DirEntry;
import rossi.fstools.fs.reiserfs.Item;
import rossi.fstools.fs.reiserfs.ItemHead;
import rossi.fstools.fs.reiserfs.LeafNode;

public class DirectoryItem
extends Item {
    protected DirEntry[] entries;

    public DirectoryItem(byte[] buffer, int bufferOffset, LeafNode block, ItemHead header) throws FsException {
        super(buffer, bufferOffset, block, header);
        this.load();
    }

    public int numEntries() {
        return this.header.getFreeEntCt();
    }

    public DirEntry[] getEntries() {
        return this.entries;
    }

    protected void load() throws FsException {
        this.entries = new DirEntry[this.numEntries()];
        int end = this.header.getItemLen();
        for (int i = 0; i < this.numEntries(); ++i) {
            this.entries[i] = new DirEntry();
            this.entries[i].loadFromBuffer(this.buffer, this.bufferOffset + this.header.getItemLocation(), i, end);
            end = this.entries[i].getLocation();
        }
    }
}

