/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.reiserfs.InternalNode;
import rossi.fstools.fs.reiserfs.Key;
import rossi.fstools.fs.reiserfs.LeafNode;
import rossi.fstools.fs.reiserfs.ReiserSuperBlock;

public class FBlock
implements DiskStructure {
    protected int level;
    protected int numItems;
    protected int freeSpace;
    protected int reserved;
    protected Key rightKey;
    protected ReiserSuperBlock sb;
    protected int blocknum;
    protected FBlock parent;

    public FBlock(ReiserSuperBlock sb, int blocknum) {
        this.sb = sb;
        this.blocknum = blocknum;
    }

    public int getBlockHeaderSize() {
        return 24;
    }

    public int getDataSize() {
        return this.sb.getBlockSize();
    }

    public ReiserSuperBlock getSuperBlock() {
        return this.sb;
    }

    public int getBlockNum() {
        return this.blocknum;
    }

    public FBlock getParent() {
        return this.parent;
    }

    public void setParent(FBlock aParent) {
        this.parent = aParent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int aLevel) {
        this.level = aLevel;
    }

    public int getNumItems() {
        return this.numItems;
    }

    public void setNumItems(int aNumItems) {
        this.numItems = aNumItems;
    }

    public int getFreeSpace() {
        return this.freeSpace;
    }

    public void setFreeSpace(int aFreeSpace) {
        this.freeSpace = aFreeSpace;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int aReserved) {
        this.reserved = aReserved;
    }

    public Key getRightKey() {
        return this.rightKey;
    }

    public void setRightKey(Key aRightKey) {
        this.rightKey = aRightKey;
    }

    public static FBlock createFromBuffer(ReiserSuperBlock sb, int blocknum, byte[] buffer, int blkoffset) throws FsException {
        int level = FsUtils.getU16(buffer, blkoffset + 0);
        FBlock blk = level == 1 ? new LeafNode(sb, blocknum) : new InternalNode(sb, blocknum);
        blk.loadFromBuffer(buffer, blkoffset);
        return blk;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        this.setLevel(FsUtils.getU16(buffer, offset + 0));
        this.setNumItems(FsUtils.getU16(buffer, offset + 2));
        this.setFreeSpace(FsUtils.getU16(buffer, offset + 4));
        this.setReserved(FsUtils.getU16(buffer, offset + 6));
    }
}

